/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.reader;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.glassfish.api.admin.progress.ProgressStatusDTO;

@Provider
@Consumes(value={"application/json"})
public class ProgressStatusDTOJsonReader
implements MessageBodyReader<ProgressStatusDTO> {
    private static final JsonFactory factory = new JsonFactory();

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return type.isAssignableFrom(ProgressStatusDTO.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressStatusDTO readFrom(Class<ProgressStatusDTO> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        JsonParser jp = factory.createJsonParser(entityStream);
        try {
            JsonToken token = jp.nextToken();
            jp.nextToken();
            JsonToken token2 = jp.nextToken();
            if (token != JsonToken.START_OBJECT || token2 != JsonToken.START_OBJECT || !"progress-status".equals(jp.getCurrentName())) {
                throw new IOException("Not expected type (progress-status) but (" + jp.getCurrentName() + ")");
            }
            ProgressStatusDTO progressStatusDTO = ProgressStatusDTOJsonReader.readProgressStatus(jp);
            return progressStatusDTO;
        }
        finally {
            jp.close();
        }
    }

    public static ProgressStatusDTO readProgressStatus(JsonParser jp) throws IOException {
        ProgressStatusDTO.ChildProgressStatusDTO child = ProgressStatusDTOJsonReader.readChildProgressStatus(jp);
        return child.getProgressStatus();
    }

    public static ProgressStatusDTO.ChildProgressStatusDTO readChildProgressStatus(JsonParser jp) throws IOException {
        ProgressStatusDTO psd = new ProgressStatusDTO();
        int allocatedSteps = 0;
        while (jp.nextToken() != JsonToken.END_OBJECT) {
            String fieldname = jp.getCurrentName();
            jp.nextToken();
            if ("name".equals(fieldname)) {
                psd.setName(jp.getText());
                continue;
            }
            if ("id".equals(fieldname)) {
                psd.setId(jp.getText());
                continue;
            }
            if ("total-step-count".equals(fieldname)) {
                psd.setTotalStepCount(jp.getIntValue());
                continue;
            }
            if ("current-step-count".equals(fieldname)) {
                psd.setCurrentStepCount(jp.getIntValue());
                continue;
            }
            if ("complete".equals(fieldname)) {
                psd.setCompleted(jp.getBooleanValue());
                continue;
            }
            if ("allocated-steps".equals(fieldname)) {
                allocatedSteps = jp.getIntValue();
                continue;
            }
            if (!"children".equals(fieldname)) continue;
            while (jp.nextToken() != JsonToken.END_ARRAY) {
                if (jp.getCurrentToken() != JsonToken.START_OBJECT) continue;
                ProgressStatusDTO.ChildProgressStatusDTO child = ProgressStatusDTOJsonReader.readChildProgressStatus(jp);
                psd.getChildren().add(child);
            }
        }
        return new ProgressStatusDTO.ChildProgressStatusDTO(allocatedSteps, psd);
    }
}

