/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote.sse;

import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.glassfish.jersey.message.MessageBodyWorkers;

public final class GfSseEventReceiver
implements Closeable {
    private final InputStream inputStream;
    private final Annotation[] annotations;
    private final MediaType mediaType;
    private final MultivaluedMap<String, String> headers;
    private final MessageBodyWorkers messageBodyWorkers;
    private boolean closed = false;

    GfSseEventReceiver(InputStream inputStream, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> headers, MessageBodyWorkers messageBodyWorkers) {
        this.inputStream = inputStream;
        this.annotations = annotations;
        this.mediaType = mediaType;
        this.headers = headers;
        this.messageBodyWorkers = messageBodyWorkers;
    }

    public GfSseInboundEvent readEvent() throws IOException {
        GfSseInboundEvent inboundEvent = new GfSseInboundEvent(this.messageBodyWorkers, this.annotations, this.mediaType, this.headers);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        State currentState = State.START;
        String fieldName = null;
        try {
            int data = 0;
            block9: while ((data = this.inputStream.read()) != -1) {
                switch (currentState) {
                    case START: {
                        if (data == 58) {
                            currentState = State.COMMENT;
                            continue block9;
                        }
                        if (data != 10) {
                            baos.write(data);
                            currentState = State.FIELD_NAME;
                            continue block9;
                        }
                        if (data != 10) continue block9;
                        if (!inboundEvent.isEmpty()) {
                            return inboundEvent;
                        }
                        inboundEvent = new GfSseInboundEvent(this.messageBodyWorkers, this.annotations, this.mediaType, this.headers);
                        continue block9;
                    }
                    case COMMENT: {
                        if (data != 10) continue block9;
                        currentState = State.START;
                        continue block9;
                    }
                    case FIELD_NAME: {
                        if (data == 58) {
                            fieldName = baos.toString();
                            baos.reset();
                            currentState = State.FIELD_VALUE_FIRST;
                            continue block9;
                        }
                        if (data == 10) {
                            this.processField(inboundEvent, baos.toString(), "".getBytes());
                            baos.reset();
                            currentState = State.START;
                            continue block9;
                        }
                        baos.write(data);
                        continue block9;
                    }
                    case FIELD_VALUE_FIRST: {
                        if (data != 32) {
                            baos.write(data);
                        }
                        if (data == 10) {
                            this.processField(inboundEvent, fieldName, baos.toByteArray());
                            baos.reset();
                            currentState = State.START;
                            continue block9;
                        }
                        currentState = State.FIELD_VALUE;
                        continue block9;
                    }
                    case FIELD_VALUE: {
                        if (data == 10) {
                            this.processField(inboundEvent, fieldName, baos.toByteArray());
                            baos.reset();
                            currentState = State.START;
                            continue block9;
                        }
                        baos.write(data);
                        continue block9;
                    }
                }
            }
            if (data == -1) {
                this.closed = true;
            }
            return null;
        }
        catch (IOException e) {
            this.closed = true;
            throw e;
        }
    }

    private void processField(GfSseInboundEvent inboundEvent, String name, byte[] value) {
        if (name.equals("event")) {
            inboundEvent.setName(new String(value));
        } else if (name.equals("data")) {
            inboundEvent.addData(value);
            inboundEvent.addData(new byte[]{10});
        } else if (name.equals("id")) {
            String s = "";
            if (value != null) {
                s = new String(value);
                if (!(s = s.trim()).matches("\\-?\\d+")) {
                    s = "";
                }
            }
            inboundEvent.setId(s);
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.inputStream.close();
    }

    private static enum State {
        START,
        COMMENT,
        FIELD_NAME,
        FIELD_VALUE_FIRST,
        FIELD_VALUE,
        EVENT_FIRED;

    }
}

