/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.ClassToClassMapping;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URL;

public final class ClassUtil {
    private static final ClassNameToClassMapping[] sPrimitiveNameToObjectClass = new ClassNameToClassMapping[]{new ClassNameToClassMapping("int", Integer.TYPE), new ClassNameToClassMapping("long", Long.TYPE), new ClassNameToClassMapping("short", Short.TYPE), new ClassNameToClassMapping("byte", Byte.TYPE), new ClassNameToClassMapping("boolean", Boolean.TYPE), new ClassNameToClassMapping("float", Float.TYPE), new ClassNameToClassMapping("double", Double.TYPE), new ClassNameToClassMapping("char", Character.TYPE), new ClassNameToClassMapping("void", Void.TYPE)};
    private static final ClassToClassMapping[] sPrimitiveClassToObjectClass = new ClassToClassMapping[]{new ClassToClassMapping(Integer.TYPE, Integer.class), new ClassToClassMapping(Long.TYPE, Long.class), new ClassToClassMapping(Short.TYPE, Short.class), new ClassToClassMapping(Byte.TYPE, Byte.class), new ClassToClassMapping(Boolean.TYPE, Boolean.class), new ClassToClassMapping(Float.TYPE, Float.class), new ClassToClassMapping(Double.TYPE, Double.class), new ClassToClassMapping(Character.TYPE, Character.class)};
    static final String javaLang = "java.lang.";
    static final String[] sJavaLangTypes = new String[]{"Character", "Boolean", "Byte", "Short", "Integer", "Long", "Float", "Double", "String", "Object"};
    static final int sNumBaseTypes = Array.getLength(sJavaLangTypes);

    private ClassUtil() {
    }

    public static boolean objectIsArray(Object o) {
        return ClassUtil.classIsArray(o.getClass());
    }

    public static boolean classIsArray(Class theClass) {
        return ClassUtil.classnameIsArray(theClass.getName());
    }

    public static boolean objectIsPrimitiveArray(Object o) {
        return ClassUtil.getPrimitiveArrayTypeCode(o.getClass()) != '\u0000';
    }

    public static boolean classnameIsArray(String classname) {
        return classname.startsWith("[");
    }

    public static boolean classnameIsPrimitiveArray(String classname) {
        return ClassUtil.getPrimitiveArrayTypeCode(classname) != '\u0000';
    }

    public static char getPrimitiveArrayTypeCode(Class theClass) {
        char typeCode = '\u0000';
        if (ClassUtil.classIsArray(theClass)) {
            typeCode = ClassUtil.getPrimitiveArrayTypeCode(theClass.getName());
        }
        return typeCode;
    }

    public static char getPrimitiveArrayTypeCode(String classname) {
        char typeCode = '\u0000';
        int length = classname.length();
        if (ClassUtil.classnameIsArray(classname) && classname.charAt(length - 2) == '[') {
            typeCode = classname.charAt(length - 1);
            switch (typeCode) {
                default: {
                    typeCode = '\u0000';
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'Z': 
            }
        }
        return typeCode;
    }

    public static String getArrayMemberClassName(String classname) {
        String result = null;
        if (!ClassUtil.classnameIsArray(classname)) {
            throw new IllegalArgumentException("not an array");
        }
        int classnameLength = classname.length();
        if (ClassUtil.classnameIsPrimitiveArray(classname)) {
            char lastChar = classname.charAt(classnameLength - 1);
            switch (lastChar) {
                default: {
                    assert (false);
                }
                case 'Z': {
                    result = "boolean";
                    break;
                }
                case 'B': {
                    result = "byte";
                    break;
                }
                case 'C': {
                    result = "char";
                    break;
                }
                case 'S': {
                    result = "short";
                    break;
                }
                case 'I': {
                    result = "int";
                    break;
                }
                case 'J': {
                    result = "long";
                    break;
                }
                case 'F': {
                    result = "float";
                    break;
                }
                case 'D': {
                    result = "double";
                    break;
                }
            }
        } else {
            result = classname.substring(2, classnameLength - 1);
        }
        return result;
    }

    public static Class getClassFromName(String classname) throws ClassNotFoundException {
        Class theClass = null;
        if (classname.startsWith("[L")) {
            theClass = Class.forName(classname);
        } else {
            int numMappings = Array.getLength(sPrimitiveNameToObjectClass);
            for (int i = 0; i < numMappings; ++i) {
                if (!ClassUtil.sPrimitiveNameToObjectClass[i].mName.equals(classname)) continue;
                theClass = ClassUtil.sPrimitiveNameToObjectClass[i].mClass;
                break;
            }
            if (theClass == null) {
                theClass = Class.forName(classname);
            }
        }
        return theClass;
    }

    public static Class primitiveClassToObjectClass(Class theClass) {
        Class result = theClass;
        int numMappings = Array.getLength(sPrimitiveClassToObjectClass);
        for (int i = 0; i < numMappings; ++i) {
            ClassToClassMapping mapping = sPrimitiveClassToObjectClass[i];
            if (!mapping.mSrc.equals(theClass)) continue;
            result = mapping.mDest;
            break;
        }
        return result;
    }

    public static boolean isPrimitiveClass(Class theClass) {
        boolean isSimple = false;
        int numMappings = Array.getLength(sPrimitiveClassToObjectClass);
        for (int i = 0; i < numMappings; ++i) {
            ClassToClassMapping mapping = sPrimitiveClassToObjectClass[i];
            if (!mapping.mSrc.equals(theClass)) continue;
            isSimple = true;
            break;
        }
        return isSimple;
    }

    public static String primitiveLetterToClassName(char primitive) {
        Object result = "" + primitive;
        switch (primitive) {
            case 'B': {
                result = "byte";
                break;
            }
            case 'C': {
                result = "char";
                break;
            }
            case 'D': {
                result = "double";
                break;
            }
            case 'F': {
                result = "float";
                break;
            }
            case 'I': {
                result = "int";
                break;
            }
            case 'J': {
                result = "long";
                break;
            }
            case 'S': {
                result = "short";
                break;
            }
            case 'Z': {
                result = "boolean";
                break;
            }
            default: {
                result = "unknown";
            }
        }
        return result;
    }

    public static String[] getTypes(Object[] args) {
        if (args == null) {
            return null;
        }
        int numArgs = Array.getLength(args);
        String[] types = new String[numArgs];
        for (int i = 0; i < numArgs; ++i) {
            types[i] = args[i].getClass().getName();
        }
        return types;
    }

    public static String getFriendlyClassname(Class theClass) {
        return ClassUtil.getFriendlyClassname(theClass.getName());
    }

    public static String getFriendlyClassname(String type) {
        String result = type;
        if (type.startsWith("[")) {
            int depth = 0;
            while (type.charAt(depth) == '[') {
                ++depth;
            }
            result = type.substring(depth, type.length());
            if (result.startsWith("L") && result.endsWith(";")) {
                result = result.substring(1, result.length() - 1);
            } else if (result.length() == 1) {
                switch (result.charAt(0)) {
                    case 'Z': {
                        result = "boolean";
                        break;
                    }
                    case 'B': {
                        result = "byte";
                        break;
                    }
                    case 'C': {
                        result = "char";
                        break;
                    }
                    case 'S': {
                        result = "short";
                        break;
                    }
                    case 'I': {
                        result = "int";
                        break;
                    }
                    case 'J': {
                        result = "long";
                        break;
                    }
                    case 'F': {
                        result = "float";
                        break;
                    }
                    case 'D': {
                        result = "double";
                        break;
                    }
                    default: {
                        result = "unknown";
                    }
                }
            }
            StringBuilder resultBuf = new StringBuilder(result);
            for (int i = 0; i < depth; ++i) {
                resultBuf.append("[]");
            }
            result = resultBuf.toString();
        }
        if (result.startsWith(javaLang)) {
            result = result.substring(javaLang.length(), result.length());
        }
        return result;
    }

    public static Class getArrayElementClass(Class arrayClass) {
        Class theClass;
        block7: {
            String arrayClassName = arrayClass.getName();
            if (!ClassUtil.classnameIsArray(arrayClassName)) {
                throw new IllegalArgumentException("not an array");
            }
            String name = arrayClassName;
            if (!(name = name.substring(1, name.length())).startsWith("[")) {
                if (name.startsWith("L")) {
                    name = name.substring(1, name.length() - 1);
                } else if (name.length() == 1) {
                    name = ClassUtil.primitiveLetterToClassName(name.charAt(0));
                }
            }
            theClass = null;
            try {
                theClass = ClassUtil.getClassFromName(name);
            }
            catch (ClassNotFoundException e) {
                if ($assertionsDisabled) break block7;
                throw new AssertionError();
            }
        }
        return theClass;
    }

    public static Class getInnerArrayElementClass(Class arrayClass) throws ClassNotFoundException {
        Class elementClass = arrayClass;
        while (ClassUtil.classIsArray(elementClass = ClassUtil.getArrayElementClass(elementClass))) {
        }
        return elementClass;
    }

    private static Object instantiateObject(String theString) throws Exception {
        Object result = null;
        try {
            result = ClassUtil.instantiateNumber(theString);
        }
        catch (NumberFormatException e) {
            result = theString;
        }
        return result;
    }

    public static boolean signaturesAreCompatible(Class[] callee, Class[] argsSignature) {
        boolean compatible = false;
        if (callee.length == argsSignature.length) {
            compatible = true;
            for (int i = 0; i < callee.length; ++i) {
                if (callee[i].isAssignableFrom(argsSignature[i])) continue;
                compatible = false;
                break;
            }
        }
        return compatible;
    }

    public static Object instantiateObject(Class theClass, Object[] args) throws Exception {
        Constructor<Object> constructor;
        block7: {
            Class[] signature = new Class[args.length];
            for (int i = 0; i < signature.length; ++i) {
                signature[i] = args[i].getClass();
            }
            constructor = null;
            try {
                constructor = theClass.getConstructor(signature);
            }
            catch (NoSuchMethodException e) {
                Constructor<?>[] constructors = theClass.getConstructors();
                int numMatches = 0;
                for (int i = 0; i < constructors.length; ++i) {
                    Constructor<?> tempConstructor = constructors[i];
                    Class[] tempSignature = tempConstructor.getParameterTypes();
                    if (!ClassUtil.signaturesAreCompatible(tempSignature, signature)) continue;
                    ++numMatches;
                    constructor = tempConstructor;
                }
                if (numMatches == true) break block7;
                throw e;
            }
        }
        Object result = null;
        try {
            result = constructor.newInstance(args);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        return result;
    }

    public static Object instantiateObject(Class theClass, String theString) throws Exception {
        Class[] signature = new Class[]{String.class};
        Constructor constructor = theClass.getConstructor(signature);
        Object result = null;
        try {
            result = constructor.newInstance(theString);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw e;
        }
        return result;
    }

    private static Object instantiateNumber(String theString) throws Exception {
        Object result = null;
        if (theString.indexOf(46) >= 0) {
            result = ClassUtil.instantiateObject(Double.class, theString);
        } else {
            try {
                result = ClassUtil.instantiateObject(Integer.class, theString);
            }
            catch (NumberFormatException e) {
                result = ClassUtil.instantiateObject(Long.class, theString);
            }
        }
        return result;
    }

    public static Object instantiateFromString(Class theClass, String theString) throws Exception {
        Object result = null;
        if (theClass == Object.class) {
            result = ClassUtil.instantiateObject(theString);
        } else if (theClass == Number.class) {
            result = ClassUtil.instantiateNumber(theString);
        } else if (theClass == Character.class || theClass == Character.TYPE) {
            if (theString.length() != 1) {
                throw new IllegalArgumentException("not a character: " + theString);
            }
            result = Character.valueOf(theString.charAt(0));
        } else {
            Class objectClass = ClassUtil.primitiveClassToObjectClass(theClass);
            result = ClassUtil.instantiateObject(objectClass, theString);
        }
        return result;
    }

    public static Object instantiateDefault(Class inClass) throws Exception {
        Object result = null;
        Class objectClass = ClassUtil.primitiveClassToObjectClass(inClass);
        if (Number.class.isAssignableFrom(objectClass)) {
            result = ClassUtil.instantiateFromString(objectClass, "0");
        } else if (objectClass == Boolean.class) {
            result = Boolean.TRUE;
        } else if (objectClass == Character.class) {
            result = Character.valueOf('X');
        } else if (ClassUtil.classIsArray(objectClass)) {
            result = Array.newInstance(objectClass, 0);
        } else if (objectClass == Object.class) {
            result = "anyObject";
        } else if (objectClass == String.class) {
            result = "";
        } else if (objectClass == URL.class) {
            result = new URL("http://www.sun.com");
        } else if (objectClass == URI.class) {
            result = new URI("http://www.sun.com");
        } else if (ClassUtil.classIsArray(inClass)) {
            int dimensions = 3;
            result = Array.newInstance(ClassUtil.getInnerArrayElementClass(inClass), 3);
        } else {
            result = objectClass.newInstance();
        }
        return result;
    }

    public static String expandClassName(String name) {
        Object fullName = name;
        int numTypes = sNumBaseTypes;
        for (int i = 0; i < numTypes; ++i) {
            if (!name.equals(sJavaLangTypes[i])) continue;
            fullName = javaLang + name;
            break;
        }
        if (fullName == name) {
            if (name.equals("Number")) {
                fullName = javaLang + name;
            } else if (name.equals("BigDecimal") || name.equals("BigInteger")) {
                fullName = "java.math." + name;
            } else if (name.equals("URL") || name.equals("URI")) {
                fullName = "java.net." + name;
            } else if (name.equals("Date")) {
                fullName = "java.util." + name;
            } else if (name.equals("ObjectName")) {
                fullName = "javax.management." + name;
            }
        }
        return fullName;
    }

    public static Class convertArrayClass(Class arrayClass, Class newInnerType) throws ClassNotFoundException {
        String arrayClassname = arrayClass.getName();
        if (!arrayClassname.endsWith(";")) {
            throw new IllegalArgumentException("not an array of Object");
        }
        int innerNameBegin = 1 + arrayClassname.indexOf("L");
        String newClassName = arrayClassname.substring(0, innerNameBegin) + newInnerType.getName() + ";";
        Class newClass = ClassUtil.getClassFromName(newClassName);
        return newClass;
    }

    static final class ClassNameToClassMapping {
        String mName;
        Class mClass;

        ClassNameToClassMapping(String name, Class theClass) {
            this.mName = name;
            this.mClass = theClass;
        }
    }
}

