/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.remote;

import com.sun.enterprise.admin.event.AdminCommandEventBrokerImpl;
import com.sun.enterprise.admin.remote.Header;
import com.sun.enterprise.admin.remote.ParamsWithPayload;
import com.sun.enterprise.admin.remote.RestPayloadImpl;
import com.sun.enterprise.admin.remote.reader.CliActionReport;
import com.sun.enterprise.admin.remote.reader.ProprietaryReader;
import com.sun.enterprise.admin.remote.reader.ProprietaryReaderFactory;
import com.sun.enterprise.admin.remote.sse.GfSseEventReceiver;
import com.sun.enterprise.admin.remote.sse.GfSseEventReceiverProprietaryReader;
import com.sun.enterprise.admin.remote.sse.GfSseInboundEvent;
import com.sun.enterprise.admin.remote.writer.ProprietaryWriter;
import com.sun.enterprise.admin.remote.writer.ProprietaryWriterFactory;
import com.sun.enterprise.admin.util.AuthenticationInfo;
import com.sun.enterprise.admin.util.CachedCommandModel;
import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.admin.util.HttpConnectorAddress;
import com.sun.enterprise.admin.util.cache.AdminCacheUtils;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.net.NetUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.payload.PayloadFilesManager;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandState;
import org.glassfish.api.admin.AuthenticationException;
import org.glassfish.api.admin.CommandException;
import org.glassfish.api.admin.CommandModel;
import org.glassfish.api.admin.CommandValidationException;
import org.glassfish.api.admin.InvalidCommandException;
import org.glassfish.api.admin.ParameterMap;
import org.glassfish.api.admin.Payload;
import org.glassfish.common.util.admin.AuthTokenManager;

public class RemoteRestAdminCommand
extends AdminCommandEventBrokerImpl<GfSseInboundEvent> {
    private static final LocalStringsImpl strings = new LocalStringsImpl(RemoteRestAdminCommand.class);
    private static final String ADMIN_URI_PATH = "/command/";
    private static final String COMMAND_NAME_REGEXP = "^[a-zA-Z_][-a-zA-Z0-9_]*$";
    private static final String READ_TIMEOUT = "AS_ADMIN_READTIMEOUT";
    public static final String COMMAND_MODEL_MATCH_HEADER = "X-If-Command-Model-Match";
    private static final String MEDIATYPE_TXT = "text/plain";
    private static final String MEDIATYPE_JSON = "application/json";
    private static final String MEDIATYPE_MULTIPART = "multipart/*";
    private static final String MEDIATYPE_SSE = "text/event-stream";
    private static final String EOL = StringUtils.EOL;
    private static final int defaultReadTimeout;
    private String responseFormatType = "hk2-agent";
    protected String output;
    private Map<String, String> attrs;
    private boolean doUpload = false;
    private boolean addedUploadOption = false;
    private RestPayloadImpl.Outbound outboundPayload;
    private String usage;
    private File fileOutputDir;
    private StringBuilder passwordOptions;
    private String manpage;
    private String cmduri;
    private ActionReport actionReport;
    protected String name;
    protected String host;
    private String canonicalHostCache;
    protected int port;
    protected boolean secure;
    protected boolean notify;
    protected String user;
    protected char[] password;
    protected Logger logger;
    protected String scope;
    protected String authToken = null;
    protected boolean prohibitDirectoryUploads = false;
    protected ParameterMap options;
    protected List<String> operands;
    private CommandModel commandModel;
    private boolean commandModelFromCache = false;
    private int readTimeout = defaultReadTimeout;
    private int connectTimeout = -1;
    private boolean interactive = true;
    private final List<Header> requestHeaders = new ArrayList<Header>();
    private boolean closeSse = false;
    private boolean enableCommandModelCache = true;
    private OutputStream userOut;
    private static final String FILE_PAYLOAD_MIME_TYPE = "application/octet-stream";

    public RemoteRestAdminCommand(String name, String host, int port) throws CommandException {
        this(name, host, port, false, "admin", null, Logger.getAnonymousLogger(), false);
    }

    public RemoteRestAdminCommand(String name, String host, int port, boolean secure, String user, char[] password, Logger logger, boolean notify) throws CommandException {
        this(name, host, port, secure, user, password, logger, null, null, false, notify);
    }

    public RemoteRestAdminCommand(String name, String host, int port, boolean secure, String user, char[] password, Logger logger, String scope, String authToken, boolean prohibitDirectoryUploads, boolean notify) throws CommandException {
        this.name = name;
        this.host = host;
        this.port = port;
        this.secure = secure;
        this.notify = notify;
        this.user = user;
        this.password = password;
        this.logger = logger;
        this.scope = scope;
        this.authToken = authToken;
        this.prohibitDirectoryUploads = prohibitDirectoryUploads;
        this.checkName();
    }

    private void checkName() throws CommandException {
        if (!this.name.matches(COMMAND_NAME_REGEXP)) {
            throw new CommandException("Illegal command name: " + this.name);
        }
    }

    public void closeSse(String message, ActionReport.ExitCode exitCode) {
        CliActionReport report = new CliActionReport();
        report.setMessage(message);
        report.setActionExitCode(exitCode);
        this.setActionReport(report);
        this.closeSse = true;
    }

    public void setResponseFormatType(String responseFormatType) {
        this.responseFormatType = responseFormatType;
    }

    public void setUserOut(OutputStream userOut) {
        this.userOut = userOut;
    }

    public void setCommandModel(CommandModel commandModel) {
        this.commandModel = commandModel;
        this.commandModelFromCache = false;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    public static int getReadTimeout() {
        return defaultReadTimeout;
    }

    public String findPropertyInReport(String key) {
        if (this.actionReport == null) {
            return null;
        }
        return this.actionReport.findProperty(key);
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setInteractive(boolean state) {
        this.interactive = state;
    }

    public void setEnableCommandModelCache(boolean enableCommandModelCache) {
        this.enableCommandModelCache = enableCommandModelCache;
    }

    public CommandModel getCommandModel() throws CommandException {
        block8: {
            if (this.commandModel == null && this.enableCommandModelCache) {
                long startNanos = System.nanoTime();
                try {
                    this.commandModel = this.getCommandModelFromCache();
                    if (this.commandModel != null) {
                        this.commandModelFromCache = true;
                        if (this.logger.isLoggable(Level.FINEST)) {
                            this.logger.log(Level.FINEST, "Command model for command {0} was successfully loaded from the cache. [Duration: {1} nanos]", new Object[]{this.name, System.nanoTime() - startNanos});
                        }
                    } else if (this.logger.isLoggable(Level.FINEST)) {
                        this.logger.log(Level.FINEST, "Command model for command {0} is not in cache. It must be fatched from server.", this.name);
                    }
                }
                catch (Exception ex) {
                    if (!this.logger.isLoggable(Level.FINEST)) break block8;
                    this.logger.log(Level.FINEST, "Can not get data from cache under key " + this.createCommandCacheKey(), ex);
                }
            }
        }
        if (this.commandModel == null) {
            this.fetchCommandModel();
        }
        return this.commandModel;
    }

    private CommandModel getCommandModelFromCache() {
        String cachedModel = AdminCacheUtils.getCache().get(this.createCommandCacheKey(), String.class);
        if (cachedModel == null) {
            return null;
        }
        int ind = (cachedModel = cachedModel.trim()).indexOf(10);
        if (ind < 0) {
            return null;
        }
        String eTag = cachedModel.substring(0, ind);
        if (!eTag.startsWith("ETag:")) {
            return null;
        }
        eTag = eTag.substring(5).trim();
        if (this.logger.isLoggable(Level.FINEST)) {
            this.logger.log(Level.FINEST, "Cached command model ETag is {0}", eTag);
        }
        String content = cachedModel.substring(ind + 1).trim();
        CachedCommandModel result = this.parseMetadata(content, eTag);
        return result;
    }

    private CachedCommandModel parseMetadata(String str, String etag) {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.finer("------- RAW METADATA RESPONSE ---------");
            this.logger.log(Level.FINER, "ETag: {0}", etag);
            this.logger.finer(str);
            this.logger.finer("------- RAW METADATA RESPONSE ---------");
        }
        if (str == null) {
            return null;
        }
        try {
            boolean sawFile = false;
            JSONObject obj = new JSONObject(str);
            obj = obj.getJSONObject("command");
            CachedCommandModel cm = new CachedCommandModel(obj.getString("@name"), etag);
            cm.dashOk = obj.optBoolean("@unknown-options-are-operands", false);
            cm.managedJob = obj.optBoolean("@managed-job", false);
            cm.setUsage(obj.optString("usage", null));
            Object optns = obj.opt("option");
            if (!JSONObject.NULL.equals(optns)) {
                JSONArray jsonOptions;
                if (optns instanceof JSONArray) {
                    jsonOptions = (JSONArray)optns;
                } else {
                    jsonOptions = new JSONArray();
                    jsonOptions.put(optns);
                }
                for (int i = 0; i < jsonOptions.length(); ++i) {
                    JSONObject jsOpt = jsonOptions.getJSONObject(i);
                    String type = jsOpt.getString("@type");
                    CommandModelData.ParamModelData opt = new CommandModelData.ParamModelData(jsOpt.getString("@name"), this.typeOf(type), jsOpt.optBoolean("@optional", false), jsOpt.optString("@default"), jsOpt.optString("@short"), jsOpt.optBoolean("@obsolete", false), jsOpt.optString("@alias"));
                    opt.param._acceptableValues = jsOpt.optString("@acceptable-values");
                    if ("PASSWORD".equals(type)) {
                        opt.param._password = true;
                        opt.prompt = jsOpt.optString("@prompt");
                        opt.promptAgain = jsOpt.optString("@prompt-again");
                    } else if ("FILE".equals(type)) {
                        sawFile = true;
                    }
                    if (jsOpt.optBoolean("@primary", false)) {
                        opt.param._primary = true;
                    }
                    if (jsOpt.optBoolean("@multiple", false)) {
                        opt.type = opt.type == File.class ? File[].class : List.class;
                        opt.param._multiple = true;
                    }
                    cm.add(opt);
                }
            }
            if (sawFile) {
                cm.add(new CommandModelData.ParamModelData("upload", Boolean.class, true, null));
                this.addedUploadOption = true;
                cm.setAddedUploadOption(true);
            }
            if (this.notify) {
                cm.add(new CommandModelData.ParamModelData("notify", Boolean.class, false, "false"));
            }
            this.usage = cm.getUsage();
            return cm;
        }
        catch (JSONException ex) {
            this.logger.log(Level.FINER, "Can not parse command metadata", ex);
            return null;
        }
    }

    public boolean isCommandModelFromCache() {
        return this.commandModelFromCache;
    }

    public void setFileOutputDirectory(File dir) {
        this.fileOutputDir = dir;
    }

    public List<Header> headers() {
        return this.requestHeaders;
    }

    protected boolean useSse() throws CommandException {
        return this.getCommandModel().isManagedJob();
    }

    public String executeCommand(ParameterMap opts) throws CommandException {
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "RemoteRestAdminCommand.executeCommand() - name: {0}", this.name);
        }
        if (opts != null && opts.size() == 1 && opts.containsKey((Object)"help")) {
            return this.getManPage();
        }
        ParameterMap params = this.processParams(opts);
        boolean retry = false;
        try {
            this.executeRemoteCommand(params);
        }
        catch (CommandValidationException mve) {
            if (this.refetchInvalidModel() && this.isCommandModelFromCache()) {
                this.fetchCommandModel();
                retry = true;
            }
            throw mve;
        }
        return this.output;
    }

    private ParameterMap processParams(ParameterMap opts) throws CommandException {
        if (opts == null) {
            opts = new ParameterMap();
        }
        this.getCommandModel();
        this.options = new ParameterMap();
        for (Map.Entry o : opts.entrySet()) {
            String key = (String)o.getKey();
            List value = (List)o.getValue();
            this.options.set((Object)key.toLowerCase(Locale.ENGLISH), (Collection)value);
        }
        this.operands = this.options.get((Object)"default");
        try {
            this.initializeDoUpload();
            this.outboundPayload = this.doUpload ? new RestPayloadImpl.Outbound(true) : null;
            ParameterMap result = new ParameterMap();
            CommandModel.ParamModel operandParam = null;
            for (CommandModel.ParamModel opt : this.commandModel.getParameters()) {
                String envValue;
                if (opt.getParam().primary()) {
                    operandParam = opt;
                    continue;
                }
                String paramName = opt.getName();
                ArrayList<String> paramValues = new ArrayList<String>(this.options.get((Object)paramName.toLowerCase(Locale.ENGLISH)));
                if (!opt.getParam().alias().isEmpty() && !paramName.equalsIgnoreCase(opt.getParam().alias())) {
                    paramValues.addAll(this.options.get((Object)opt.getParam().alias().toLowerCase(Locale.ENGLISH)));
                }
                if (!opt.getParam().multiple() && paramValues.size() > 1) {
                    throw new CommandException(strings.get("tooManyOptions", new Object[]{paramName}));
                }
                if (paramValues.isEmpty() && (envValue = this.getFromEnvironment(paramName)) != null) {
                    paramValues.add(envValue);
                }
                if (paramValues.isEmpty()) {
                    if (opt.getParam().optional()) continue;
                    throw new CommandException(strings.get("missingOption", new Object[]{paramName}));
                }
                for (String paramValue : paramValues) {
                    if (opt.getType() == File.class || opt.getType() == File[].class) {
                        this.addFileOption(result, paramName, paramValue);
                        continue;
                    }
                    result.add((Object)paramName, (Object)paramValue);
                }
            }
            for (String operand : this.operands) {
                if (operandParam.getType() == File.class || operandParam.getType() == File[].class) {
                    this.addFileOption(result, "DEFAULT", operand);
                    continue;
                }
                result.add((Object)"DEFAULT", (Object)operand);
            }
            return result;
        }
        catch (IOException ioex) {
            throw new CommandException("I/O Error", (Throwable)ioex);
        }
    }

    protected boolean refetchInvalidModel() {
        return true;
    }

    public Map<String, String> getAttributes() {
        return this.attrs;
    }

    protected boolean updateAuthentication() {
        return false;
    }

    protected String getFromEnvironment(String name) {
        return null;
    }

    protected boolean retryUsingSecureConnection(String host, int port) {
        return false;
    }

    protected String reportAuthenticationException() {
        return strings.get("InvalidCredentials", new Object[]{this.user});
    }

    protected String getCommandURI() {
        if (this.cmduri == null) {
            StringBuilder rv = new StringBuilder(ADMIN_URI_PATH);
            if (this.scope != null) {
                rv.append(this.scope);
            }
            rv.append(this.name);
            this.cmduri = rv.toString();
        }
        return this.cmduri;
    }

    private void executeRemoteCommand(final ParameterMap params) throws CommandException {
        this.doHttpCommand(this.getCommandURI(), "POST", new HttpCommand(){

            @Override
            public void prepareConnection(HttpURLConnection urlConnection) throws IOException {
                ParamsWithPayload pwp;
                try {
                    if (RemoteRestAdminCommand.this.useSse()) {
                        urlConnection.addRequestProperty("Accept", RemoteRestAdminCommand.MEDIATYPE_SSE);
                    } else {
                        urlConnection.addRequestProperty("Accept", "application/json; q=0.8, multipart/*; q=0.9");
                    }
                }
                catch (CommandException cex) {
                    throw new IOException(cex.getLocalizedMessage(), cex);
                }
                for (Header h : RemoteRestAdminCommand.this.requestHeaders) {
                    urlConnection.addRequestProperty(h.getName(), h.getValue());
                }
                if (RemoteRestAdminCommand.this.doUpload) {
                    urlConnection.setChunkedStreamingMode(0);
                    pwp = new ParamsWithPayload(RemoteRestAdminCommand.this.outboundPayload, params);
                } else {
                    pwp = new ParamsWithPayload(null, params);
                }
                ProprietaryWriter writer = ProprietaryWriterFactory.getWriter(pwp);
                if (RemoteRestAdminCommand.this.logger.isLoggable(Level.FINER)) {
                    RemoteRestAdminCommand.this.logger.log(Level.FINER, "Writer to use {0}", writer.getClass().getName());
                }
                writer.writeTo(pwp, urlConnection);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void useConnection(HttpURLConnection urlConnection) throws CommandException, IOException {
                String resultMediaType = urlConnection.getContentType();
                if (RemoteRestAdminCommand.this.logger.isLoggable(Level.FINER)) {
                    RemoteRestAdminCommand.this.logger.log(Level.FINER, "Result type is {0}", resultMediaType);
                    RemoteRestAdminCommand.this.logger.log(Level.FINER, "URL connection is {0}", urlConnection.getClass().getName());
                }
                if (resultMediaType != null && resultMediaType.startsWith(RemoteRestAdminCommand.MEDIATYPE_SSE)) {
                    String instanceId = null;
                    boolean retryableCommand = false;
                    try {
                        GfSseInboundEvent event;
                        RemoteRestAdminCommand.this.logger.log(Level.FINEST, "Response is SSE - about to read events");
                        RemoteRestAdminCommand.this.closeSse = false;
                        GfSseEventReceiverProprietaryReader reader = new GfSseEventReceiverProprietaryReader();
                        GfSseEventReceiver eventReceiver = (GfSseEventReceiver)reader.readFrom(urlConnection.getInputStream(), resultMediaType);
                        do {
                            if ((event = eventReceiver.readEvent()) == null) continue;
                            RemoteRestAdminCommand.this.logger.log(Level.FINEST, "Event: {0}", event.getName());
                            RemoteRestAdminCommand.this.fireEvent(event.getName(), event);
                            if (!"AdminCommandInstance/stateChanged".equals(event.getName())) continue;
                            AdminCommandState acs = event.getData(AdminCommandState.class, RemoteRestAdminCommand.MEDIATYPE_JSON);
                            if (acs.getId() != null) {
                                instanceId = acs.getId();
                                RemoteRestAdminCommand.this.logger.log(Level.FINEST, "Command instance ID: {0}", instanceId);
                            }
                            if (acs.getState() == AdminCommandState.State.COMPLETED || acs.getState() == AdminCommandState.State.RECORDED || acs.getState() == AdminCommandState.State.REVERTED) {
                                if (acs.getActionReport() != null) {
                                    RemoteRestAdminCommand.this.setActionReport(acs.getActionReport());
                                }
                                RemoteRestAdminCommand.this.closeSse = true;
                                if (acs.isOutboundPayloadEmpty()) continue;
                                RemoteRestAdminCommand.this.logger.log(Level.FINEST, "Romote command holds data. Must load it");
                                RemoteRestAdminCommand.this.downloadPayloadFromManaged(instanceId);
                                continue;
                            }
                            if (acs.getState() == AdminCommandState.State.FAILED_RETRYABLE) {
                                RemoteRestAdminCommand.this.logger.log(Level.INFO, strings.get("remotecommand.failedretryable", new Object[]{acs.getId()}));
                                if (acs.getActionReport() != null) {
                                    RemoteRestAdminCommand.this.setActionReport(acs.getActionReport());
                                }
                                RemoteRestAdminCommand.this.closeSse = true;
                                continue;
                            }
                            if (acs.getState() != AdminCommandState.State.RUNNING_RETRYABLE) continue;
                            RemoteRestAdminCommand.this.logger.log(Level.FINEST, "Command stores checkpoint and is retryable");
                            retryableCommand = true;
                        } while (event != null && !eventReceiver.isClosed() && !RemoteRestAdminCommand.this.closeSse);
                        if (!RemoteRestAdminCommand.this.closeSse) return;
                        try {
                            eventReceiver.close();
                            return;
                        }
                        catch (Exception exception) {}
                        return;
                    }
                    catch (IOException ioex) {
                        if (instanceId == null || !"Premature EOF".equals(ioex.getMessage())) throw new CommandException(ioex.getMessage(), (Throwable)ioex);
                        if (!retryableCommand) throw new CommandException(strings.get("remotecommand.lostConnection", new Object[]{instanceId}), (Throwable)ioex);
                        throw new CommandException(strings.get("remotecommand.lostConnection.retryableCommand", new Object[]{instanceId}), (Throwable)ioex);
                    }
                    catch (Exception ex) {
                        throw new CommandException(ex.getMessage(), (Throwable)ex);
                    }
                }
                ProprietaryReader<ParamsWithPayload> reader = ProprietaryReaderFactory.getReader(ParamsWithPayload.class, resultMediaType);
                if (urlConnection.getResponseCode() == 500) {
                    CliActionReport report;
                    if (reader == null) {
                        report = new CliActionReport();
                        report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                        report.setMessage(urlConnection.getResponseMessage());
                    } else {
                        report = reader.readFrom(urlConnection.getErrorStream(), resultMediaType).getActionReport();
                    }
                    RemoteRestAdminCommand.this.setActionReport(report);
                    return;
                }
                ParamsWithPayload pwp = reader.readFrom(urlConnection.getInputStream(), resultMediaType);
                if (pwp.getPayloadInbound() == null) {
                    RemoteRestAdminCommand.this.setActionReport(pwp.getActionReport());
                    return;
                }
                if (!resultMediaType.startsWith("multipart/")) return;
                RestPayloadImpl.Inbound inbound = pwp.getPayloadInbound();
                RemoteRestAdminCommand.this.setActionReport(pwp.getActionReport());
                if (RemoteRestAdminCommand.this.logger.isLoggable(Level.FINER)) {
                    RemoteRestAdminCommand.this.logger.log(Level.FINER, "------ PAYLOAD ------");
                    Iterator<Payload.Part> parts = inbound.parts();
                    while (parts.hasNext()) {
                        Payload.Part part = parts.next();
                        RemoteRestAdminCommand.this.logger.log(Level.FINER, " - {0} [{1}]", new Object[]{part.getName(), part.getContentType()});
                    }
                    RemoteRestAdminCommand.this.logger.log(Level.FINER, "---- END PAYLOAD ----");
                }
                PayloadFilesManager.Perm downloadedFilesMgr = new PayloadFilesManager.Perm(RemoteRestAdminCommand.this.fileOutputDir, null, RemoteRestAdminCommand.this.logger, null);
                try {
                    downloadedFilesMgr.processParts((Payload.Inbound)inbound);
                    return;
                }
                catch (CommandException cex) {
                    throw cex;
                }
                catch (Exception ex) {
                    throw new CommandException(ex.getMessage(), (Throwable)ex);
                }
            }
        });
        if (this.actionReport == null) {
            this.output = null;
            throw new CommandException(strings.get("emptyResponse"));
        }
        if (this.actionReport.getActionExitCode() == ActionReport.ExitCode.FAILURE) {
            throw new CommandException(strings.getString("remote.failure.prefix", "remote failure:") + " " + this.output);
        }
    }

    private void downloadPayloadFromManaged(String jobId) {
        if (jobId == null) {
            return;
        }
        try {
            RemoteRestAdminCommand command = new RemoteRestAdminCommand("_get-payload", this.host, this.port, this.secure, this.user, this.password, this.logger, this.scope, this.authToken, this.prohibitDirectoryUploads, this.notify);
            ParameterMap params = new ParameterMap();
            params.add((Object)"DEFAULT", (Object)jobId);
            command.executeCommand(params);
        }
        catch (CommandException ex) {
            this.logger.log(Level.WARNING, strings.getString("remote.sse.canNotGetPayload", "Cannot retrieve payload. {0}"), ex.getMessage());
        }
    }

    protected void setActionReport(ActionReport ar) {
        this.actionReport = ar;
        if (ar == null) {
            this.output = null;
        } else {
            StringBuilder sb = new StringBuilder();
            if (ar instanceof CliActionReport) {
                RemoteRestAdminCommand.addCombinedMessages((CliActionReport)ar, sb);
            } else if (ar.getMessage() != null) {
                sb.append(ar.getMessage());
            }
            RemoteRestAdminCommand.addSubMessages("", ar.getTopMessagePart(), sb);
            this.output = sb.toString();
            if (this.logger.isLoggable(Level.FINER)) {
                this.logger.log(Level.FINER, "------ ACTION REPORT ------");
                this.logger.log(Level.FINER, String.valueOf(this.actionReport));
                this.logger.log(Level.FINER, "---- END ACTION REPORT ----");
            }
        }
    }

    public ActionReport getActionReport() {
        return this.actionReport;
    }

    private static void addSubMessages(String indentPrefix, ActionReport.MessagePart mp, StringBuilder sb) {
        List children;
        if (mp == null || sb == null) {
            return;
        }
        if (indentPrefix == null) {
            indentPrefix = "";
        }
        if ((children = mp.getChildren()) != null) {
            for (ActionReport.MessagePart subPart : children) {
                if (sb.length() > 0) {
                    sb.append(EOL);
                }
                if (RemoteRestAdminCommand.ok(subPart.getMessage())) {
                    sb.append(subPart.getMessage());
                }
                RemoteRestAdminCommand.addSubMessages(indentPrefix + "    ", subPart, sb);
            }
        }
    }

    private static void addCombinedMessages(CliActionReport aReport, StringBuilder sb) {
        if (aReport == null || sb == null) {
            return;
        }
        String mainMsg = "";
        if (aReport.getMessage() != null && aReport.getMessage().length() != 0) {
            if (sb.length() > 0) {
                sb.append(EOL);
            }
            sb.append(aReport.getMessage());
        }
        if (aReport.getFailureCause() != null && aReport.getFailureCause().getMessage() != null && aReport.getFailureCause().getMessage().length() != 0) {
            String failMsg = aReport.getFailureCause().getMessage();
            if (!failMsg.equals(mainMsg) && sb.length() > 0) {
                sb.append(EOL);
            }
            sb.append(failMsg);
        }
        for (CliActionReport sub : aReport.getSubActionsReport()) {
            RemoteRestAdminCommand.addCombinedMessages(sub, sb);
        }
    }

    private void doHttpCommand(String uriString, String httpMethod, HttpCommand cmd) throws CommandException {
        this.doHttpCommand(uriString, httpMethod, cmd, false);
    }

    private void doHttpCommand(String uriString, String httpMethod, HttpCommand cmd, boolean isForMetadata) throws CommandException {
        boolean shouldTryCommandAgain;
        boolean askedUserForCredentials = false;
        boolean shouldUseSecure = this.secure;
        HttpConnectorAddress url = this.getHttpConnectorAddress(this.host, this.port, shouldUseSecure);
        url.setInteractive(this.interactive);
        do {
            String msg;
            shouldTryCommandAgain = false;
            try {
                AuthenticationInfo authInfo = this.authenticationInfo();
                if (this.logger.isLoggable(Level.FINER)) {
                    this.logger.log(Level.FINER, "URI: {0}", uriString);
                    this.logger.log(Level.FINER, "URL: {0}", url.toURL(uriString).toString());
                    this.logger.log(Level.FINER, "Method: {0}", httpMethod);
                    this.logger.log(Level.FINER, "Password options: {0}", this.passwordOptions);
                    this.logger.log(Level.FINER, "Using auth info: {0}", authInfo);
                }
                if (authInfo != null) {
                    url.setAuthenticationInfo(authInfo);
                }
                HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection(uriString);
                urlConnection.setRequestProperty("User-Agent", this.responseFormatType);
                if (this.passwordOptions != null) {
                    urlConnection.setRequestProperty("X-passwords", this.passwordOptions.toString());
                }
                urlConnection.addRequestProperty("Cache-Control", "no-cache");
                urlConnection.addRequestProperty("Pragma", "no-cache");
                if (this.authToken != null) {
                    urlConnection.setRequestProperty("X-GlassFish-authToken", isForMetadata ? AuthTokenManager.markTokenForReuse((String)this.authToken) : this.authToken);
                }
                if (this.commandModel != null && this.isCommandModelFromCache() && this.commandModel instanceof CachedCommandModel) {
                    urlConnection.setRequestProperty(COMMAND_MODEL_MATCH_HEADER, ((CachedCommandModel)this.commandModel).getETag());
                    if (this.logger.isLoggable(Level.FINER)) {
                        this.logger.log(Level.FINER, "CommandModel ETag: {0}", ((CachedCommandModel)this.commandModel).getETag());
                    }
                }
                urlConnection.setRequestMethod(httpMethod);
                urlConnection.setReadTimeout(this.readTimeout);
                if (this.connectTimeout >= 0) {
                    urlConnection.setConnectTimeout(this.connectTimeout);
                }
                this.addAdditionalHeaders(urlConnection);
                urlConnection.addRequestProperty("X-Requested-By", "cli");
                cmd.prepareConnection(urlConnection);
                urlConnection.connect();
                String redirection = this.checkConnect(urlConnection);
                if (redirection != null) {
                    this.logger.log(Level.FINER, "Following redirection to " + redirection);
                    url = this.followRedirection(url, redirection);
                    shouldTryCommandAgain = true;
                    shouldUseSecure = url.isSecure();
                    this.secure = true;
                    urlConnection.disconnect();
                    continue;
                }
                cmd.useConnection(urlConnection);
                this.processHeaders(urlConnection);
                this.logger.finer("doHttpCommand succeeds");
            }
            catch (AuthenticationException authEx) {
                this.logger.log(Level.FINER, "DAS has challenged for credentials");
                if (askedUserForCredentials) {
                    this.logger.log(Level.FINER, "Already tried with updated credentials; cannot authenticate");
                    throw authEx;
                }
                this.logger.log(Level.FINER, "Try to update credentials");
                if (!this.updateAuthentication()) {
                    this.logger.log(Level.FINER, "Could not update credentials; cannot authenticate");
                    throw authEx;
                }
                this.logger.log(Level.FINER, "Was able to update the credentials so will retry with the updated ones");
                askedUserForCredentials = true;
                shouldTryCommandAgain = true;
            }
            catch (ConnectException ce) {
                this.logger.log(Level.FINER, "doHttpCommand: connect exception {0}", ce);
                msg = strings.get("ConnectException", new Object[]{this.host, "" + this.port});
                throw new CommandException(msg, (Throwable)ce);
            }
            catch (UnknownHostException he) {
                this.logger.log(Level.FINER, "doHttpCommand: host exception {0}", he);
                msg = strings.get("UnknownHostException", new Object[]{this.host});
                throw new CommandException(msg, (Throwable)he);
            }
            catch (SocketException se) {
                this.logger.log(Level.FINER, "doHttpCommand: socket exception {0}", se);
                try {
                    boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.host, (int)this.port);
                    if (!serverAppearsSecure || shouldUseSecure || !this.retryUsingSecureConnection(this.host, this.port)) {
                        throw new CommandException((Throwable)se);
                    }
                    shouldUseSecure = true;
                    shouldTryCommandAgain = true;
                }
                catch (IOException io) {
                    throw new CommandException((Throwable)io);
                }
            }
            catch (SSLException se) {
                this.logger.log(Level.FINER, "doHttpCommand: SSL exception {0}", se);
                try {
                    boolean serverAppearsSecure = NetUtils.isSecurePort((String)this.host, (int)this.port);
                    if (!serverAppearsSecure && this.secure) {
                        this.logger.log(Level.SEVERE, "NCLS-ADMIN-00010", new Object[]{this.host, this.port});
                    }
                    throw new CommandException((Throwable)se);
                }
                catch (IOException io) {
                    throw new CommandException((Throwable)io);
                }
            }
            catch (SocketTimeoutException e) {
                this.logger.log(Level.FINER, "doHttpCommand: read timeout {0}", e);
                throw new CommandException(strings.get("ReadTimeout", new Object[]{Float.valueOf((float)this.readTimeout / 1000.0f)}), (Throwable)e);
            }
            catch (IOException e) {
                this.logger.log(Level.FINER, "doHttpCommand: IO exception {0}", e);
                throw new CommandException(strings.get("IOError", new Object[]{e.getMessage()}), (Throwable)e);
            }
            catch (CommandException e) {
                throw e;
            }
            catch (Exception e) {
                this.logger.log(Level.FINER, "doHttpCommand: exception {0}", e);
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                e.printStackTrace(new PrintStream(buf));
                this.logger.finer(buf.toString());
                throw new CommandException((Throwable)e);
            }
        } while (shouldTryCommandAgain);
        this.outboundPayload = null;
    }

    private HttpConnectorAddress followRedirection(HttpConnectorAddress originalAddr, String redirection) throws MalformedURLException {
        URL url = new URL(redirection);
        boolean useSecure = url.getProtocol().equalsIgnoreCase("https");
        HttpConnectorAddress hca = new HttpConnectorAddress(url.getHost(), url.getPort(), useSecure, originalAddr.getPath(), originalAddr.getSSLSocketFactory());
        hca.setInteractive(this.interactive);
        return hca;
    }

    protected HttpConnectorAddress getHttpConnectorAddress(String host, int port, boolean shouldUseSecure) {
        HttpConnectorAddress hca = new HttpConnectorAddress(host, port, shouldUseSecure);
        hca.setInteractive(this.interactive);
        return hca;
    }

    protected void addAdditionalHeaders(URLConnection urlConnection) {
    }

    protected void processHeaders(URLConnection urlConnection) {
    }

    protected AuthenticationInfo authenticationInfo() {
        return this.user != null || this.password != null ? new AuthenticationInfo(this.user, this.password) : null;
    }

    private String checkConnect(HttpURLConnection urlConnection) throws IOException, CommandException {
        int code = urlConnection.getResponseCode();
        if (this.logger.isLoggable(Level.FINER)) {
            this.logger.log(Level.FINER, "Response code: " + code);
        }
        if (code == -1) {
            URL url = urlConnection.getURL();
            throw new CommandException(strings.get("NotHttpResponse", new Object[]{url.getHost(), url.getPort()}));
        }
        if (code == 401) {
            throw new AuthenticationException(this.reportAuthenticationException());
        }
        if (code == 412) {
            throw new CommandValidationException("Code: 412: Cached CommandModel is invalid.");
        }
        if (code == 404) {
            try {
                InputStream errorStream = urlConnection.getErrorStream();
                try {
                    throw new InvalidCommandException(ProprietaryReaderFactory.getReader(String.class, urlConnection.getContentType()).readFrom(errorStream, urlConnection.getContentType()));
                }
                catch (Throwable throwable) {
                    if (errorStream != null) {
                        try {
                            errorStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
            }
            catch (IOException ioex) {
                throw new InvalidCommandException(urlConnection.getResponseMessage());
            }
        }
        if (this.isStatusRedirection(code)) {
            return urlConnection.getHeaderField("Location");
        }
        if (code != 200 && code != 500) {
            throw new CommandException(strings.get("BadResponse", new Object[]{String.valueOf(code), urlConnection.getResponseMessage()}));
        }
        return null;
    }

    private boolean isStatusRedirection(int returnCode) {
        return returnCode == 302;
    }

    public String getUsage() {
        return this.usage;
    }

    private void addFileOption(ParameterMap params, String optionName, String filename) throws IOException, CommandException {
        boolean uploadThisFile;
        File f = SmartFile.sanitize((File)new File(filename));
        this.logger.finer("FILE PARAM: " + optionName + " = " + String.valueOf(f));
        boolean bl = uploadThisFile = this.doUpload && !f.isDirectory();
        if (uploadThisFile) {
            this.logger.finer("Uploading file");
            try {
                this.outboundPayload.attachFile(FILE_PAYLOAD_MIME_TYPE, URI.create(optionName + "/" + f.getName() + (f.isDirectory() ? "/" : "")), optionName, null, f, true);
            }
            catch (FileNotFoundException fnfe) {
                throw new CommandException(strings.get("UploadedFileNotFound", new Object[]{f.getAbsolutePath()}));
            }
        }
        if (f != null) {
            String pathToPass = uploadThisFile ? f.getName() : f.getPath();
            params.add((Object)optionName, (Object)pathToPass);
        }
    }

    protected void fetchCommandModel() throws CommandException {
        final long startNanos = System.nanoTime();
        this.commandModel = null;
        this.doHttpCommand(this.getCommandURI(), "GET", new HttpCommand(){

            @Override
            public void prepareConnection(HttpURLConnection urlConnection) {
                urlConnection.setRequestProperty("Accept", RemoteRestAdminCommand.MEDIATYPE_JSON);
            }

            @Override
            public void useConnection(HttpURLConnection urlConnection) throws CommandException, IOException {
                String eTag = urlConnection.getHeaderField("ETag");
                if (eTag != null) {
                    if ((eTag = eTag.trim()).startsWith("W/")) {
                        eTag = eTag.substring(2).trim();
                    }
                    if (eTag.startsWith("\"")) {
                        eTag = eTag.substring(1);
                    }
                    if (eTag.endsWith("\"")) {
                        eTag = eTag.substring(0, eTag.length() - 1);
                    }
                }
                String json = ProprietaryReaderFactory.getReader(String.class, urlConnection.getContentType()).readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
                RemoteRestAdminCommand.this.commandModel = RemoteRestAdminCommand.this.parseMetadata(json, eTag);
                if (RemoteRestAdminCommand.this.commandModel != null) {
                    RemoteRestAdminCommand.this.commandModelFromCache = false;
                    if (RemoteRestAdminCommand.this.logger.isLoggable(Level.FINEST)) {
                        RemoteRestAdminCommand.this.logger.log(Level.FINEST, "Command model for {0} command fetched from remote server. [Duration: {1} nanos]", new Object[]{RemoteRestAdminCommand.this.name, System.nanoTime() - startNanos});
                    }
                    try {
                        StringBuilder forCache = new StringBuilder(json.length() + 40);
                        forCache.append("ETag: ").append(eTag);
                        forCache.append("\n");
                        forCache.append(json);
                        AdminCacheUtils.getCache().put(RemoteRestAdminCommand.this.createCommandCacheKey(), forCache.toString());
                    }
                    catch (Exception ex) {
                        if (RemoteRestAdminCommand.this.logger.isLoggable(Level.WARNING)) {
                            RemoteRestAdminCommand.this.logger.log(Level.WARNING, "NCLS-ADMIN-00013", new Object[]{RemoteRestAdminCommand.this.createCommandCacheKey()});
                        }
                    }
                } else {
                    throw new InvalidCommandException(strings.get("unknownError"));
                }
            }
        });
    }

    public String getManPage() throws CommandException {
        if (this.manpage == null) {
            this.doHttpCommand(this.getCommandURI() + "/manpage", "GET", new HttpCommand(){

                @Override
                public void prepareConnection(HttpURLConnection urlConnection) {
                    urlConnection.setRequestProperty("Accept", RemoteRestAdminCommand.MEDIATYPE_TXT);
                }

                @Override
                public void useConnection(HttpURLConnection urlConnection) throws CommandException, IOException {
                    RemoteRestAdminCommand.this.manpage = ProprietaryReaderFactory.getReader(String.class, urlConnection.getContentType()).readFrom(urlConnection.getInputStream(), urlConnection.getContentType());
                }
            });
        }
        return this.manpage;
    }

    private String createCommandCacheKey() {
        StringBuilder result = new StringBuilder(this.getCanonicalHost().length() + this.name.length() + 12);
        result.append("cache/");
        result.append(this.getCanonicalHost()).append('_').append(this.port);
        result.append('/').append(this.name);
        return result.toString();
    }

    protected String getCanonicalHost() {
        block3: {
            if (this.canonicalHostCache == null) {
                try {
                    InetAddress address = InetAddress.getByName(this.host);
                    this.canonicalHostCache = address.getCanonicalHostName();
                }
                catch (UnknownHostException ex) {
                    this.canonicalHostCache = this.host;
                    if (this.canonicalHostCache == null) break block3;
                    this.canonicalHostCache = this.canonicalHostCache.trim().toLowerCase(Locale.ENGLISH);
                }
            }
        }
        return this.canonicalHostCache;
    }

    private Class<?> typeOf(String type) {
        if (type.equals("STRING")) {
            return String.class;
        }
        if (type.equals("BOOLEAN")) {
            return Boolean.class;
        }
        if (type.equals("FILE")) {
            return File.class;
        }
        if (type.equals("PASSWORD")) {
            return String.class;
        }
        if (type.equals("PROPERTIES")) {
            return Properties.class;
        }
        return String.class;
    }

    private void initializeDoUpload() throws CommandException {
        boolean sawFile = false;
        boolean sawDirectory = false;
        boolean sawUploadableFile = false;
        for (Object param : this.options.entrySet()) {
            CommandModel.ParamModel opt;
            String paramName = (String)param.getKey();
            if (paramName.equals("DEFAULT") || (opt = this.commandModel.getModelFor(paramName)) == null || opt.getType() != File.class && opt.getType() != File[].class) continue;
            sawFile = true;
            for (String fname : this.options.get((Object)opt.getName())) {
                File optionFile = new File(fname);
                sawDirectory |= optionFile.isDirectory();
                sawUploadableFile |= optionFile.isFile();
            }
        }
        CommandModel.ParamModel operandParam = this.getOperandModel();
        if (operandParam != null && (operandParam.getType() == File.class || operandParam.getType() == File[].class)) {
            sawFile |= !this.operands.isEmpty();
            for (String operandValue : this.operands) {
                File operandFile = new File(operandValue);
                sawDirectory |= operandFile.isDirectory();
                sawUploadableFile |= operandFile.isFile();
            }
        }
        if (sawFile) {
            this.logger.finer("Saw a file parameter");
            String upString = this.getOption("upload");
            if (RemoteRestAdminCommand.ok(upString)) {
                this.doUpload = Boolean.parseBoolean(upString);
            } else {
                boolean bl = this.doUpload = !RemoteRestAdminCommand.isLocal(this.host) && sawUploadableFile;
            }
            if (this.prohibitDirectoryUploads && sawDirectory && this.doUpload) {
                this.logger.finer("--upload=" + upString + ", doUpload=" + this.doUpload);
                throw new CommandException(strings.get("CantUploadDirectory"));
            }
        }
        if (this.addedUploadOption) {
            this.logger.finer("removing --upload option");
            ParameterMap noptions = new ParameterMap();
            for (Map.Entry e : this.options.entrySet()) {
                if (((String)e.getKey()).equals("upload")) continue;
                noptions.set((Object)((String)e.getKey()), (Collection)e.getValue());
            }
            this.options = noptions;
        }
        this.logger.finer("doUpload set to " + this.doUpload);
    }

    private static boolean isLocal(String hostname) {
        if (hostname.equalsIgnoreCase("localhost")) {
            return true;
        }
        try {
            InetAddress ia = InetAddress.getByName(hostname);
            return NetUtils.isLocal((String)ia.getHostAddress());
        }
        catch (UnknownHostException ex) {
            return false;
        }
    }

    private CommandModel.ParamModel getOperandModel() {
        for (CommandModel.ParamModel pm : this.commandModel.getParameters()) {
            if (!pm.getParam().primary()) continue;
            return pm;
        }
        return null;
    }

    private String getOption(String name) {
        String def;
        CommandModel.ParamModel opt;
        String val = (String)this.options.getOne((Object)name);
        if (val == null) {
            val = this.getFromEnvironment(name);
        }
        if (val == null && (opt = this.commandModel.getModelFor(name)) != null && RemoteRestAdminCommand.ok(def = opt.getParam().defaultValue())) {
            val = def;
        }
        return val;
    }

    private static boolean ok(String s) {
        return s != null && s.length() > 0;
    }

    public static void preinit() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                ProprietaryReaderFactory.getReader(Class.class, "not/defined");
                ProprietaryWriterFactory.getWriter(Class.class);
            }
        });
        thread.setDaemon(true);
        thread.start();
    }

    static {
        String rt = System.getProperty(READ_TIMEOUT);
        if (rt == null) {
            rt = System.getenv(READ_TIMEOUT);
        }
        defaultReadTimeout = rt != null ? Integer.parseInt(rt) : 600000;
    }

    static interface HttpCommand {
        public void prepareConnection(HttpURLConnection var1) throws IOException;

        public void useConnection(HttpURLConnection var1) throws CommandException, IOException;
    }
}

