/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.util;

import com.sun.enterprise.admin.util.CommandModelData;
import com.sun.enterprise.util.StringUtils;
import jakarta.xml.bind.DatatypeConverter;
import java.security.MessageDigest;
import java.util.Comparator;
import java.util.TreeSet;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandModel;

public class CachedCommandModel
extends CommandModelData {
    private String eTag;
    private String usage;
    private boolean addedUploadOption = false;

    public CachedCommandModel(String name) {
        super(name);
    }

    public CachedCommandModel(String name, String eTag) {
        super(name);
        this.eTag = eTag;
    }

    public String getETag() {
        if (this.eTag == null) {
            this.eTag = CachedCommandModel.computeETag(this);
        }
        return this.eTag;
    }

    public void setETag(String eTag) {
        this.eTag = eTag;
    }

    public String geteTag() {
        return this.eTag;
    }

    public void seteTag(String eTag) {
        this.eTag = eTag;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public boolean isAddedUploadOption() {
        return this.addedUploadOption;
    }

    public void setAddedUploadOption(boolean addedUploadOption) {
        this.addedUploadOption = addedUploadOption;
    }

    public static String computeETag(CommandModel cm) {
        String result;
        if (cm instanceof CachedCommandModel && (result = ((CachedCommandModel)cm).eTag) != null && !result.isEmpty()) {
            return ((CachedCommandModel)cm).eTag;
        }
        StringBuilder tag = new StringBuilder();
        tag.append(cm.getCommandName());
        if (cm.isManagedJob()) {
            tag.append('m');
        }
        if (cm.unknownOptionsAreOperands()) {
            tag.append('o');
        }
        if (cm.getParameters() != null) {
            TreeSet<CommandModel.ParamModel> tree = new TreeSet<CommandModel.ParamModel>(new Comparator<CommandModel.ParamModel>(){

                @Override
                public int compare(CommandModel.ParamModel o1, CommandModel.ParamModel o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            for (CommandModel.ParamModel paramModel : cm.getParameters()) {
                tree.add(paramModel);
            }
            for (CommandModel.ParamModel pm : tree) {
                if ("upload".equals(pm.getName())) continue;
                tag.append(pm.getName());
                tag.append(pm.getClass().getCanonicalName());
                Param param = pm.getParam();
                if (param.multiple()) {
                    tag.append('M');
                }
                if (param.optional()) {
                    tag.append('P');
                }
                if (param.primary()) {
                    tag.append('1');
                }
                if (param.obsolete()) {
                    tag.append('O');
                }
                if (param.shortName() != null && !param.shortName().isEmpty()) {
                    tag.append(param.shortName());
                }
                if (param.alias() != null && !param.alias().isEmpty()) {
                    tag.append(param.alias());
                }
                if (!StringUtils.ok((String)param.defaultValue())) continue;
                tag.append(param.defaultValue());
                tag.append("A");
            }
        }
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(tag.toString().getBytes("UTF-8"));
            return DatatypeConverter.printBase64Binary((byte[])md.digest());
        }
        catch (Exception ex) {
            return "v2" + tag.toString();
        }
    }
}

