/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.commands;

import com.sun.enterprise.admin.commands.CreateSsl;
import com.sun.enterprise.admin.commands.DeleteSsl;
import com.sun.enterprise.admin.commands.SslConfigHandler;
import com.sun.enterprise.util.LocalStringManagerImpl;
import org.glassfish.api.ActionReport;
import org.glassfish.grizzly.config.dom.NetworkConfig;
import org.glassfish.grizzly.config.dom.Protocol;
import org.glassfish.grizzly.config.dom.Ssl;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigSupport;
import org.jvnet.hk2.config.SingleConfigCode;
import org.jvnet.hk2.config.TransactionFailure;

@Service(name="protocol")
public class ProtocolSslConfigHandler
implements SslConfigHandler {
    private static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ProtocolSslConfigHandler.class);

    @Override
    public void create(final CreateSsl command, ActionReport report) {
        try {
            Protocol protocol = command.findOrCreateProtocol(command.listenerId, false);
            if (protocol == null) {
                report.setMessage(localStrings.getLocalString("create.ssl.protocol.notfound.fail", "Unable to find protocol {0}.", new Object[]{command.listenerId}));
                report.setActionExitCode(ActionReport.ExitCode.FAILURE);
                return;
            }
            ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(){

                public Object run(Protocol param) throws TransactionFailure {
                    Ssl newSsl = (Ssl)param.createChild(Ssl.class);
                    param.setSecurityEnabled("true");
                    command.populateSslElement(newSsl);
                    param.setSsl(newSsl);
                    return newSsl;
                }
            }, (ConfigBeanProxy)protocol);
        }
        catch (TransactionFailure transactionFailure) {
            command.reportError(report, transactionFailure);
            return;
        }
        command.reportSuccess(report);
    }

    @Override
    public void delete(DeleteSsl command, ActionReport report) {
        try {
            NetworkConfig networkConfig = command.config.getNetworkConfig();
            Protocol protocol = networkConfig.findProtocol(command.listenerId);
            if (protocol != null) {
                ConfigSupport.apply((SingleConfigCode)new SingleConfigCode<Protocol>(this){

                    public Object run(Protocol param) {
                        param.setSecurityEnabled("false");
                        param.setSsl(null);
                        return null;
                    }
                }, (ConfigBeanProxy)protocol);
            }
        }
        catch (TransactionFailure transactionFailure) {
            command.reportError(report, (Exception)((Object)transactionFailure));
        }
    }
}

