/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.serverbeans.customvalidators;

import com.sun.enterprise.config.serverbeans.Cluster;
import com.sun.enterprise.config.serverbeans.Configs;
import com.sun.enterprise.config.serverbeans.Domain;
import com.sun.enterprise.config.serverbeans.Server;
import com.sun.enterprise.config.serverbeans.Servers;
import com.sun.enterprise.config.serverbeans.customvalidators.ConfigRefConstraint;
import com.sun.enterprise.util.LocalStringManagerImpl;
import com.sun.logging.LogDomains;
import java.util.logging.Logger;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import javax.validation.Payload;
import org.glassfish.api.admin.config.Named;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigRefValidator
implements ConstraintValidator<ConfigRefConstraint, Named>,
Payload {
    static final Logger logger = LogDomains.getLogger(ConfigRefValidator.class, (String)"javax.enterprise.system.tools.admin");
    static final LocalStringManagerImpl localStrings = new LocalStringManagerImpl(ConfigRefValidator.class);

    public void initialize(ConfigRefConstraint constraint) {
    }

    public boolean isValid(Named bean, ConstraintValidatorContext constraintValidatorContext) {
        if (bean == null) {
            return true;
        }
        Server server = null;
        Cluster mycluster = null;
        String configRef = null;
        String serverName = null;
        if (bean instanceof Server) {
            server = (Server)bean;
            configRef = server.getConfigRef();
            serverName = server.getName();
        } else if (bean instanceof Cluster) {
            mycluster = (Cluster)bean;
            configRef = mycluster.getConfigRef();
            serverName = mycluster.getName();
        }
        if (configRef == null) {
            return true;
        }
        if (configRef.equals("default-config")) {
            logger.warning(localStrings.getLocalString("configref.defaultconfig", "The default configuration template (named default-config) cannot be referenced by a server."));
            return false;
        }
        if (server != null) {
            if (server.isDas() && !configRef.equals("server-config")) {
                logger.warning(localStrings.getLocalString("configref.dasconfig", "The configuration of the Domain Administration Server cannot be changed from server-config."));
                return false;
            }
            if (!server.isDas() && configRef.equals("server-config")) {
                logger.warning(localStrings.getLocalString("configref.serverconfig", "The configuration of the Domain Administration Server (named server-config) cannot be referenced by a server."));
                return false;
            }
            Servers servers = (Servers)server.getParent(Servers.class);
            Domain domain = (Domain)servers.getParent(Domain.class);
            Configs configs = domain.getConfigs();
            if (servers.getServer(serverName) != null) {
                Cluster cluster = domain.getClusterForInstance(serverName);
                if (cluster != null && !cluster.getConfigRef().equals(configRef)) {
                    logger.warning(localStrings.getLocalString("configref.clusteredinstance", "Cannot change a config-ref when the instance is part of a cluster."));
                    return false;
                }
                if (configs == null || configs.getConfigByName(configRef) == null) {
                    logger.warning(localStrings.getLocalString("configref.nonexistent", "A configuration that doesn't exist cannot be referenced by a server."));
                    return false;
                }
            }
        }
        return true;
    }
}

