/*
 * Copyright (c) 2010, 2020 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.enterprise.config.serverbeans.customvalidators;

import java.lang.annotation.Target;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.ElementType;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.Constraint;
import jakarta.validation.Payload;

/**
 * NotDuplicateTargetName class-level constraint to verify that the name
 * attribute is not already in use by another target (cluster, instance,
 * node, config).
 *
 * @author Joe Di Pol
 */
@Target({ElementType.TYPE})
@Retention(RetentionPolicy.RUNTIME)
@Constraint(validatedBy=NotDuplicateTargetNameValidator.class)
public @interface NotDuplicateTargetName {

    String message() default "Name is already used by another instance, cluster, config or node";
    Class<?>[] groups() default {};
    Class<? extends Payload>[] payload() default {};
}
