/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.config.modularity;

import com.sun.enterprise.config.modularity.ConfigModularityUtils;
import com.sun.enterprise.config.serverbeans.Config;
import com.sun.enterprise.config.serverbeans.Domain;
import jakarta.inject.Inject;
import java.util.StringTokenizer;
import org.glassfish.config.support.Singleton;
import org.jvnet.hk2.annotations.Service;

@Service
@Singleton
public class GetSetModularityHelper {
    @Inject
    private ConfigModularityUtils configModularityUtils;
    @Inject
    private Domain domain;

    private Class getElementClass(String prefix, int position) {
        StringTokenizer tokenizer = new StringTokenizer(prefix, ".");
        String token = null;
        for (int i = 0; i < position; ++i) {
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            token = tokenizer.nextToken();
        }
        if (token != null) {
            return this.configModularityUtils.getClassFor(token);
        }
        return null;
    }

    public Class getClassFor(String serviceName) {
        return this.configModularityUtils.getClassFor(serviceName);
    }

    private String getElement(String string, int position) {
        StringTokenizer tokenizer = new StringTokenizer(string, ".");
        String token = null;
        for (int i = 0; i < position; ++i) {
            if (!tokenizer.hasMoreTokens()) {
                return null;
            }
            token = tokenizer.nextToken();
        }
        return token;
    }

    public void getLocationForDottedName(String dottedName) {
        if (dottedName.contains("monitor")) {
            return;
        }
        if (dottedName.contains("mdb-container") || dottedName.contains("ejb-container.") || dottedName.contains("web-container.") || dottedName.contains("cdi-service") || dottedName.contains("batch-runtime-configuration") || dottedName.contains("managed-job-config")) {
            this.checkForDependentElements(dottedName);
            if (dottedName.startsWith("configs.config.")) {
                Config c = null;
                if (this.getElement(dottedName, 3) != null) {
                    c = this.getConfigForName(this.getElement(dottedName, 3));
                }
                if (c != null && this.getElementClass(dottedName, 4) != null) {
                    c.getExtensionByType(this.getElementClass(dottedName, 4));
                }
            } else if (!dottedName.startsWith("domain.")) {
                Config c = null;
                if (this.getElement(dottedName, 1) != null) {
                    c = this.getConfigForName(this.getElement(dottedName, 1));
                }
                if (c != null && this.getElementClass(dottedName, 2) != null) {
                    c.getExtensionByType(this.getElementClass(dottedName, 2));
                }
            }
        }
    }

    private void checkForDependentElements(String dottedName) {
    }

    private Config getConfigForName(String name) {
        if (this.domain.getConfigNamed(name) != null) {
            return this.domain.getConfigNamed(name);
        }
        if (this.domain.getServerNamed(name) != null) {
            return this.domain.getServerNamed(name).getConfig();
        }
        return null;
    }
}

