/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.launcher;

import com.sun.enterprise.admin.launcher.CommandLine;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.admin.launcher.GFLauncherLogger;
import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.xml.MiniXmlParser;
import com.sun.enterprise.universal.xml.MiniXmlParserException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

class GFEmbeddedLauncher
extends GFLauncher {
    private boolean setup;
    private File gfeJar;
    private File runServerJar;
    private File installDir;
    private File javaExe;
    private File domainDir;
    private List<File> javaDbClassPath;
    private String logFilename;
    private static final String GFE_RUNSERVER_JAR = "GFE_RUNSERVER_JAR";
    private static final String GFE_RUNSERVER_CLASS = "GFE_RUNSERVER_CLASS";
    private static final String GFE_JAR = "GFE_JAR";
    private static final String INSTALL_HOME = "S1AS_HOME";
    private static final String JAVA_HOME = "JAVA_HOME";
    private static final String GENERAL_MESSAGE = " *********  GENERAL MESSAGE ********\nYou must setup four different environmental variables to run embedded with asadmin. They are\nGFE_JAR - path to the embedded jar\nS1AS_HOME - path to installation directory. This can be empty or not exist yet.\nJAVA_HOME - path to a JDK installation. JRE installation is generally not good enough\nGFE_DEBUG_PORT - optional debugging port. It will start suspended.\n\n*********  SPECIFIC MESSAGE ********\n";
    private final String[] DERBY_FILES = new String[]{"derby.jar", "derbyclient.jar"};

    GFEmbeddedLauncher(GFLauncherInfo info) {
        super(info);
    }

    @Override
    void internalLaunch() throws GFLauncherException {
        try {
            this.launchInstance();
        }
        catch (Exception ex) {
            throw new GFLauncherException(ex);
        }
    }

    @Override
    List<File> getMainClasspath() throws GFLauncherException {
        return List.of();
    }

    @Override
    String getMainClass() throws GFLauncherException {
        String className = System.getenv(GFE_RUNSERVER_CLASS);
        if (className == null) {
            return "org.glassfish.tests.embedded.EmbeddedMain";
        }
        return className;
    }

    @Override
    public void setup() throws GFLauncherException, MiniXmlParserException {
        if (this.setup) {
            return;
        }
        this.setup = true;
        try {
            this.setupFromEnv();
        }
        catch (GFLauncherException gfle) {
            throw new GFLauncherException(GENERAL_MESSAGE + gfle.getMessage(), gfle);
        }
        this.initCommandLine();
        GFLauncherInfo info = this.getInfo();
        try {
            File parent = info.getDomainParentDir();
            String domainName = info.getDomainName();
            String instanceName = info.getInstanceName();
            if (instanceName == null) {
                instanceName = "server";
            }
            File dom = new File(parent, domainName);
            File theConfigDir = new File(dom, "config");
            File dx = new File(theConfigDir, "domain.xml");
            info.setConfigDir(theConfigDir);
            info.setDomainRootDir(new File(System.getenv(INSTALL_HOME)));
            MiniXmlParser parser = new MiniXmlParser(dx, instanceName);
            info.setAdminAddresses(parser.getAdminAddresses());
            File logFile = new File(dom, "logs");
            logFile = new File(logFile, "server.log");
            this.logFilename = logFile.getAbsolutePath();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        List<HostAndPort> adminAddresses = info.getAdminAddresses();
        if (adminAddresses == null || adminAddresses.isEmpty()) {
            adminAddresses = new ArrayList<HostAndPort>();
            adminAddresses.add(new HostAndPort("localhost", 4848, false));
            info.setAdminAddresses(adminAddresses);
        }
        GFLauncherLogger.addLogFileHandler(this.getLogFilename());
    }

    @Override
    public String getLogFilename() throws GFLauncherException {
        return this.logFilename;
    }

    @Override
    void setClasspath() {
        ArrayList<File> cp = new ArrayList<File>();
        cp.add(this.gfeJar);
        cp.addAll(this.javaDbClassPath);
        if (this.runServerJar != null) {
            cp.add(this.runServerJar);
        }
        this.setClasspath((File[])cp.toArray(File[]::new));
    }

    @Override
    void initCommandLine() throws GFLauncherException {
        CommandLine cmdLine = new CommandLine(CommandLine.CommandFormat.ProcessBuilder);
        cmdLine.append(this.javaExe.toPath());
        this.addThreadDump(cmdLine);
        if (this.getClasspath().length > 0) {
            cmdLine.appendClassPath(this.getClasspath());
        }
        this.addDebug(cmdLine);
        cmdLine.append(this.getMainClass());
        cmdLine.append("--installdir");
        cmdLine.append(this.installDir.toPath());
        cmdLine.append("--instancedir");
        cmdLine.append(this.domainDir.toPath());
        cmdLine.append("--autodelete");
        cmdLine.append("false");
        cmdLine.append("--autodeploy");
        this.setCommandLine(cmdLine);
    }

    private void addDebug(CommandLine cmdLine) {
        String suspend;
        String debugPort = System.getenv("GFE_DEBUG_PORT");
        if (this.ok(debugPort)) {
            suspend = "y";
        } else {
            debugPort = "12345";
            suspend = "n";
        }
        cmdLine.append("-Xdebug");
        cmdLine.append("-Xrunjdwp:transport=dt_socket,server=y,suspend=" + suspend + ",address=" + debugPort);
    }

    private void addThreadDump(CommandLine cmdLine) {
        Path jvmLog = this.domainDir.toPath().resolve(Path.of("logs", "jvm.log"));
        cmdLine.appendJavaOption("-XX:+UnlockDiagnosticVMOptions");
        cmdLine.appendJavaOption("-XX:+LogVMOutput");
        cmdLine.appendJavaOption("-XX:LogFile", jvmLog);
    }

    private void setupFromEnv() throws GFLauncherException {
        this.setupEmbeddedJars();
        this.setupInstallationDir();
        this.setupJDK();
        this.setupDomainDir();
        this.setupJavaDB();
        this.setClasspath();
    }

    private void setupDomainDir() throws GFLauncherException {
        String domainDirName = this.getInfo().getDomainName();
        this.domainDir = this.getInfo().getDomainParentDir();
        this.domainDir = new File(this.domainDir, domainDirName);
        if (!FileUtils.mkdirsMaybe((File)this.domainDir)) {
            throw new GFLauncherException("Can not create directory: " + String.valueOf(this.domainDir));
        }
        this.domainDir = SmartFile.sanitize((File)this.domainDir);
    }

    private void setupJDK() throws GFLauncherException {
        String err = "You must set the environmental variable JAVA_HOME to point at a valid JDK. <jdk>/bin/javac[.exe] must exist.";
        String jdkDirName = System.getenv(JAVA_HOME);
        if (!this.ok(jdkDirName)) {
            throw new GFLauncherException(err);
        }
        File jdkDir = new File(jdkDirName);
        if (!jdkDir.isDirectory()) {
            throw new GFLauncherException(err);
        }
        this.javaExe = File.separatorChar == '\\' ? new File(jdkDir, "bin/java.exe") : new File(jdkDir, "bin/java");
        if (!this.javaExe.isFile()) {
            throw new GFLauncherException(err);
        }
        this.javaExe = SmartFile.sanitize((File)this.javaExe);
    }

    private void setupInstallationDir() throws GFLauncherException {
        String err = "You must set the environmental variable S1AS_HOME to point at a GlassFish installation or at an empty directory or at a location where an empty directory can be created.";
        String installDirName = System.getenv(INSTALL_HOME);
        if (!this.ok(installDirName)) {
            throw new GFLauncherException(err);
        }
        this.installDir = new File(installDirName);
        if (!FileUtils.mkdirsMaybe((File)this.installDir)) {
            throw new GFLauncherException(err);
        }
        this.installDir = SmartFile.sanitize((File)this.installDir);
    }

    private void setupEmbeddedJars() throws GFLauncherException {
        String err = "You must set the environmental variable GFE_JAR to point at the Embedded jarfile.";
        String gfeJarName = System.getenv(GFE_JAR);
        if (!this.ok(gfeJarName)) {
            throw new GFLauncherException(err);
        }
        this.gfeJar = new File(gfeJarName);
        if (!this.gfeJar.isFile() || this.gfeJar.length() < 1000000L) {
            throw new GFLauncherException(err);
        }
        this.gfeJar = SmartFile.sanitize((File)this.gfeJar);
        err = "You must set the environmental variable GFE_RUNSERVER_JAR to point at the server startup jar.";
        String runServerJarName = System.getenv(GFE_RUNSERVER_JAR);
        if (runServerJarName != null) {
            if (!this.ok(runServerJarName)) {
                throw new GFLauncherException(err);
            }
            this.runServerJar = new File(runServerJarName);
            if (!this.runServerJar.isFile()) {
                throw new GFLauncherException(err);
            }
            this.runServerJar = SmartFile.sanitize((File)this.runServerJar);
        }
    }

    private void setupJavaDB() throws GFLauncherException {
        String relPath = "javadb/lib";
        File derbyLib = new File(this.installDir, relPath);
        if (!derbyLib.isDirectory()) {
            derbyLib = new File(this.installDir.getParentFile(), relPath);
        }
        if (!derbyLib.isDirectory()) {
            throw new GFLauncherException("Could not find the JavaDB lib directory.");
        }
        this.javaDbClassPath = new ArrayList<File>();
        for (String fname : this.DERBY_FILES) {
            File file = new File(derbyLib, fname);
            this.javaDbClassPath.add(file);
            if (file.exists()) continue;
            throw new GFLauncherException("Could not find the JavaDB jar: " + String.valueOf(file));
        }
    }

    private boolean ok(String s) {
        return s != null && s.length() > 0;
    }
}

