/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.client;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import com.sun.jersey.multipart.FormDataMultiPart;
import com.sun.jersey.multipart.file.FileDataBodyPart;
import java.io.File;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.client.RestResponse;
import org.glassfish.admin.rest.client.utils.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RestClientBase {
    protected static final String RESPONSE_TYPE = "application/json";
    protected Map<String, Object> entityValues = new HashMap<String, Object>();
    protected List<String> children;
    protected int status;
    protected String message;
    protected Client client;
    protected RestClientBase parent;
    private boolean initialized = false;
    private boolean isNew = false;

    protected RestClientBase(Client c, RestClientBase p) {
        this.client = c;
        this.parent = p;
    }

    protected RestClientBase getParent() {
        return this.parent;
    }

    protected String getRestUrl() {
        return this.getParent().getRestUrl() + this.getSegment();
    }

    protected abstract String getSegment();

    public int getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean save() {
        ClientResponse response = (ClientResponse)((WebResource.Builder)this.client.resource(this.getRestUrl()).accept(new String[]{RESPONSE_TYPE}).type(MediaType.MULTIPART_FORM_DATA_TYPE)).post(ClientResponse.class, (Object)this.buildMultivalueMap(this.entityValues));
        boolean success = this.isSuccess(response);
        if (!success) {
            this.status = response.getStatus();
            this.message = (String)response.getEntity(String.class);
        } else {
            this.isNew = false;
        }
        return success;
    }

    public boolean delete() {
        ClientResponse response = (ClientResponse)this.client.resource(this.getRestUrl()).accept(new String[]{RESPONSE_TYPE}).delete(ClientResponse.class);
        boolean success = this.isSuccess(response);
        if (!success) {
            this.status = response.getStatus();
            this.message = (String)response.getEntity(String.class);
        }
        return success;
    }

    public RestResponse execute(Method method, String endpoint, boolean needsMultiPart) {
        return this.execute(method, endpoint, new HashMap<String, Object>(), needsMultiPart);
    }

    public RestResponse execute(Method method, String endPoint, Map<String, Object> payload) {
        return this.execute(method, endPoint, payload, false);
    }

    public RestResponse execute(Method method, String endPoint, Map<String, Object> payload, boolean needsMultiPart) {
        ClientResponse clientResponse;
        WebResource request = this.client.resource(this.getRestUrl() + endPoint);
        switch (method) {
            case POST: {
                if (needsMultiPart) {
                    clientResponse = (ClientResponse)((WebResource.Builder)request.accept(new String[]{RESPONSE_TYPE}).type(MediaType.MULTIPART_FORM_DATA_TYPE)).post(ClientResponse.class, (Object)this.buildFormDataMultipart(payload));
                    break;
                }
                clientResponse = (ClientResponse)request.accept(new String[]{RESPONSE_TYPE}).post(ClientResponse.class, (Object)this.buildMultivalueMap(payload));
                break;
            }
            case PUT: {
                if (needsMultiPart) {
                    clientResponse = (ClientResponse)((WebResource.Builder)request.accept(new String[]{RESPONSE_TYPE}).type(MediaType.MULTIPART_FORM_DATA_TYPE)).put(ClientResponse.class, (Object)this.buildFormDataMultipart(payload));
                    break;
                }
                clientResponse = (ClientResponse)request.accept(new String[]{RESPONSE_TYPE}).put(ClientResponse.class, (Object)this.buildMultivalueMap(payload));
                break;
            }
            case DELETE: {
                clientResponse = (ClientResponse)request.queryParams(this.buildMultivalueMap(payload)).accept(new String[]{RESPONSE_TYPE}).delete(ClientResponse.class);
                break;
            }
            default: {
                clientResponse = (ClientResponse)request.queryParams(this.buildMultivalueMap(payload)).accept(new String[]{RESPONSE_TYPE}).get(ClientResponse.class);
            }
        }
        return new RestResponse(clientResponse);
    }

    protected boolean isSuccess(ClientResponse response) {
        int responseStatus = response.getStatus();
        return responseStatus == 200 || responseStatus == 201;
    }

    protected boolean isNew() {
        return this.isNew;
    }

    protected void setIsNew() {
        this.isNew = true;
    }

    protected synchronized void initialize() {
        if (!this.initialized) {
            ClientResponse clientResponse = (ClientResponse)this.client.resource(this.getRestUrl()).accept(new String[]{RESPONSE_TYPE}).get(ClientResponse.class);
            Map<String, Object> responseMap = Util.processJsonMap((String)clientResponse.getEntity(String.class));
            this.status = clientResponse.getStatus();
            this.getEntityValues(responseMap);
            this.getChildren(responseMap);
            this.initialized = true;
        }
    }

    protected <T> T getValue(String key, Class<T> clazz) {
        this.initialize();
        Object retValue = null;
        Object value = this.entityValues.get(key);
        if (value != null && !value.equals(JSONObject.NULL)) {
            retValue = value;
        }
        return (T)retValue;
    }

    protected <T> void setValue(String key, T value) {
        this.initialize();
        this.entityValues.put(key, value);
    }

    protected Map<String, String> getEntityMetadata(Map<String, Object> extraProperties) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        List methods = (List)extraProperties.get("methods");
        for (Map entry : methods) {
            Map params;
            if (!"POST".equals(entry.get("name")) || (params = (Map)entry.get("messageParameters")) == null) continue;
            for (Map.Entry param : params.entrySet()) {
                String paramName = (String)param.getKey();
                Map md = (Map)param.getValue();
                metadata.put(paramName, (String)md.get("type"));
            }
        }
        return metadata;
    }

    protected void getEntityValues(Map<String, Object> responseMap) {
        Map entity;
        this.entityValues = new HashMap<String, Object>();
        Map extraProperties = (Map)responseMap.get("extraProperties");
        if (extraProperties != null && (entity = (Map)extraProperties.get("entity")) != null) {
            Map<String, String> metadata = this.getEntityMetadata(extraProperties);
            for (Map.Entry entry : entity.entrySet()) {
                String type = metadata.get(entry.getKey());
                Constable value = null;
                value = "int".equals(type) ? (Constable)Integer.valueOf(Integer.parseInt((String)entry.getValue())) : (Constable)("boolean".equals(type) ? Boolean.valueOf(Boolean.parseBoolean((String)entry.getValue())) : entry.getValue());
                this.entityValues.put((String)entry.getKey(), value);
            }
        }
    }

    protected void getChildren(Map<String, Object> responseMap) {
        Map childResources;
        this.children = new ArrayList<String>();
        Map extraProperties = (Map)responseMap.get("extraProperties");
        if (extraProperties != null && (childResources = (Map)extraProperties.get("childResources")) != null) {
            for (Map.Entry child : childResources.entrySet()) {
                this.children.add((String)child.getKey());
            }
        }
    }

    protected FormDataMultiPart buildFormDataMultipart(Map<String, Object> payload) {
        FormDataMultiPart formData = new FormDataMultiPart();
        Logger logger = Logger.getLogger(RestClientBase.class.getName());
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            Object value = entry.getValue();
            String key = entry.getKey();
            if (value instanceof Collection) {
                for (Object obj : (Collection)value) {
                    try {
                        formData.field(key, obj, MediaType.TEXT_PLAIN_TYPE);
                    }
                    catch (ClassCastException ex) {
                        if (!logger.isLoggable(Level.FINEST)) continue;
                        logger.log(Level.FINEST, "Unable to add key (\"{0}\") w/ value (\"{1}\").", new Object[]{key, obj});
                    }
                }
                continue;
            }
            try {
                if (value instanceof File) {
                    formData.getBodyParts().add(new FileDataBodyPart(key, (File)value));
                    continue;
                }
                formData.field(key, value, MediaType.TEXT_PLAIN_TYPE);
            }
            catch (ClassCastException ex) {
                if (!logger.isLoggable(Level.FINEST)) continue;
                logger.log(Level.FINEST, "Unable to add key (\"{0}\") w/ value (\"{1}\").", new Object[]{key, value});
            }
        }
        return formData;
    }

    private MultivaluedMap buildMultivalueMap(Map<String, Object> payload) {
        MultivaluedMapImpl formData = new MultivaluedMapImpl();
        for (Map.Entry<String, Object> entry : payload.entrySet()) {
            Object value = entry.getValue();
            if (JSONObject.NULL.equals(value)) {
                value = null;
            } else if (value != null) {
                value = value.toString();
            }
            formData.add((Object)entry.getKey(), value);
        }
        return formData;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        GET,
        PUT,
        POST,
        DELETE;

    }
}

