/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.rest.testing;

import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.jettison.json.JSONArray;
import org.codehaus.jettison.json.JSONException;
import org.codehaus.jettison.json.JSONObject;
import org.glassfish.admin.rest.testing.ArrayValue;
import org.glassfish.admin.rest.testing.BooleanValue;
import org.glassfish.admin.rest.testing.Common;
import org.glassfish.admin.rest.testing.DoubleValue;
import org.glassfish.admin.rest.testing.Environment;
import org.glassfish.admin.rest.testing.IndentingStringBuffer;
import org.glassfish.admin.rest.testing.IntValue;
import org.glassfish.admin.rest.testing.LongValue;
import org.glassfish.admin.rest.testing.NilValue;
import org.glassfish.admin.rest.testing.ObjectValue;
import org.glassfish.admin.rest.testing.ScalarValue;
import org.glassfish.admin.rest.testing.StringValue;
import org.glassfish.admin.rest.testing.Value;

public class DataVerifier {
    private Environment env;
    private ObjectValue objectWant;
    private JSONObject objectHave;
    private IndentingStringBuffer sb = new IndentingStringBuffer();

    public DataVerifier(Environment env, ObjectValue objectWant, JSONObject objectHave) {
        this.env = env;
        this.objectWant = objectWant;
        this.objectHave = objectHave;
    }

    private void trace(String msg) {
        this.sb.println(msg);
    }

    private void indent() {
        this.sb.indent();
    }

    private void undent() {
        this.sb.undent();
    }

    private Environment getEnvironment() {
        return this.env;
    }

    public static void verify(Environment env, ObjectValue objectWant, JSONObject objectHave) throws Exception {
        IndentingStringBuffer sb = new IndentingStringBuffer();
        objectWant.print(sb);
        env.debug("Body want : " + sb.toString());
        env.debug("Body have : " + objectHave.toString(2));
        new DataVerifier(env, objectWant, objectHave).verify();
    }

    private void verify() throws Exception {
        try {
            if (!this.sameProperties(this.objectWant.getProperties(), this.objectHave, this.objectWant.isIgnoreExtra())) {
                this.trace("Response object want=");
                this.objectWant.print(this.sb);
                this.trace("Response object have=");
                this.indent();
                try {
                    this.trace(this.objectHave.toString(2));
                }
                finally {
                    this.undent();
                }
                throw new IllegalArgumentException("Response object does not match expected value");
            }
            this.trace("same response bodies");
            this.getEnvironment().debug(this.sb.toString());
        }
        catch (Exception e) {
            throw new Exception("Exception verifying resource response object\n" + this.sb.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameProperties(Map<String, Value> want, JSONObject have, boolean ignoreExtra) throws Exception {
        this.trace("comparing properties, ignoreExtra=" + ignoreExtra);
        this.indent();
        try {
            if (want.size() > have.length()) {
                this.trace("different since object has too few properties");
                boolean bl = false;
                return bl;
            }
            if (!ignoreExtra && want.size() < have.length()) {
                this.trace("different since object has too many properties want=" + want.size() + " have=" + have.length());
                boolean bl = false;
                return bl;
            }
            for (Map.Entry<String, Value> p : want.entrySet()) {
                if (this.sameProperty(p.getKey(), p.getValue(), have)) continue;
                this.trace("different since object didn't have matching " + p.getKey() + " property");
                boolean bl = false;
                return bl;
            }
            this.trace("same properties");
            boolean bl = true;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameArray(ArrayValue want, JSONArray have) throws Exception {
        this.trace("comparing arrays, ignoreExtra=" + want.isIgnoreExtra() + ", ordered=" + want.isOrdered());
        this.indent();
        try {
            boolean ignoreExtra = want.isIgnoreExtra();
            boolean ordered = want.isOrdered();
            List<Value> wantVals = want.getValues();
            if (ordered && ignoreExtra) {
                throw new AssertionError((Object)"ignore-extra must be false if ordered is true");
            }
            if (wantVals.size() > have.length()) {
                this.trace("different since array has too few elements");
                boolean bl = false;
                return bl;
            }
            if (!ignoreExtra && wantVals.size() < have.length()) {
                this.trace("diffent since array has too many elements");
                boolean bl = false;
                return bl;
            }
            if (ordered) {
                for (int i = 0; i < wantVals.size(); ++i) {
                    if (this.sameValue(wantVals.get(i), have, i)) continue;
                    this.trace("different since array element " + i + " didn't match");
                    boolean bl = false;
                    return bl;
                }
                this.trace("same ordered elements");
                boolean bl = true;
                return bl;
            }
            if (new UnorderedArrayMatcher(want, have).matches()) {
                this.trace("same unordered elements");
                boolean bl = true;
                return bl;
            }
            this.trace("different unorder elements");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameProperty(String nameWant, Value valueWant, JSONObject have) throws Exception {
        this.trace("comparing property " + nameWant);
        this.indent();
        try {
            if (!have.has(nameWant)) {
                this.trace("missing property " + nameWant);
                boolean bl = false;
                return bl;
            }
            if (!this.sameValue(valueWant, have, nameWant)) {
                this.trace("different value for property " + nameWant);
                boolean bl = false;
                return bl;
            }
            this.trace("same property " + nameWant);
            boolean bl = true;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    private boolean sameValue(Value want, JSONObject parent, String name) throws Exception {
        if (want instanceof ObjectValue) {
            return this.sameObject((ObjectValue)want, parent, name);
        }
        if (want instanceof ArrayValue) {
            return this.sameArray((ArrayValue)want, parent, name);
        }
        if (want instanceof ScalarValue) {
            return this.sameScalar((ScalarValue)want, parent, name);
        }
        if (want instanceof NilValue) {
            return this.sameNil(parent, name);
        }
        throw new AssertionError((Object)("Unknown value " + String.valueOf(want)));
    }

    private boolean sameValue(Value want, JSONArray parent, int index) throws Exception {
        if (want instanceof ObjectValue) {
            return this.sameObject((ObjectValue)want, parent, index);
        }
        if (want instanceof ArrayValue) {
            return this.sameArray((ArrayValue)want, parent, index);
        }
        if (want instanceof ScalarValue) {
            return this.sameScalar((ScalarValue)want, parent, index);
        }
        if (want instanceof NilValue) {
            return this.sameNil(parent, index);
        }
        throw new AssertionError((Object)("Unknown value " + String.valueOf(want)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameObject(ObjectValue want, JSONObject parent, String name) throws Exception {
        this.trace("comparing object object property " + name);
        this.indent();
        try {
            JSONObject have = parent.getJSONObject(name);
            if (this.sameProperties(want.getProperties(), have, want.isIgnoreExtra())) {
                this.trace("same object");
                boolean bl = true;
                return bl;
            }
            this.trace("different object");
            boolean bl = false;
            return bl;
        }
        catch (JSONException e) {
            this.trace("different since property was not an object");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameObject(ObjectValue want, JSONArray parent, int index) throws Exception {
        this.trace("comparing array object element " + index);
        this.indent();
        try {
            JSONObject have = parent.getJSONObject(index);
            if (this.sameProperties(want.getProperties(), have, want.isIgnoreExtra())) {
                this.trace("same object");
                boolean bl = true;
                return bl;
            }
            this.trace("different object");
            boolean bl = false;
            return bl;
        }
        catch (JSONException e) {
            this.trace("different since property was not an object");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameArray(ArrayValue want, JSONObject parent, String name) throws Exception {
        this.trace("comparing object array property " + name);
        this.indent();
        try {
            if (this.sameArray(want, parent.getJSONArray(name))) {
                this.trace("same array");
                boolean bl = true;
                return bl;
            }
            this.trace("different array");
            boolean bl = false;
            return bl;
        }
        catch (JSONException e) {
            this.trace("different since property was not an array");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameArray(ArrayValue want, JSONArray parent, int index) throws Exception {
        this.trace("comparing array array element " + index);
        this.indent();
        try {
            if (this.sameArray(want, parent.getJSONArray(index))) {
                this.trace("same array");
                boolean bl = true;
                return bl;
            }
            this.trace("different array");
            boolean bl = false;
            return bl;
        }
        catch (JSONException e) {
            this.trace("different since property was not an array");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    private boolean sameScalar(ScalarValue want, JSONObject parent, String name) throws Exception {
        this.trace("comparing object scalar property " + name);
        String regexp = want.getRegexp();
        if (want instanceof StringValue) {
            return this.sameString(((StringValue)want).getValue(), regexp, parent.getString(name));
        }
        if (want instanceof LongValue) {
            return this.sameString(this.longToString(((LongValue)want).getValue()), regexp, this.longToString(parent.getLong(name)));
        }
        if (want instanceof IntValue) {
            return this.sameString(this.intToString(((IntValue)want).getValue()), regexp, this.intToString(parent.getInt(name)));
        }
        if (want instanceof DoubleValue) {
            return this.sameString(this.doubleToString(((DoubleValue)want).getValue()), regexp, this.doubleToString(parent.getDouble(name)));
        }
        if (want instanceof BooleanValue) {
            return this.sameString(this.booleanToString(((BooleanValue)want).getValue()), regexp, this.booleanToString(parent.getBoolean(name)));
        }
        throw new AssertionError((Object)(String.valueOf(want) + " is not a valid scalar type.  Valid types are string, long, int, double, boolean"));
    }

    private boolean sameScalar(ScalarValue want, JSONArray parent, int index) throws Exception {
        this.trace("comparing array scalar element " + index);
        String regexp = want.getRegexp();
        if (want instanceof StringValue) {
            return this.sameString(((StringValue)want).getValue(), regexp, parent.getString(index));
        }
        if (want instanceof LongValue) {
            return this.sameString(this.longToString(((LongValue)want).getValue()), regexp, this.longToString(parent.getLong(index)));
        }
        if (want instanceof IntValue) {
            return this.sameString(this.intToString(((IntValue)want).getValue()), regexp, this.intToString(parent.getInt(index)));
        }
        if (want instanceof DoubleValue) {
            return this.sameString(this.doubleToString(((DoubleValue)want).getValue()), regexp, this.doubleToString(parent.getDouble(index)));
        }
        if (want instanceof BooleanValue) {
            return this.sameString(this.booleanToString(((BooleanValue)want).getValue()), regexp, this.booleanToString(parent.getBoolean(index)));
        }
        throw new AssertionError((Object)(String.valueOf(want) + " is not a valid scalar type.  Valid types are string, long, int, double, boolean"));
    }

    private String longToString(long val) {
        return Long.toString(val);
    }

    private String intToString(int val) {
        return Integer.toString(val);
    }

    private String doubleToString(double val) {
        return Double.toHexString(val);
    }

    private String booleanToString(boolean val) {
        return Boolean.toString(val);
    }

    private boolean sameString(String want, String regexp, String have) throws Exception {
        if (Common.haveValue(regexp)) {
            return this.sameRegexpString(regexp, have);
        }
        return this.sameLiteralString(want, have);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameRegexpString(String regexp, String have) throws Exception {
        this.trace("comparing string against regular expression regexp='" + regexp + "', have='" + have + "'");
        this.indent();
        try {
            Pattern pattern = Pattern.compile(regexp);
            Matcher matcher = pattern.matcher(have);
            if (matcher.matches()) {
                this.trace("same since matches regular expression");
                boolean bl = true;
                return bl;
            }
            this.trace("different since does not match regular expression");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameLiteralString(String want, String have) throws Exception {
        this.trace("comparing strings want='" + want + "', have='" + have + "'");
        this.indent();
        try {
            if (Common.haveValue(want) != Common.haveValue(have)) {
                this.trace("different strings - one is null and the other is not");
                boolean bl = false;
                return bl;
            }
            if (!Common.haveValue(want)) {
                this.trace("same empty strings");
                boolean bl = true;
                return bl;
            }
            if (want.equals(have)) {
                this.trace("same literal value");
                boolean bl = true;
                return bl;
            }
            this.trace("different literal value");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameNil(JSONObject parent, String name) {
        this.trace("comparing object nil property " + name);
        this.indent();
        try {
            if (parent.isNull(name)) {
                this.trace("same nil");
                boolean bl = true;
                return bl;
            }
            this.trace("different nil");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sameNil(JSONArray parent, int index) {
        this.trace("comparing array nil element " + index);
        this.indent();
        try {
            if (parent.isNull(index)) {
                this.trace("same nil");
                boolean bl = true;
                return bl;
            }
            this.trace("different nil");
            boolean bl = false;
            return bl;
        }
        finally {
            this.undent();
        }
    }

    private class UnorderedArrayMatcher {
        private int matchCount = 0;
        private ArrayValue want;
        private List<Value> wantValues;
        private JSONArray have;
        private int[] wantMatches;
        private int[] haveMatches;
        private boolean[][] potentialMatches;

        private UnorderedArrayMatcher(ArrayValue want, JSONArray have) {
            int i;
            this.want = want;
            this.wantValues = this.want.getValues();
            this.have = have;
            this.wantMatches = new int[this.wantValues.size()];
            this.haveMatches = new int[this.have.length()];
            for (i = 0; i < this.wantCount(); ++i) {
                this.setWantMatch(i, -1);
            }
            for (i = 0; i < this.haveCount(); ++i) {
                this.setHaveMatch(i, -1);
            }
            this.potentialMatches = new boolean[this.wantCount()][];
            for (i = 0; i < this.wantMatches.length; ++i) {
                this.potentialMatches[i] = new boolean[this.haveCount()];
                for (int j = 0; j < this.haveCount(); ++j) {
                    this.setPotentialMatch(i, j, false);
                }
            }
        }

        private boolean matches() throws Exception {
            this.findExactMatches();
            if (!this.done()) {
                this.findPotentialMatches();
                while (!this.done()) {
                    this.findMatches();
                    if (this.done()) continue;
                    this.selectAnyMatch();
                }
            }
            return this.result();
        }

        private void findExactMatches() throws Exception {
            for (int i = 0; i < this.wantCount(); ++i) {
                Value v = this.getWantValue(i);
                if (!this.requiresExactMatch(v)) continue;
                for (int j = 0; j < this.haveCount(); ++j) {
                    if (this.haveHaveMatch(j) || !DataVerifier.this.sameValue(v, this.have, j)) continue;
                    this.matched(i, j);
                    break;
                }
                if (this.haveWantMatch(i)) continue;
                this.notMatched(i);
                return;
            }
        }

        private void findPotentialMatches() throws Exception {
            for (int i = 0; i < this.wantCount(); ++i) {
                if (this.haveWantMatch(i)) continue;
                for (int j = 0; j < this.haveCount(); ++j) {
                    if (this.haveHaveMatch(j) || !DataVerifier.this.sameValue(this.getWantValue(i), this.have, j)) continue;
                    this.setPotentialMatch(i, j, true);
                }
                int c = this.potentialMatchCount(i);
                if (c == 0) {
                    this.notMatched(i);
                    return;
                }
                if (c != 1) continue;
                for (int j = 0; j < this.haveCount(); ++j) {
                    if (!this.isPotentialMatch(i, j)) continue;
                    this.matched(i, j);
                }
            }
        }

        private void findMatches() throws Exception {
            boolean modified = true;
            while (modified) {
                modified = false;
                for (int i = 0; i < this.wantCount(); ++i) {
                    int j;
                    if (this.haveWantMatch(i)) continue;
                    int c = this.potentialMatchCount(i);
                    if (c == 0) {
                        this.notMatched(i);
                        return;
                    }
                    if (c == 1) {
                        for (j = 0; j < this.haveCount(); ++j) {
                            if (!this.isPotentialMatch(i, j)) continue;
                            this.matched(i, j);
                            modified = true;
                        }
                    }
                    if (c <= 1) continue;
                    for (j = 0; j < this.haveCount(); ++j) {
                        if (!this.isPotentialMatch(i, j) || this.matchedBySomeoneElse(i, j)) continue;
                        this.matched(i, j);
                        modified = true;
                    }
                }
            }
        }

        private void selectAnyMatch() throws Exception {
            for (int i = 0; i < this.wantCount(); ++i) {
                if (this.haveWantMatch(i)) continue;
                for (int j = 0; j < this.haveCount(); ++j) {
                    if (this.haveHaveMatch(j)) continue;
                    this.matched(i, j);
                    return;
                }
            }
        }

        private boolean matchedBySomeoneElse(int wantIndex, int haveIndex) {
            for (int i = 0; i < this.wantCount(); ++i) {
                if (i == wantIndex || !this.isPotentialMatch(i, haveIndex)) continue;
                return true;
            }
            return false;
        }

        private void notMatched(int wantIndex) {
            this.matchCount = -1;
            DataVerifier.this.trace("Different since no match for array element " + wantIndex);
        }

        private void matched(int wantIndex, int haveIndex) {
            int i;
            DataVerifier.this.trace("matched array element want=" + wantIndex + " have=" + haveIndex);
            ++this.matchCount;
            this.setWantMatch(wantIndex, haveIndex);
            this.setHaveMatch(haveIndex, wantIndex);
            this.setPotentialMatch(wantIndex, haveIndex, true);
            for (i = 0; i < this.haveCount(); ++i) {
                if (i == haveIndex) continue;
                this.setPotentialMatch(wantIndex, i, false);
            }
            for (i = 0; i < this.wantCount(); ++i) {
                if (i == wantIndex) continue;
                this.setPotentialMatch(i, haveIndex, false);
            }
        }

        private boolean done() {
            if (this.matchCount == -1) {
                return true;
            }
            return this.matchCount == this.wantMatches.length;
        }

        private boolean result() {
            if (!this.done()) {
                throw new AssertionError((Object)"Asking for result before we're done finding matches.");
            }
            return this.matchCount != -1;
        }

        private boolean isPotentialMatch(int wantIndex, int haveIndex) {
            return this.potentialMatches[wantIndex][haveIndex];
        }

        private void setPotentialMatch(int wantIndex, int haveIndex, boolean matches) {
            this.potentialMatches[wantIndex][haveIndex] = matches;
        }

        private int wantCount() {
            return this.wantMatches.length;
        }

        private int haveCount() {
            return this.haveMatches.length;
        }

        private boolean haveWantMatch(int wantIndex) {
            return this.getWantMatch(wantIndex) != -1;
        }

        private boolean haveHaveMatch(int haveIndex) {
            return this.getHaveMatch(haveIndex) != -1;
        }

        private int getWantMatch(int wantIndex) {
            return this.wantMatches[wantIndex];
        }

        private int getHaveMatch(int haveIndex) {
            return this.haveMatches[haveIndex];
        }

        private void setWantMatch(int wantIndex, int haveIndex) {
            this.wantMatches[wantIndex] = haveIndex;
        }

        private void setHaveMatch(int haveIndex, int wantIndex) {
            this.haveMatches[haveIndex] = wantIndex;
        }

        private int potentialMatchCount(int wantIndex) {
            int count = 0;
            for (int i = 0; i < this.haveCount(); ++i) {
                if (!this.isPotentialMatch(wantIndex, i)) continue;
                ++count;
            }
            return count;
        }

        private Value getWantValue(int index) {
            return this.wantValues.get(index);
        }

        private boolean requiresExactMatch(Value val) {
            if (val instanceof ObjectValue) {
                ObjectValue v = (ObjectValue)val;
                if (v.isIgnoreExtra()) {
                    return false;
                }
                for (Map.Entry<String, Value> p : v.getProperties().entrySet()) {
                    if (this.requiresExactMatch(p.getValue())) continue;
                    return false;
                }
                return true;
            }
            if (val instanceof ArrayValue) {
                ArrayValue v = (ArrayValue)val;
                if (v.isIgnoreExtra() || !v.isOrdered()) {
                    return false;
                }
                for (Value e : v.getValues()) {
                    if (this.requiresExactMatch(e)) continue;
                    return false;
                }
                return true;
            }
            if (val instanceof ScalarValue) {
                ScalarValue v = (ScalarValue)val;
                return !Common.haveValue(v.getRegexp());
            }
            if (val instanceof NilValue) {
                return true;
            }
            throw new AssertionError((Object)("Unknown value " + String.valueOf(this.want)));
        }
    }
}

