/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.Environment;
import com.sun.enterprise.admin.cli.ProgramOptions;
import com.sun.enterprise.admin.cli.remote.DASUtils;
import com.sun.enterprise.admin.cli.remote.RemoteCommand;
import com.sun.enterprise.admin.servermgmt.cli.LocalDomainCommand;
import com.sun.enterprise.admin.servermgmt.cli.Strings;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import org.glassfish.api.Param;
import org.glassfish.api.admin.CommandException;
import org.jvnet.hk2.annotations.Scoped;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.PerLookup;

@Service(name="stop-domain")
@Scoped(value=PerLookup.class)
public class StopDomainCommand
extends LocalDomainCommand {
    @Param(name="domain_name", primary=true, optional=true)
    private String userArgDomainName;
    @Param(name="force", optional=true, defaultValue="true")
    Boolean force;
    @Param(optional=true, defaultValue="false")
    Boolean kill;
    private boolean local;
    private static final long WAIT_FOR_DAS_TIME_MS = 60000L;

    protected void validate() throws CommandException {
        this.setDomainName(this.userArgDomainName);
        super.validate();
        this.local = this.getServerDirs().getServerName() != null;
    }

    protected void initDomain() throws CommandException {
        if (this.programOpts.getHost().equals("localhost")) {
            super.initDomain();
        } else if (this.userArgDomainName != null) {
            throw new CommandException(Strings.get("StopDomain.noDomainNameAllowed"));
        }
    }

    protected int executeCommand() throws CommandException {
        if (this.local) {
            if (this.getServerDirs().getLocalPassword() == null) {
                return this.dasNotRunning(this.local);
            }
            this.programOpts.setHostAndPort(this.getAdminAddress());
            logger.finer("Stopping local domain on port " + this.programOpts.getPort());
            this.programOpts.setInteractive(false);
            if (!this.isThisDAS(this.getDomainRootDir())) {
                return this.dasNotRunning(this.local);
            }
            logger.finer("It's the correct DAS");
        } else {
            if (!DASUtils.pingDASQuietly((ProgramOptions)this.programOpts, (Environment)this.env)) {
                return this.dasNotRunning(this.local);
            }
            logger.finer("DAS is running");
            this.programOpts.setInteractive(false);
        }
        this.doCommand();
        return 0;
    }

    protected int dasNotRunning(boolean local) throws CommandException {
        if (this.kill.booleanValue()) {
            if (local) {
                return this.kill();
            }
            throw new CommandException(Strings.get("StopDomain.dasNotRunningRemotely"));
        }
        if (local) {
            logger.warning(Strings.get("StopDomain.dasNotRunning", this.getDomainRootDir()));
        } else {
            logger.warning(Strings.get("StopDomain.dasNotRunningRemotely"));
        }
        return 0;
    }

    protected void doCommand() throws CommandException {
        RemoteCommand cmd = new RemoteCommand(this.getName(), this.programOpts, this.env);
        cmd.executeAndReturnOutput(new String[]{"stop-domain", "--force", this.force.toString()});
        this.waitForDeath();
        if (this.kill.booleanValue() && this.local) {
            this.kill();
        }
    }

    protected void waitForDeath() throws CommandException {
        if (!this.programOpts.isTerse()) {
            System.out.print(Strings.get("StopDomain.WaitDASDeath") + " ");
        }
        long startWait = System.currentTimeMillis();
        boolean alive = true;
        int count = 0;
        while (!this.timedOut(startWait)) {
            if (!this.isRunning()) {
                alive = false;
                break;
            }
            try {
                Thread.sleep(100L);
                if (this.programOpts.isTerse() || count++ % 10 != 0) continue;
                System.out.print(".");
            }
            catch (InterruptedException ex) {}
        }
        if (!this.programOpts.isTerse()) {
            System.out.println();
        }
        if (alive) {
            throw new CommandException(Strings.get("StopDomain.DASNotDead", 60L));
        }
    }

    private boolean timedOut(long startTime) {
        return System.currentTimeMillis() - startTime > 60000L;
    }

    private int kill() throws CommandException {
        File prevPid = null;
        String pids = null;
        try {
            prevPid = new File(this.getServerDirs().getPidFile().getPath() + ".prev");
            if (!prevPid.canRead()) {
                throw new CommandException(Strings.get("StopDomain.nopidprev", prevPid));
            }
            pids = FileUtils.readSmallFile((File)prevPid).trim();
            String s = ProcessUtils.kill((int)Integer.parseInt(pids));
            if (s != null) {
                logger.finer(s);
            }
        }
        catch (CommandException ce) {
            throw ce;
        }
        catch (Exception ex) {
            throw new CommandException(Strings.get("StopDomain.pidprevreaderror", prevPid, ex.getMessage()));
        }
        return 0;
    }
}

