/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.cli;

import com.sun.enterprise.admin.cli.CLIConstants;
import com.sun.enterprise.admin.launcher.GFLauncher;
import com.sun.enterprise.admin.launcher.GFLauncherException;
import com.sun.enterprise.admin.launcher.GFLauncherInfo;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import com.sun.enterprise.universal.process.ProcessStreamDrainer;
import com.sun.enterprise.universal.process.ProcessUtils;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.net.NetUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.time.Duration;
import java.util.List;
import java.util.function.Supplier;
import org.glassfish.api.admin.CommandException;

public class StartServerHelper {
    private static final LocalStringsImpl I18N = new LocalStringsImpl(StartServerHelper.class);
    private static final System.Logger LOG = System.getLogger(StartServerHelper.class.getName(), I18N.getBundle());
    private final boolean terse;
    private final GFLauncher launcher;
    private final File pidFile;
    private final GFLauncherInfo info;
    private final List<HostAndPort> addresses;
    private final ServerDirs serverDirs;
    private final String masterPassword;
    private final String serverOrDomainName;
    private final int debugPort;

    public StartServerHelper(boolean terse, ServerDirs serverDirs, GFLauncher launcher, String masterPassword) {
        this(terse, serverDirs, launcher, masterPassword, false);
    }

    public StartServerHelper(boolean terse, ServerDirs serverDirs, GFLauncher launcher, String masterPassword, boolean debug) {
        this.terse = terse;
        this.launcher = launcher;
        this.info = launcher.getInfo();
        this.serverOrDomainName = this.info.isDomain() ? this.info.getDomainName() : this.info.getInstanceName();
        this.addresses = this.info.getAdminAddresses();
        this.serverDirs = serverDirs;
        this.pidFile = serverDirs.getPidFile();
        this.masterPassword = masterPassword;
        this.debugPort = launcher.getDebugPort();
    }

    public void waitForServerStart() throws CommandException {
        String serverName;
        String output;
        Process glassFishProcess;
        if (!this.terse) {
            System.out.print(I18N.get("WaitServer", new Object[]{this.serverOrDomainName}) + " ");
        }
        try {
            glassFishProcess = this.launcher.getProcess();
        }
        catch (GFLauncherException e) {
            throw new IllegalStateException("Could not access the server process!", e);
        }
        Supplier<Boolean> signOfFinishedStartup = () -> {
            if (this.pidFile == null) {
                if (this.isListeningOnAnyEndpoint()) {
                    return true;
                }
            } else if (this.pidFile.exists()) {
                LOG.log(System.Logger.Level.TRACE, "The pid file {0} has been created.", this.pidFile);
                return true;
            }
            return !glassFishProcess.isAlive();
        };
        Duration timeout = Duration.ofMillis(CLIConstants.WAIT_FOR_DAS_TIME_MS);
        if (!ProcessUtils.waitFor(signOfFinishedStartup, (Duration)timeout, (!this.terse ? 1 : 0) != 0)) {
            String msg = this.info.isDomain() ? I18N.get("serverNoStart", new Object[]{I18N.get("DAS"), this.info.getDomainName(), timeout.toSeconds()}) : I18N.get("serverNoStart", new Object[]{I18N.get("INSTANCE"), this.info.getInstanceName(), timeout.toSeconds()});
            throw new CommandException(msg);
        }
        if (glassFishProcess.isAlive()) {
            return;
        }
        int exitCode = glassFishProcess.exitValue();
        try {
            ProcessStreamDrainer psd = this.launcher.getProcessStreamDrainer();
            output = psd.getOutErrString();
        }
        catch (GFLauncherException e) {
            throw new IllegalStateException("Could not access the output of the server process!", e);
        }
        String string = serverName = this.info.isDomain() ? "domain " + this.info.getDomainName() : "instance " + this.info.getInstanceName();
        if (StringUtils.ok((String)output)) {
            throw new CommandException(I18N.get("serverDiedOutput", new Object[]{serverName, exitCode, output}));
        }
        throw new CommandException(I18N.get("serverDied", new Object[]{serverName, exitCode}));
    }

    public boolean prepareForLaunch() throws CommandException {
        this.waitForParentToDie();
        this.setSecurity();
        if (!this.checkPorts()) {
            return false;
        }
        this.deletePidFile();
        return true;
    }

    public void report() {
        String logfile;
        try {
            logfile = this.launcher.getLogFilename();
        }
        catch (GFLauncherException e) {
            throw new IllegalStateException(e);
        }
        Integer adminPort = this.addresses == null || this.addresses.isEmpty() ? null : Integer.valueOf(this.addresses.get(0).getPort());
        LOG.log(System.Logger.Level.INFO, "ServerStart.SuccessMessage", this.info.isDomain() ? "domain " : "instance", this.serverDirs.getServerName(), this.serverDirs.getServerDir(), logfile, adminPort);
    }

    private void waitForParentToDie() throws CommandException {
        Integer pid = this.getParentPid();
        if (pid == null) {
            return;
        }
        LOG.log(System.Logger.Level.DEBUG, "Waiting for death of the parent process with pid={0}", pid);
        if (!ProcessUtils.waitWhileIsAlive((long)pid.intValue(), (Duration)Duration.ofMillis(CLIConstants.DEATH_TIMEOUT_MS), (boolean)false)) {
            throw new CommandException(I18N.get("deathwait_timeout", new Object[]{CLIConstants.DEATH_TIMEOUT_MS}));
        }
        LOG.log(System.Logger.Level.DEBUG, "Parent process with PID={0} is dead and all admin endpoints are free.", pid);
    }

    private Integer getParentPid() {
        String pid = System.getProperty("AS_RESTART");
        if (!StringUtils.ok((String)pid)) {
            return null;
        }
        try {
            return Integer.valueOf(pid);
        }
        catch (NumberFormatException e) {
            LOG.log(System.Logger.Level.WARNING, "Cannot parse pid {0} required for waiting for the death of the parent process.", pid);
            return null;
        }
    }

    private boolean isListeningOnAnyEndpoint() {
        for (HostAndPort address : this.addresses) {
            if (!ProcessUtils.isListening((HostAndPort)address)) continue;
            LOG.log(System.Logger.Level.TRACE, "Server is listening on {0}.", address);
            return true;
        }
        return false;
    }

    private boolean checkPorts() {
        String err = this.adminPortInUse();
        if (err == null) {
            return true;
        }
        LOG.log(System.Logger.Level.WARNING, err);
        return false;
    }

    private void deletePidFile() {
        if (this.pidFile.exists() && !this.pidFile.isFile()) {
            throw new IllegalStateException("The pid file " + String.valueOf(this.pidFile) + " is not a file!");
        }
        try {
            Files.delete(this.pidFile.toPath());
        }
        catch (NoSuchFileException noSuchFileException) {
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't remove the pid file " + String.valueOf(this.pidFile), e);
        }
        LOG.log(System.Logger.Level.DEBUG, "The pid file {0} has been deleted.", this.pidFile);
    }

    private void setSecurity() {
        this.info.addSecurityToken("AS_ADMIN_MASTERPASSWORD", this.masterPassword);
    }

    private String adminPortInUse() {
        return StartServerHelper.adminPortInUse(this.info.getAdminAddresses());
    }

    private static String adminPortInUse(List<HostAndPort> adminAddresses) {
        for (HostAndPort addr : adminAddresses) {
            if (NetUtils.isPortFree((String)addr.getHost(), (int)addr.getPort())) continue;
            return I18N.get("ServerRunning", new Object[]{addr.getPort()});
        }
        return null;
    }
}

