/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.admin.servermgmt.stringsubs.impl;

import com.sun.enterprise.admin.servermgmt.SLogger;
import com.sun.enterprise.admin.servermgmt.stringsubs.AttributePreprocessor;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutionException;
import com.sun.enterprise.admin.servermgmt.stringsubs.StringSubstitutor;
import com.sun.enterprise.admin.servermgmt.stringsubs.Substitutable;
import com.sun.enterprise.admin.servermgmt.stringsubs.SubstitutableFactory;
import com.sun.enterprise.admin.servermgmt.stringsubs.SubstitutionAlgorithm;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.AttributePreprocessorImpl;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.ModeProcessor;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.StringSubstitutionParser;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SubstituableFactoryImpl;
import com.sun.enterprise.admin.servermgmt.stringsubs.impl.SubstitutionAlgorithmFactory;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Archive;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.ChangePair;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.ChangePairRef;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Component;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Defaults;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.FileEntry;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Group;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.GroupRef;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.ModeType;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.Property;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.PropertyType;
import com.sun.enterprise.admin.servermgmt.xml.stringsubs.StringsubsDefinition;
import com.sun.enterprise.universal.i18n.LocalStringsImpl;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.logging.LogHelper;

public class StringSubstitutionEngine
implements StringSubstitutor {
    private static final Logger _logger = SLogger.getLogger();
    private static final LocalStringsImpl _strings = new LocalStringsImpl(StringSubstitutionEngine.class);
    private StringsubsDefinition _root = null;
    private Map<String, Pair> _changePairsMap = null;
    Map<String, Property> _defaultProperties = null;
    private SubstitutableFactory _substitutableFactory = new SubstituableFactoryImpl();
    private AttributePreprocessor _attrPreprocessor = new AttributePreprocessorImpl();

    public StringSubstitutionEngine(InputStream inputStream) throws StringSubstitutionException {
        if (inputStream == null) {
            throw new StringSubstitutionException("InputStream is null");
        }
        this._root = StringSubstitutionParser.parse(inputStream);
    }

    @Override
    public void setAttributePreprocessor(AttributePreprocessor attributePreprocessor) {
        this._attrPreprocessor = attributePreprocessor;
    }

    @Override
    public void setEntryFactory(SubstitutableFactory factory) {
        this._substitutableFactory = factory;
    }

    @Override
    public void setFileBackupLocation(File backupLocation) {
    }

    @Override
    public List<Property> getDefaultProperties(PropertyType type) {
        Defaults defaults = this._root.getDefaults();
        if (defaults == null) {
            return Collections.emptyList();
        }
        if (type == null) {
            return defaults.getProperty();
        }
        ArrayList<Property> props = new ArrayList<Property>();
        for (Property prop : defaults.getProperty()) {
            if (!prop.getType().equals((Object)type)) continue;
            props.add(prop);
        }
        return props;
    }

    @Override
    public void substituteAll() throws StringSubstitutionException {
        for (Component component : this._root.getComponent()) {
            this.doSubstitution(component);
        }
    }

    @Override
    public void substituteComponents(List<String> components) throws StringSubstitutionException {
        if (!this.isValid(components)) {
            throw new StringSubstitutionException(_strings.get("missingComponentIdentifiers"));
        }
        for (String componentId : components) {
            Component component = this.findComponentById(componentId);
            if (component == null) {
                _logger.log(Level.INFO, "NCLS-SRVRMGMT-00027", componentId);
                continue;
            }
            this.doSubstitution(component);
        }
    }

    @Override
    public void substituteGroups(List<String> groups) throws StringSubstitutionException {
        if (!this.isValid(groups)) {
            throw new StringSubstitutionException(_strings.get("missingGroupIdentifiers"));
        }
        for (String groupId : groups) {
            Group group = this.findGroupById(groupId);
            if (group == null) {
                _logger.log(Level.WARNING, "NCLS-SRVRMGMT-00028", groupId);
                continue;
            }
            this.doSubstitution(group);
        }
    }

    @Override
    public StringsubsDefinition getStringSubsDefinition() {
        return this._root;
    }

    private void doSubstitution(Component component) throws StringSubstitutionException {
        List<GroupRef> refList = component.getGroupRef();
        for (GroupRef ref : refList) {
            this.doSubstitution(this.findGroupById(ref.getName()));
        }
    }

    private void doSubstitution(Group group) throws StringSubstitutionException {
        List<? extends Substitutable> substituables;
        List<FileEntry> fileList = group.getFileEntry();
        List<Archive> archiveList = group.getArchive();
        if (!this.isValid(fileList) && !this.isValid(archiveList)) {
            if (_logger.isLoggable(Level.FINER)) {
                _logger.log(Level.FINER, _strings.get("noSubstitutableGroupEntry", new Object[]{group.getId()}));
            }
            return;
        }
        List<ChangePairRef> refList = group.getChangePairRef();
        if (!this.isValid(refList)) {
            if (_logger.isLoggable(Level.FINE)) {
                _logger.log(Level.FINE, _strings.get("noChangePairForGroup", new Object[]{group.getId()}));
            }
            return;
        }
        String groupMode = null;
        ModeType modeType = group.getMode();
        if (modeType != null) {
            groupMode = modeType.value();
        }
        this.buildChangePairsMap();
        HashMap<String, String> substitutionMap = new HashMap<String, String>();
        for (ChangePairRef ref : refList) {
            Pair pair;
            String name = ref.getName();
            String localMode = ref.getMode();
            if (localMode == null || localMode.length() == 0) {
                localMode = groupMode;
            }
            if ((pair = this._changePairsMap.get(name)) == null) {
                _logger.log(Level.INFO, "NCLS-SRVRMGMT-00029", new Object[]{name, group.getId()});
                continue;
            }
            String string = pair.getBefore();
            String afterString = pair.getAfter();
            if (localMode == null || localMode.length() == 0) {
                if (_logger.isLoggable(Level.FINEST)) {
                    _logger.log(Level.FINEST, _strings.get("noModeValue", new Object[]{group.getId()}));
                }
            } else {
                try {
                    afterString = ModeProcessor.processModeType(ModeType.fromValue(localMode), afterString);
                }
                catch (Exception e) {
                    _logger.log(Level.WARNING, "NCLS-SRVRMGMT-00030", localMode);
                }
            }
            substitutionMap.put(string, afterString);
        }
        SubstitutionAlgorithm algorithm = new SubstitutionAlgorithmFactory().getAlgorithm(substitutionMap);
        for (FileEntry fileEntry : fileList) {
            fileEntry.setName(this._attrPreprocessor.substitutePath(fileEntry.getName()));
            substituables = this._substitutableFactory.getFileEntrySubstituables(fileEntry);
            for (Substitutable substitutable : substituables) {
                algorithm.substitute(substitutable);
                substitutable.finish();
            }
        }
        for (Archive archive : archiveList) {
            if (archive == null || archive.getName().isEmpty()) continue;
            try {
                archive.setName(this._attrPreprocessor.substitutePath(archive.getName()));
                substituables = this._substitutableFactory.getArchiveEntrySubstitutable(archive);
                if (!this.isValid(substituables)) continue;
                for (Substitutable substitutable : substituables) {
                    algorithm.substitute(substitutable);
                    substitutable.finish();
                }
            }
            catch (Exception e) {
                LogHelper.log((Logger)_logger, (Level)Level.WARNING, (String)"NCLS-SRVRMGMT-00021", (Throwable)e, (Object[])new Object[]{archive.getName()});
            }
        }
    }

    private void buildChangePairsMap() {
        if (this._changePairsMap == null || this._changePairsMap.isEmpty()) {
            List<Property> properties;
            Defaults defaults = this._root.getDefaults();
            if (defaults != null && !(properties = defaults.getProperty()).isEmpty()) {
                this._defaultProperties = new HashMap<String, Property>(properties.size(), 1.0f);
                for (Property prop : properties) {
                    this._defaultProperties.put(prop.getKey(), prop);
                }
            }
            List<ChangePair> changePairList = this._root.getChangePair();
            this._changePairsMap = new HashMap<String, Pair>(changePairList.size());
            for (ChangePair pair : this._root.getChangePair()) {
                String id = pair.getId();
                String beforeValue = pair.getBefore();
                String afterValue = pair.getAfter();
                if (id == null || beforeValue == null || afterValue == null) {
                    _logger.log(Level.INFO, "NCLS-SRVRMGMT-00031");
                    continue;
                }
                beforeValue = this._attrPreprocessor.substituteBefore(beforeValue);
                afterValue = this._attrPreprocessor.substituteAfter(afterValue);
                this._changePairsMap.put(id, new Pair(beforeValue, afterValue));
            }
        }
    }

    private Group findGroupById(String id) {
        if (id == null) {
            return null;
        }
        List<Group> groupList = this._root.getGroup();
        if (!this.isValid(groupList)) {
            return null;
        }
        for (Group group : groupList) {
            if (!id.equals(group.getId())) continue;
            return group;
        }
        return null;
    }

    private Component findComponentById(String id) {
        if (id == null) {
            return null;
        }
        List<Component> components = this._root.getComponent();
        if (!this.isValid(components)) {
            return null;
        }
        for (Component component : components) {
            if (!id.equals(component.getId())) continue;
            return component;
        }
        return null;
    }

    private boolean isValid(Collection<? extends Object> collection) {
        return collection != null && !collection.isEmpty();
    }

    private static class Pair {
        String _before;
        String _after;

        Pair(String before, String after) {
            this._before = before;
            this._after = after;
        }

        public String getBefore() {
            return this._before;
        }

        public String getAfter() {
            return this._after;
        }
    }
}

