/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestResponse;
import org.glassfish.admingui.common.util.RestUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MonitoringHandlers {
    private static final List<String> levels = new ArrayList<String>();
    public static final String JVM;
    public static final String WEB_CONTAINER;
    public static final String HTTP_SERVICE;
    public static final String THREAD_POOL;
    public static final String JDBC_CONNECTION_POOL;
    public static final String CONNECTOR_CONNECTION_POOL;
    public static final String EJB_CONTAINER;
    public static final String TRANSACTION_SERVICE;
    public static final String ORB;
    public static final String CONNECTOR_SERVICE;
    public static final String JMS_SERVICE;
    public static final String WEB_SERVICES_CONTAINER;
    public static final String JPA;
    public static final String SECURITY;
    public static final String JERSEY;
    public static final String DEPLOYMENT;
    private static final List monDisplayList;
    private static final List monNamesList;
    private static final List containerDispList;
    private static final List containerNameList;

    public static void getMonitorLevels(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        ArrayList result = new ArrayList();
        try {
            String value;
            String dispName;
            ListIterator vi;
            String monitoringServiceEndPoint = endpoint + "/monitoring-service";
            Map<String, Object> attrs = RestUtil.getEntityAttrs(monitoringServiceEndPoint + "/container-monitoring", "entitiy");
            if (attrs != null) {
                for (Map.Entry<String, Object> e : attrs.entrySet()) {
                    HashMap<String, Object> oneRow = new HashMap<String, Object>();
                    String cname = null;
                    String pname = e.getKey();
                    ListIterator ci = containerDispList.listIterator();
                    vi = containerNameList.listIterator();
                    while (ci.hasNext() && vi.hasNext()) {
                        dispName = (String)ci.next();
                        value = (String)vi.next();
                        if (!pname.equals(value)) continue;
                        cname = dispName;
                    }
                    oneRow.put("monCompName", cname == null ? pname : cname);
                    oneRow.put("level", e.getValue());
                    oneRow.put("selected", false);
                    result.add(oneRow);
                }
            }
            String monitoringLevelsEndPoint = monitoringServiceEndPoint + "/module-monitoring-levels";
            attrs = RestUtil.getEntityAttrs(monitoringLevelsEndPoint, "entity");
            for (Map.Entry<String, Object> e : attrs.entrySet()) {
                HashMap<String, Object> oneRow = new HashMap<String, Object>();
                String name = null;
                ListIterator ni = monDisplayList.listIterator();
                vi = monNamesList.listIterator();
                while (ni.hasNext() && vi.hasNext()) {
                    dispName = (String)ni.next();
                    value = (String)vi.next();
                    if (!e.getKey().equals(value)) continue;
                    name = dispName;
                }
                if (name == null) {
                    name = e.getKey();
                }
                oneRow.put("monCompName", name);
                oneRow.put("level", e.getValue());
                oneRow.put("selected", false);
                result.add(oneRow);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("monitorCompList", result);
    }

    public static void getStats(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String statType = (String)handlerCtx.getInputValue("statType");
        String type = (String)handlerCtx.getInputValue("type");
        Locale locale = GuiUtil.getLocale();
        DateFormat df = DateFormat.getDateTimeInstance(2, 2, locale);
        NumberFormat nf = NumberFormat.getNumberInstance(locale);
        ArrayList result = new ArrayList();
        try {
            if ((type == null || statType == null || type.equals(statType)) && RestUtil.doesProxyExist(endpoint).booleanValue()) {
                Map<String, Object> stats = MonitoringHandlers.getMonitoringStatInfo(endpoint);
                if (statType != null && statType.equals("jersey")) {
                    HashMap<String, Object> jerseyStats = new HashMap<String, Object>();
                    for (Map.Entry<String, Object> e : stats.entrySet()) {
                        Map jerseyStat = (Map)e.getValue();
                        if (jerseyStat == null) continue;
                        jerseyStats.putAll(jerseyStat);
                    }
                    stats = jerseyStats;
                }
                for (Map.Entry<String, Object> e : stats.entrySet()) {
                    Long startTime;
                    if (!e.getValue().getClass().equals(HashMap.class)) continue;
                    Map monAttrs = (Map)e.getValue();
                    HashMap<String, String> statMap = new HashMap<String, String>();
                    String val = "";
                    String details = "--";
                    String desc = "--";
                    String start = "--";
                    String last = "--";
                    String unit = "";
                    String mname = null;
                    String runtimes = null;
                    String queuesize = null;
                    String thresholds = "--";
                    if (monAttrs.isEmpty()) continue;
                    if (monAttrs.containsKey("name")) {
                        mname = (String)monAttrs.get("name");
                    } else if (monAttrs.containsKey("appname")) {
                        mname = (String)monAttrs.get("appname");
                    }
                    unit = (String)monAttrs.get("unit");
                    desc = (String)monAttrs.get("description");
                    Long lastTime = (Long)monAttrs.get("lastsampletime");
                    if (lastTime != -1L) {
                        last = df.format(new Date(lastTime));
                    }
                    if ((startTime = (Long)monAttrs.get("starttime")) != -1L) {
                        start = df.format(new Date(startTime));
                    }
                    if (monAttrs.containsKey("count")) {
                        val = monAttrs.get("count") + " " + unit;
                    } else if (monAttrs.containsKey("current")) {
                        if (unit != null) {
                            String str;
                            if (unit.equals("String")) {
                                if (mname.equals("LiveThreads")) {
                                    str = (String)monAttrs.get("current");
                                    val = MonitoringHandlers.formatStringForDisplay(str);
                                } else {
                                    val = (String)monAttrs.get("current");
                                }
                            } else if (unit.equals("List")) {
                                str = (String)monAttrs.get("current");
                                String formatStr = MonitoringHandlers.formatActiveIdsForDisplay(str);
                                if (!formatStr.isEmpty() && !formatStr.equals("")) {
                                    val = formatStr;
                                }
                            } else {
                                Long currentVal = (Long)monAttrs.get("current");
                                val = currentVal + unit;
                            }
                        }
                    } else if (monAttrs.containsKey("applicationtype")) {
                        val = (String)monAttrs.get("applicationtype");
                    }
                    if (monAttrs.containsKey("appName")) {
                        details = GuiUtil.getMessage("msg.AppName") + ": " + monAttrs.get("appName") + "<br/>";
                    }
                    if (monAttrs.containsKey("appname")) {
                        details = GuiUtil.getMessage("msg.AppName") + ": " + monAttrs.get("appname") + "<br/>";
                    }
                    if (monAttrs.containsKey("environment")) {
                        details = details + GuiUtil.getMessage("msg.Environment") + ": " + monAttrs.get("environment") + "<br/>";
                    }
                    if (monAttrs.containsKey("address")) {
                        details = details + GuiUtil.getMessage("msg.Address") + ": " + monAttrs.get("address") + "<br/>";
                    }
                    if (monAttrs.containsKey("deploymenttype")) {
                        details = details + GuiUtil.getMessage("msg.DepType") + ": " + monAttrs.get("deploymenttype") + "<br/>";
                    }
                    if (monAttrs.containsKey("endpointname")) {
                        details = details + GuiUtil.getMessage("msg.EndPointName") + ": " + monAttrs.get("endpointname") + "<br/>";
                    }
                    if (monAttrs.containsKey("classname")) {
                        details = GuiUtil.getMessage("msg.ClassName") + ": " + monAttrs.get("classname") + "<br/>";
                    }
                    if (monAttrs.containsKey("impltype")) {
                        details = details + GuiUtil.getMessage("msg.ImplClass") + ": " + monAttrs.get("implclass") + "<br/>";
                    }
                    if (monAttrs.containsKey("implclass") && monAttrs.containsKey("impltype")) {
                        details = details + GuiUtil.getMessage("msg.ImplType") + ": " + monAttrs.get("impltype") + "<br/>";
                    }
                    if (monAttrs.containsKey("namespace")) {
                        details = details + GuiUtil.getMessage("msg.NameSpace") + ": " + monAttrs.get("namespace") + "<br/>";
                    }
                    if (monAttrs.containsKey("portname")) {
                        details = details + GuiUtil.getMessage("msg.PortName") + ": " + monAttrs.get("portname") + "<br/>";
                    }
                    if (monAttrs.containsKey("servicename")) {
                        details = details + GuiUtil.getMessage("msg.ServiceName") + ": " + monAttrs.get("servicename") + "<br/>";
                    }
                    if (monAttrs.containsKey("tester")) {
                        details = details + GuiUtil.getMessage("msg.Tester") + ": " + monAttrs.get("tester") + "<br/>";
                    }
                    if (monAttrs.containsKey("wsdl")) {
                        details = details + GuiUtil.getMessage("msg.WSDL") + ": " + monAttrs.get("wsdl") + "<br/>";
                    }
                    if (monAttrs.containsKey("maxtime")) {
                        details = GuiUtil.getMessage("msg.MaxTime") + ": " + monAttrs.get("maxtime") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("mintime")) {
                        details = details + GuiUtil.getMessage("msg.MinTime") + ": " + monAttrs.get("mintime") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("totaltime")) {
                        details = details + GuiUtil.getMessage("msg.TotalTime") + ": " + monAttrs.get("totaltime") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("highwatermark")) {
                        details = GuiUtil.getMessage("msg.HWaterMark") + ": " + monAttrs.get("highwatermark") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("lowwatermark")) {
                        details = details + GuiUtil.getMessage("msg.LWaterMark") + ": " + monAttrs.get("lowwatermark") + " " + unit + "<br/>";
                    }
                    if (monAttrs.containsKey("activeruntimes")) {
                        runtimes = (String)monAttrs.get("activeruntimes");
                    }
                    if (monAttrs.containsKey("queuesize")) {
                        queuesize = (String)monAttrs.get("queuesize");
                    }
                    if (monAttrs.containsKey("hardmaximum") && monAttrs.get("hardmaximum") != null) {
                        val = monAttrs.get("hardmaximum") + " " + "hard max " + "<br/>" + monAttrs.get("hardminimum") + " " + "hard min";
                    }
                    if (monAttrs.containsKey("newthreshold") && monAttrs.get("newThreshold") != null) {
                        thresholds = monAttrs.get("newthreshold") + " " + "new " + "<br/>" + monAttrs.get("queuedownthreshold") + " " + "queue down";
                    }
                    if (monAttrs.containsKey("queuesize") && monAttrs.containsKey("environment")) {
                        details = details + monAttrs.get("environment");
                    }
                    statMap.put("name", mname);
                    statMap.put("startTime", start);
                    statMap.put("lastTime", last);
                    statMap.put("description", desc);
                    statMap.put("value", val == null ? "" : val);
                    statMap.put("details", details == null ? "--" : details);
                    statMap.put("thresholds", thresholds == null ? "--" : thresholds);
                    statMap.put("queueSize", queuesize == null ? "--" : queuesize);
                    statMap.put("runtimes", runtimes == null ? "--" : runtimes);
                    result.add(statMap);
                }
            }
            handlerCtx.setOutputValue("result", result);
            handlerCtx.setOutputValue("hasStats", (Object)(result.size() != 0 ? 1 : 0));
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
    }

    public static void updateMonitorLevels(HandlerContext handlerCtx) {
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String containerEndpoint = (String)handlerCtx.getInputValue("containerEndpoint");
        List allRows = (List)handlerCtx.getInputValue("allRows");
        String objectNameStr = null;
        for (Map oneRow : allRows) {
            String name = (String)oneRow.get("monCompName");
            String value = null;
            ListIterator ni = monDisplayList.listIterator();
            ListIterator vi = monNamesList.listIterator();
            while (ni.hasNext() && vi.hasNext()) {
                String dispName = (String)ni.next();
                String mvalue = (String)vi.next();
                if (!name.equals(dispName)) continue;
                value = mvalue;
                objectNameStr = endpoint;
            }
            if (value == null) {
                ListIterator ci = containerDispList.listIterator();
                ListIterator cni = containerNameList.listIterator();
                while (ci.hasNext() && cni.hasNext()) {
                    String cDispName = (String)ci.next();
                    String cName = (String)cni.next();
                    if (!name.equals(cDispName)) continue;
                    value = "Level";
                    objectNameStr = containerEndpoint + "/" + cName;
                }
            }
            HashMap<String, Object> attrMap = new HashMap<String, Object>();
            attrMap.put(value == null ? name : value, oneRow.get("level"));
            String entityUrl = objectNameStr == null ? containerEndpoint + "/" + name : objectNameStr;
            RestResponse response = RestUtil.sendUpdateRequest(entityUrl, attrMap, null, null, null);
            if (response.isSuccess()) continue;
            GuiUtil.getLogger().severe("Update monitor level failed.  parent=" + endpoint + "; attrsMap =" + attrMap);
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
            return;
        }
    }

    public static void addToMonitorList(HandlerContext handlerCtx) {
        List oldList = (List)handlerCtx.getInputValue("oldList");
        ArrayList<String> newList = (ArrayList<String>)handlerCtx.getInputValue("newList");
        if (newList == null) {
            newList = new ArrayList<String>();
        }
        if (oldList != null) {
            for (String sk : oldList) {
                newList.add(sk);
            }
        }
        handlerCtx.setOutputValue("result", newList);
    }

    public static void getValidMonitorLevels(HandlerContext handlerCtx) {
        handlerCtx.setOutputValue("monitorLevelList", levels);
    }

    public static void getFirstValueFromList(HandlerContext handlerCtx) {
        List values = (List)handlerCtx.getInputValue("values");
        String firstval = "";
        if (values != null && values.size() != 0) {
            firstval = (String)values.get(0);
        }
        handlerCtx.setOutputValue("firstValue", (Object)firstval);
    }

    public static void getAppName(HandlerContext handlerCtx) {
        String name;
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        String appName = name = (String)handlerCtx.getInputValue("name");
        String fullName = name;
        try {
            ArrayList<String> applications = new ArrayList<String>(RestUtil.getChildMap(endpoint).keySet());
            for (String oneApp : applications) {
                ArrayList<String> modules = new ArrayList<String>(RestUtil.getChildMap(endpoint + "/" + oneApp + "/module").keySet());
                if (!modules.contains(name)) continue;
                appName = oneApp;
                break;
            }
            if (fullName != null && !name.equals(appName)) {
                fullName = URLEncoder.encode(appName, "UTF-8") + "/" + URLEncoder.encode(name, "UTF-8");
            }
            if (appName != null) {
                appName = URLEncoder.encode(appName, "UTF-8");
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("appName", (Object)appName);
        handlerCtx.setOutputValue("appFullName", (Object)fullName);
    }

    public static void getWebStatsUrl(HandlerContext handlerCtx) {
        String webType;
        String statType;
        String webServletUrl;
        String webUrl;
        block4: {
            String app = (String)handlerCtx.getInputValue("app");
            String monitorURL = (String)handlerCtx.getInputValue("monitorURL");
            List vsList = (List)handlerCtx.getInputValue("vsList");
            String compVal = (String)handlerCtx.getInputValue("compVal");
            Map moduleProps = (Map)handlerCtx.getInputValue("moduleProps");
            webUrl = "EMPTY";
            webServletUrl = "EMPTY";
            statType = "EMPTY";
            webType = "EMPTY";
            String monitorEndpoint = monitorURL + "/applications/" + app;
            try {
                String[] compStrs;
                for (String vs : vsList) {
                    if (!MonitoringHandlers.doesMonitoringDataExist(monitorEndpoint + "/" + URLEncoder.encode(vs, "UTF-8")).booleanValue()) continue;
                    webUrl = monitorEndpoint + "/" + URLEncoder.encode(vs, "UTF-8");
                    webType = "Web";
                    break;
                }
                if (compVal != null && !compVal.equals("") && vsList.contains((compStrs = compVal.split("/"))[0]) && moduleProps != null && moduleProps.containsKey(compStrs[1]) && ((String)moduleProps.get(compStrs[1])).equals("Servlet") && RestUtil.doesProxyExist(monitorEndpoint = monitorEndpoint + "/" + URLEncoder.encode(compStrs[0], "UTF-8") + "/" + URLEncoder.encode(compStrs[1], "UTF-8")).booleanValue()) {
                    webServletUrl = monitorEndpoint;
                    statType = "ServletInstance";
                }
            }
            catch (UnsupportedEncodingException ex) {
                GuiUtil.getLogger().info(GuiUtil.getCommonMessage("log.error.getWebStatsUrl") + ex.getLocalizedMessage());
                if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block4;
                ex.printStackTrace();
            }
        }
        handlerCtx.setOutputValue("webServletUrl", (Object)webServletUrl);
        handlerCtx.setOutputValue("webServletType", (Object)statType);
        handlerCtx.setOutputValue("webUrl", (Object)webUrl);
        handlerCtx.setOutputValue("webType", (Object)webType);
    }

    public static void getStatsUrl(HandlerContext handlerCtx) {
        String app = (String)handlerCtx.getInputValue("app");
        String comp = (String)handlerCtx.getInputValue("compVal");
        String monitorURL = (String)handlerCtx.getInputValue("monitorURL");
        Map moduleProps = (Map)handlerCtx.getInputValue("moduleProps");
        StringBuilder statUrl = new StringBuilder();
        String statType = "";
        if (comp != null && !comp.trim().equals("")) {
            List<Object> compStrs;
            block8: {
                compStrs = new ArrayList<String>();
                if (comp.startsWith("resources/")) {
                    compStrs.add("resources");
                    compStrs.add(comp.substring(10));
                } else {
                    compStrs = Arrays.asList(comp.split("/"));
                }
                try {
                    statUrl = statUrl.append(monitorURL).append("/applications/").append(app);
                    for (String string : compStrs) {
                        statUrl = statUrl.append("/").append(URLEncoder.encode(string, "UTF-8"));
                    }
                }
                catch (UnsupportedEncodingException ex) {
                    GuiUtil.getLogger().log(Level.INFO, "{0}{1}", new Object[]{GuiUtil.getCommonMessage("log.error.getStatsUrl"), ex.getLocalizedMessage()});
                    if (!GuiUtil.getLogger().isLoggable(Level.FINE)) break block8;
                    ex.printStackTrace();
                }
            }
            if (RestUtil.doesProxyExist(statUrl.toString()).booleanValue()) {
                statType = compStrs.size() == 1 ? (String)moduleProps.get(compStrs.get(0)) : (((String)compStrs.get(0)).equals("resources") ? "AppScopedResource" : MonitoringHandlers.modifyStatType((String)compStrs.get(1)));
            }
        } else {
            statUrl.append("EMPTY");
        }
        handlerCtx.setOutputValue("statUrl", (Object)statUrl.toString());
        handlerCtx.setOutputValue("statType", (Object)statType);
    }

    public static void filterWebStats(HandlerContext handlerCtx) {
        List webStats = (List)handlerCtx.getInputValue("webStats");
        String statType = (String)handlerCtx.getInputValue("statType");
        List<String> requestStatNames = Arrays.asList("MaxTime", "ProcessingTime", "RequestCount", "ErrorCount");
        ArrayList<Map> stats = new ArrayList<Map>();
        if (webStats != null) {
            for (Map webStat : webStats) {
                String statName = (String)webStat.get("name");
                if (requestStatNames.contains(statName) && statType.equals("Request")) {
                    stats.add(webStat);
                    continue;
                }
                if (!statName.contains(statType) || statType.equals("Request")) continue;
                stats.add(webStat);
            }
        }
        handlerCtx.setOutputValue("stats", stats);
    }

    public static void isPool(HandlerContext handlerCtx) {
        String poolName = (String)handlerCtx.getInputValue("poolName");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        Boolean result = false;
        try {
            ArrayList<String> poolNames = new ArrayList<String>(RestUtil.getChildMap(endpoint).keySet());
            if (poolNames.contains(poolName)) {
                result = true;
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("result", (Object)result);
    }

    public static void getMonitoringPools(HandlerContext handlerCtx) {
        List poolNames = (List)handlerCtx.getInputValue("poolNames");
        String endpoint = (String)handlerCtx.getInputValue("endpoint");
        ArrayList<String> jdbcMonitorList = new ArrayList<String>();
        ArrayList<String> connectorMonitorList = new ArrayList<String>();
        Object fisrtJdbc = null;
        Object firstConnector = null;
        try {
            ArrayList<String> jdbcPools = new ArrayList<String>(RestUtil.getChildMap(endpoint + "/jdbc-connection-pool").keySet());
            ArrayList<String> connectorPools = new ArrayList<String>(RestUtil.getChildMap(endpoint + "/connector-connection-pool").keySet());
            for (String poolName : poolNames) {
                if (jdbcPools.contains(poolName)) {
                    jdbcMonitorList.add(poolName);
                    continue;
                }
                if (!connectorPools.contains(poolName)) continue;
                connectorMonitorList.add(poolName);
            }
        }
        catch (Exception ex) {
            GuiUtil.handleException(handlerCtx, ex);
        }
        handlerCtx.setOutputValue("jdbcList", jdbcMonitorList);
        handlerCtx.setOutputValue("firstJdbc", fisrtJdbc);
        handlerCtx.setOutputValue("connectorList", connectorMonitorList);
        handlerCtx.setOutputValue("firstConnector", firstConnector);
    }

    public static void getInstanceMonitorURL(HandlerContext handlerCtx) {
        String instanceName = (String)handlerCtx.getInputValue("instanceName");
        String monitorURL = (String)GuiUtil.getSessionValue("MONITOR_URL") + "/" + instanceName;
        handlerCtx.setOutputValue("monitorURL", (Object)monitorURL);
    }

    public static Boolean doesAppProxyExist(String appName, String moduleName) {
        boolean proxyexist = false;
        Map<String, Object> subComps = MonitoringHandlers.getSubComponents(appName, moduleName);
        if (subComps != null && subComps.size() > 0) {
            proxyexist = true;
        }
        return proxyexist;
    }

    public static Map<String, Object> getSubComponents(String appName, String moduleName) {
        String endpoint = GuiUtil.getSessionValue("REST_URL") + "/applications/application/" + appName + "/list-sub-components";
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        attrs.put("appname", appName);
        attrs.put("id", moduleName);
        try {
            Map<String, Object> responseMap = RestUtil.restRequest(endpoint, attrs, "GET", null, false);
            Map propsMap = (Map)((Map)responseMap.get("data")).get("properties");
            if (propsMap != null && propsMap.size() > 0) {
                return propsMap;
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().severe("Error in getSubComponents ; \nendpoint = " + endpoint + "attrs=" + attrs + "method=GET");
        }
        return null;
    }

    public static Boolean doesMonitoringDataExist(String endpoint) {
        if (RestUtil.doesProxyExist(endpoint).booleanValue() && MonitoringHandlers.getMonitoringStatInfo(endpoint).size() > 0) {
            return true;
        }
        return false;
    }

    public static String modifyStatType(String name) {
        String[] nameStrs = name.split("-");
        StringBuilder modifiedName = new StringBuilder();
        for (int i = 0; i < nameStrs.length; ++i) {
            String tmp = nameStrs[i].substring(0, 1).toUpperCase(GuiUtil.guiLocale) + nameStrs[i].substring(1);
            modifiedName.append(tmp);
        }
        return modifiedName.toString();
    }

    private static String formatActiveIdsForDisplay(String str) {
        StringBuilder values = new StringBuilder(" ");
        String[] strArray = str.split("%%%EOL%%%");
        if (strArray != null && strArray.length > 0) {
            values.append("<table>");
            for (String s : strArray) {
                if (s.startsWith("Transaction")) {
                    String sh = s.replaceFirst(" ", "_");
                    String[] strHeaders = sh.split(" ");
                    if (strHeaders == null || strHeaders.length <= 0) continue;
                    values.append("<tr>");
                    for (String h : strHeaders) {
                        if (h.isEmpty()) continue;
                        values.append("<td>").append("</td>");
                    }
                    values.append("</tr>");
                    continue;
                }
                String[] strData = s.split(" ");
                if (strData == null || strData.length <= 0) continue;
                values.append("<tr>");
                for (String d : strData) {
                    if (d.isEmpty()) continue;
                    values.append("<td>").append(d).append("</td>");
                }
                values.append("</tr>");
            }
            values.append("</table>");
        }
        return values.toString();
    }

    private static String formatStringForDisplay(String strToFormat) {
        String[] strs = strToFormat.split(",");
        StringBuilder formattedStr = new StringBuilder();
        if (strs != null && strs.length > 10) {
            for (int i = 0; i < strs.length; ++i) {
                String str = strs[i];
                if (formattedStr.length() != 0) {
                    formattedStr.append(",");
                }
                if (i % 10 == 0 && i != 0) {
                    formattedStr.append("\n");
                }
                formattedStr.append(str);
            }
            return formattedStr.toString();
        }
        return strToFormat;
    }

    private static Map<String, Object> getMonitoringStatInfo(String endpoint) {
        Map<String, Object> monitorInfoMap = new HashMap<String, Object>();
        try {
            Map entityMap;
            Map extraPropsMap;
            Map<String, Object> responseMap = RestUtil.restRequest(endpoint, null, "GET", null, false);
            Map dataMap = (Map)responseMap.get("data");
            if (dataMap != null && (extraPropsMap = (Map)dataMap.get("extraProperties")) != null && (entityMap = (Map)extraPropsMap.get("entity")) != null) {
                monitorInfoMap = entityMap;
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().log(Level.SEVERE, "Error in getMonitoringStatInfo ; \nendpoint = {0}attrs=method=GET", endpoint);
        }
        return monitorInfoMap;
    }

    static {
        levels.add("OFF");
        levels.add("LOW");
        levels.add("HIGH");
        JVM = GuiUtil.getMessage("monitoring.Jvm");
        WEB_CONTAINER = GuiUtil.getMessage("monitoring.Web");
        HTTP_SERVICE = GuiUtil.getMessage("monitoring.Http");
        THREAD_POOL = GuiUtil.getMessage("monitoring.ThreadPool");
        JDBC_CONNECTION_POOL = GuiUtil.getMessage("monitoring.Jdbc");
        CONNECTOR_CONNECTION_POOL = GuiUtil.getMessage("monitoring.Connector");
        EJB_CONTAINER = GuiUtil.getMessage("monitoring.Ejb");
        TRANSACTION_SERVICE = GuiUtil.getMessage("monitoring.TransactionService");
        ORB = GuiUtil.getMessage("monitoring.Orb");
        CONNECTOR_SERVICE = GuiUtil.getMessage("monitoring.ConnectorService");
        JMS_SERVICE = GuiUtil.getMessage("monitoring.JmsService");
        WEB_SERVICES_CONTAINER = GuiUtil.getMessage("monitoring.WebServices");
        JPA = GuiUtil.getMessage("monitoring.Jpa");
        SECURITY = GuiUtil.getMessage("monitoring.Security");
        JERSEY = GuiUtil.getMessage("monitoring.Jersey");
        DEPLOYMENT = GuiUtil.getMessage("monitoring.Deployment");
        monDisplayList = new ArrayList();
        monDisplayList.add(JVM);
        monDisplayList.add(WEB_CONTAINER);
        monDisplayList.add(HTTP_SERVICE);
        monDisplayList.add(THREAD_POOL);
        monDisplayList.add(JDBC_CONNECTION_POOL);
        monDisplayList.add(CONNECTOR_CONNECTION_POOL);
        monDisplayList.add(EJB_CONTAINER);
        monDisplayList.add(TRANSACTION_SERVICE);
        monDisplayList.add(ORB);
        monDisplayList.add(CONNECTOR_SERVICE);
        monDisplayList.add(JMS_SERVICE);
        monDisplayList.add(WEB_SERVICES_CONTAINER);
        monDisplayList.add(JPA);
        monDisplayList.add(SECURITY);
        monDisplayList.add(JERSEY);
        monDisplayList.add(DEPLOYMENT);
        monNamesList = new ArrayList();
        monNamesList.add("jvm");
        monNamesList.add("webContainer");
        monNamesList.add("httpService");
        monNamesList.add("threadPool");
        monNamesList.add("jdbcConnectionPool");
        monNamesList.add("connectorConnectionPool");
        monNamesList.add("ejbContainer");
        monNamesList.add("transactionService");
        monNamesList.add("orb");
        monNamesList.add("connectorService");
        monNamesList.add("jmsService");
        monNamesList.add("webServicesContainer");
        monNamesList.add("jpa");
        monNamesList.add("security");
        monNamesList.add("jersey");
        monNamesList.add("deployment");
        containerDispList = new ArrayList();
        containerNameList = new ArrayList();
    }
}

