/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.util;

import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import jakarta.faces.context.FacesContext;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.Cookie;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.RestUtil;

public class RestUtil2 {
    public static void sendRequestToCollectionResource(HandlerContext handlerCtx) {
        String endpoint = RestUtil2.fixEndpoint((String)handlerCtx.getInputValue("endpoint"));
        Response resp = (Response)RestUtil.getJerseyClient().target(endpoint).request(new String[]{"application/json"}).cookie(new Cookie("gfresttoken", RestUtil.getRestToken())).get(Response.class);
        if (!RestUtil2.isSuccess(resp.getStatus())) {
            throw new RuntimeException((String)resp.readEntity(String.class));
        }
        List list = (List)resp.readEntity(List.class);
        handlerCtx.setOutputValue("result", (Object)list);
    }

    public static void sendGetRequestToItemResource(HandlerContext handlerCtx) {
        Map attrs = (Map)handlerCtx.getInputValue("attrs");
        String endpoint = RestUtil2.fixEndpoint((String)handlerCtx.getInputValue("endpoint"));
        Response resp = (Response)RestUtil.targetWithQueryParams(RestUtil.getJerseyClient().target(endpoint), (Map<String, Object>)RestUtil.buildMultivalueMap(attrs)).request(new String[]{"application/json"}).cookie(new Cookie("gfresttoken", RestUtil.getRestToken())).get(Response.class);
        Map map = (Map)resp.readEntity(Map.class);
        handlerCtx.setOutputValue("result", (Object)map);
    }

    public static void sendPostRequest(HandlerContext handlerCtx) {
        Map attrs = (Map)handlerCtx.getInputValue("attrs");
        String endpoint = RestUtil2.fixEndpoint((String)handlerCtx.getInputValue("endpoint"));
        Response resp = (Response)RestUtil.getJerseyClient().target(endpoint).request(new String[]{"application/json"}).cookie(new Cookie("gfresttoken", RestUtil.getRestToken())).post(Entity.entity((Object)attrs, (MediaType)MediaType.APPLICATION_JSON_TYPE), Response.class);
        if (!RestUtil2.isSuccess(resp.getStatus())) {
            GuiUtil.getLogger().log(Level.SEVERE, GuiUtil.getCommonMessage("LOG_UPDATE_ENTITY_FAILED", new Object[]{endpoint, attrs}));
            GuiUtil.handleError(handlerCtx, GuiUtil.getMessage("msg.error.checkLog"));
            return;
        }
        handlerCtx.setOutputValue("result", (Object)endpoint);
    }

    private static String fixEndpoint(String endpoint) {
        if (endpoint.startsWith("/")) {
            endpoint = FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("REST_URL") + endpoint;
        }
        return endpoint;
    }

    protected static boolean isSuccess(int status) {
        return status >= 200 && status <= 299;
    }
}

