/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.common.handlers;

import com.sun.enterprise.util.SystemPropertyConstants;
import com.sun.jsftemplating.el.PageSessionResolver;
import com.sun.jsftemplating.handlers.NavigationHandlers;
import com.sun.jsftemplating.layout.descriptors.handler.HandlerContext;
import com.sun.jsftemplating.util.Util;
import jakarta.faces.component.UIInput;
import jakarta.faces.component.UIViewRoot;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admingui.common.tree.FilterTreeEvent;
import org.glassfish.admingui.common.util.GuiUtil;
import org.glassfish.admingui.common.util.MiscUtil;
import org.glassfish.admingui.common.util.RestUtil;
import org.glassfish.admingui.common.util.TargetUtil;

public class CommonHandlers {
    private static final String AIX = "AIX";
    private static final int INDEX = 0;

    public static void initClusterSessionAttribute(HandlerContext handlerCtx) {
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        sessionMap.put("appSummaryView", true);
        sessionMap.put("webSummaryView", true);
        sessionMap.put("ejbSummaryView", true);
        sessionMap.put("appclientSummaryView", true);
        sessionMap.put("rarSummaryView", true);
        sessionMap.put("lifecycleSummaryView", true);
        sessionMap.put("adminObjectSummaryView", true);
        sessionMap.put("connectorResSummaryView", true);
        sessionMap.put("customResSummaryView", true);
        sessionMap.put("externalResSummaryView", true);
        sessionMap.put("javaMailSessionSummaryView", true);
        sessionMap.put("jdbcResSummaryView", true);
        sessionMap.put("jmsConnectionSummaryView", true);
        sessionMap.put("jmsDestinationSummaryView", true);
    }

    public static void initSessionAttributes(HandlerContext handlerCtx) {
        Object initialized = FacesContext.getCurrentInstance().getExternalContext().getSessionMap().get("_SESSION_INITIALIZED");
        if (initialized == null) {
            GuiUtil.initSessionAttributes();
        }
    }

    public static void getFieldLengths(HandlerContext handlerCtx) {
        ResourceBundle bundle = (ResourceBundle)handlerCtx.getInputValue("bundle");
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (String key : bundle.keySet()) {
            try {
                result.put(key, Integer.decode(bundle.getString(key)));
            }
            catch (NumberFormatException ex) {
                GuiUtil.getLogger().warning("Field length is expected to be a number, but got ('" + bundle.getString(key) + "') instead for key '" + key + "'.");
            }
        }
        handlerCtx.setOutputValue("result", result);
    }

    public static void initProductInfoAttributes(HandlerContext handlerCtx) {
        Map sessionMap = handlerCtx.getFacesContext().getExternalContext().getSessionMap();
        Object initialized = sessionMap.get("_INFO_SESSION_INITIALIZED");
        if (initialized != null) {
            return;
        }
        sessionMap.put("productImageURL", GuiUtil.getMessage("productImage.URL"));
        sessionMap.put("productImageWidth", Integer.parseInt(GuiUtil.getMessage("productImage.width")));
        sessionMap.put("productImageHeight", Integer.parseInt(GuiUtil.getMessage("productImage.height")));
        sessionMap.put("loginProductImageURL", GuiUtil.getMessage("login.productImage.URL"));
        sessionMap.put("loginProductImageWidth", Integer.parseInt(GuiUtil.getMessage("login.productImage.width")));
        sessionMap.put("loginProductImageHeight", Integer.parseInt(GuiUtil.getMessage("login.productImage.height")));
        sessionMap.put("fullProductName", GuiUtil.getMessage("versionImage.description"));
        sessionMap.put("loginButtonTooltip", GuiUtil.getMessage("loginButtonTooltip"));
        sessionMap.put("mastHeadDescription", GuiUtil.getMessage("mastHeadDescription"));
        sessionMap.put("_INFO_SESSION_INITIALIZED", "TRUE");
    }

    public static void getListElement(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        Integer selectedIndex = (Integer)handlerCtx.getInputValue("index");
        String[] listItem = null;
        if (list != null) {
            if (selectedIndex == null) {
                selectedIndex = 0;
            }
            listItem = new String[]{(String)list.get(selectedIndex)};
        }
        handlerCtx.setOutputValue("selectedIndex", listItem);
    }

    public static void removeListElement(HandlerContext handlerCtx) {
        List list = (List)handlerCtx.getInputValue("list");
        String name = (String)handlerCtx.getInputValue("name");
        Object listItem = null;
        if (list != null) {
            list.remove(name);
        }
        handlerCtx.setOutputValue("finalList", (Object)list);
    }

    public static void convertMillisToReadable(HandlerContext handlerCtx) {
        Long milliseconds = (Long)handlerCtx.getInputValue("milliseconds");
        long MSEC_PER_SECOND = 1000L;
        long MSEC_PER_MINUTE = 60000L;
        long MSEC_PER_HOUR = 3600000L;
        long MSEC_PER_DAY = 86400000L;
        long MSEC_PER_WEEK = 604800000L;
        String FORMAT2 = "%d %s %d %s";
        String FORMAT1 = "%d %s";
        String readableString = "";
        long msecLeftover = milliseconds;
        long numWeeks = msecLeftover / 604800000L;
        long numDays = (msecLeftover -= numWeeks * 604800000L) / 86400000L;
        long numHours = (msecLeftover -= numDays * 86400000L) / 3600000L;
        long numMinutes = (msecLeftover -= numHours * 3600000L) / 60000L;
        long numSeconds = (msecLeftover -= numMinutes * 60000L) / 1000L;
        long numMilliSeconds = msecLeftover -= numSeconds * 1000L;
        readableString = numWeeks > 0L ? String.format(FORMAT2, numWeeks, GuiUtil.getMessage("common.Weeks"), numDays, GuiUtil.getMessage("common.Days")) : (numDays > 0L ? String.format(FORMAT1, numDays, GuiUtil.getMessage("common.Days")) : (numHours > 0L ? String.format(FORMAT2, numHours, GuiUtil.getMessage("common.Hours"), numMinutes, GuiUtil.getMessage("common.Minutes")) : (numMinutes > 0L ? String.format(FORMAT2, numMinutes, GuiUtil.getMessage("common.Minutes"), numSeconds, GuiUtil.getMessage("common.Seconds")) : (numSeconds > 0L ? String.format(FORMAT1, numSeconds, GuiUtil.getMessage("common.Seconds")) : String.format(FORMAT1, numMilliSeconds, GuiUtil.getMessage("common.Milliseconds"))))));
        handlerCtx.setOutputValue("readableString", (Object)readableString);
    }

    public static void createAttributeMap(HandlerContext handlerCtx) {
        List keys = (List)handlerCtx.getInputValue("keys");
        List values = (List)handlerCtx.getInputValue("values");
        HashMap map = new HashMap();
        if (keys != null && values != null) {
            for (int i = 0; i < keys.size(); ++i) {
                map.put((String)keys.get(i), values.get(i));
            }
        }
        handlerCtx.setOutputValue("map", map);
    }

    public static void selectiveEncode(HandlerContext handlerCtx) {
        String value = (String)handlerCtx.getInputValue("value");
        String delim = (String)handlerCtx.getInputValue("delim");
        String encType = (String)handlerCtx.getInputValue("type");
        String encodedString = GuiUtil.encode(value, delim, encType);
        handlerCtx.setOutputValue("result", (Object)encodedString);
    }

    public static void logout(HandlerContext handlerCtx) {
        handlerCtx.getFacesContext().getExternalContext().invalidateSession();
    }

    public static void setComponentRequired(HandlerContext handlerCtx) {
        String id = (String)handlerCtx.getInputValue("id");
        String required = (String)handlerCtx.getInputValue("required");
        UIViewRoot viewRoot = handlerCtx.getFacesContext().getViewRoot();
        if (viewRoot == null) {
            return;
        }
        try {
            UIInput targetComponent = (UIInput)viewRoot.findComponent(id);
            if (targetComponent != null) {
                targetComponent.setRequired(Boolean.valueOf(required).booleanValue());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void testExists(HandlerContext handlerCtx) {
        String attr = (String)handlerCtx.getInputValue("attr");
        if (GuiUtil.isEmpty(attr)) {
            handlerCtx.setOutputValue("defined", (Object)false);
        } else {
            handlerCtx.setOutputValue("defined", (Object)true);
        }
    }

    public static void removeEmptyProps(HandlerContext handlerCtx) {
        List props = (List)handlerCtx.getInputValue("props");
        ArrayList<Map> modifiedProps = new ArrayList<Map>();
        if (props != null) {
            for (Map prop : props) {
                if (GuiUtil.isEmpty((String)prop.get("name")) || GuiUtil.isEmpty((String)prop.get("value"))) continue;
                if (((String)prop.get("value")).equals("()")) {
                    prop.put("value", "");
                }
                modifiedProps.add(prop);
            }
        }
        handlerCtx.setOutputValue("modifiedProps", modifiedProps);
    }

    public static void getRequestValue(HandlerContext handlerCtx) {
        Object value;
        String key = (String)handlerCtx.getInputValue("key");
        Object defaultValue = handlerCtx.getInputValue("default");
        Object orig = value = handlerCtx.getFacesContext().getExternalContext().getRequestParameterMap().get(key);
        if (value == null || "".equals(value)) {
            value = handlerCtx.getFacesContext().getExternalContext().getRequestMap().get(key);
            if (value == null && defaultValue != null) {
                value = defaultValue;
            }
        } else {
            value = Util.htmlEscape((String)((String)value));
        }
        handlerCtx.setOutputValue("value", value);
        handlerCtx.setOutputValue("orig", orig);
    }

    public void longAdd(HandlerContext handlerCtx) {
        Long result;
        block2: {
            Long long1 = (Long)handlerCtx.getInputValue("Long1");
            Long long2 = (Long)handlerCtx.getInputValue("Long2");
            result = 0L;
            try {
                result = long1 + long2;
            }
            catch (Exception ex) {
                Logger logger = GuiUtil.getLogger();
                if (!logger.isLoggable(Level.WARNING)) break block2;
                logger.log(Level.WARNING, GuiUtil.getCommonMessage("LOG_LONGADD_ERROR", new Object[]{"" + long1, "" + long2}));
            }
        }
        handlerCtx.setOutputValue("LongResult", (Object)result);
    }

    public void getCurrentTime(HandlerContext handlerCtx) {
        Date d = new Date(System.currentTimeMillis());
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 2, handlerCtx.getFacesContext().getViewRoot().getLocale());
        String currentTime = dateFormat.format(d);
        handlerCtx.setOutputValue("CurrentTime", (Object)currentTime);
    }

    public void handleError(HandlerContext handlerCtx) {
        String detail = (String)handlerCtx.getInputValue("detail");
        GuiUtil.prepareAlert("error", GuiUtil.getMessage("msg.Error"), detail);
        handlerCtx.getFacesContext().renderResponse();
    }

    public static void onlyDas(HandlerContext handlerCtx) {
        boolean onlyDAS = TargetUtil.getClusters().isEmpty() && TargetUtil.getStandaloneInstances().isEmpty();
        handlerCtx.setOutputValue("onlyDAS", (Object)onlyDAS);
    }

    public static void setValueExpression(HandlerContext handlerCtx) {
        MiscUtil.setValueExpression((String)handlerCtx.getHandler().getInputValue("expression"), handlerCtx.getInputValue("value"));
    }

    public static void convertDateTimeFormat(HandlerContext handlerCtx) {
        String dateTime = (String)handlerCtx.getInputValue("dateTime");
        String result = "";
        if (!GuiUtil.isEmpty(dateTime)) {
            try {
                long longValue = Long.parseLong(dateTime);
                String format = (String)handlerCtx.getHandler().getInputValue("format");
                if (format == null) {
                    format = "yyyy-MM-dd HH:mm:ss z";
                }
                result = new SimpleDateFormat(format).format(new Date(longValue));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        handlerCtx.setOutputValue("result", (Object)result);
    }

    public static void setPartialRequest(HandlerContext context) {
        boolean isPartial = (Boolean)context.getInputValue("value");
        context.getFacesContext().getPartialViewContext().setPartialRequest(isPartial);
    }

    public static void navigate(HandlerContext context) {
        context.getFacesContext().getPartialViewContext().setPartialRequest(false);
        NavigationHandlers.navigate((HandlerContext)context);
    }

    public static void redirect(HandlerContext context) {
        String page = (String)context.getInputValue("page");
        FacesContext ctx = context.getFacesContext();
        page = CommonHandlers.handleBareAttribute(ctx, page);
        try {
            ((HttpServletResponse)ctx.getExternalContext().getResponse()).sendRedirect(page);
        }
        catch (IOException ex) {
            throw new RuntimeException("Unable to redirect to page '" + page + "'!", ex);
        }
        ctx.responseComplete();
    }

    public static void filterTable(HandlerContext handlerCtx) {
        List table = (List)handlerCtx.getInputValue("table");
        String key = (String)handlerCtx.getInputValue("key");
        String value = (String)handlerCtx.getInputValue("value");
        Boolean keep = (Boolean)handlerCtx.getInputValue("keep");
        if (key == null || "".equals(key)) {
            GuiUtil.getLogger().info("'attr' must be non-null, and non-blank");
        }
        if (value == null || "".equals(value)) {
            GuiUtil.getLogger().info("'value' must be non-null, and non-blank");
        }
        if (keep == null) {
            keep = Boolean.TRUE;
        }
        ArrayList<Map> results = new ArrayList<Map>();
        if (!keep.booleanValue()) {
            results.addAll(table);
        }
        for (Map child : table) {
            if (!value.equals(child.get(key))) continue;
            if (keep.booleanValue()) {
                results.add(child);
                continue;
            }
            results.remove(child);
        }
        handlerCtx.setOutputValue("table", results);
    }

    public static void filterMap(HandlerContext handlerCtx) {
        Map map = (Map)handlerCtx.getInputValue("map");
        List attrNames = (List)handlerCtx.getInputValue("attrNames");
        Boolean keep = (Boolean)handlerCtx.getInputValue("keep");
        Map<String, String> resultMap = new HashMap();
        if (map != null) {
            if (keep == null) {
                keep = Boolean.TRUE;
            }
            if (attrNames == null) {
                resultMap = map;
            } else {
                for (Map.Entry e : map.entrySet()) {
                    String key = (String)e.getKey();
                    if (attrNames.contains(key) && keep.booleanValue()) {
                        resultMap.put(key, (String)e.getValue());
                        continue;
                    }
                    if (attrNames.contains(key) || keep.booleanValue()) continue;
                    resultMap.put(key, (String)e.getValue());
                }
            }
        }
        handlerCtx.setOutputValue("resultMap", resultMap);
    }

    public static void isAIX(HandlerContext handlerCtx) {
        Boolean isAIX = AIX.equalsIgnoreCase(System.getProperty("os.name"));
        handlerCtx.setOutputValue("result", (Object)isAIX);
    }

    public static List filterProtocols(HandlerContext context) {
        FilterTreeEvent event = (FilterTreeEvent)((Object)FilterTreeEvent.class.cast(context.getEventObject()));
        List protocols = event.getChildObjects();
        ArrayList<String> result = new ArrayList<String>();
        if (protocols != null && protocols.size() > 0) {
            for (Object protocol2 : protocols) {
                String protocol = (String)protocol2;
                if (protocol.equals("pu-protocol") || protocol.equals("admin-http-redirect")) continue;
                result.add(protocol);
            }
        }
        return result;
    }

    public static List filterAdminObjects(HandlerContext context) {
        ArrayList<String> result = new ArrayList<String>();
        FilterTreeEvent event = null;
        try {
            Map childRes;
            if (!(context.getEventObject() instanceof FilterTreeEvent)) {
                return result;
            }
            event = (FilterTreeEvent)((Object)FilterTreeEvent.class.cast(context.getEventObject()));
            List jmsResources = event.getChildObjects();
            if (jmsResources == null || jmsResources.size() <= 0) {
                return result;
            }
            ArrayList<Object> adminObjs = new ArrayList();
            Map<String, Object> responseMap = RestUtil.restRequest(GuiUtil.getSessionValue("REST_URL") + "/resources/admin-object-resource", null, "GET", null, false);
            Map extraPropsMap = (Map)((Map)responseMap.get("data")).get("extraProperties");
            if (extraPropsMap != null && (childRes = (Map)extraPropsMap.get("childResources")) != null) {
                adminObjs = new ArrayList(childRes.keySet());
            }
            for (String oneJms : jmsResources) {
                if (adminObjs.contains(oneJms)) continue;
                result.add(oneJms);
            }
        }
        catch (Exception ex) {
            GuiUtil.getLogger().warning("Exception in filterAdminObjects()");
        }
        return result;
    }

    public static void getDefaultAdminTimeout(HandlerContext handlerCtx) {
        String result = SystemPropertyConstants.getDefaultAdminTimeout().toString();
        handlerCtx.setOutputValue("result", (Object)result);
    }

    private static String handleBareAttribute(FacesContext ctx, String url) {
        String request;
        UIViewRoot root = ctx.getViewRoot();
        Map pageSession = PageSessionResolver.getPageSession((FacesContext)ctx, (UIViewRoot)root);
        if (pageSession == null) {
            pageSession = PageSessionResolver.createPageSession((FacesContext)ctx, (UIViewRoot)root);
        }
        if ((request = (String)ctx.getExternalContext().getRequestParameterMap().get("bare")) != null) {
            if (request.equalsIgnoreCase("true")) {
                url = CommonHandlers.addQueryStringParam(url, "bare", "true");
                request = "true";
            } else {
                request = "false";
            }
            pageSession.put("bare", request);
        } else {
            Object pageSessionValue = pageSession.get("bare");
            if (Boolean.TRUE.equals(pageSessionValue)) {
                url = CommonHandlers.addQueryStringParam(url, "bare", "true");
            } else {
                pageSession.put("bare", "false");
            }
        }
        return url;
    }

    private static String addQueryStringParam(String url, String name, String value) {
        String sep = "?";
        if (((String)url).indexOf("?") > -1) {
            sep = "&";
        }
        String insert = sep + name + "=" + value;
        int hash = ((String)url).indexOf("#");
        url = hash > -1 ? ((String)url).substring(0, hash - 1) + insert + ((String)url).substring(hash) : (String)url + insert;
        return url;
    }
}

