/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admingui.plugin;

import jakarta.inject.Inject;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.admingui.connector.ConsoleConfig;
import org.glassfish.admingui.connector.Index;
import org.glassfish.admingui.connector.IndexItem;
import org.glassfish.admingui.connector.IntegrationPoint;
import org.glassfish.admingui.connector.TOC;
import org.glassfish.admingui.connector.TOCItem;
import org.glassfish.api.admingui.ConsoleProvider;
import org.glassfish.hk2.api.IterableProvider;
import org.glassfish.hk2.api.ServiceLocator;
import org.jvnet.hk2.annotations.Service;
import org.jvnet.hk2.component.MultiMap;
import org.jvnet.hk2.config.ConfigParser;
import org.jvnet.hk2.config.DomDocument;

@Service
public class ConsolePluginService {
    @Inject
    Logger logger;
    @Inject
    ServiceLocator habitat;
    @Inject
    IterableProvider<ConsoleProvider> providers;
    private boolean initialized = false;
    private MultiMap<String, IntegrationPoint> pointsByType = new MultiMap();
    private Map<String, ClassLoader> moduleClassLoaderMap = new HashMap<String, ClassLoader>();
    private Map<ClassLoader, String> classLoaderModuleMap = new HashMap<ClassLoader, String>();

    protected synchronized void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.providers != null && this.providers.iterator().hasNext()) {
            ConfigParser parser = new ConfigParser(this.habitat);
            URL url = null;
            String id = null;
            for (ConsoleProvider provider : this.providers) {
                url = provider.getConfiguration();
                if (url == null) {
                    url = provider.getClass().getClassLoader().getResource("META-INF/admingui/console-config.xml");
                }
                if (url == null) {
                    if (!this.logger.isLoggable(Level.INFO)) continue;
                    this.logger.info("Unable to find META-INF/admingui/console-config.xml file for provider '" + provider.getClass().getName() + "'");
                    continue;
                }
                DomDocument doc = parser.parse(url);
                ConsoleConfig config = (ConsoleConfig)doc.getRoot().get();
                id = config.getId();
                this.moduleClassLoaderMap.put(id, provider.getClass().getClassLoader());
                this.classLoaderModuleMap.put(provider.getClass().getClassLoader(), id);
                this.addIntegrationPoints(config.getIntegrationPoints(), id);
            }
        }
        if (this.logger.isLoggable(Level.FINE)) {
            this.logger.fine("Console Plugin Service has been Initialized!");
            if (this.logger.isLoggable(Level.FINEST)) {
                this.logger.finest(this.pointsByType.toString());
            }
        }
    }

    public synchronized TOC getHelpTOC(String locale) {
        if (locale == null) {
            locale = "en";
        }
        Map<String, List<URL>> mapUrls = this.getResources(locale + "/help/toc.xml");
        ConfigParser parser = new ConfigParser(this.habitat);
        TOC mergedTOC = new TOC();
        mergedTOC.setTOCItems(new ArrayList());
        mergedTOC.setVersion("2.0");
        String id = null;
        String prefix = "/" + locale + "/help/";
        List<URL> urls = null;
        for (Map.Entry<String, List<URL>> entry : mapUrls.entrySet()) {
            id = entry.getKey();
            urls = entry.getValue();
            for (URL url : urls) {
                DomDocument doc = parser.parse(url);
                TOC toc = (TOC)doc.getRoot().get();
                for (TOCItem item : toc.getTOCItems()) {
                    this.insertTOCItem(mergedTOC.getTOCItems(), item, id + prefix);
                }
            }
        }
        return mergedTOC;
    }

    private void insertTOCItem(List<TOCItem> dest, TOCItem item, String prefix) {
        int idx = dest.indexOf(item);
        if (idx == -1) {
            this.fixTargetPath(item, prefix);
            dest.add(item);
        } else {
            TOCItem parent = dest.get(idx);
            for (TOCItem child : item.getTOCItems()) {
                this.insertTOCItem(parent.getTOCItems(), child, prefix);
            }
        }
    }

    public synchronized Index getHelpIndex(String locale) {
        if (locale == null) {
            locale = "en";
        }
        Map<String, List<URL>> mapUrls = this.getResources(locale + "/help/index.xml");
        ConfigParser parser = new ConfigParser(this.habitat);
        Index mergedIndex = new Index();
        mergedIndex.setIndexItems(new ArrayList());
        mergedIndex.setVersion("2.0");
        String id = null;
        String prefix = "/" + locale + "/help/";
        List<URL> urls = null;
        for (Map.Entry<String, List<URL>> entry : mapUrls.entrySet()) {
            id = entry.getKey();
            urls = entry.getValue();
            for (URL url : urls) {
                DomDocument doc = parser.parse(url);
                Index index = (Index)doc.getRoot().get();
                for (IndexItem item : index.getIndexItems()) {
                    this.insertIndexItem(mergedIndex.getIndexItems(), item, id + prefix);
                }
            }
        }
        return mergedIndex;
    }

    private void insertIndexItem(List<IndexItem> dest, IndexItem item, String prefix) {
        int idx = dest.indexOf(item);
        if (idx == -1) {
            this.fixHtmlFileForIndexItem(item, prefix);
            dest.add(item);
        } else {
            IndexItem parent = dest.get(idx);
            for (IndexItem child : item.getIndexItems()) {
                this.insertIndexItem(parent.getIndexItems(), child, prefix);
            }
        }
    }

    private void fixTargetPath(TOCItem parent, String prefix) {
        parent.setTargetPath(prefix + parent.getTarget() + ".html");
        for (TOCItem item : parent.getTOCItems()) {
            this.fixTargetPath(item, prefix);
        }
    }

    private void fixHtmlFileForIndexItem(IndexItem parent, String prefix) {
        String target = null;
        target = parent.getTarget();
        if (null != target) {
            parent.setHtmlFileForTarget(prefix + target + ".html");
        }
        for (IndexItem item : parent.getIndexItems()) {
            this.fixHtmlFileForIndexItem(item, prefix);
        }
    }

    public Map<String, List<URL>> getResources(String name) {
        HashMap<String, List<URL>> result = new HashMap<String, List<URL>>();
        if (this.providers != null && this.providers.iterator().hasNext()) {
            Enumeration<URL> urls = null;
            URL url = null;
            for (ConsoleProvider provider : this.providers) {
                ClassLoader loader = provider.getClass().getClassLoader();
                try {
                    urls = loader.getResources(name);
                }
                catch (IOException ex) {
                    if (!this.logger.isLoggable(Level.INFO)) continue;
                    this.logger.log(Level.INFO, "Error getting resource '" + name + "' from provider: '" + provider.getClass().getName() + "'. Skipping...", ex);
                    continue;
                }
                ArrayList<URL> providerURLs = new ArrayList<URL>();
                while (urls.hasMoreElements()) {
                    url = urls.nextElement();
                    try {
                        providerURLs.add(new URL(url, ""));
                    }
                    catch (Exception ex) {
                        System.out.println("ConsolePluginService: URL Copy Failed!");
                    }
                }
                if (providerURLs.size() <= 0) continue;
                result.put(this.classLoaderModuleMap.get(loader), providerURLs);
            }
        }
        return result;
    }

    public void addIntegrationPoints(List<IntegrationPoint> points, String id) {
        for (IntegrationPoint point : points) {
            this.addIntegrationPoint(point, id);
        }
    }

    public void addIntegrationPoint(IntegrationPoint point, String id) {
        point.setConsoleConfigId(id);
        this.pointsByType.add((Object)point.getType(), (Object)point);
    }

    public List<IntegrationPoint> getIntegrationPoints(String type) {
        this.init();
        return this.pointsByType.get((Object)type);
    }

    public ClassLoader getModuleClassLoader(String moduleName) {
        return this.moduleClassLoaderMap.get(moduleName);
    }
}

