/*
 * Decompiled with CFR 0.152.
 */
package com.sun.data.provider.impl;

import com.sun.data.provider.DataListener;
import com.sun.data.provider.DataProviderException;
import com.sun.data.provider.FieldKey;
import com.sun.data.provider.RefreshableDataListener;
import com.sun.data.provider.RefreshableDataProvider;
import com.sun.data.provider.RowKey;
import com.sun.data.provider.TableCursorListener;
import com.sun.data.provider.TableCursorVetoException;
import com.sun.data.provider.TableDataListener;
import com.sun.data.provider.TableDataProvider;
import com.sun.data.provider.impl.AbstractDataProvider;
import com.sun.data.provider.impl.ObjectListDataProvider;
import java.beans.Beans;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;

public class MethodResultTableDataProvider
implements TableDataProvider,
RefreshableDataProvider,
Serializable {
    private Object dataClassInstance;
    private transient Method dataMethod;
    private Class collectionElementType;
    private Object[] dataMethodArgs;
    private Object resultObject;
    private ObjectListDataProvider resultProvider = new ObjectListDataProvider();

    public MethodResultTableDataProvider() {
    }

    public MethodResultTableDataProvider(Object dataClassInstance, Method dataMethod) {
        this();
        this.setDataClassInstance(dataClassInstance);
        this.setDataMethod(dataMethod);
    }

    public Object getDataClassInstance() {
        return this.dataClassInstance;
    }

    public void setDataClassInstance(Object instance) {
        this.dataClassInstance = instance;
        this.resultProvider.clearObjectList();
    }

    public Method getDataMethod() {
        return this.dataMethod;
    }

    public void setDataMethod(Method method) {
        this.dataMethod = method;
        this.resultProvider.clearObjectList();
        this.refreshFieldKeys();
    }

    public void setCollectionElementType(Class elementType) {
        this.collectionElementType = elementType;
        this.refreshFieldKeys();
    }

    public Class getCollectionElementType() {
        return this.collectionElementType;
    }

    public Object getResultObject() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultObject;
    }

    public Object[] getResultObjects() throws DataProviderException {
        this.testInvokeDataMethod();
        if (this.resultObject instanceof Object[]) {
            return (Object[])this.resultObject;
        }
        if (this.resultObject instanceof Collection) {
            return ((Collection)this.resultObject).toArray();
        }
        if (this.resultObject != null) {
            return new Object[]{this.resultObject};
        }
        return null;
    }

    public void setIncludeFields(boolean includeFields) {
        this.resultProvider.setIncludeFields(includeFields);
    }

    public boolean isIncludeFields() {
        return this.resultProvider.isIncludeFields();
    }

    protected void refreshFieldKeys() {
        this.resultProvider.clearFieldKeys();
        if (this.dataMethod != null) {
            Class returnType = this.dataMethod.getReturnType();
            if (returnType.isArray()) {
                returnType = returnType.getComponentType();
            } else if (Collection.class.isAssignableFrom(returnType)) {
                returnType = this.collectionElementType;
            }
            this.resultProvider.setObjectType(returnType);
        }
    }

    public void setDataMethodArguments(Object[] methodArgs) {
        this.dataMethodArgs = methodArgs;
        this.resultObject = null;
        this.resultProvider.clearObjectList();
    }

    public Object[] getDataMethodArguments() {
        return this.dataMethodArgs;
    }

    public void invokeDataMethod() throws DataProviderException {
        this.invokeDataMethod(this.getDataMethodArguments());
    }

    public void invokeDataMethod(Object[] args) throws DataProviderException {
        this.dataMethodArgs = args;
        this.resultObject = null;
        this.resultProvider.clearObjectList();
        if (this.dataMethod == null || this.dataClassInstance == null) {
            return;
        }
        try {
            this.resultObject = Beans.isDesignTime() ? AbstractDataProvider.getFakeData(this.dataMethod.getReturnType(), this.collectionElementType) : this.dataMethod.invoke(this.dataClassInstance, args);
            if (this.resultObject instanceof Object[]) {
                Object[] oa = (Object[])this.resultObject;
                for (int i = 0; i < oa.length; ++i) {
                    this.resultProvider.addObject(oa[i]);
                }
            } else if (this.resultObject instanceof Collection) {
                Object[] oa = ((Collection)this.resultObject).toArray();
                for (int i = 0; i < oa.length; ++i) {
                    this.resultProvider.addObject(oa[i]);
                }
            } else if (this.resultObject != null) {
                this.resultProvider.addObject(this.resultObject);
            }
            this.resultProvider.commitChanges();
            this.fireRefreshed();
        }
        catch (Exception e) {
            throw new DataProviderException(e);
        }
    }

    protected void testInvokeDataMethod() throws DataProviderException {
        if (this.resultObject == null || this.resultProvider.getRowCount() == 0) {
            this.invokeDataMethod();
        }
    }

    public void refresh() throws DataProviderException {
        this.invokeDataMethod();
    }

    public void addRefreshableDataListener(RefreshableDataListener l) {
        this.resultProvider.addDataListener(l);
    }

    public void removeRefreshableDataListener(RefreshableDataListener l) {
        this.resultProvider.removeDataListener(l);
    }

    public RefreshableDataListener[] getRefreshableDataListeners() {
        DataListener[] dpListeners = this.resultProvider.getDataListeners();
        if (dpListeners == null) {
            return new RefreshableDataListener[0];
        }
        ArrayList<DataListener> rdlList = new ArrayList<DataListener>();
        for (int i = 0; i < dpListeners.length; ++i) {
            if (!(dpListeners[i] instanceof RefreshableDataListener)) continue;
            rdlList.add(dpListeners[i]);
        }
        return rdlList.toArray(new RefreshableDataListener[rdlList.size()]);
    }

    protected void fireRefreshed() {
        RefreshableDataListener[] rdls = this.getRefreshableDataListeners();
        for (int i = 0; i < rdls.length; ++i) {
            rdls[i].refreshed(this);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        if (this.dataMethod != null) {
            HashMap<String, Object> sig = new HashMap<String, Object>();
            sig.put("class", this.dataMethod.getDeclaringClass());
            sig.put("name", this.dataMethod.getName());
            sig.put("params", this.dataMethod.getParameterTypes());
            out.writeObject(sig);
        }
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        Object o = in.readObject();
        if (o instanceof HashMap) {
            HashMap sig = (HashMap)o;
            Class clazz = (Class)sig.get("class");
            String name = (String)sig.get("name");
            Class[] params = (Class[])sig.get("params");
            try {
                this.dataMethod = clazz.getMethod(name, params);
            }
            catch (NoSuchMethodException nsmx) {
                // empty catch block
            }
        }
    }

    public FieldKey[] getFieldKeys() throws DataProviderException {
        return this.resultProvider.getFieldKeys();
    }

    public FieldKey getFieldKey(String fieldId) throws DataProviderException {
        return this.resultProvider.getFieldKey(fieldId);
    }

    public Class getType(FieldKey fieldKey) throws DataProviderException {
        return this.resultProvider.getType(fieldKey);
    }

    public Object getValue(FieldKey fieldKey) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.getValue(fieldKey);
    }

    public boolean isReadOnly(FieldKey fieldKey) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.isReadOnly(fieldKey);
    }

    public void setValue(FieldKey fieldKey, Object value) throws DataProviderException {
        this.testInvokeDataMethod();
        this.resultProvider.setValue(fieldKey, value);
    }

    public void addDataListener(DataListener listener) {
        this.resultProvider.addDataListener(listener);
    }

    public void removeDataListener(DataListener listener) {
        this.resultProvider.removeDataListener(listener);
    }

    public DataListener[] getDataListeners() {
        return this.resultProvider.getDataListeners();
    }

    public int getRowCount() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.getRowCount();
    }

    public boolean isRowAvailable(RowKey row) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.isRowAvailable(row);
    }

    public RowKey[] getRowKeys(int count, RowKey afterRow) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.getRowKeys(count, afterRow);
    }

    public RowKey getRowKey(String rowId) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.getRowKey(rowId);
    }

    public Object getValue(FieldKey fieldKey, RowKey row) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.getValue(fieldKey, row);
    }

    public void setValue(FieldKey fieldKey, RowKey row, Object value) throws DataProviderException {
        this.testInvokeDataMethod();
        this.resultProvider.setValue(fieldKey, row, value);
    }

    public boolean canInsertRow(RowKey beforeRow) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.canInsertRow(beforeRow);
    }

    public RowKey insertRow(RowKey beforeRow) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.insertRow(beforeRow);
    }

    public boolean canAppendRow() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.canAppendRow();
    }

    public RowKey appendRow() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.appendRow();
    }

    public boolean canRemoveRow(RowKey row) throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.canRemoveRow(row);
    }

    public void removeRow(RowKey row) throws DataProviderException {
        this.testInvokeDataMethod();
        this.resultProvider.removeRow(row);
    }

    public void addTableDataListener(TableDataListener l) {
        this.resultProvider.addTableDataListener(l);
    }

    public void removeTableDataListener(TableDataListener l) {
        this.resultProvider.removeTableDataListener(l);
    }

    public TableDataListener[] getTableDataListeners() {
        return this.resultProvider.getTableDataListeners();
    }

    public RowKey getCursorRow() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.getCursorRow();
    }

    public void setCursorRow(RowKey row) throws TableCursorVetoException {
        this.testInvokeDataMethod();
        this.resultProvider.setCursorRow(row);
    }

    public boolean cursorFirst() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.cursorFirst();
    }

    public boolean cursorPrevious() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.cursorPrevious();
    }

    public boolean cursorNext() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.cursorNext();
    }

    public boolean cursorLast() throws DataProviderException {
        this.testInvokeDataMethod();
        return this.resultProvider.cursorLast();
    }

    public void addTableCursorListener(TableCursorListener l) {
        this.resultProvider.addTableCursorListener(l);
    }

    public void removeTableCursorListener(TableCursorListener l) {
        this.resultProvider.removeTableCursorListener(l);
    }

    public TableCursorListener[] getTableCursorListeners() {
        return this.resultProvider.getTableCursorListeners();
    }
}

