/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.RadioButton;
import com.sun.webui.jsf.component.RadioButtonGroup;
import com.sun.webui.jsf.model.Option;
import com.sun.webui.jsf.renderkit.html.SelectorGroupRenderer;
import com.sun.webui.jsf.util.ConversionUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;

public class RadioButtonGroupRenderer
extends SelectorGroupRenderer {
    private final String MSG_COMPONENT_NOT_RADIOBUTTONGROUP = "RadioButtonGroupRender only renders RadioButtonGroup components.";
    protected String[] styles = new String[]{"RADIOBUTTON_GROUP", "RADIOBUTTON_GROUP_CAPTION", "RADIOBUTTON_GROUP_LABEL", "RADIOBUTTON_GROUP_LABEL_DISABLED", "RADIOBUTTON_GROUP_ROW_EVEN", "RADIOBUTTON_GROUP_ROW_ODD", "RADIOBUTTON_GROUP_CELL_EVEN", "RADIOBUTTON_GROUP_CELL_ODD", "RADIOBUTTON", "RADIOBUTTON_DISABLED", "RADIOBUTTON_LABEL", "RADIOBUTTON_LABEL_DISABLED", "RADIOBUTTON_IMAGE", "RADIOBUTTON_IMAGE_DISABLED", "LABEL_LEVEL_ONE_TEXT", "LABEL_LEVEL_TWO_TEXT", "LABEL_LEVEL_THREE_TEXT"};

    public void renderStart(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        if (!(component instanceof RadioButtonGroup)) {
            throw new IllegalArgumentException("RadioButtonGroupRender only renders RadioButtonGroup components.");
        }
    }

    public void renderEnd(FacesContext context, UIComponent component, ResponseWriter writer) throws IOException {
        RadioButtonGroup rbgrp = (RadioButtonGroup)component;
        Theme theme = ThemeUtilities.getTheme(context);
        this.renderSelectorGroup(context, component, theme, writer, rbgrp.getColumns());
    }

    protected UIComponent getSelectorComponent(FacesContext context, UIComponent component, Theme theme, String id, Option option) {
        RadioButtonGroup rbgrp = (RadioButtonGroup)component;
        RadioButton rb = new RadioButton();
        rb.setId(id);
        rb.setParent(component);
        rb.setName(rbgrp.getClientId(context));
        rb.setToolTip(option.getTooltip());
        rb.setImageURL(option.getImage());
        rb.setSelectedValue(option.getValue());
        rb.setLabel(option.getLabel());
        rb.setDisabled(rbgrp.isDisabled());
        rb.setReadOnly(rbgrp.isReadOnly());
        rb.setTabIndex(rbgrp.getTabIndex());
        this.transferEventAttributes(rbgrp, rb);
        rb.setSelected(null);
        String[] subValue = (String[])rbgrp.getSubmittedValue();
        if (subValue == null) {
            if (this.isSelected(option, rbgrp.getSelected())) {
                rb.setSelected(rb.getSelectedValue());
            }
        } else if (subValue.length != 0) {
            Object selectedValue = rb.getSelectedValue();
            String selectedValueAsString = ConversionUtilities.convertValueToString(component, selectedValue);
            if (subValue[0] != null && subValue[0].equals(selectedValueAsString)) {
                rb.setSelected(rb.getSelectedValue());
            }
        }
        return rb;
    }

    private boolean isSelected(Option item, Object currentValue) {
        return currentValue != null && item.getValue() != null && item.getValue().equals(currentValue);
    }

    protected String[] getStyles() {
        return this.styles;
    }
}

