/*
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS HEADER.
 *
 * Copyright (c) 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * The contents of this file are subject to the terms of either the GNU
 * General Public License Version 2 only ("GPL") or the Common Development
 * and Distribution License("CDDL") (collectively, the "License").  You
 * may not use this file except in compliance with the License.  You can
 * obtain a copy of the License at
 * https://oss.oracle.com/licenses/CDDL+GPL-1.1
 * or LICENSE.txt.  See the License for the specific
 * language governing permissions and limitations under the License.
 *
 * When distributing the software, include this License Header Notice in each
 * file and include the License file at LICENSE.txt.
 *
 * GPL Classpath Exception:
 * Oracle designates this particular file as subject to the "Classpath"
 * exception as provided by Oracle in the GPL Version 2 section of the License
 * file that accompanied this code.
 *
 * Modifications:
 * If applicable, add the following below the License Header, with the fields
 * enclosed by brackets [] replaced by your own identifying information:
 * "Portions Copyright [year] [name of copyright owner]"
 *
 * Contributor(s):
 * If you wish your version of this file to be governed by only the CDDL or
 * only the GPL Version 2, indicate your decision by adding "[Contributor]
 * elects to include this software in this distribution under the [CDDL or GPL
 * Version 2] license."  If you don't indicate a single choice of license, a
 * recipient has the option to distribute your version of this file under
 * either the CDDL, the GPL Version 2 or to extend the choice of license to
 * its licensees as provided above.  However, if you add GPL Version 2 code
 * and therefore, elected the GPL Version 2 license, then the option applies
 * only if the new code is made subject to such option by the copyright
 * holder.
 */

//
// This Javascript file should be included in any page that uses the associated
// component, where JSF Extensions is used as the underlying transfer protocol.
//

dojo.provide("webui.suntheme.widget.jsfx.progressBar");

dojo.require("webui.suntheme.widget.progressBar");

/**
 * This name space is used to update data asynchronously.
 */
webui.suntheme.widget.jsfx.progressBar =  {
    /**
     * This function is used to process refresh events.
     *
     * @param evt Event generated by scroll bar.
     */
    processRefreshEvent: function(id) {
        var dom = document.getElementById(id); 

        // Generate AJAX request using the JSF Extensions library.
        new DynaFaces.fireAjaxTransaction(dom, {
            execute: (dom) ? id : "none",
            render: id,
            replaceElement: webui.suntheme.widget.jsfx.progressBar.update });

        return true;
    },

    /**
     * This function is used to update progress.
     *
     * @param elementId The HTML element Id.
     * @param content The content returned by the AJAX response.
     * @param closure The closure argument provided to DynaFaces.fireAjaxTransaction.
     * @param xjson The zjson argument provided to DynaFaces.fireAjaxTransaction.
     */
    update: function(elementId, content, closure, xjson) {
        if (elementId == null || content == null) {
            return false;
        }

        // Parse JSON text.
        var json = JSON.parse(content);

        // Set progress.
        var domNode = document.getElementById(elementId);
        domNode._setProgress({
            failedStateText : json.failedStateText,
            logMessage : json.logMessage,
            progress : json.progress,
            status: json.status,
            taskState : json.taskState,
            topText : json.topText
        });

        // Publish an event for custom AJAX implementations to listen for.
        webui.suntheme.widget.progressBar.refresh.publishEndEvent(json);
        return true;
    }
}

// Listen for Dojo Widget events.
dojo.event.topic.subscribe(webui.suntheme.widget.progressBar.refresh.beginEventTopic,
    webui.suntheme.widget.jsfx.progressBar, "processRefreshEvent");

//-->
