/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.renderkit.html;

import com.sun.webui.jsf.component.DropDown;
import com.sun.webui.jsf.component.Icon;
import com.sun.webui.jsf.component.Scheduler;
import com.sun.webui.jsf.component.Time;
import com.sun.webui.jsf.util.JavaScriptUtilities;
import com.sun.webui.jsf.util.JsonUtilities;
import com.sun.webui.jsf.util.LogUtil;
import com.sun.webui.jsf.util.MessageUtil;
import com.sun.webui.jsf.util.RenderingUtilities;
import com.sun.webui.jsf.util.ThemeUtilities;
import com.sun.webui.theme.Theme;
import jakarta.faces.FacesException;
import jakarta.faces.component.UIComponent;
import jakarta.faces.context.FacesContext;
import jakarta.faces.context.ResponseWriter;
import jakarta.faces.render.Renderer;
import jakarta.json.JsonObject;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.MissingResourceException;

public final class SchedulerRenderer
extends Renderer {
    private static final String SPACE = "&nbsp;";
    private static final boolean DEBUG = false;

    public void encodeBegin(FacesContext context, UIComponent component) {
    }

    public boolean getRendersChildren() {
        return true;
    }

    public void encodeChildren(FacesContext context, UIComponent component) throws IOException {
    }

    public void encodeEnd(FacesContext context, UIComponent component) throws IOException {
        if (component == null) {
            return;
        }
        if (!(component instanceof Scheduler)) {
            Object[] params = new Object[]{component.toString(), ((Object)((Object)this)).getClass().getName(), Scheduler.class.getName()};
            String message = MessageUtil.getMessage("com.sun.webui.jsf.resources.LogMessages", "Renderer.component", params);
            throw new FacesException(message);
        }
        Scheduler scheduler = (Scheduler)component;
        Theme theme = ThemeUtilities.getTheme(context);
        ResponseWriter writer = context.getResponseWriter();
        String spacerPath = theme.getImagePath("DOT");
        this.renderEnclosingDiv(scheduler, theme, context, writer);
        writer.writeText((Object)"\n", null);
        this.renderOpenTable((UIComponent)scheduler, writer, null);
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        this.renderDatePicker(scheduler, theme, spacerPath, writer, context);
        this.renderInputControls(context, scheduler, writer, theme, spacerPath);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
        writer.endElement("div");
        this.renderJavaScript(context, scheduler, writer, theme);
    }

    private void renderEnclosingDiv(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        writer.startElement("div", (UIComponent)scheduler);
        writer.writeAttribute("id", (Object)scheduler.getClientId(context), null);
        String style = scheduler.getStyle();
        if (style != null) {
            writer.writeAttribute("style", (Object)style, "style");
        }
        style = scheduler.getStyleClass();
        if (scheduler.isVisible()) {
            if (style != null) {
                writer.writeAttribute("class", (Object)style, "styleClass");
            }
        } else {
            style = style + " " + theme.getStyleClass("HIDDEN");
            writer.writeAttribute("class", (Object)style, "styleClass");
        }
    }

    private void renderOpenTable(UIComponent comp, ResponseWriter writer, String styleClass) throws IOException {
        writer.startElement("table", comp);
        if (styleClass != null) {
            writer.writeAttribute("class", (Object)styleClass, null);
        }
        writer.writeAttribute("border", (Object)"0", null);
        writer.writeAttribute("cellpadding", (Object)"0", null);
        writer.writeAttribute("cellspacing", (Object)"0", null);
        writer.writeAttribute("title", (Object)"", null);
    }

    private void renderLegendRow(Scheduler scheduler, Theme theme, ResponseWriter writer, FacesContext context, String spacerPath) throws IOException {
        writer.writeText((Object)"\n", null);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        this.renderSpacerImage((UIComponent)scheduler, spacerPath, 1, 30, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("colspan", (Object)"3", null);
        writer.writeAttribute("height", (Object)"25", null);
        writer.writeAttribute("valign", (Object)"top", null);
        if (scheduler.isRequiredLegend()) {
            writer.writeText((Object)"\n", null);
            writer.startElement("div", (UIComponent)scheduler);
            writer.writeAttribute("align", (Object)"left", null);
            writer.writeAttribute("class", (Object)theme.getStyleClass("LABEL_REQUIRED_DIV"), null);
            writer.writeText((Object)"\n", null);
            Icon icon = ThemeUtilities.getIcon(theme, "LABEL_REQUIRED_ICON");
            icon.setId(scheduler.getId().concat("_icon"));
            icon.setParent((UIComponent)scheduler);
            RenderingUtilities.renderComponent((UIComponent)icon, context);
            writer.writeText((Object)"\n", null);
            writer.write(SPACE);
            writer.writeText((Object)theme.getMessage("Scheduler.requiredLegend"), null);
            writer.writeText((Object)"\n", null);
            writer.endElement("div");
        } else {
            writer.write(SPACE);
        }
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderSpacerRow(UIComponent component, String path, int height, int width, int colspan, ResponseWriter writer) throws IOException {
        writer.startElement("tr", component);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", component);
        writer.writeAttribute("colspan", (Object)String.valueOf(colspan), null);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage(component, path, height, width, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderSpacerImage(UIComponent component, String path, int height, int width, ResponseWriter writer) throws IOException {
        writer.startElement("img", component);
        writer.writeAttribute("src", (Object)path, null);
        writer.writeAttribute("height", (Object)String.valueOf(height), null);
        writer.writeAttribute("width", (Object)String.valueOf(width), null);
        writer.writeAttribute("alt", (Object)"", null);
        writer.endElement("img");
    }

    private void renderDatePicker(Scheduler scheduler, Theme theme, String spacerPath, ResponseWriter writer, FacesContext context) throws IOException {
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)scheduler.getDatePicker(), context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
    }

    private void renderInputControls(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme, String spacerPath) throws IOException {
        UIComponent label;
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("valign", (Object)"top", null);
        writer.writeText((Object)"\n", null);
        String styleClass = theme.getStyleClass("DATE_TIME_FIELD_TABLE");
        this.renderOpenTable((UIComponent)scheduler, writer, styleClass);
        this.renderLegendRow(scheduler, theme, writer, context, spacerPath);
        this.renderStartDateRow(scheduler, spacerPath, theme, context, writer);
        if (scheduler.isStartTime()) {
            label = scheduler.getStartTimeLabelComponent(theme);
            this.renderTimeRow(scheduler, label, scheduler.getStartTimeComponent(), theme, spacerPath, context, writer);
        }
        if (scheduler.isEndTime()) {
            label = scheduler.getEndTimeLabelComponent(theme);
            this.renderTimeRow(scheduler, label, scheduler.getEndTimeComponent(), theme, spacerPath, context, writer);
        }
        if (scheduler.isRepeating()) {
            this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
            this.renderRepeatIntervalRow(scheduler, theme, context, writer);
            if (scheduler.isLimitRepeating()) {
                this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
                this.renderRepeatLimitRow(context, scheduler, writer, theme, spacerPath);
                this.renderRepeatLegend(scheduler, theme, context, writer);
            }
        }
        if (scheduler.isPreviewButton()) {
            this.renderSpacerRow((UIComponent)scheduler, spacerPath, 30, 1, 4, writer);
            this.renderPreviewRow(context, scheduler, writer, theme);
        }
        writer.writeText((Object)"\n", null);
        writer.endElement("table");
        writer.writeText((Object)"\n", null);
    }

    private void renderTimeRow(Scheduler scheduler, UIComponent label, Time time, Theme theme, String spacerPath, FacesContext context, ResponseWriter writer) throws IOException {
        this.renderSpacerRow((UIComponent)scheduler, spacerPath, 5, 1, 4, writer);
        writer.writeText((Object)"\n", null);
        this.renderInputRowStart(scheduler, writer, theme);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)time, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderStartDateRow(Scheduler scheduler, String spacerPath, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        UIComponent date = scheduler.getDateComponent();
        UIComponent label = scheduler.getDateLabelComponent(theme);
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage((UIComponent)scheduler, spacerPath, 1, 30, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(label, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        this.renderSpacerImage((UIComponent)scheduler, spacerPath, 1, 10, writer);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent(date, context);
        writer.writeText((Object)"\n", null);
        writer.startElement("span", (UIComponent)scheduler);
        String styleClass = theme.getStyleClass("HELP_FIELD_TEXT");
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.write(SPACE);
        writer.write(SPACE);
        writer.writeText((Object)this.getPattern(scheduler, theme), null);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private String getPattern(Scheduler scheduler, Theme theme) {
        String hint = scheduler.getDateFormatPatternHelp();
        if (hint == null) {
            try {
                String pattern = scheduler.getDatePicker().getDateFormatPattern();
                hint = theme.getMessage("calendar.".concat(pattern));
            }
            catch (MissingResourceException mre) {
                hint = ((SimpleDateFormat)scheduler.getDateFormat()).toLocalizedPattern().toLowerCase();
            }
        }
        return hint;
    }

    private void renderPreviewRow(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("colspan", (Object)"3", null);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        UIComponent button = scheduler.getPreviewButtonComponent();
        RenderingUtilities.renderComponent(button, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatIntervalRow(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        UIComponent label = scheduler.getRepeatIntervalLabelComponent();
        DropDown menu = scheduler.getRepeatIntervalComponent();
        this.renderInputRowStart(scheduler, writer, theme);
        RenderingUtilities.renderComponent(label, context);
        writer.writeText((Object)"\n", null);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)menu, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderInputRowStart(Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        writer.startElement("tr", (UIComponent)scheduler);
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.writeText((Object)"\n", null);
        writer.startElement("span", (UIComponent)scheduler);
        String styleClass = theme.getStyleClass("DATE_TIME_LABEL_TEXT");
        writer.writeAttribute("class", (Object)styleClass, null);
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatLimitRow(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme, String spacerPath) throws IOException {
        UIComponent label = scheduler.getRepeatLimitLabelComponent();
        UIComponent field = scheduler.getRepeatingFieldComponent();
        DropDown menu = scheduler.getRepeatUnitComponent();
        this.renderInputRowStart(scheduler, writer, theme);
        RenderingUtilities.renderComponent(label, context);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        RenderingUtilities.renderComponent(field, context);
        writer.writeText((Object)"\n", null);
        RenderingUtilities.renderComponent((UIComponent)menu, context);
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.endElement("tr");
        writer.writeText((Object)"\n", null);
    }

    private void renderRepeatLegend(Scheduler scheduler, Theme theme, FacesContext context, ResponseWriter writer) throws IOException {
        this.renderInputRowStart(scheduler, writer, theme);
        writer.write(SPACE);
        writer.endElement("span");
        writer.endElement("td");
        writer.writeText((Object)"\n", null);
        writer.startElement("td", (UIComponent)scheduler);
        writer.write(SPACE);
        writer.endElement("td");
        writer.write("\n");
        writer.startElement("td", (UIComponent)scheduler);
        writer.writeAttribute("nowrap", (Object)"nowrap", null);
        writer.startElement("div", (UIComponent)scheduler);
        writer.writeAttribute("class", (Object)theme.getStyleClass("HELP_FIELD_TEXT"), null);
        writer.writeText((Object)theme.getMessage("Scheduler.blankForWhat"), null);
        writer.write("\n");
        writer.endElement("div");
        writer.endElement("td");
        writer.write("\n");
        writer.endElement("tr");
        writer.write("\n");
    }

    private void renderJavaScript(FacesContext context, Scheduler scheduler, ResponseWriter writer, Theme theme) throws IOException {
        JsonObject initProps = JsonUtilities.JSON_BUILDER_FACTORY.createObjectBuilder().add("id", scheduler.getClientId(context)).add("datePickerId", scheduler.getDatePicker().getClientId(context)).add("dateFieldId", scheduler.getDateComponent().getClientId(context)).add("dateClass", theme.getStyleClass("DATE_TIME_LINK")).add("selectedClass", theme.getStyleClass("DATE_TIME_BOLD_LINK")).add("edgeClass", theme.getStyleClass("DATE_TIME_OTHER_LINK")).add("edgeSelectedClass", theme.getStyleClass("DATE_TIME_OTHER_BOLD_LINK")).add("todayClass", theme.getStyleClass("DATE_TIME_TODAY_LINK")).add("dateFormat", scheduler.getDatePicker().getDateFormatPattern()).build();
        JavaScriptUtilities.renderInitScriptTag(writer, "scheduler", initProps);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void log(String msg) {
        LogUtil.finest(SchedulerRenderer.class.getName() + "::" + msg);
    }
}

