/*
 * Decompiled with CFR 0.152.
 */
package com.sun.webui.jsf.util;

import com.sun.webui.jsf.util.LogUtil;
import jakarta.faces.context.FacesContext;
import jakarta.servlet.ServletContext;
import jakarta.servlet.http.HttpServletRequest;
import java.beans.Beans;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.IndexItem;
import javax.help.IndexView;
import javax.help.InvalidHelpSetContextException;
import javax.help.Map;
import javax.help.Merge;
import javax.help.NavigatorView;
import javax.help.SearchHit;
import javax.help.SearchTOCItem;
import javax.help.SearchView;
import javax.help.ServletHelpBroker;
import javax.help.TOCItem;
import javax.help.TOCView;
import javax.help.TreeItem;
import javax.help.search.MergingSearchEngine;
import javax.help.search.SearchEvent;
import javax.help.search.SearchItem;
import javax.help.search.SearchListener;
import javax.help.search.SearchQuery;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public final class HelpUtils
implements SearchListener {
    public static final String URL_SEPARATOR = "/";
    public static final String TOC_VIEW_NAME = "TOC";
    public static final String INDEX_VIEW_NAME = "Index";
    public static final String SEARCH_VIEW_NAME = "Search";
    private ServletHelpBroker helpBroker;
    private TOCView tocView;
    private Enumeration tocTreeEnum;
    private ArrayList<Object> tocTreeList;
    private DefaultMutableTreeNode tocTopNode;
    private IndexView indexView;
    private Enumeration indexTreeEnum;
    private ArrayList<Object> indexTreeList;
    private DefaultMutableTreeNode indexTopNode;
    private SearchView searchView;
    private MergingSearchEngine helpSearch;
    private SearchQuery searchQuery;
    private List<SearchTOCItem> searchNodes;
    private Enumeration searchEnum;
    private boolean searchFinished;
    private String currentRequestScheme = null;
    private final String appName;
    private static String pathPrefix;
    private int httpPort = -1;
    private Locale currentLocale;
    public static final String BASE_ID = "root";
    protected static final String REQUEST_SCHEME = "http";
    protected static final String HTML_DIR = "html";
    protected static final String HELP_DIR = "help";
    protected static final String DEFAULT_HELPSET_NAME = "app.hs";
    protected static final String TIPS_ON_SEARCHING_FILE = "tips_on_searching.html";

    public HelpUtils(HttpServletRequest request, String newAppName, int newHttpPort) {
        this.appName = newAppName;
        this.httpPort = newHttpPort;
        this.currentLocale = HelpUtils.getLocale();
        this.initHelp(request);
    }

    public HelpUtils(HttpServletRequest request, String newAppName, int newHttpPort, String requestScheme) {
        this.appName = newAppName;
        this.httpPort = newHttpPort;
        this.currentLocale = HelpUtils.getLocale();
        this.currentRequestScheme = requestScheme;
        this.initHelp(request);
    }

    public HelpUtils(HttpServletRequest request, String newAppName, String newPathPrefix) {
        this.appName = newAppName;
        if (newPathPrefix != null && newPathPrefix.length() != 0 && newPathPrefix.trim().length() != 0) {
            pathPrefix = newPathPrefix.trim();
        }
        this.currentLocale = HelpUtils.getLocale();
        this.initHelp(request);
    }

    public String getCurrentRequestScheme() {
        if (this.currentRequestScheme != null) {
            return this.currentRequestScheme;
        }
        return REQUEST_SCHEME;
    }

    public void setCurrentRequestScheme(String newScheme) {
        this.currentRequestScheme = newScheme;
    }

    private static Locale getLocale() {
        FacesContext context = FacesContext.getCurrentInstance();
        return context.getViewRoot().getLocale();
    }

    public String getTipsOnSearchingPath(ServletContext context) {
        StringBuilder buf = new StringBuilder();
        buf.append(HelpUtils.getHelpPath(this.appName)).append(URL_SEPARATOR).append(HTML_DIR).append(URL_SEPARATOR).append(this.currentLocale.toString()).append(URL_SEPARATOR).append(HELP_DIR).append(URL_SEPARATOR).append(TIPS_ON_SEARCHING_FILE);
        return buf.toString();
    }

    private void initHelp(HttpServletRequest request) {
        this.instantiateHelpBroker(request);
        String hsPath = this.getDefaultHelpSetPath();
        this.validateHelpSet(request, hsPath, false);
        this.validateID(null);
        this.initNavigatorViews();
    }

    private void instantiateHelpBroker(HttpServletRequest request) {
        try {
            this.helpBroker = (ServletHelpBroker)Beans.instantiate(this.getClass().getClassLoader(), "javax.help.ServletHelpBroker");
        }
        catch (ClassNotFoundException exc) {
            LogUtil.warning("Cannot instantiate ServletHelpBroker." + exc.getMessage());
        }
        catch (IOException exc) {
            LogUtil.warning("Cannot create bean of class ServletHelpBroker." + exc.getMessage());
        }
    }

    public ServletHelpBroker getHelpBroker() {
        return this.helpBroker;
    }

    public String getLocalizedHelpPath() {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(this.appName);
        if (!this.appName.endsWith(URL_SEPARATOR)) {
            buffer.append(URL_SEPARATOR);
        }
        buffer.append(HTML_DIR).append(URL_SEPARATOR).append(this.currentLocale.toString()).append(URL_SEPARATOR).append(HELP_DIR).append(URL_SEPARATOR);
        return buffer.toString();
    }

    public String getDefaultHelpSetPath() {
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(this.getLocalizedHelpPath()).append(DEFAULT_HELPSET_NAME);
        return buffer.toString();
    }

    private static String getHelpPath(String appName) {
        if (appName == null || appName.length() == 0) {
            return HTML_DIR;
        }
        if (pathPrefix == null) {
            return appName;
        }
        return appName + URL_SEPARATOR + pathPrefix;
    }

    private void initNavigatorViews() {
        HelpSet hs = this.helpBroker.getHelpSet();
        Locale locale = hs.getLocale();
        this.tocView = (TOCView)hs.getNavigatorView(TOC_VIEW_NAME);
        if (this.tocView != null) {
            this.tocTopNode = this.tocView.getDataAsTree();
            this.addSubHelpSets(hs);
            this.tocTreeEnum = this.tocTopNode.preorderEnumeration();
            this.setTOCTreeList();
        }
        this.indexView = (IndexView)hs.getNavigatorView(INDEX_VIEW_NAME);
        if (this.indexView != null) {
            this.indexTopNode = this.indexView.getDataAsTree();
            this.indexTreeEnum = this.indexTopNode.preorderEnumeration();
            this.setIndexTreeList();
        }
        this.searchView = (SearchView)hs.getNavigatorView(SEARCH_VIEW_NAME);
    }

    public void validateHelpSet(HttpServletRequest request, String hsName, boolean merge) {
        HelpSet hs = this.helpBroker.getHelpSet();
        if (hs != null) {
            if (hsName == null) {
                return;
            }
            HelpSet newHS = this.createHelpSet(request, hsName);
            if (merge && !hs.contains(newHS)) {
                hs.add(newHS);
            } else {
                this.helpBroker.setHelpSet(newHS);
            }
        } else {
            if (hsName == null) {
                return;
            }
            this.helpBroker.setHelpSet(this.createHelpSet(request, hsName));
        }
    }

    public void validateID(String helpID) {
        if (helpID != null) {
            this.helpBroker.setCurrentID(helpID);
        } else if (this.helpBroker.getCurrentID() == null && this.helpBroker.getCurrentURL() == null) {
            try {
                this.helpBroker.setCurrentID(this.helpBroker.getHelpSet().getHomeID());
            }
            catch (InvalidHelpSetContextException invalidHelpSetContextException) {
                // empty catch block
            }
        }
    }

    public void setCurrentHelpPage(URL url) {
        this.helpBroker.setCurrentURL(url);
    }

    private HelpSet createHelpSet(HttpServletRequest request, String hsName) {
        String helpSetName = hsName;
        if (!helpSetName.startsWith(REQUEST_SCHEME) && !helpSetName.startsWith(URL_SEPARATOR)) {
            helpSetName = URL_SEPARATOR + helpSetName;
        }
        HelpSet hs = null;
        int port = this.httpPort;
        if (port == -1) {
            port = request.getServerPort();
        }
        try {
            URL url = helpSetName.startsWith(REQUEST_SCHEME) ? new URL(helpSetName) : new URL(this.getCurrentRequestScheme(), request.getServerName(), port, hsName);
            hs = new HelpSet(null, url);
        }
        catch (MalformedURLException url) {
        }
        catch (HelpSetException hse) {
            if (!this.currentLocale.equals(Locale.ENGLISH)) {
                this.currentLocale = Locale.ENGLISH;
                try {
                    hs = this.createHelpSet(request, this.getDefaultHelpSetPath());
                }
                catch (Exception ex) {
                    LogUtil.warning("Can not create helpset for en locale: " + ex.getMessage());
                    throw new RuntimeException(ex);
                }
            }
            LogUtil.warning("Can not create helpset for en locale: " + hse.getMessage());
            throw new RuntimeException(hse);
        }
        return hs;
    }

    private void addSubHelpSets(HelpSet hs) {
        Enumeration e = hs.getHelpSets();
        while (e.hasMoreElements()) {
            NavigatorView[] views;
            HelpSet ehs = (HelpSet)e.nextElement();
            if (ehs == null) continue;
            for (NavigatorView view : views = ehs.getNavigatorViews()) {
                Merge mergeObject;
                if (!(view instanceof TOCView) || (mergeObject = Merge.DefaultMergeFactory.getMerge((NavigatorView)this.tocView, (NavigatorView)view)) == null) continue;
                mergeObject.processMerge((TreeNode)this.tocTopNode);
            }
            this.addSubHelpSets(ehs);
        }
    }

    public String getID(TreeNode node) {
        if (node == this.tocTopNode) {
            return BASE_ID;
        }
        TreeNode parent = node.getParent();
        if (parent == null) {
            return "";
        }
        String id = this.getID(parent);
        return id.concat("_" + Integer.toString(parent.getIndex(node)));
    }

    public String getContentURL(TreeItem item) {
        URL url = null;
        Map.ID id = item.getID();
        if (id != null) {
            HelpSet hs = id.hs;
            Map map = hs.getLocalMap();
            try {
                url = map.getURLFromID(id);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url != null) {
            return url.toExternalForm();
        }
        return "";
    }

    private void setTOCTreeList() {
        this.tocTreeList = new ArrayList();
        while (this.tocTreeEnum.hasMoreElements()) {
            this.tocTreeList.add(this.tocTreeEnum.nextElement());
        }
    }

    public ArrayList getTOCTreeList() {
        if (this.tocTreeList == null) {
            this.setTOCTreeList();
        }
        return this.tocTreeList;
    }

    private void setIndexTreeList() {
        this.indexTreeList = new ArrayList();
        while (this.indexTreeEnum.hasMoreElements()) {
            this.indexTreeList.add(this.indexTreeEnum.nextElement());
        }
    }

    public ArrayList getIndexTreeList() {
        if (this.indexTreeList == null) {
            this.setIndexTreeList();
        }
        return this.indexTreeList;
    }

    public synchronized Enumeration doSearch(String query) {
        if (query == null) {
            return null;
        }
        if (this.helpSearch == null) {
            if (this.searchView == null) {
                this.searchView = (SearchView)this.helpBroker.getHelpSet().getNavigatorView(SEARCH_VIEW_NAME);
            }
            if (this.searchView == null) {
                return null;
            }
            this.helpSearch = new MergingSearchEngine((NavigatorView)this.searchView);
            this.searchQuery = this.helpSearch.createQuery();
            this.searchQuery.addSearchListener((SearchListener)this);
        }
        if (this.searchQuery.isActive()) {
            this.searchQuery.stop();
        }
        this.searchFinished = false;
        this.searchQuery.start(query, this.currentLocale);
        if (!this.searchFinished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.searchEnum;
    }

    public synchronized void searchStarted(SearchEvent evt) {
        this.searchNodes = new ArrayList<SearchTOCItem>();
        this.searchFinished = false;
    }

    public synchronized void searchFinished(SearchEvent evt) {
        this.searchFinished = true;
        this.searchEnum = Collections.enumeration(this.searchNodes);
        this.notifyAll();
    }

    public synchronized void itemsFound(SearchEvent e) {
        Enumeration itemEnum = e.getSearchItems();
        while (itemEnum.hasMoreElements()) {
            SearchTOCItem tocitem2;
            URL url;
            SearchItem item = (SearchItem)itemEnum.nextElement();
            try {
                url = new URL(item.getBase(), item.getFilename());
            }
            catch (MalformedURLException me) {
                continue;
            }
            boolean foundNode = false;
            for (SearchTOCItem tocitem2 : this.searchNodes) {
                URL testURL = tocitem2.getURL();
                if (testURL == null || !url.sameFile(testURL)) continue;
                tocitem2.addSearchHit(new SearchHit(item.getConfidence(), item.getBegin(), item.getEnd()));
                foundNode = true;
                break;
            }
            if (foundNode) continue;
            tocitem2 = new SearchTOCItem(item);
            this.searchNodes.add(tocitem2);
        }
    }

    public void printDebug() {
        DefaultMutableTreeNode node;
        ArrayList tocTree = this.getTOCTreeList();
        if (tocTree == null) {
            return;
        }
        StringBuffer buf = new StringBuffer("tocTreeList dump:\n");
        int nTreeNodes = tocTree.size();
        for (int i = 0; i < nTreeNodes; ++i) {
            node = (DefaultMutableTreeNode)tocTree.get(i);
            buf.append(this.tocTreeToString(node)).append("\n");
        }
        ArrayList indexTree = this.getIndexTreeList();
        if (indexTree == null) {
            return;
        }
        buf = new StringBuffer("indexTreeList dump:\n");
        nTreeNodes = indexTree.size();
        for (int i = 0; i < nTreeNodes; ++i) {
            node = (DefaultMutableTreeNode)indexTree.get(i);
            buf.append(this.indexTreeToString(node)).append("\n");
        }
    }

    public String tocTreeToString(DefaultMutableTreeNode node) {
        if (node == null) {
            return "\n\tTOC tree node is null.";
        }
        TOCItem item = (TOCItem)node.getUserObject();
        if (item == null) {
            return "\n\tTOCItem is null.";
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        StringBuilder buf = new StringBuilder();
        buf.append("\n\tname:          ").append(item.getName());
        buf.append("\n\thelpID:        ");
        if (item.getID() != null) {
            buf.append(item.getID());
        } else {
            buf.append("");
        }
        buf.append("\n\tparentID:        ");
        if (parent != null) {
            buf.append(Integer.toHexString(parent.hashCode()));
        } else {
            buf.append("");
        }
        buf.append("\n\tparentID 2:      ").append(this.getID(parent));
        buf.append("\n\tnode:          ").append(Integer.toHexString(node.hashCode()));
        buf.append("\n\tnodeID:        ").append(this.getID(node));
        buf.append("\n\tcontentURL:    ").append(this.getContentURL((TreeItem)item));
        buf.append("\n\texpansionType: ").append(Integer.toString(item.getExpansionType()));
        return buf.toString();
    }

    public String indexTreeToString(DefaultMutableTreeNode node) {
        if (node == null) {
            return "\n\tTree node is null.";
        }
        IndexItem item = (IndexItem)node.getUserObject();
        if (item == null) {
            return "\n\tIndexItem is null.";
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        StringBuilder buf = new StringBuilder();
        buf.append("\n\tname:          ").append(item.getName()).append("\n\thelpID:        ");
        if (item.getID() != null) {
            buf.append(item.getID());
        }
        buf.append("\n\tparentID:        ");
        if (parent != null) {
            buf.append(Integer.toHexString(parent.hashCode()));
        }
        buf.append("\n\tparentID 2:      ").append(this.getID(parent)).append("\n\tnode:          ").append(Integer.toHexString(node.hashCode())).append("\n\tnodeID:        ").append(this.getID(node)).append("\n\texpansionType: ").append(Integer.toString(item.getExpansionType()));
        return buf.toString();
    }
}

