/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.ant.tasks;

import java.util.ArrayList;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.glassfish.ant.tasks.Component;
import org.glassfish.ant.tasks.DeployTask;

public class ComponentTask
extends DeployTask {
    String action;
    private Component component;
    private List<Component> components = new ArrayList<Component>();

    @Override
    public void setAction(String action) {
        this.action = action;
    }

    @Override
    public Component createComponent() {
        this.component = new Component();
        this.components.add(this.component);
        return this.component;
    }

    @Override
    public void execute() throws BuildException {
        if (this.components.size() == 0) {
            this.log("component must be specified", 1);
            return;
        }
        if (!this.valid(this.action)) {
            this.log("action must be specified. Valid values are 'enable' and 'disable'", 1);
            return;
        }
        this.processComponents();
    }

    private void processComponents() throws BuildException {
        for (Component comp : this.components) {
            super.execute(this.action + " " + comp.name);
        }
    }

    private boolean valid(String action) {
        return action != null && (action.equals("enable") || action.equals("disable"));
    }
}

