/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.config;

import com.sun.logging.LogDomains;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.glassfish.admin.amx.base.DomainRoot;
import org.glassfish.admin.amx.core.Util;
import org.glassfish.admin.amx.core.proxy.ProxyFactory;
import org.glassfish.admin.amx.impl.config.AMXConfigImpl;
import org.glassfish.admin.amx.impl.config.AMXConfigLoaderMBean;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupport;
import org.glassfish.admin.amx.impl.config.ConfigBeanJMXSupportRegistry;
import org.glassfish.admin.amx.impl.config.ConfigBeanRegistry;
import org.glassfish.admin.amx.impl.config.ConfigToolsImpl;
import org.glassfish.admin.amx.impl.mbean.MBeanImplBase;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.impl.util.SingletonEnforcer;
import org.glassfish.admin.amx.intf.config.ConfigTools;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.FeatureAvailability;
import org.glassfish.admin.amx.util.MapUtil;
import org.glassfish.admin.amx.util.TypeCast;
import org.glassfish.admin.amx.util.jmx.JMXUtil;
import org.glassfish.admin.mbeanserver.PendingConfigBeanJob;
import org.glassfish.admin.mbeanserver.PendingConfigBeans;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;
import org.jvnet.hk2.config.ConfigBean;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.TransactionListener;
import org.jvnet.hk2.config.Transactions;
import org.jvnet.hk2.config.UnprocessedChangeEvents;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.NOT_AN_INTERFACE)
public final class AMXConfigLoader
extends MBeanImplBase
implements AMXConfigLoaderMBean,
TransactionListener {
    private volatile AMXConfigLoaderThread mLoaderThread;
    private final Transactions mTransactions;
    private final Logger mLogger = LogDomains.getLogger(AMXConfigLoader.class, (String)"javax.enterprise.system.amx");
    private final PendingConfigBeans mPendingConfigBeans;
    private final ConfigBeanRegistry mRegistry = ConfigBeanRegistry.getInstance();
    private volatile ObjectName mConfigToolsObjectName = null;
    private static final AtomicLong sCounter = new AtomicLong(1L);

    private static void debug(String s) {
        System.out.println(s);
    }

    public AMXConfigLoader(MBeanServer mbeanServer, PendingConfigBeans pending, Transactions transactions) {
        super(mbeanServer);
        if (transactions == null) {
            throw new IllegalStateException("AMXConfigLoader.AMXConfigLoader: null Transactions");
        }
        this.mTransactions = transactions;
        this.mPendingConfigBeans = pending;
    }

    public void registerConfigured(Class<? extends ConfigBeanProxy> intf) {
        ConfigBeanJMXSupportRegistry.getInstance(intf);
    }

    @Override
    public Map<String, String> getConfiguredTypes() {
        List<Class<? extends ConfigBeanProxy>> classes = ConfigBeanJMXSupportRegistry.getConfiguredClasses();
        Map types = MapUtil.newMap();
        for (Class<? extends ConfigBeanProxy> clazz : classes) {
            String classname = clazz.getName();
            String elementType = Util.typeFromName((String)classname);
            types.put(elementType, classname);
        }
        return types;
    }

    private void configBeanRemoved(ConfigBean cb) {
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName != null) {
            ImplUtil.unregisterAMXMBeans((MBeanServer)this.mServer, (ObjectName)objectName);
            this.mRegistry.remove(objectName);
        } else {
            this.mPendingConfigBeans.remove(cb);
        }
    }

    private void issueAttributeChange(ConfigBean cb, String xmlAttrName, Object oldValue, Object newValue, long whenChanged) {
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName == null) {
            throw new IllegalArgumentException("Can't issue attribute change for null ObjectName for ConfigBean " + cb.getProxyType().getName());
        }
        boolean changed = false;
        if (oldValue != null) {
            changed = !oldValue.equals(newValue);
        } else if (newValue != null) {
            boolean bl = changed = !newValue.equals(oldValue);
        }
        if (changed) {
            Object impl = this.mRegistry.getImpl(cb);
            if (!(impl instanceof AMXConfigImpl)) {
                throw new IllegalStateException("impossible");
            }
            AMXConfigImpl amx = (AMXConfigImpl)((Object)impl);
            String message = cb.getProxyType().getName() + "." + xmlAttrName + ": " + oldValue + " => " + newValue;
            amx.issueAttributeChangeForXmlAttrName(xmlAttrName, message, oldValue, newValue, whenChanged);
        }
    }

    private void sortAndDispatch(List<PropertyChangeEvent> events, long whenChanged) {
        ConfigBean cb;
        ConfigBeanProxy cbp;
        String propertyName;
        Object source;
        Object newValue;
        Object oldValue;
        ArrayList<ConfigBean> newConfigBeans = new ArrayList<ConfigBean>();
        ArrayList<PropertyChangeEvent> remainingEvents = new ArrayList<PropertyChangeEvent>();
        for (PropertyChangeEvent event : events) {
            oldValue = event.getOldValue();
            newValue = event.getNewValue();
            source = event.getSource();
            propertyName = event.getPropertyName();
            if (oldValue == null && newValue instanceof ConfigBeanProxy) {
                cbp = (ConfigBeanProxy)newValue;
                cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                Class proxyClass = cb.getProxyType();
                boolean doWait = this.amxIsRunning();
                if (!this.handleConfigBean(cb, doWait)) continue;
                newConfigBeans.add(cb);
                continue;
            }
            if (newValue == null && oldValue instanceof ConfigBeanProxy && this.amxIsRunning()) {
                cbp = (ConfigBeanProxy)oldValue;
                cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                this.configBeanRemoved(cb);
                continue;
            }
            remainingEvents.add(event);
        }
        if (this.amxIsRunning()) {
            for (PropertyChangeEvent event : remainingEvents) {
                oldValue = event.getOldValue();
                newValue = event.getNewValue();
                source = event.getSource();
                propertyName = event.getPropertyName();
                if (source instanceof ConfigBeanProxy) {
                    cbp = (ConfigBeanProxy)source;
                    cb = AMXConfigLoader.asConfigBean(ConfigBean.unwrap((ConfigBeanProxy)cbp));
                    if (this.mRegistry.getObjectName(cb) == null) {
                        if (newConfigBeans.contains(cb) || !this.handleConfigBean(cb, false)) continue;
                        newConfigBeans.add(cb);
                        continue;
                    }
                    this.issueAttributeChange(cb, propertyName, oldValue, newValue, whenChanged);
                    continue;
                }
                AMXConfigLoader.debug("AMXConfigLoader.sortAndDispatch: WARNING: source is not a ConfigBean");
            }
        }
    }

    public void transactionCommited(List<PropertyChangeEvent> changes) {
        this.sortAndDispatch(changes, System.currentTimeMillis());
    }

    public void unprocessedTransactedEvents(List<UnprocessedChangeEvents> changes) {
    }

    protected void postRegisterHook(Boolean registrationDone) {
        super.postRegisterHook(registrationDone);
        if (registrationDone.booleanValue()) {
            this.mPendingConfigBeans.swapTransactionListener((TransactionListener)this);
        }
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
    }

    protected void postDeregisterHook() {
        super.postDeregisterHook();
        this.mTransactions.removeTransactionsListener((TransactionListener)this);
    }

    public void stop() {
        ObjectName objectName = JMXUtil.newObjectName((String)AMXGlassfish.DEFAULT.amxSupportDomain(), (String)"type=AMXConfigLoader");
        try {
            this.mServer.unregisterMBean(objectName);
        }
        catch (Exception e) {
            this.mLogger.log(Level.SEVERE, "Can't register AMXConfigLoader ", e);
            throw new RuntimeException(e);
        }
        SingletonEnforcer.deregister(AMXConfigLoader.class, (Object)this);
    }

    boolean handleConfigBean(ConfigBean cb, boolean waitDone) {
        boolean processed = true;
        if (this.mRegistry.getObjectName(cb) == null) {
            PendingConfigBeanJob job = this.mPendingConfigBeans.add(cb, waitDone);
            if (job == null) {
                this.mLogger.log(Level.INFO, "amx.ConfigBean.not.processed", cb.getProxyType().getName());
                processed = false;
            } else if (waitDone) {
                try {
                    job.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return processed;
    }

    private ConfigBean getActualParent(ConfigBean configBean) {
        ConfigBean parent = AMXConfigLoader.asConfigBean(configBean.parent());
        if (parent != null) {
            ObjectName objectName = this.mRegistry.getObjectName(parent);
        } else if (!configBean.getProxyType().getName().endsWith("Domain")) {
            throw new IllegalStateException("WARNING: parent is null for " + configBean.getProxyType().getName() + ",  see issue #10528");
        }
        return parent;
    }

    private ObjectName getActualParentObjectName(ConfigBean configBean) {
        ObjectName parentObjectName = null;
        ConfigBean parent = this.getActualParent(configBean);
        if (parent != null) {
            parentObjectName = this.mRegistry.getObjectName(parent);
        }
        return parentObjectName;
    }

    static ConfigBean asConfigBean(Object o) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof ConfigBean)) {
            throw new IllegalArgumentException("Not a ConfigBean: " + o.getClass().getName());
        }
        return (ConfigBean)o;
    }

    public synchronized ObjectName start() {
        this.mLogger.log(Level.INFO, "amx.In.AMXConfigLoader", this.mLoaderThread);
        if (this.mLoaderThread == null) {
            FeatureAvailability.getInstance().waitForFeature("AMXCoreReady", "AMXConfigLoader.start");
            this.mLoaderThread = new AMXConfigLoaderThread(this.mPendingConfigBeans);
            this.mLoaderThread.setDaemon(true);
            this.mLoaderThread.start();
            ObjectName objectName = JMXUtil.newObjectName((String)AMXGlassfish.DEFAULT.amxSupportDomain(), (String)"type=AMXConfigLoader");
            try {
                this.mServer.registerMBean(this, objectName);
            }
            catch (Exception e) {
                this.mLogger.log(Level.SEVERE, "Can't register AMXConfigLoader ", e);
                throw new RuntimeException(e);
            }
            SingletonEnforcer.register(AMXConfigLoader.class, (Object)this);
            try {
                ObjectName parent = this.getDomainRootProxy().getExt().objectName();
                ConfigToolsImpl tools = new ConfigToolsImpl(parent);
                ObjectName configToolsObjectName = ObjectNameBuilder.buildChildObjectName((MBeanServer)this.mServer, (ObjectName)parent, ConfigTools.class);
                this.mConfigToolsObjectName = this.mServer.registerMBean((Object)tools, configToolsObjectName).getObjectName();
            }
            catch (JMException e) {
                this.mLogger.log(Level.SEVERE, "Can't register ConfigTools ", e);
            }
            this.mLoaderThread.waitInitialQueue();
            ObjectName domainConfig = this.getDomainRootProxy().getDomain().objectName();
            this.mLogger.log(Level.INFO, "amx.domain.config.registered", domainConfig);
            FeatureAvailability.getInstance().registerFeature("AMXConfigReady", (Object)domainConfig);
        }
        return null;
    }

    private synchronized boolean amxIsRunning() {
        return this.mLoaderThread != null;
    }

    private ObjectName registerConfigBeanAsMBean(ConfigBean cb) {
        ObjectName objectName = null;
        ConfigBean parentCB = this.getActualParent(cb);
        if (parentCB != null && this.mRegistry.getObjectName(parentCB) == null) {
            this.registerConfigBeanAsMBean(parentCB);
        }
        objectName = this._registerConfigBeanAsMBean(cb, parentCB);
        assert (objectName == null || this.mRegistry.getObjectName(cb) != null);
        return objectName;
    }

    private ObjectName _registerConfigBeanAsMBean(ConfigBean cb, ConfigBean parentCB) {
        Class cbClass = cb.getProxyType();
        ObjectName objectName = this.mRegistry.getObjectName(cb);
        if (objectName != null) {
            throw new IllegalArgumentException("ConfigBean " + cbClass.getName() + " already registered as " + objectName);
        }
        if (parentCB != null && this.mRegistry.getObjectName(parentCB) == null) {
            throw new IllegalArgumentException("ConfigBean parent " + parentCB.getProxyType().getName() + " must be registered first before child = " + cbClass.getName());
        }
        objectName = this.buildObjectName(cb);
        if ((objectName = this.createAndRegister(cb, objectName)) != null) {
            this.mLogger.fine("REGISTERED MBEAN: " + objectName);
        }
        return objectName;
    }

    private ObjectName createAndRegister(ConfigBean cb, ObjectName objectNameIn) {
        ObjectName objectName = objectNameIn;
        String type = objectNameIn.getKeyProperty("type");
        ObjectName parentObjectName = this.getActualParentObjectName(cb);
        if (parentObjectName == null) {
            parentObjectName = AMXGlassfish.DEFAULT.domainRoot();
        }
        AMXConfigImpl impl = new AMXConfigImpl(parentObjectName, cb);
        try {
            ObjectInstance instance = this.mServer.registerMBean((Object)impl, objectNameIn);
            objectName = instance.getObjectName();
            this.mRegistry.add(cb, objectName, (Object)impl);
        }
        catch (JMException e) {
            AMXConfigLoader.debug(ExceptionUtil.toString((Throwable)e));
            objectName = null;
        }
        return objectName;
    }

    private String getType(ConfigBean cb) {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        return spt.getTypeString();
    }

    static String getKey(ConfigBean cb) {
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        if (spt.isSingleton()) {
            return null;
        }
        String name = null;
        String nameHint = spt.getNameHint();
        if (nameHint == null) {
            name = "MISSING_NAME__KEY_MUST_BE_SPECIFIED_IN_INTERFACE";
        } else if (spt.nameHintIsElement()) {
            List leaf = cb.leafElements(nameHint);
            if (leaf != null) {
                List items = TypeCast.checkList((List)leaf, String.class);
                if (items.size() != 1) {
                    throw new IllegalArgumentException("Can't find sub-element of type " + nameHint + " in " + cb.getProxyType().getName());
                }
                name = (String)items.get(0);
            }
        } else {
            name = cb.rawAttribute(nameHint);
        }
        return name;
    }

    private DomainRoot getDomainRootProxy() {
        return ProxyFactory.getInstance((MBeanServer)this.mServer).getDomainRootProxy(false);
    }

    private ObjectName buildObjectName(ConfigBean cb) {
        ConfigBean parent = this.getActualParent(cb);
        ObjectName parentObjectName = parent == null ? AMXGlassfish.DEFAULT.domainRoot() : this.mRegistry.getObjectName(parent);
        String type = this.getType(cb);
        String name = AMXConfigLoader.getKey(cb);
        ConfigBeanJMXSupport spt = ConfigBeanJMXSupportRegistry.getInstance(cb);
        if (!(spt.isSingleton() || name != null && name.length() != 0)) {
            name = "MISSING_NAME-" + sCounter.getAndIncrement();
            this.mLogger.log(Level.WARNING, "amx.nonsingleton.configbean", new Object[]{cb.getProxyType().getName(), name});
        }
        ObjectName objectName = ObjectNameBuilder.buildChildObjectName((MBeanServer)this.mServer, (ObjectName)parentObjectName, (String)type, (String)name);
        return objectName;
    }

    private final class AMXConfigLoaderThread
    extends Thread {
        private final PendingConfigBeans mPending;
        volatile boolean mQuit;
        private volatile CountDownLatch mInitalQueueLatch;

        AMXConfigLoaderThread(PendingConfigBeans pending) {
            super("AMXConfigLoader.AMXConfigLoaderThread");
            this.mQuit = false;
            this.mInitalQueueLatch = new CountDownLatch(1);
            this.mPending = pending;
        }

        void quit() {
            this.mQuit = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectName registerOne(PendingConfigBeanJob job) {
            ConfigBean cb = job.getConfigBean();
            ObjectName objectName = AMXConfigLoader.this.mRegistry.getObjectName(cb);
            try {
                if (objectName == null) {
                    objectName = AMXConfigLoader.this.registerConfigBeanAsMBean(cb);
                }
            }
            catch (Throwable t) {
                AMXConfigLoader.this.mLogger.log(Level.WARNING, "Can't register config MBean: " + objectName, t);
            }
            finally {
                job.releaseLatch();
            }
            return objectName;
        }

        public void run() {
            try {
                this.doRun();
            }
            catch (Throwable t) {
                AMXConfigLoader.this.mLogger.log(Level.SEVERE, "Unexpected thread death of AMXConfigLoaderThread", t);
            }
        }

        public void waitInitialQueue() {
            CountDownLatch latch = this.mInitalQueueLatch;
            if (latch != null) {
                try {
                    latch.await();
                }
                catch (InterruptedException e) {
                    throw new RuntimeException(e);
                }
                this.mInitalQueueLatch = null;
            }
        }

        protected void doRun() throws Exception {
            PendingConfigBeanJob job = this.mPending.take();
            while (!this.mQuit && job != null) {
                ObjectName objectName = this.registerOne(job);
                job = this.mPending.peek();
                if (job == null) continue;
                job = this.mPending.take();
            }
            this.mInitalQueueLatch.countDown();
            while (!this.mQuit) {
                job = this.mPending.take();
                this.registerOne(job);
            }
        }
    }

    private static final class Job {
        final ConfigBean mConfigBean;
        final CountDownLatch mLatch;

        public Job(ConfigBean configBean, CountDownLatch latch) {
            this.mConfigBean = configBean;
            this.mLatch = latch;
        }

        public void releaseLatch() {
            if (this.mLatch != null) {
                this.mLatch.countDown();
            }
        }
    }
}

