/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.intf.config;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.management.Descriptor;
import javax.management.MBeanAttributeInfo;
import org.glassfish.admin.amx.config.AMXConfigProxy;
import org.glassfish.external.arc.Stability;
import org.glassfish.external.arc.Taxonomy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Taxonomy(stability=Stability.UNCOMMITTED)
public class AMXConfigHelper {
    private final AMXConfigProxy mAMX;

    public AMXConfigHelper(AMXConfigProxy amx) {
        this.mAMX = amx;
    }

    public Set<String> attributeNamesByDescriptorField(String fieldName, String value) {
        HashSet<String> attrNames = new HashSet<String>();
        for (MBeanAttributeInfo attrInfo : this.mAMX.extra().mbeanInfo().getAttributes()) {
            Descriptor desc = attrInfo.getDescriptor();
            if (!value.equals(desc.getFieldValue(fieldName))) continue;
            attrNames.add(attrInfo.getName());
        }
        return attrNames;
    }

    public Set<String> simpleAttributes() {
        String elementKind = "element";
        Set<String> elementNames = this.attributeNamesByDescriptorField("amx.configbean.kind", "element");
        Set remaining = this.mAMX.attributeNames();
        remaining.removeAll(elementNames);
        return remaining;
    }

    public Map<String, Object> simpleAttributesMap() {
        return this.mAMX.attributesMap(this.simpleAttributes());
    }

    public final Descriptor attributeDescriptor(String attrName) {
        MBeanAttributeInfo info = this.mAMX.extra().attributeInfo(attrName);
        return info == null ? null : info.getDescriptor();
    }

    public final Object attributeDescriptorField(String attrName, String fieldName) {
        Descriptor desc = this.attributeDescriptor(attrName);
        return desc == null ? null : desc.getFieldValue(fieldName);
    }

    public String units(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "amx.configbean.units");
    }

    public Long min(String attrName) {
        return (Long)this.attributeDescriptorField(attrName, "amx.configbean.min");
    }

    public Long max(String attrName) {
        return (Long)this.attributeDescriptorField(attrName, "amx.configbean.max");
    }

    public String dataType(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "amx.configbean.dataType");
    }

    public String regexPattern(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "amx.configbean.pattern");
    }

    public boolean key(String attrName) {
        return Boolean.parseBoolean("" + this.attributeDescriptorField(attrName, "amx.configbean.key"));
    }

    public boolean notNull(String attrName) {
        return Boolean.parseBoolean("" + this.attributeDescriptorField(attrName, "amx.configbean.notNull"));
    }

    public Boolean required(String attrName) {
        return this.notNull(attrName) || this.key(attrName) || Boolean.parseBoolean("" + this.attributeDescriptorField(attrName, "amx.configbean.required"));
    }

    public String xmlName(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "amx.configbean.xmlName");
    }

    public String defaultValue(String attrName) {
        return (String)this.attributeDescriptorField(attrName, "amx.configbean.defaultValue");
    }
}

