/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.amx.impl.ext;

import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbBundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.EjbSessionDescriptor;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.enterprise.deployment.WebComponentDescriptor;
import com.sun.enterprise.module.Module;
import com.sun.enterprise.module.ModulesRegistry;
import com.sun.enterprise.security.ssl.SSLUtils;
import com.sun.enterprise.v3.admin.RestartDomainCommand;
import com.sun.enterprise.v3.admin.commands.JVMInformation;
import com.sun.enterprise.v3.common.PlainTextActionReporter;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.remote.JMXServiceURL;
import org.glassfish.admin.amx.base.RuntimeRoot;
import org.glassfish.admin.amx.base.ServerRuntime;
import org.glassfish.admin.amx.impl.ext.ServerRuntimeImpl;
import org.glassfish.admin.amx.impl.mbean.AMXImplBase;
import org.glassfish.admin.amx.impl.util.ImplUtil;
import org.glassfish.admin.amx.impl.util.InjectedValues;
import org.glassfish.admin.amx.impl.util.ObjectNameBuilder;
import org.glassfish.admin.amx.intf.config.Config;
import org.glassfish.admin.amx.intf.config.Domain;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkConfig;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListener;
import org.glassfish.admin.amx.intf.config.grizzly.NetworkListeners;
import org.glassfish.admin.amx.intf.config.grizzly.Protocol;
import org.glassfish.admin.amx.util.ExceptionUtil;
import org.glassfish.admin.amx.util.StringUtil;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.container.Sniffer;
import org.glassfish.api.deployment.archive.ReadableArchive;
import org.glassfish.external.amx.AMXGlassfish;
import org.glassfish.internal.data.ApplicationInfo;
import org.glassfish.internal.data.ApplicationRegistry;
import org.glassfish.internal.data.EngineRef;
import org.glassfish.internal.data.ModuleInfo;
import org.jvnet.hk2.component.Habitat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RuntimeRootImpl
extends AMXImplBase {
    private final ApplicationRegistry appRegistry;
    private final Habitat mHabitat = InjectedValues.getInstance().getHabitat();
    private static final String ADMIN_LISTENER_NAME = "admin-listener";

    public RuntimeRootImpl(ObjectName parent) {
        super(parent, RuntimeRoot.class);
        this.appRegistry = (ApplicationRegistry)this.mHabitat.getComponent(ApplicationRegistry.class);
    }

    public ObjectName[] getServerRuntime() {
        return this.getChildren(ServerRuntime.class);
    }

    protected final void registerChildren() {
        super.registerChildren();
        ObjectName self = this.getObjectName();
        MBeanServer server = this.getMBeanServer();
        ObjectNameBuilder objectNames = new ObjectNameBuilder(server, self);
        ObjectName childObjectName = null;
        ServerRuntimeImpl mbean = null;
        childObjectName = objectNames.buildChildObjectName(ServerRuntime.class, AMXGlassfish.DEFAULT.dasName());
        mbean = new ServerRuntimeImpl(self);
        this.registerChild((Object)mbean, childObjectName);
    }

    public List<Map<String, String>> getDeploymentConfigurations(String appName) {
        ApplicationInfo appInfo = this.appRegistry.get(appName);
        ArrayList<Map<String, String>> resultList = new ArrayList<Map<String, String>>();
        if (appInfo == null) {
            return resultList;
        }
        try {
            if (appInfo.getEngineRefs().size() > 0) {
                for (EngineRef ref : appInfo.getEngineRefs()) {
                    Sniffer appSniffer = ref.getContainerInfo().getSniffer();
                    this.addToResultDDList("", appSniffer.getDeploymentConfigurations(appInfo.getSource()), resultList);
                }
                for (ModuleInfo moduleInfo : appInfo.getModuleInfos()) {
                    for (Sniffer moduleSniffer : moduleInfo.getSniffers()) {
                        ReadableArchive moduleArchive = appInfo.getSource().getSubArchive(moduleInfo.getName());
                        this.addToResultDDList(moduleInfo.getName(), moduleSniffer.getDeploymentConfigurations(moduleArchive), resultList);
                    }
                }
            } else {
                for (Sniffer sniffer : appInfo.getSniffers()) {
                    this.addToResultDDList(appName, sniffer.getDeploymentConfigurations(appInfo.getSource()), resultList);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resultList;
    }

    private void addToResultDDList(String moduleName, Map<String, String> snifferConfigs, List<Map<String, String>> resultList) {
        for (String pathKey : snifferConfigs.keySet()) {
            HashMap<String, String> resultMap = new HashMap<String, String>();
            resultMap.put("module-name", moduleName);
            resultMap.put("dd-path", pathKey);
            resultMap.put("dd-content", snifferConfigs.get(pathKey));
            resultList.add(resultMap);
        }
    }

    public void stopDomain() {
        ModulesRegistry registry = InjectedValues.getInstance().getModulesRegistry();
        Collection modules = registry.getModules("com.sun.enterprise.osgi-adapter");
        if (modules.size() == 1) {
            Module mgmtAgentModule = (Module)modules.iterator().next();
            mgmtAgentModule.stop();
        } else {
            ImplUtil.getLogger().warning("Cannot find primordial com.sun.enterprise.osgi-adapter");
        }
        ImplUtil.getLogger().warning("Stopping server forcibly");
        System.exit(0);
    }

    public void restartDomain() {
        ModulesRegistry registry = InjectedValues.getInstance().getModulesRegistry();
        AdminCommandContext ctx = new AdminCommandContext(ImplUtil.getLogger(), (ActionReport)new PlainTextActionReporter());
        RestartDomainCommand cmd = new RestartDomainCommand(registry);
        cmd.execute(ctx);
    }

    private NetworkConfig networkConfig() {
        return (NetworkConfig)((Config)((Domain)this.getDomainRootProxy().child(Domain.class)).getConfigs().getConfig().get("server-config")).getNetworkConfig().as(NetworkConfig.class);
    }

    private NetworkListener getAdminListener() {
        NetworkConfig network = this.networkConfig();
        NetworkListeners listeners = network.getNetworkListeners();
        Map listenersMap = listeners.getNetworkListener();
        NetworkListener listener = (NetworkListener)listenersMap.get(ADMIN_LISTENER_NAME);
        return listener;
    }

    private int getRESTPort() {
        return (int)this.getAdminListener().resolveLong("Port").longValue();
    }

    private String get_asadmin() {
        Protocol protocol = (Protocol)this.networkConfig().getProtocols().getProtocol().get(ADMIN_LISTENER_NAME);
        return protocol.getHttp().resolveAttribute("DefaultVirtualServer");
    }

    public String getRESTBaseURL() {
        Protocol protocol = (Protocol)this.networkConfig().getProtocols().getProtocol().get(ADMIN_LISTENER_NAME);
        String scheme = protocol.resolveBoolean("SecurityEnabled") != false ? "https" : "http";
        String host = "localhost";
        return scheme + "://" + "localhost" + ":" + this.getRESTPort() + "/" + this.get_asadmin() + "/";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeREST(String cmd) {
        String result = null;
        HttpURLConnection conn = null;
        try {
            String url = this.getRESTBaseURL() + cmd;
            URL invoke = new URL(url);
            conn = (HttpURLConnection)invoke.openConnection();
            InputStream is = conn.getInputStream();
            result = RuntimeRootImpl.toString((Object)is);
            is.close();
        }
        catch (Exception e) {
            result = ExceptionUtil.toString((Throwable)e);
        }
        finally {
            if (conn != null) {
                conn.disconnect();
            }
        }
        return result;
    }

    public String[] getSupportedCipherSuites() {
        try {
            SSLUtils sslUtils = (SSLUtils)this.mHabitat.getComponent(SSLUtils.class);
            return sslUtils.getSupportedCipherSuites();
        }
        catch (Exception ex) {
            ImplUtil.getLogger().log(Level.INFO, "Can't get cipher suites", ex);
            return new String[0];
        }
    }

    public String[] getJMXServiceURLs() {
        try {
            AMXGlassfish amxg = AMXGlassfish.DEFAULT;
            JMXServiceURL[] items = (JMXServiceURL[])this.getMBeanServer().getAttribute(amxg.getBootAMXMBeanObjectName(), "JMXServiceURLs");
            String[] urls = new String[items.length];
            for (int i = 0; i < items.length; ++i) {
                urls[i] = "" + items[i];
            }
            return urls;
        }
        catch (JMException e) {
            throw new RuntimeException(e);
        }
    }

    public String getJVMReport(String type) {
        JVMInformation info = new JVMInformation((MBeanServerConnection)this.getMBeanServer());
        String NL = StringUtil.LS;
        String target = "das";
        String result = "FAILED";
        if ("summary".equals(type)) {
            result = info.getSummary("das");
        } else if ("memory".equals(type)) {
            result = info.getMemoryInformation("das");
        } else if ("thread".equals(type)) {
            result = info.getThreadDump("das");
        } else if ("class".equals(type)) {
            result = info.getClassInformation("das");
        } else if ("log".equals(type)) {
            result = info.getLogInformation("das");
        } else if ("all".equals(type)) {
            result = "SUMMARY" + NL + NL + this.getJVMReport("summary") + NL + NL + "MEMORY" + NL + NL + this.getJVMReport("memory") + NL + NL + "THREADS" + NL + NL + this.getJVMReport("thread") + NL + NL + "CLASSES" + NL + NL + this.getJVMReport("class") + NL + NL + "LOGGING" + NL + NL + this.getJVMReport("log");
        } else {
            throw new IllegalArgumentException("Unsupported JVM report type: " + type);
        }
        if (result != null) {
            result = result.replace("%%%EOL%%%", NL);
        }
        return result;
    }

    public boolean isStartedInDebugMode() {
        boolean inDebugMode = false;
        String s = System.getProperty("hk2.startup.context.args");
        if (s != null) {
            String[] ss;
            String prefix = "-debug=";
            for (String opt : ss = s.split("\n")) {
                if (!opt.startsWith("-debug=")) continue;
                String value = opt.substring("-debug=".length()).toLowerCase();
                inDebugMode = Boolean.valueOf(value);
                break;
            }
        }
        return inDebugMode;
    }

    public Map<String, String> getSubComponentsOfModule(String applicationName, String moduleName) {
        BundleDescriptor bundleDesc;
        Application app;
        ApplicationRegistry appRegistry = (ApplicationRegistry)this.mHabitat.getComponent(ApplicationRegistry.class);
        ApplicationInfo appInfo = appRegistry.get(applicationName);
        if (appInfo != null && (app = (Application)appInfo.getMetaData(Application.class)) != null && (bundleDesc = app.getModuleByUri(moduleName)) != null) {
            return this.getModuleLevelComponents(bundleDesc);
        }
        return Collections.emptyMap();
    }

    private Map<String, String> getModuleLevelComponents(BundleDescriptor bundle) {
        HashMap<String, String> subComponentsMap;
        block4: {
            block3: {
                subComponentsMap = new HashMap<String, String>();
                if (!(bundle instanceof WebBundleDescriptor)) break block3;
                WebBundleDescriptor wbd = (WebBundleDescriptor)bundle;
                Collection ejbBundleDescs = wbd.getExtensionsDescriptors(EjbBundleDescriptor.class);
                if (ejbBundleDescs.size() > 0) {
                    EjbBundleDescriptor ejbBundle = (EjbBundleDescriptor)ejbBundleDescs.iterator().next();
                    subComponentsMap.putAll(this.getModuleLevelComponents((BundleDescriptor)ejbBundle));
                }
                for (WebComponentDescriptor wcd : wbd.getWebComponentDescriptors()) {
                    String wcdName = wcd.getCanonicalName();
                    String wcdType = wcd.isServlet() ? "Servlet" : "JSP";
                    subComponentsMap.put(wcdName, wcdType);
                }
                break block4;
            }
            if (!(bundle instanceof EjbBundleDescriptor)) break block4;
            EjbBundleDescriptor ebd = (EjbBundleDescriptor)bundle;
            for (EjbDescriptor ejbDesc : ebd.getEjbs()) {
                String ejbName = ejbDesc.getName();
                String ejbType = this.getEjbType(ejbDesc);
                subComponentsMap.put(ejbName, ejbType);
            }
        }
        return subComponentsMap;
    }

    private String getEjbType(EjbDescriptor ejbDesc) {
        String type = null;
        if (ejbDesc.getType().equals("Session")) {
            EjbSessionDescriptor sessionDesc = (EjbSessionDescriptor)ejbDesc;
            if (sessionDesc.isStateful()) {
                type = "StatefulSessionBean";
            } else if (sessionDesc.isStateless()) {
                type = "StatelessSessionBean";
            } else if (sessionDesc.isSingleton()) {
                type = "SingletonSessionBean";
            }
        } else if (ejbDesc.getType().equals("Message-driven")) {
            type = "MessageDrivenBean";
        } else if (ejbDesc.getType().equals("Entity")) {
            type = "EntityBean";
        }
        return type;
    }

    public String getContextRoot(String applicationName, String moduleName) {
        BundleDescriptor bundleDesc;
        Application app;
        ApplicationRegistry appRegistry = (ApplicationRegistry)this.mHabitat.getComponent(ApplicationRegistry.class);
        ApplicationInfo appInfo = appRegistry.get(applicationName);
        if (appInfo != null && (app = (Application)appInfo.getMetaData(Application.class)) != null && (bundleDesc = app.getModuleByUri(moduleName)) != null && bundleDesc instanceof WebBundleDescriptor) {
            return ((WebBundleDescriptor)bundleDesc).getContextRoot();
        }
        return null;
    }
}

