/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.net;

import com.sun.enterprise.util.CULoggerInfo;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipFile;

public class JarURIPattern {
    private static final Logger logger = CULoggerInfo.getLogger();

    public static List<String> getJarEntries(URI uri, Pattern pattern) {
        ArrayList<String> results = new ArrayList<String>();
        File file = null;
        try {
            file = new File(uri);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (file == null || file.isDirectory()) {
            return results;
        }
        String fileName = file.getName();
        if (fileName != null && fileName.endsWith(".jar")) {
            ZipFile jarFile = null;
            try {
                jarFile = new JarFile(new File(uri));
                Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    String entryName = entry.getName();
                    if (!pattern.matcher(entryName).matches()) continue;
                    results.add(entryName);
                }
            }
            catch (Exception ex) {
                if (logger.isLoggable(Level.WARNING)) {
                    logger.log(Level.WARNING, CULoggerInfo.getString("NCLS-COMUTIL-00038", fileName), ex);
                }
                throw new RuntimeException(ex);
            }
            finally {
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (Throwable t) {}
                }
            }
        }
        return results;
    }
}

