/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

public class BeanUtils {
    public static Map<String, Object> beanToMap(Object bean) throws InvocationTargetException {
        if (bean == null) {
            return null;
        }
        HashMap<String, Object> result = new HashMap<String, Object>();
        Collection<Method> getters = BeanUtils.getGetters(bean);
        for (Method method : getters) {
            try {
                result.put(BeanUtils.toAttributeName(method), method.invoke(bean, new Object[0]));
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return result;
    }

    public static void mapToBean(Object bean, Map<String, Object> data, boolean ignoreNotExistingSetter) throws InvocationTargetException, IllegalArgumentException {
        if (data == null || bean == null) {
            return;
        }
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            try {
                Method mtd = BeanUtils.getSetter(bean, entry.getKey());
                if (mtd == null) {
                    if (ignoreNotExistingSetter) continue;
                    throw new IllegalArgumentException();
                }
                mtd.invoke(bean, entry.getValue());
            }
            catch (IllegalAccessException illegalAccessException) {}
        }
    }

    public static Collection<Method> getGetters(Object bean) {
        if (bean == null) {
            return null;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : bean.getClass().getMethods()) {
            if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length != 0 || (method.getName().length() <= 3 || !method.getName().startsWith("get")) && (method.getName().length() <= 2 || !method.getName().startsWith("is"))) continue;
            result.add(method);
        }
        return result;
    }

    public static Collection<Method> getSetters(Object bean) {
        if (bean == null) {
            return null;
        }
        ArrayList<Method> result = new ArrayList<Method>();
        for (Method method : bean.getClass().getMethods()) {
            if (method.getDeclaringClass() == Object.class || method.getParameterTypes().length != 1 || method.getName().length() <= 3 || !method.getName().startsWith("set")) continue;
            result.add(method);
        }
        return result;
    }

    public static String toAttributeName(Method m) throws IllegalArgumentException {
        String result;
        String name = m.getName();
        if (name.startsWith("get") || name.startsWith("set")) {
            result = name.substring(3);
        } else if (name.startsWith("is")) {
            result = name.substring(2);
        } else {
            throw new IllegalArgumentException();
        }
        if (result.length() == 0) {
            throw new IllegalArgumentException();
        }
        result = Character.toLowerCase(result.charAt(0)) + result.substring(1);
        return result;
    }

    public static Method getSetter(Object bean, String attributeName) {
        String methodName = "set" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1);
        for (Method m : bean.getClass().getMethods()) {
            if (m.getParameterTypes().length != 1 || !m.getName().equals(methodName)) continue;
            return m;
        }
        return null;
    }
}

