/*
 * Decompiled with CFR 0.152.
 */
package com.sun.common.util.logging;

import com.sun.common.util.logging.LoggingConfig;
import com.sun.common.util.logging.LoggingXMLNames;
import jakarta.inject.Inject;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.glassfish.api.admin.FileMonitoring;
import org.glassfish.hk2.api.PostConstruct;
import org.glassfish.server.ServerEnvironmentImpl;
import org.jvnet.hk2.annotations.Contract;
import org.jvnet.hk2.annotations.Service;

@Service
@Contract
public class LoggingConfigImpl
implements LoggingConfig,
PostConstruct {
    @Inject
    Logger logger;
    @Inject
    ServerEnvironmentImpl env;
    @Inject
    FileMonitoring fileMonitoring;
    Properties props = new Properties();
    String loggingPropertiesName;
    File loggingConfigDir = null;

    public void postConstruct() {
        this.setupConfigDir(this.env.getConfigDirPath(), this.env.getLibPath());
    }

    public void setupConfigDir(File file, File installDir) {
        this.loggingConfigDir = file;
        this.loggingPropertiesName = "logging.properties";
    }

    private void loadLoggingProperties() throws IOException {
        this.props = new Properties();
        File file = this.getLoggingPropertiesFile();
        try (InputStream fis = null;){
            fis = !file.exists() ? this.getDefaultLoggingPropertiesInputStream() : new FileInputStream(file);
            fis = new BufferedInputStream(fis);
            this.props.load(fis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadLoggingProperties(String target) throws IOException {
        this.props = new Properties();
        File file = this.getLoggingPropertiesFile(target);
        try (InputStream fis = null;){
            fis = !file.exists() ? this.getDefaultLoggingPropertiesInputStream() : new FileInputStream(file);
            fis = new BufferedInputStream(fis);
            this.props.load(fis);
        }
    }

    private File getLoggingPropertiesFile() {
        return new File(this.loggingConfigDir, this.loggingPropertiesName);
    }

    private File getLoggingPropertiesFile(String target) {
        String pathForLoggingFile = this.loggingConfigDir.getAbsolutePath() + File.separator + target;
        return new File(pathForLoggingFile, "logging.properties");
    }

    private FileInputStream getDefaultLoggingPropertiesInputStream() throws IOException {
        File defaultConfig = new File(this.env.getConfigDirPath(), "default-logging.properties");
        return new FileInputStream(defaultConfig);
    }

    private void safeCloseStream(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void safeCloseStream(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closePropFile(String targetConfigName) throws IOException {
        BufferedOutputStream os = null;
        try {
            File file = targetConfigName == null || targetConfigName.isEmpty() ? this.getLoggingPropertiesFile() : this.getLoggingPropertiesFile(targetConfigName);
            File parentFile = file.getParentFile();
            if (!parentFile.exists() && !parentFile.mkdirs()) {
                throw new IOException();
            }
            os = new BufferedOutputStream(new FileOutputStream(file));
            this.props.store(os, "GlassFish logging.properties list");
            ((OutputStream)os).flush();
            this.fileMonitoring.fileModified(file);
            this.safeCloseStream(os);
        }
        catch (Throwable throwable) {
            this.safeCloseStream(os);
            throw throwable;
        }
    }

    private void setWebLoggers(String value) {
        this.props.setProperty("org.apache.catalina.level", value);
        this.props.setProperty("org.apache.coyote.level", value);
        this.props.setProperty("org.glassfish.wasp.level", value);
    }

    @Override
    public synchronized String setLoggingProperty(String propertyName, String propertyValue) throws IOException {
        this.loadLoggingProperties();
        if (propertyValue == null) {
            return null;
        }
        String key = LoggingXMLNames.xmltoPropsMap.get(propertyName);
        if (key == null) {
            key = propertyName;
        }
        String property = (String)this.props.setProperty(key, propertyValue);
        if (propertyName.contains("jakarta.enterprise.system.container.web")) {
            this.setWebLoggers(propertyValue);
        }
        this.closePropFile("");
        return property;
    }

    @Override
    public synchronized String setLoggingProperty(String propertyName, String propertyValue, String targetConfigName) throws IOException {
        this.loadLoggingProperties(targetConfigName);
        if (propertyValue == null) {
            return null;
        }
        String key = LoggingXMLNames.xmltoPropsMap.get(propertyName);
        if (key == null) {
            key = propertyName;
        }
        String property = (String)this.props.setProperty(key, propertyValue);
        if (propertyName.contains("jakarta.enterprise.system.container.web")) {
            this.setWebLoggers(propertyValue);
        }
        this.closePropFile(targetConfigName);
        return property;
    }

    @Override
    public synchronized Map<String, String> updateLoggingProperties(Map<String, String> properties) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        this.loadLoggingProperties();
        String key = null;
        for (Map.Entry<String, String> e : properties.entrySet()) {
            if (e.getValue() == null) continue;
            key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
            if (key == null) {
                key = e.getKey();
            }
            String property = (String)this.props.setProperty(key, e.getValue());
            if (e.getKey().contains("jakarta.enterprise.system.container.web")) {
                this.setWebLoggers(e.getValue());
            }
            m.put(key, property);
        }
        this.closePropFile("");
        return m;
    }

    @Override
    public synchronized Map<String, String> updateLoggingProperties(Map<String, String> properties, String targetConfigName) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        this.loadLoggingProperties(targetConfigName);
        String key = null;
        for (Map.Entry<String, String> e : properties.entrySet()) {
            if (e.getValue() == null) continue;
            key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
            if (key == null) {
                key = e.getKey();
            }
            String property = (String)this.props.setProperty(key, e.getValue());
            if (e.getKey().contains("jakarta.enterprise.system.container.web")) {
                this.setWebLoggers(e.getValue());
            }
            m.put(key, property);
        }
        this.closePropFile(targetConfigName);
        return m;
    }

    @Override
    public synchronized Map<String, String> getLoggingProperties(String targetConfigName) throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        this.loadLoggingProperties(targetConfigName);
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, this.props.getProperty(key));
        }
        return m;
    }

    @Override
    public synchronized Map<String, String> getLoggingProperties() throws IOException {
        HashMap<String, String> m = new HashMap<String, String>();
        this.loadLoggingProperties();
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, this.props.getProperty(key));
        }
        return m;
    }

    @Override
    public synchronized void deleteLoggingProperties(Map<String, String> properties) throws IOException {
        this.loadLoggingProperties();
        String key = null;
        for (Map.Entry<String, String> e : properties.entrySet()) {
            key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
            if (key == null) {
                key = e.getKey();
            }
            this.props.remove(key);
        }
        this.closePropFile("");
    }

    @Override
    public synchronized void deleteLoggingProperties(Map<String, String> properties, String targetConfigName) throws IOException {
        this.loadLoggingProperties(targetConfigName);
        String key = null;
        for (Map.Entry<String, String> e : properties.entrySet()) {
            key = LoggingXMLNames.xmltoPropsMap.get(e.getKey());
            if (key == null) {
                key = e.getKey();
            }
            this.props.remove(key);
        }
        this.closePropFile(targetConfigName);
    }

    private String getZipFileName(String sourceDir) {
        String DATE_FORMAT_NOW = "yyyy-MM-dd_HH-mm-ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String currentTime = sdf.format(cal.getTime());
        String zipFile = sourceDir + File.separator + "log_" + currentTime + ".zip";
        return zipFile;
    }

    private String getZipFileName(String sourceDir, String fileName) {
        String DATE_FORMAT_NOW = "yyyy-MM-dd_HH-mm-ss";
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
        String currentTime = sdf.format(cal.getTime());
        String zipFile = sourceDir + File.separator + fileName + "-" + currentTime + ".zip";
        return zipFile;
    }

    @Override
    public String createZipFile(String sourceDir) throws IOException {
        ZipOutputStream zout = null;
        String zipFile = this.getZipFileName(sourceDir);
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            zout = new ZipOutputStream(fout);
            File fileSource = new File(sourceDir);
            this.addDirectory(zout, fileSource, fileSource.getAbsolutePath().length() + 1);
            zout.close();
            this.safeCloseStream(zout);
        }
        catch (IOException ioe) {
            try {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                this.safeCloseStream(zout);
                throw throwable;
            }
        }
        return zipFile;
    }

    public String createZipFile(String sourceDir, String zipFileName) throws IOException {
        ZipOutputStream zout = null;
        String zipFile = this.getZipFileName(sourceDir, zipFileName);
        try {
            FileOutputStream fout = new FileOutputStream(zipFile);
            zout = new ZipOutputStream(fout);
            File fileSource = new File(sourceDir);
            this.addDirectory(zout, fileSource, fileSource.getAbsolutePath().length() + 1);
            zout.close();
            this.safeCloseStream(zout);
        }
        catch (IOException ioe) {
            try {
                Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
                throw ioe;
            }
            catch (Throwable throwable) {
                this.safeCloseStream(zout);
                throw throwable;
            }
        }
        return zipFile;
    }

    private void addDirectory(ZipOutputStream zout, File fileSource, int ignoreLength) throws IOException {
        File[] files = fileSource.listFiles();
        FileInputStream fin = null;
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                this.addDirectory(zout, files[i], ignoreLength);
                continue;
            }
            if (files[i].getAbsolutePath().contains(".zip")) continue;
            try {
                int length;
                byte[] buffer = new byte[1024];
                fin = new FileInputStream(files[i].getAbsolutePath());
                zout.putNextEntry(new ZipEntry(ignoreLength > -1 ? files[i].getAbsolutePath().substring(ignoreLength) : files[i].getAbsolutePath()));
                while ((length = fin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
                zout.closeEntry();
                this.safeCloseStream(fin);
                continue;
            }
            catch (IOException ioe) {
                try {
                    Logger.getAnonymousLogger().log(Level.SEVERE, "Error while creating zip file :", ioe);
                    throw ioe;
                }
                catch (Throwable throwable) {
                    this.safeCloseStream(fin);
                    throw throwable;
                }
            }
        }
    }

    public synchronized String getLoggingFileDetails() throws IOException {
        this.loadLoggingProperties();
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            if (key == null || !key.equals("com.sun.enterprise.server.logging.GFFileHandler.file")) continue;
            return this.props.getProperty(key);
        }
        return null;
    }

    public synchronized String getLoggingFileDetails(String targetConfigName) throws IOException {
        this.loadLoggingProperties(targetConfigName);
        Enumeration<?> e = this.props.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            if (key == null || !key.equals("com.sun.enterprise.server.logging.GFFileHandler.file")) continue;
            return this.props.getProperty(key);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getDefaultLoggingProperties() throws IOException {
        FileInputStream fisForLoggingTemplate = null;
        Properties propsLoggingTempleate = new Properties();
        HashMap<String, String> m = new HashMap<String, String>();
        try {
            File loggingTemplateFile = new File(this.env.getConfigDirPath(), "default-logging.properties");
            fisForLoggingTemplate = new FileInputStream(loggingTemplateFile);
            propsLoggingTempleate.load(fisForLoggingTemplate);
            this.safeCloseStream(fisForLoggingTemplate);
        }
        catch (Throwable throwable) {
            this.safeCloseStream(fisForLoggingTemplate);
            throw throwable;
        }
        Enumeration<?> e = propsLoggingTempleate.propertyNames();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            if (LoggingXMLNames.xmltoPropsMap.get(key) != null) {
                key = LoggingXMLNames.xmltoPropsMap.get(key);
            }
            m.put(key, propsLoggingTempleate.getProperty(key));
        }
        return m;
    }
}

