/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.io.SmartFile;
import com.sun.enterprise.universal.process.KillNotPossibleException;
import com.sun.enterprise.universal.process.KillTimeoutException;
import com.sun.enterprise.util.HostAndPort;
import com.sun.enterprise.util.OS;
import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.FileUtils;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Optional;
import java.util.function.Supplier;

public final class ProcessUtils {
    private static final System.Logger LOG = System.getLogger(ProcessUtils.class.getName());
    private static final int SOCKET_TIMEOUT = 5000;
    private static final String[] PATH = ProcessUtils.getSystemPath();

    private ProcessUtils() {
    }

    public static File getExe(String name) {
        for (String path : PATH) {
            File f = new File(path + "/" + name);
            if (!f.canExecute()) continue;
            return SmartFile.sanitize(f);
        }
        return null;
    }

    public static void saveCurrentPid(File pidFile) throws IOException {
        FileUtils.writeStringToFile(Long.toString(ProcessHandle.current().pid()), pidFile);
    }

    public static boolean isAlive(File pidFile) {
        long pid;
        if (!pidFile.exists()) {
            return false;
        }
        try {
            pid = ProcessUtils.loadPid(pidFile);
        }
        catch (Exception e) {
            LOG.log(System.Logger.Level.TRACE, "Could not load the pid file " + pidFile + ", therefore we assume that the process stopped.", (Throwable)e);
            return false;
        }
        return ProcessUtils.isAlive(pid);
    }

    public static boolean isAlive(long pid) {
        Optional<ProcessHandle> handle = ProcessHandle.of(pid);
        if (handle.isEmpty()) {
            return false;
        }
        if (!handle.get().isAlive()) {
            return false;
        }
        ProcessHandle.Info info = handle.get().info();
        if (!(!info.commandLine().isEmpty() || OS.isWindowsForSure() && info.command().isPresent())) {
            LOG.log(System.Logger.Level.TRACE, "Could not retrieve command line for the pid {0}, therefore we assume that the process stopped.");
            return false;
        }
        return true;
    }

    public static long loadPid(File pidFile) throws IllegalArgumentException {
        try {
            return Long.parseLong(FileUtils.readSmallFile(pidFile).trim());
        }
        catch (IOException | NumberFormatException e) {
            throw new IllegalArgumentException("Could not parse the PID file: " + pidFile, e);
        }
    }

    public static boolean isListening(HostAndPort endpoint) {
        boolean bl;
        Socket server = new Socket();
        try {
            server.connect(new InetSocketAddress(endpoint.getHost(), endpoint.getPort()), 5000);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    server.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                LOG.log(System.Logger.Level.TRACE, "An attempt to open a socket to " + endpoint + " resulted in exception. Therefore we assume the server has stopped.", (Throwable)ex);
                return false;
            }
        }
        server.close();
        return bl;
    }

    public static void kill(File pidFile, File watchedPidFile, Duration timeout, boolean printDots) throws KillNotPossibleException, KillTimeoutException {
        LOG.log(System.Logger.Level.DEBUG, "kill(pidFile={0}, watchedPidFile={1}, timeout={2}, printDots={3})", pidFile, watchedPidFile, timeout, printDots);
        if (!pidFile.exists()) {
            return;
        }
        long pid = ProcessUtils.loadPid(pidFile);
        if (!ProcessUtils.isAlive(pid)) {
            LOG.log(System.Logger.Level.INFO, "Process with pid {0} has already stopped.", pid);
            return;
        }
        Optional<ProcessHandle> handleOptional = ProcessHandle.of(pid);
        Optional<String> commandLine = handleOptional.get().info().commandLine();
        LOG.log(System.Logger.Level.INFO, "Killing process with pid {0} and command line {1}", pid, commandLine);
        if (!handleOptional.get().destroyForcibly()) {
            if (ProcessUtils.isAlive(pid)) {
                throw new KillNotPossibleException("It wasn't possible to destroy the process with pid=" + pid + ". Check your system permissions.");
            }
            return;
        }
        Supplier<Boolean> deathSign = () -> !ProcessUtils.isAlive(pid) || !Files.exists(watchedPidFile.toPath(), new LinkOption[0]);
        if (!ProcessUtils.waitFor(deathSign, timeout, printDots)) {
            throw new KillTimeoutException(MessageFormat.format("The process {0} was killed, but it is still alive after timeout {1} s.", pid, timeout.getSeconds()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean waitFor(Supplier<Boolean> sign, Duration timeout, boolean printDots) {
        boolean bl;
        Instant start;
        block8: {
            boolean bl2;
            block9: {
                LOG.log(System.Logger.Level.DEBUG, "waitFor(sign={0}, timeout={1}, printDots={2})", sign, timeout, printDots);
                start = Instant.now();
                try {
                    Instant deadline = start.plus(timeout);
                    Instant nextDot = start;
                    while (Instant.now().isBefore(deadline)) {
                        Instant now;
                        if (sign.get().booleanValue()) {
                            bl = true;
                            if (printDots) {
                                System.out.println();
                            }
                            break block8;
                        }
                        if (printDots && (now = Instant.now()).isAfter(nextDot)) {
                            nextDot = now.plusSeconds(1L);
                            System.out.print(".");
                            System.out.flush();
                        }
                        Thread.yield();
                    }
                    bl2 = false;
                    if (!printDots) break block9;
                    System.out.println();
                }
                catch (Throwable throwable) {
                    if (printDots) {
                        System.out.println();
                    }
                    LOG.log(System.Logger.Level.INFO, "Waiting finished after {0} ms.", Duration.between(start, Instant.now()).toMillis());
                    throw throwable;
                }
            }
            LOG.log(System.Logger.Level.INFO, "Waiting finished after {0} ms.", Duration.between(start, Instant.now()).toMillis());
            return bl2;
        }
        LOG.log(System.Logger.Level.INFO, "Waiting finished after {0} ms.", Duration.between(start, Instant.now()).toMillis());
        return bl;
    }

    private static String[] getSystemPath() {
        String tempPaths;
        if (OS.isWindows()) {
            tempPaths = System.getenv("Path");
            if (!StringUtils.ok(tempPaths)) {
                tempPaths = System.getenv("PATH");
            }
        } else {
            tempPaths = System.getenv("PATH");
        }
        if (StringUtils.ok(tempPaths)) {
            return tempPaths.split(File.pathSeparator);
        }
        return new String[0];
    }
}

