/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.server.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class Version {
    private static final String KEY_PRODUCT_NAME = "product.name";
    private static final String KEY_PRODUCT_NAME_ABBREVIATION = "product.name.abbreviation";
    private static final String KEY_PRODUCT_VERSION = "product.version";
    private static final String KEY_GIT_BRANCH = "product.build.git.branch";
    private static final String KEY_GIT_COMMIT = "product.build.git.commit";
    private static final String KEY_BUILD_TIMESTAMP = "product.build.timestamp";
    private static final String KEY_BASED_ON = "based.on";
    private static final String KEY_ADMIN_COMMAND_NAME = "admin.command.name";
    private static final String KEY_DOMAIN_TEMPLATE_DEFAULTJARFILENAME = "domain.template.defaultJarFileName";
    private static final String KEY_DOMAIN_DEFAULT_ADMIN_GROUPS = "domain.admin.groups";
    private static final List<Properties> VERSION_PROPERTIES;
    private static final Map<String, Properties> VERSION_PROPERTIES_MAP;
    private static final Properties PROPERTIES;
    private static final String PRODUCT_NAME;
    private static final String PRODUCT_NAME_ABBREVIATION;
    private static final String VERSION;
    private static final String VERSION_RELEASE;
    private static final int VERSION_MAJOR;
    private static final int VERSION_MINOR;
    private static final int VERSION_PATCH;
    private static final String GIT_BRANCH;
    private static final String COMMIT;
    private static final Instant BUILD_TIMESTAMP;

    public static String getVersion() {
        return VERSION;
    }

    public static String getVersionNumber() {
        return VERSION_RELEASE;
    }

    public static String getProductId() {
        return Version.getProductName() + " " + Version.getVersionNumber();
    }

    public static String getProductIdInfo() {
        return Version.getProductName() + " " + Version.getVersion() + " (branch: " + GIT_BRANCH + ", commit: " + COMMIT + ", timestamp: " + BUILD_TIMESTAMP + ")";
    }

    public static int getMajorVersion() {
        return VERSION_MAJOR;
    }

    public static int getMinorVersion() {
        return VERSION_MINOR;
    }

    public static int getPatchVersion() {
        return VERSION_PATCH;
    }

    public static String getProductName() {
        return PRODUCT_NAME;
    }

    public static String getProductNameAbbreviation() {
        return PRODUCT_NAME_ABBREVIATION;
    }

    public static String getAdminClientCommandName() {
        return Version.getProperty(KEY_ADMIN_COMMAND_NAME, "nadmin");
    }

    public static String getDomainTemplateDefaultJarFileName() {
        return Version.getProperty(KEY_DOMAIN_TEMPLATE_DEFAULTJARFILENAME, "nucleus-domain.jar");
    }

    public static String getDomainDefaultAdminGroups() {
        return Version.getProperty(KEY_DOMAIN_DEFAULT_ADMIN_GROUPS, "asadmin");
    }

    private static String getProperty(String key, String def) {
        return Version.getProperty(PROPERTIES, key, def);
    }

    private static String getProperty(Properties p, String key, String def) {
        Properties bp;
        if (p == null) {
            return def;
        }
        String v = p.getProperty(key);
        if (v != null) {
            return v;
        }
        String basedon = p.getProperty(KEY_BASED_ON);
        if (basedon != null && (bp = VERSION_PROPERTIES_MAP.get(basedon)) != null) {
            return Version.getProperty(bp, key, def);
        }
        return def;
    }

    private static Properties loadVersionProp() {
        String installRoot = System.getProperty("com.sun.aas.installRoot");
        if (installRoot == null) {
            System.out.println("installRoot is null");
            return null;
        }
        File directory = new File(installRoot).toPath().resolve(Path.of("config", "branding")).toFile();
        if (directory.isDirectory()) {
            for (File file : directory.listFiles(f1 -> f1.getName().endsWith(".properties") && f1.canRead())) {
                try (FileReader fr = new FileReader(file);){
                    Properties p = new Properties();
                    p.load(fr);
                    VERSION_PROPERTIES.add(p);
                    String shortName = p.getProperty(KEY_PRODUCT_NAME_ABBREVIATION);
                    if (shortName == null) continue;
                    VERSION_PROPERTIES_MAP.put(shortName, p);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        Comparator comparator = (p1, p2) -> {
            String abp1 = p1.getProperty(KEY_PRODUCT_NAME_ABBREVIATION);
            String bo1 = p1.getProperty(KEY_BASED_ON);
            String abp2 = p2.getProperty(KEY_PRODUCT_NAME_ABBREVIATION);
            String bo2 = p2.getProperty(KEY_BASED_ON);
            if (bo1 != null && abp2 != null && bo1.contains(abp2)) {
                return -1;
            }
            if (bo2 != null && abp1 != null && bo2.contains(abp1)) {
                return 1;
            }
            return 0;
        };
        Collections.sort(VERSION_PROPERTIES, comparator);
        return VERSION_PROPERTIES.isEmpty() ? null : VERSION_PROPERTIES.get(0);
    }

    private static int parseInt(String source, int defaultValue) {
        try {
            return Integer.parseInt(source);
        }
        catch (Exception e) {
            return 0;
        }
    }

    static {
        int suffixStart;
        int dotBeforeMinor;
        VERSION_PROPERTIES = new ArrayList<Properties>();
        VERSION_PROPERTIES_MAP = new HashMap<String, Properties>();
        PROPERTIES = Version.loadVersionProp();
        PRODUCT_NAME = Version.getProperty(KEY_PRODUCT_NAME, "GlassFish");
        PRODUCT_NAME_ABBREVIATION = Version.getProperty(KEY_PRODUCT_NAME_ABBREVIATION, "GF");
        VERSION = Version.getProperty(KEY_PRODUCT_VERSION, "");
        int dotBeforePatch = VERSION.indexOf(46, (dotBeforeMinor = VERSION.indexOf(46)) + 2);
        int n = dotBeforePatch > 0 ? dotBeforePatch + 1 : (suffixStart = dotBeforeMinor > 0 ? dotBeforeMinor + 1 : 0);
        while (suffixStart < VERSION.length() && Character.isDigit(VERSION.charAt(suffixStart))) {
            ++suffixStart;
        }
        if (dotBeforeMinor > 0) {
            VERSION_MAJOR = Version.parseInt(VERSION.substring(0, dotBeforeMinor), 0);
            if (dotBeforePatch > dotBeforeMinor) {
                VERSION_MINOR = Version.parseInt(VERSION.substring(dotBeforeMinor + 1, dotBeforePatch), 0);
                VERSION_PATCH = suffixStart > dotBeforePatch ? Version.parseInt(VERSION.substring(dotBeforePatch + 1, suffixStart), 0) : Version.parseInt(VERSION.substring(dotBeforePatch + 1), 0);
            } else {
                VERSION_MINOR = suffixStart > dotBeforeMinor ? Version.parseInt(VERSION.substring(dotBeforeMinor + 1, suffixStart), 0) : Version.parseInt(VERSION.substring(dotBeforeMinor + 1), 0);
                VERSION_PATCH = 0;
            }
        } else {
            VERSION_MAJOR = suffixStart > 0 ? Version.parseInt(VERSION.substring(0, suffixStart), 0) : Version.parseInt(VERSION, 0);
            VERSION_MINOR = 0;
            VERSION_PATCH = 0;
        }
        VERSION_RELEASE = Integer.toString(VERSION_MAJOR) + "." + Integer.toString(VERSION_MINOR) + "." + Integer.toString(VERSION_PATCH);
        GIT_BRANCH = Version.getProperty(KEY_GIT_BRANCH, null);
        COMMIT = Version.getProperty(KEY_GIT_COMMIT, null);
        String timestamp = Version.getProperty(KEY_BUILD_TIMESTAMP, null);
        BUILD_TIMESTAMP = timestamp == null ? null : Instant.parse(timestamp);
    }
}

