/*
 * Decompiled with CFR 0.152.
 */
package com.sun.appserv.management.client.prefs;

import com.sun.appserv.management.client.prefs.LoginInfo;
import com.sun.appserv.management.client.prefs.LoginInfoStore;
import com.sun.appserv.management.client.prefs.StoreException;
import com.sun.enterprise.security.store.AsadminSecurityUtil;
import com.sun.enterprise.universal.GFBase64Decoder;
import com.sun.enterprise.universal.GFBase64Encoder;
import com.sun.enterprise.util.Utility;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class MemoryHashLoginInfoStore
implements LoginInfoStore {
    private static final String DEFAULT_STORE_NAME = "pass";
    private static final GFBase64Encoder encoder = new GFBase64Encoder();
    private static final GFBase64Decoder decoder = new GFBase64Decoder();
    private Map<HostPortKey, LoginInfo> state;
    private final File store;

    public MemoryHashLoginInfoStore() throws StoreException {
        BufferedReader br = null;
        BufferedWriter bw = null;
        try {
            this.store = new File(AsadminSecurityUtil.GF_CLIENT_DIR, DEFAULT_STORE_NAME);
            if (this.store.createNewFile()) {
                bw = new BufferedWriter(new FileWriter(this.store));
                FileMapTransform.writePreamble(bw);
                this.state = new HashMap<HostPortKey, LoginInfo>();
            } else {
                br = new BufferedReader(new FileReader(this.store));
                this.state = FileMapTransform.readAll(br);
            }
        }
        catch (Exception e) {
            throw new StoreException(e);
        }
        finally {
            try {
                if (br != null) {
                    br.close();
                }
            }
            catch (Exception exception) {}
            try {
                if (bw != null) {
                    bw.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void store(LoginInfo login) throws StoreException {
        this.store(login, false);
    }

    @Override
    public void store(LoginInfo login, boolean overwrite) throws StoreException {
        if (login == null) {
            throw new IllegalArgumentException("null_arg");
        }
        String host = login.getHost();
        int port = login.getPort();
        if (!overwrite && this.exists(host, port)) {
            throw new StoreException("Login exists for host: " + host + " port: " + port);
        }
        HostPortKey key = new HostPortKey(host, port);
        LoginInfo old = this.state.get(key);
        this.state.put(key, login);
        this.commit(key, old);
        this.protect();
    }

    @Override
    public void remove(String host, int port) {
        HostPortKey key = new HostPortKey(host, port);
        LoginInfo gone = this.state.remove(key);
        this.commit(key, gone);
    }

    @Override
    public LoginInfo read(String host, int port) {
        HostPortKey key = new HostPortKey(host, port);
        LoginInfo login = this.state.get(key);
        return login;
    }

    @Override
    public boolean exists(String host, int port) {
        HostPortKey key = new HostPortKey(host, port);
        boolean exists = this.state.containsKey(key);
        return exists;
    }

    @Override
    public int size() {
        return this.state.size();
    }

    @Override
    public Collection<LoginInfo> list() {
        Collection<LoginInfo> logins = this.state.values();
        return Collections.unmodifiableCollection(logins);
    }

    @Override
    public String getName() {
        return this.store.getAbsoluteFile().getAbsolutePath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void commit(HostPortKey key, LoginInfo old) {
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(this.store));
            FileMapTransform.writeAll(this.state.values(), writer);
        }
        catch (Exception e) {
            this.state.put(key, old);
            try {
                if (old != null) {
                    writer = new BufferedWriter(new FileWriter(this.store));
                    FileMapTransform.writeAll(this.state.values(), writer);
                }
            }
            catch (Exception ae) {
                throw new RuntimeException("catastrophe, can't write it to file");
            }
        }
        finally {
            try {
                writer.close();
            }
            catch (Exception exception) {}
        }
    }

    private void protect() {
        try {
            if (this.store == null || !this.store.exists()) {
                return;
            }
            ProcessBuilder pb = new ProcessBuilder("chmod", "0600", this.store.getAbsolutePath());
            pb.start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class FileMapTransform {
        private FileMapTransform() {
        }

        static Map<HostPortKey, LoginInfo> readAll(BufferedReader reader) throws IOException, URISyntaxException {
            String line;
            HashMap<HostPortKey, LoginInfo> map = new HashMap<HostPortKey, LoginInfo>();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                int si = line.indexOf(32);
                if (si == -1) {
                    throw new IOException("Error: invalid record: " + line);
                }
                URI uri = new URI(line.substring(0, si));
                String encp = line.substring(si + 1, line.length());
                HostPortKey key = FileMapTransform.uri2Key(uri);
                LoginInfo value = FileMapTransform.line2LoginInfo(uri, encp);
                map.put(key, value);
            }
            return map;
        }

        static void writeAll(Collection<LoginInfo> logins, BufferedWriter writer) throws IOException, URISyntaxException {
            FileMapTransform.writePreamble(writer);
            ArrayList<LoginInfo> list = new ArrayList<LoginInfo>(logins);
            Collections.sort(list);
            for (LoginInfo login : list) {
                FileMapTransform.writeOne(login, writer);
            }
        }

        private static void writeOne(LoginInfo login, BufferedWriter writer) throws IOException, URISyntaxException {
            writer.write(FileMapTransform.login2Line(login));
            writer.newLine();
        }

        static HostPortKey uri2Key(URI uri) {
            String host = uri.getHost();
            int port = uri.getPort();
            HostPortKey key = new HostPortKey(host, port);
            return key;
        }

        static LoginInfo line2LoginInfo(URI uri, String encp) throws IOException {
            String host = uri.getHost();
            int port = uri.getPort();
            String user = uri.getUserInfo();
            char[] password = Utility.convertByteArrayToCharArray(decoder.decodeBuffer(encp), null);
            return new LoginInfo(host, port, user, password);
        }

        static String login2Line(LoginInfo login) throws IOException, URISyntaxException {
            String scheme = "asadmin";
            String host = login.getHost();
            int port = login.getPort();
            String user = login.getUser();
            URI uri = new URI("asadmin", user, host, port, null, null, null);
            char[] password = login.getPassword();
            String encp = encoder.encode(Utility.convertCharArrayToByteArray(password, null));
            String line = uri.toString() + " " + encp;
            return line;
        }

        static void writePreamble(BufferedWriter bw) throws IOException {
            String preamble = "# Do not edit this file by hand. Use login interface instead.";
            bw.write("# Do not edit this file by hand. Use login interface instead.");
            bw.newLine();
        }
    }

    private static class HostPortKey {
        private final String host;
        private final int port;

        HostPortKey(String host, int port) {
            this.host = host;
            this.port = port;
        }

        public boolean equals(Object other) {
            boolean same = false;
            if (other instanceof HostPortKey) {
                HostPortKey that = (HostPortKey)other;
                same = this.host.equals(that.host) && this.port == that.port;
            }
            return same;
        }

        public int hashCode() {
            return 53 * this.host.hashCode() + 31 * this.port;
        }
    }
}

