/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.universal.process;

import com.sun.enterprise.universal.process.ProcessManagerException;
import com.sun.enterprise.universal.process.ProcessManagerTimeoutException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public class ProcessManager {
    private static final System.Logger LOG = System.getLogger(ProcessManager.class.getName());
    protected final ProcessBuilder builder;
    private String stdout;
    private String stderr;
    private int timeout;
    private boolean echo = true;
    private String[] stdinLines;

    public ProcessManager(String ... cmds) {
        this.builder = new ProcessBuilder(cmds);
    }

    public ProcessManager(List<String> cmdline) {
        this.builder = new ProcessBuilder(cmdline);
    }

    public void setTimeoutMsec(int num) {
        if (num > 0) {
            this.timeout = num;
        }
    }

    public void setEnvironment(String name, String value) {
        Map<String, String> env = this.builder.environment();
        env.put(name, value);
    }

    public void setWorkingDir(File directory) {
        this.builder.directory(directory);
    }

    public void setStdinLines(List<String> list) {
        if (list != null && !list.isEmpty()) {
            this.stdinLines = (String[])list.toArray(String[]::new);
        }
    }

    public void setEcho(boolean newEcho) {
        this.echo = newEcho;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int execute() throws ProcessManagerException {
        Process process;
        LOG.log(System.Logger.Level.DEBUG, "Executing command:\n  command={0}  \nenv={1}", this.builder.command(), this.builder.environment());
        try {
            process = this.builder.start();
        }
        catch (IOException e) {
            throw new IllegalStateException("Could not execute command: " + this.builder.command(), e);
        }
        ReaderThread threadErr = new ReaderThread(process.getErrorStream(), this.echo, "stderr");
        threadErr.start();
        ReaderThread threadOut = new ReaderThread(process.getInputStream(), this.echo, "stdout");
        threadOut.start();
        try {
            try {
                this.writeStdin(process);
                int n = this.await(process);
                this.stderr = threadErr.finish(1000L);
                this.stdout = threadOut.finish(1000L);
                return n;
            }
            catch (Throwable throwable) {
                try {
                    this.stderr = threadErr.finish(1000L);
                    this.stdout = threadOut.finish(1000L);
                    throw throwable;
                }
                catch (ProcessManagerException pme) {
                    throw pme;
                }
                catch (Exception e) {
                    throw new ProcessManagerException(e);
                }
            }
        }
        finally {
            if (process.isAlive()) {
                this.destroy(process);
            }
        }
    }

    private void destroy(Process process) {
        process.destroy();
        try {
            boolean exited = process.waitFor(10L, TimeUnit.SECONDS);
            if (!exited) {
                process.destroyForcibly();
            }
        }
        catch (InterruptedException e) {
            LOG.log(System.Logger.Level.INFO, "Interrupted while waiting for process to terminate", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public String getStdout() {
        return this.stdout;
    }

    public String getStderr() {
        return this.stderr;
    }

    public String toString() {
        return this.builder.command().toString();
    }

    private void writeStdin(Process process) throws ProcessManagerException {
        if (this.stdinLines == null || this.stdinLines.length == 0) {
            return;
        }
        if (process == null) {
            throw new ProcessManagerException("Parameter process was null.");
        }
        try (PrintWriter pipe = new PrintWriter(new BufferedWriter(new OutputStreamWriter(process.getOutputStream())));){
            for (String stdinLine : this.stdinLines) {
                LOG.log(System.Logger.Level.DEBUG, "InputLine --> {0} <--", stdinLine);
                pipe.println(stdinLine);
                pipe.flush();
            }
        }
        catch (Exception e) {
            throw new ProcessManagerException(e);
        }
    }

    private int await(Process process) throws InterruptedException, ProcessManagerException {
        if (this.timeout > 0) {
            if (process.waitFor(this.timeout, TimeUnit.MILLISECONDS)) {
                return process.exitValue();
            }
            throw new ProcessManagerTimeoutException("Process is still running, timeout " + this.timeout + " ms exceeded.");
        }
        return process.waitFor();
    }

    static class ReaderThread
    extends Thread {
        private final BufferedReader reader;
        private final StringBuilder sb;
        private final boolean echo;
        private final AtomicBoolean stop = new AtomicBoolean();

        ReaderThread(InputStream stream, boolean echo, String threadName) {
            this.setName(threadName);
            this.reader = new BufferedReader(new InputStreamReader(stream));
            this.sb = new StringBuilder();
            this.echo = echo;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    if (!this.reader.ready()) {
                        if (this.stop.getAcquire()) {
                            break;
                        }
                        Thread.yield();
                        continue;
                    }
                    String line = this.reader.readLine();
                    this.sb.append(line).append('\n');
                    if (!this.echo) continue;
                    System.out.println(line);
                }
            }
            catch (Exception e) {
                LOG.log(System.Logger.Level.ERROR, "ReaderThread broke ...", (Throwable)e);
            }
            finally {
                try {
                    this.reader.close();
                }
                catch (IOException e) {
                    LOG.log(System.Logger.Level.ERROR, "Failed to close BufferedReader", (Throwable)e);
                }
            }
            LOG.log(System.Logger.Level.TRACE, "ReaderThread exiting...");
        }

        public String finish(long timeout) {
            this.stop.setRelease(true);
            try {
                this.join(timeout);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.sb.toString();
        }
    }
}

