/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FelixPrettyPrinter {
    private static final Pattern BUNDLE_PATTERN = Pattern.compile("\\[(\\d+)\\]", 8);

    public static void main(String[] args) {
        System.out.println(FelixPrettyPrinter.prettyPrintExceptionMessage("Unable to resolve org.glassfish.main.webservices.connector [220](R 220.0): missing requirement [org.glassfish.main.webservices.connector [220](R 220.0)] osgi.wiring.package; (&(osgi.wiring.package=org.glassfish.web.deployment.descriptor)(version>=7.0.0)(!(version>=8.0.0))) [caused by: Unable to resolve org.glassfish.main.web.glue [124](R 124.0): missing requirement [org.glassfish.main.web.glue [124](R 124.0)] osgi.wiring.package; (&(osgi.wiring.package=com.sun.web.security)(version>=7.0.0)(!(version>=8.0.0))) [caused by: Unable to resolve org.glassfish.main.security.websecurity [229](R 229.0): missing requirement [org.glassfish.main.security.websecurity [229](R 229.0)] osgi.wiring.package; (&(osgi.wiring.package=org.apache.catalina.realm)(version>=7.0.0)(!(version>=8.0.0))) [caused by: Unable to resolve org.glassfish.main.web.core [36](R 36.0): missing requirement [org.glassfish.main.web.core [36](R 36.0)] osgi.wiring.package; (&(osgi.wiring.package=org.hibernate.validator.cdi)(version>=8.0.0)(!(version>=9.0.0))) [caused by: Unable to resolve org.hibernate.validator.cdi [97](R 97.0): missing requirement [org.hibernate.validator.cdi [97](R 97.0)] osgi.wiring.host; (&(osgi.wiring.host=org.hibernate.validator)(bundle-version>=0.0.0))]]]] Unresolved requirements: [[org.glassfish.main.webservices.connector [220](R 220.0)] osgi.wiring.package; (&(osgi.wiring.package=org.glassfish.web.deployment.descriptor)(version>=7.0.0)(!(version>=8.0.0)))]"));
    }

    public static String prettyPrintExceptionMessage(String message) {
        StringBuilder messageBuilder = new StringBuilder(256);
        try {
            int index = message.indexOf("Unable to resolve");
            int indent = 0;
            while (index >= 0) {
                FelixPrettyPrinter.printLn(messageBuilder, indent, "Unable to resolve");
                int index2 = message.indexOf("missing requirement", index += "Unable to resolve".length());
                if (index2 >= 0) {
                    boolean isPackage;
                    ++indent;
                    String module = message.substring(index, index2);
                    if (module.contains("(R")) {
                        module = module.substring(0, module.indexOf("(R"));
                    }
                    FelixPrettyPrinter.printLn(messageBuilder, indent, module);
                    FelixPrettyPrinter.printLn(messageBuilder, indent, "missing requirement");
                    index = index2 + "missing requirement".length();
                    int indexPackage = message.indexOf("osgi.wiring.package; ", index);
                    int indexHost = message.indexOf("osgi.wiring.host; ", index);
                    if (indexHost == -1 || indexPackage < indexHost) {
                        index = indexPackage;
                        isPackage = true;
                    } else {
                        index = indexHost;
                        isPackage = false;
                    }
                    if (index >= 0) {
                        ++indent;
                        if (isPackage) {
                            index2 = message.indexOf(" ", index += "osgi.wiring.package; ".length());
                            String packageAndVersion = null;
                            packageAndVersion = index2 != -1 ? message.substring(index, index2) : message.substring(index);
                            packageAndVersion = packageAndVersion.replace("osgi.wiring.package", "package");
                            packageAndVersion = packageAndVersion.replace(")(", ") (");
                            packageAndVersion = packageAndVersion.replace("=", " = ");
                            packageAndVersion = packageAndVersion.replace("> =", " >=");
                            if ((packageAndVersion = packageAndVersion.replace("< =", " <=")).startsWith("(")) {
                                packageAndVersion = packageAndVersion.substring(1);
                            }
                            if (packageAndVersion.endsWith(")")) {
                                packageAndVersion = packageAndVersion.substring(0, packageAndVersion.length() - 1);
                            }
                            FelixPrettyPrinter.printLn(messageBuilder, indent, packageAndVersion);
                        } else {
                            index2 = message.indexOf("]", index += "osgi.wiring.host; ".length());
                            String remainder = null;
                            remainder = index2 != -1 ? message.substring(index, index2) : message.substring(index);
                            FelixPrettyPrinter.printLn(messageBuilder, indent, remainder);
                        }
                        index = message.indexOf("caused by: ", index2);
                        if (index >= 0) {
                            FelixPrettyPrinter.printLn(messageBuilder, indent, "caused by:");
                            ++indent;
                            index += "caused by: ".length();
                        }
                    }
                }
                if (index2 == -1) {
                    index = -1;
                    continue;
                }
                index = index2;
                index = message.indexOf("Unable to resolve", index);
            }
            return messageBuilder.toString();
        }
        catch (Exception e) {
            return message;
        }
    }

    public static List<Integer> findBundleIds(String message) {
        if (message == null || message.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedHashSet<Integer> bundleIds = new LinkedHashSet<Integer>();
        Matcher bundlePattern = BUNDLE_PATTERN.matcher(message);
        while (bundlePattern.find()) {
            String number = bundlePattern.group(1);
            bundleIds.add(Integer.valueOf(number));
        }
        return new ArrayList<Integer>(bundleIds);
    }

    private static void printLn(StringBuilder messageBuilder, int indent, String message) {
        for (int i = 0; i < indent * 4; ++i) {
            messageBuilder.append(" ");
        }
        messageBuilder.append(message.trim()).append("\n");
    }
}

