/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.util.io;

import com.sun.enterprise.util.StringUtils;
import com.sun.enterprise.util.io.ServerDirs;
import com.sun.enterprise.util.io.Strings;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;

public final class InstanceDirs {
    private final ServerDirs dirs;

    public InstanceDirs(File theInstanceDir) throws IOException {
        this.dirs = new ServerDirs(theInstanceDir);
        if (this.dirs.getServerGrandParentDir() == null) {
            throw new IOException(ServerDirs.strings.get("InstanceDirs.noGrandParent", this.dirs.getServerDir()));
        }
    }

    public InstanceDirs(String nodeDirParentPath, String nodeDirName, String instanceName) throws IOException {
        File nodeDirParent;
        if (!StringUtils.ok(nodeDirParentPath)) {
            nodeDirParentPath = this.getNodeDirRootDefault();
        }
        if (!(nodeDirParent = new File(nodeDirParentPath)).isDirectory()) {
            this.dirs = null;
            throw new IOException(Strings.get("InstanceDirs.noNodeParent"));
        }
        File nodeDir = StringUtils.ok(nodeDirName) ? new File(nodeDirParent, nodeDirName) : this.getTheOneAndOnlyNode(nodeDirParent);
        if (!nodeDir.isDirectory()) {
            this.dirs = null;
            throw new IOException(Strings.get("InstanceDirs.badNodeDir", nodeDir));
        }
        File instanceDir = StringUtils.ok(instanceName) ? new File(nodeDir, instanceName) : this.getTheOneAndOnlyInstance(nodeDir);
        if (!instanceDir.isDirectory()) {
            this.dirs = null;
            throw new IOException(Strings.get("InstanceDirs.badInstanceDir", instanceDir));
        }
        this.dirs = new ServerDirs(instanceDir);
    }

    private File getTheOneAndOnlyNode(File parent) throws IOException {
        File[] files = parent.listFiles(new FileFilter(this){

            @Override
            public boolean accept(File f) {
                return f != null && f.isDirectory();
            }
        });
        if (files == null || files.length < 1) {
            throw new IOException(Strings.get("InstanceDirs.noNodes", parent));
        }
        if (files.length > 1) {
            throw new IOException(Strings.get("InstanceDirs.tooManyNodes", parent, files.length));
        }
        return files[0];
    }

    private File getTheOneAndOnlyInstance(File nodeDir) throws IOException {
        File[] files = nodeDir.listFiles(new FileFilter(this){

            @Override
            public boolean accept(File f) {
                return f != null && f.isDirectory() && !"agent".equals(f.getName());
            }
        });
        if (files == null || files.length < 1) {
            throw new IOException(Strings.get("InstanceDirs.noInstances", nodeDir));
        }
        if (files.length > 1) {
            throw new IOException(Strings.get("InstanceDirs.tooManyInstances", files.length, nodeDir));
        }
        return files[0];
    }

    private String getNodeDirRootDefault() throws IOException {
        String nodeDirDefault = System.getProperty("com.sun.aas.agentRoot");
        if (StringUtils.ok(nodeDirDefault)) {
            return nodeDirDefault;
        }
        String installRootPath = this.getInstallRootPath();
        return installRootPath + "/nodes";
    }

    protected String getInstallRootPath() throws IOException {
        String installRootPath = System.getProperty("com.sun.aas.installRoot");
        if (!StringUtils.ok(installRootPath)) {
            throw new IOException("noInstallDirPath");
        }
        return installRootPath;
    }

    public InstanceDirs(ServerDirs sd) {
        this.dirs = sd;
    }

    public final String getInstanceName() {
        return this.dirs.getServerName();
    }

    public final File getInstanceDir() {
        return this.dirs.getServerDir();
    }

    public final File getNodeAgentDir() {
        return this.dirs.getServerParentDir();
    }

    public final File getNodeAgentsDir() {
        return this.dirs.getServerGrandParentDir();
    }

    public final ServerDirs getServerDirs() {
        return this.dirs;
    }

    public final File getDasPropertiesFile() {
        return this.dirs.getDasPropertiesFile();
    }
}

