/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.appserv.connectors.internal.api.ConnectorsUtil;
import com.sun.enterprise.container.common.impl.EntityManagerWrapper;
import com.sun.enterprise.container.common.impl.FactoryForEntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.spi.EjbNamingReferenceManager;
import com.sun.enterprise.container.common.spi.WebServiceReferenceManager;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.AdministeredObjectDefinitionDescriptor;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.ConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.DataSourceDefinitionDescriptor;
import com.sun.enterprise.deployment.EjbReferenceDescriptor;
import com.sun.enterprise.deployment.EntityManagerReferenceDescriptor;
import com.sun.enterprise.deployment.EnvironmentProperty;
import com.sun.enterprise.deployment.JMSConnectionFactoryDefinitionDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.MailSessionDescriptor;
import com.sun.enterprise.deployment.ManagedBeanDescriptor;
import com.sun.enterprise.deployment.MessageDestinationReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceDescriptor;
import com.sun.enterprise.deployment.ResourceEnvReferenceDescriptor;
import com.sun.enterprise.deployment.ResourceReferenceDescriptor;
import com.sun.enterprise.deployment.ServiceReferenceDescriptor;
import com.sun.enterprise.deployment.util.DOLUtils;
import com.sun.enterprise.naming.spi.NamingObjectFactory;
import com.sun.enterprise.naming.spi.NamingUtils;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.transaction.TransactionManager;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorContext;
import javax.validation.ValidatorFactory;
import org.glassfish.api.admin.ProcessEnvironment;
import org.glassfish.api.invocation.ApplicationEnvironment;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.api.naming.ComponentNamingUtil;
import org.glassfish.api.naming.GlassfishNamingManager;
import org.glassfish.api.naming.JNDIBinding;
import org.glassfish.api.naming.NamingObjectProxy;
import org.glassfish.deployment.common.Descriptor;
import org.glassfish.deployment.common.JavaEEResourceType;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.javaee.services.CommonResourceProxy;
import org.glassfish.javaee.services.JMSCFResourcePMProxy;
import org.glassfish.resourcebase.resources.api.ResourceDeployer;
import org.glassfish.resourcebase.resources.util.ResourceManagerFactory;
import org.jvnet.hk2.annotations.Service;

@Service
public class ComponentEnvManagerImpl
implements ComponentEnvManager {
    private static final String JAVA_COLON = "java:";
    private static final String JAVA_COMP_ENV_STRING = "java:comp/env/";
    private static final String JAVA_COMP_PREFIX = "java:comp/";
    private static final String JAVA_MODULE_PREFIX = "java:module/";
    private static final String JAVA_APP_PREFIX = "java:app/";
    private static final String JAVA_GLOBAL_PREFIX = "java:global/";
    @Inject
    private ServiceLocator locator;
    @Inject
    private Logger _logger;
    @Inject
    GlassfishNamingManager namingManager;
    @Inject
    ComponentNamingUtil componentNamingUtil;
    @Inject
    private transient CallFlowAgent callFlowAgent;
    @Inject
    private transient TransactionManager txManager;
    @Inject
    private ProcessEnvironment processEnv;
    @Inject
    private NamingUtils namingUtils;
    @Inject
    private InvocationManager invMgr;
    private ConcurrentMap<String, RefCountJndiNameEnvironment> compId2Env = new ConcurrentHashMap<String, RefCountJndiNameEnvironment>();

    public void register(String componentId, JndiNameEnvironment env) {
        RefCountJndiNameEnvironment nrj = new RefCountJndiNameEnvironment(env);
        RefCountJndiNameEnvironment rj = this.compId2Env.putIfAbsent(componentId, nrj);
        if (rj != null) {
            rj.refcnt.incrementAndGet();
        }
    }

    public void unregister(String componentId) {
        RefCountJndiNameEnvironment rj = (RefCountJndiNameEnvironment)this.compId2Env.get(componentId);
        if (rj != null && rj.refcnt.decrementAndGet() == 0) {
            this.compId2Env.remove(componentId);
        }
    }

    @Override
    public JndiNameEnvironment getJndiNameEnvironment(String componentId) {
        RefCountJndiNameEnvironment rj = (RefCountJndiNameEnvironment)this.compId2Env.get(componentId);
        if (componentId != null && this._logger.isLoggable(Level.FINEST)) {
            this._logger.finest("ComponentEnvManagerImpl: getJndiNameEnvironment " + componentId + " is " + (rj == null ? "NULL" : rj.env.getClass().toString()));
        }
        return rj == null ? null : rj.env;
    }

    @Override
    public JndiNameEnvironment getCurrentJndiNameEnvironment() {
        JndiNameEnvironment desc = null;
        ComponentInvocation inv = this.invMgr.getCurrentInvocation();
        if (inv != null && inv.componentId != null) {
            desc = this.getJndiNameEnvironment(inv.componentId);
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("ComponentEnvManagerImpl: getCurrentJndiNameEnvironment " + inv.componentId + " is " + desc.getClass());
            }
        }
        return desc;
    }

    @Override
    public String bindToComponentNamespace(JndiNameEnvironment env) throws NamingException {
        Application app;
        String compEnvId = this.getComponentEnvId(env);
        ArrayList<JNDIBinding> bindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(env, ScopeType.COMPONENT, bindings);
        this.addJNDIBindings(env, ScopeType.MODULE, bindings);
        if (!(env instanceof ApplicationClientDescriptor)) {
            this.addJNDIBindings(env, ScopeType.APP, bindings);
        }
        if (env instanceof Application) {
            app = (Application)env;
            for (JndiNameEnvironment jndiNameEnvironment : app.getBundleDescriptors(ApplicationClientDescriptor.class)) {
                this.addJNDIBindings(jndiNameEnvironment, ScopeType.APP, bindings);
            }
            this.namingManager.bindToAppNamespace(DOLUtils.getApplicationName((JndiNameEnvironment)env), bindings);
        } else {
            boolean treatComponentAsModule = DOLUtils.getTreatComponentAsModule((JndiNameEnvironment)env);
            this.namingManager.bindToComponentNamespace(DOLUtils.getApplicationName((JndiNameEnvironment)env), DOLUtils.getModuleName((JndiNameEnvironment)env), compEnvId, treatComponentAsModule, bindings);
            compEnvId = this.getComponentEnvId(env);
        }
        if (!(env instanceof ApplicationClientDescriptor)) {
            ArrayList<JNDIBinding> globalBindings = new ArrayList<JNDIBinding>();
            this.addJNDIBindings(env, ScopeType.GLOBAL, globalBindings);
            if (env instanceof Application) {
                Application app2 = (Application)env;
                for (JndiNameEnvironment next : app2.getBundleDescriptors(ApplicationClientDescriptor.class)) {
                    this.addJNDIBindings(next, ScopeType.GLOBAL, globalBindings);
                }
            }
            for (JNDIBinding jNDIBinding : globalBindings) {
                this.namingManager.publishObject(jNDIBinding.getName(), jNDIBinding.getValue(), true);
            }
        }
        app = DOLUtils.getApplicationFromEnv((JndiNameEnvironment)env);
        if (!(env instanceof ApplicationClientDescriptor) && app.getBundleDescriptors(ApplicationClientDescriptor.class).size() > 0) {
            for (JNDIBinding jNDIBinding : bindings) {
                if (!this.dependencyAppliesToScope(jNDIBinding.getName(), ScopeType.APP)) continue;
                String internalGlobalJavaAppName = this.componentNamingUtil.composeInternalGlobalJavaAppName(app.getAppName(), jNDIBinding.getName());
                this.namingManager.publishObject(internalGlobalJavaAppName, jNDIBinding.getValue(), true);
            }
        }
        if (compEnvId != null) {
            if (this._logger.isLoggable(Level.FINEST)) {
                this._logger.finest("ComponentEnvManagerImpl: register " + compEnvId + " is " + env.getClass());
            }
            this.register(compEnvId, env);
        }
        return compEnvId;
    }

    @Override
    public void addToComponentNamespace(JndiNameEnvironment origEnv, Collection<EnvironmentProperty> envProps, Collection<ResourceReferenceDescriptor> resRefs) throws NamingException {
        String compEnvId = this.getComponentEnvId(origEnv);
        ArrayList<JNDIBinding> bindings = new ArrayList<JNDIBinding>();
        this.addEnvironmentProperties(ScopeType.COMPONENT, envProps.iterator(), bindings);
        this.addResourceReferences(ScopeType.COMPONENT, resRefs.iterator(), bindings);
        boolean treatComponentAsModule = DOLUtils.getTreatComponentAsModule((JndiNameEnvironment)origEnv);
        this.namingManager.bindToComponentNamespace(DOLUtils.getApplicationName((JndiNameEnvironment)origEnv), DOLUtils.getModuleName((JndiNameEnvironment)origEnv), compEnvId, treatComponentAsModule, bindings);
    }

    private String getResourceId(JndiNameEnvironment env, Descriptor desc) {
        String resourceId = "";
        if (this.dependencyAppliesToScope(desc, ScopeType.COMPONENT)) {
            resourceId = DOLUtils.getApplicationName((JndiNameEnvironment)env) + "/" + DOLUtils.getModuleName((JndiNameEnvironment)env) + "/" + this.getComponentEnvId(env);
        } else if (this.dependencyAppliesToScope(desc, ScopeType.MODULE)) {
            resourceId = DOLUtils.getApplicationName((JndiNameEnvironment)env) + "/" + DOLUtils.getModuleName((JndiNameEnvironment)env);
        } else if (this.dependencyAppliesToScope(desc, ScopeType.APP)) {
            resourceId = DOLUtils.getApplicationName((JndiNameEnvironment)env);
        }
        return resourceId;
    }

    private void addAllDescriptorBindings(JndiNameEnvironment env, ScopeType scope, Collection<JNDIBinding> jndiBindings) {
        HashSet allDescriptors = new HashSet();
        Set dsds = env.getResourceDescriptors(JavaEEResourceType.DSD);
        Set jmscfdds = env.getResourceDescriptors(JavaEEResourceType.JMSCFDD);
        Set msds = env.getResourceDescriptors(JavaEEResourceType.MSD);
        Set jmsddds = env.getResourceDescriptors(JavaEEResourceType.JMSDD);
        if (!(env instanceof ApplicationClientDescriptor)) {
            Set cfdds = env.getResourceDescriptors(JavaEEResourceType.CFD);
            allDescriptors.addAll(cfdds);
        } else {
            this._logger.fine("Do not support connection-factory in client module.");
        }
        if (!(env instanceof ApplicationClientDescriptor)) {
            Set aodd = env.getResourceDescriptors(JavaEEResourceType.AODD);
            allDescriptors.addAll(aodd);
        } else {
            this._logger.fine("Do not support administered-object in client module.");
        }
        allDescriptors.addAll(dsds);
        allDescriptors.addAll(jmscfdds);
        allDescriptors.addAll(msds);
        allDescriptors.addAll(jmsddds);
        for (ResourceDescriptor descriptor : allDescriptors) {
            if (!this.dependencyAppliesToScope((Descriptor)descriptor, scope) || descriptor.getResourceType().equals((Object)JavaEEResourceType.DSD) && ((DataSourceDefinitionDescriptor)descriptor).isDeployed()) continue;
            String resourceId = this.getResourceId(env, (Descriptor)descriptor);
            descriptor.setResourceId(resourceId);
            CommonResourceProxy proxy = (CommonResourceProxy)this.locator.getService(CommonResourceProxy.class, new Annotation[0]);
            proxy.setDescriptor(descriptor);
            String logicalJndiName = this.descriptorToLogicalJndiName((Descriptor)descriptor);
            CompEnvBinding envBinding = new CompEnvBinding(logicalJndiName, proxy);
            jndiBindings.add(envBinding);
            if (!descriptor.getResourceType().equals((Object)JavaEEResourceType.JMSCFDD)) continue;
            CommonResourceProxy jmscfProxy = (CommonResourceProxy)this.locator.getService(JMSCFResourcePMProxy.class, new Annotation[0]);
            jmscfProxy.setDescriptor(descriptor);
            CompEnvBinding jmscfEnvBinding = new CompEnvBinding(ConnectorsUtil.getPMJndiName((String)logicalJndiName), jmscfProxy);
            jndiBindings.add(jmscfEnvBinding);
        }
    }

    private ResourceDeployer getResourceDeployer(Object resource) {
        return ((ResourceManagerFactory)this.locator.getService(ResourceManagerFactory.class, new Annotation[0])).getResourceDeployer(resource);
    }

    @Override
    public void unbindFromComponentNamespace(JndiNameEnvironment env) throws NamingException {
        this.undeployAllDescriptors(env);
        ArrayList<JNDIBinding> globalBindings = new ArrayList<JNDIBinding>();
        this.addJNDIBindings(env, ScopeType.GLOBAL, globalBindings);
        for (JNDIBinding next : globalBindings) {
            this.namingManager.unpublishObject(next.getName());
        }
        Application app = DOLUtils.getApplicationFromEnv((JndiNameEnvironment)env);
        Set appClientDescs = app.getBundleDescriptors(ApplicationClientDescriptor.class);
        for (ApplicationClientDescriptor acd : appClientDescs) {
            this.undeployAllDescriptors((JndiNameEnvironment)acd);
        }
        if (!(env instanceof ApplicationClientDescriptor) && app.getBundleDescriptors(ApplicationClientDescriptor.class).size() > 0) {
            ArrayList<JNDIBinding> appBindings = new ArrayList<JNDIBinding>();
            this.addJNDIBindings(env, ScopeType.APP, appBindings);
            for (JNDIBinding next : appBindings) {
                String internalGlobalJavaAppName = this.componentNamingUtil.composeInternalGlobalJavaAppName(app.getAppName(), next.getName());
                this.namingManager.unpublishObject(internalGlobalJavaAppName);
            }
        }
        if (env instanceof Application) {
            this.namingManager.unbindAppObjects(DOLUtils.getApplicationName((JndiNameEnvironment)env));
        } else {
            String compEnvId = this.getComponentEnvId(env);
            this.namingManager.unbindComponentObjects(compEnvId);
            this.unregister(compEnvId);
        }
    }

    private void undeployAllDescriptors(JndiNameEnvironment env) {
        Set allDescriptors = env.getAllResourcesDescriptors(env.getClass());
        for (ResourceDescriptor descriptor : allDescriptors) {
            switch (descriptor.getResourceType()) {
                case DSD: {
                    DataSourceDefinitionDescriptor dataSourceDefinitionDescriptor = (DataSourceDefinitionDescriptor)descriptor;
                    if (!dataSourceDefinitionDescriptor.isDeployed() || !this.undepoyResource((Descriptor)dataSourceDefinitionDescriptor)) break;
                    dataSourceDefinitionDescriptor.setDeployed(false);
                    break;
                }
                case MSD: {
                    MailSessionDescriptor mailSessionDescriptor = (MailSessionDescriptor)descriptor;
                    if (!mailSessionDescriptor.isDeployed() || !this.undepoyResource((Descriptor)mailSessionDescriptor)) break;
                    mailSessionDescriptor.setDeployed(false);
                    break;
                }
                case CFD: {
                    ConnectionFactoryDefinitionDescriptor connectionFactoryDefinitionDescriptor = (ConnectionFactoryDefinitionDescriptor)descriptor;
                    this.undepoyResource((Descriptor)connectionFactoryDefinitionDescriptor);
                    break;
                }
                case JMSCFDD: {
                    JMSConnectionFactoryDefinitionDescriptor jmsConnectionFactoryDefinitionDescriptor = (JMSConnectionFactoryDefinitionDescriptor)descriptor;
                    this.undepoyResource((Descriptor)jmsConnectionFactoryDefinitionDescriptor);
                    break;
                }
                case AODD: {
                    AdministeredObjectDefinitionDescriptor administeredObjectDefinitionDescriptor = (AdministeredObjectDefinitionDescriptor)descriptor;
                    this.undepoyResource((Descriptor)administeredObjectDefinitionDescriptor);
                }
            }
        }
    }

    private boolean undepoyResource(Descriptor descriptor) {
        try {
            ResourceDeployer deployer = this.getResourceDeployer(descriptor);
            deployer.undeployResource((Object)descriptor);
            return true;
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Unable to undeploy Descriptor [ " + descriptor.getName() + " ] ", e);
            return false;
        }
    }

    private void addEnvironmentProperties(ScopeType scope, Iterator envItr, Collection<JNDIBinding> jndiBindings) {
        while (envItr.hasNext()) {
            EnvironmentProperty next = (EnvironmentProperty)envItr.next();
            if (!this.dependencyAppliesToScope((Descriptor)next, scope) || !next.hasAValue()) continue;
            String name = this.descriptorToLogicalJndiName((Descriptor)next);
            NamingObjectFactory value = next.hasLookupName() ? this.namingUtils.createLazyNamingObjectFactory(name, next.getLookupName(), true) : (next.getMappedName().length() > 0 ? this.namingUtils.createLazyNamingObjectFactory(name, next.getMappedName(), true) : this.namingUtils.createSimpleNamingObjectFactory(name, next.getValueObject()));
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private void addResourceReferences(ScopeType scope, Iterator resRefItr, Collection<JNDIBinding> jndiBindings) {
        while (resRefItr.hasNext()) {
            ResourceReferenceDescriptor resourceRef = (ResourceReferenceDescriptor)resRefItr.next();
            if (!this.dependencyAppliesToScope((Descriptor)resourceRef, scope)) continue;
            resourceRef.checkType();
            String name = this.descriptorToLogicalJndiName((Descriptor)resourceRef);
            Object value = null;
            String physicalJndiName = resourceRef.getJndiName();
            if (resourceRef.isURLResource()) {
                if (physicalJndiName.startsWith(JAVA_GLOBAL_PREFIX) || physicalJndiName.startsWith(JAVA_APP_PREFIX) || physicalJndiName.startsWith(JAVA_MODULE_PREFIX) || physicalJndiName.startsWith(JAVA_COMP_PREFIX)) {
                    value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
                } else {
                    try {
                        URL obj = new URL(physicalJndiName);
                        NamingObjectFactory factory = this.namingUtils.createSimpleNamingObjectFactory(name, (Object)obj);
                        value = this.namingUtils.createCloningNamingObjectFactory(name, factory);
                    }
                    catch (MalformedURLException e) {
                        value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
                    }
                }
            } else if (resourceRef.isORB()) {
                value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
            } else if (resourceRef.isWebServiceContext()) {
                WebServiceReferenceManager wsRefMgr = (WebServiceReferenceManager)this.locator.getService(WebServiceReferenceManager.class, new Annotation[0]);
                if (wsRefMgr != null) {
                    value = wsRefMgr.getWSContextObject();
                } else {
                    this._logger.log(Level.SEVERE, "Cannot find the following class to proceed with @Resource WebServiceContext" + wsRefMgr + "Please confirm if webservices module is installed ");
                }
            } else {
                value = resourceRef.isJDBCResource() || resourceRef.isJMSConnectionFactory() || resourceRef.isMailResource() || resourceRef.isResourceConnectionFactory() ? this.namingUtils.createLazyInitializationNamingObjectFactory(name, physicalJndiName, false) : this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, false);
            }
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private void addJNDIBindings(JndiNameEnvironment env, ScopeType scope, Collection<JNDIBinding> jndiBindings) {
        Object value;
        String name;
        this.addEnvironmentProperties(scope, env.getEnvironmentProperties().iterator(), jndiBindings);
        for (ResourceEnvReferenceDescriptor next : env.getResourceEnvReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            next.checkType();
            jndiBindings.add(this.getCompEnvBinding(next));
        }
        this.addAllDescriptorBindings(env, scope, jndiBindings);
        for (ResourceEnvReferenceDescriptor next : env.getEjbReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            EjbReferenceProxy proxy = new EjbReferenceProxy((EjbReferenceDescriptor)next);
            jndiBindings.add(new CompEnvBinding(name, proxy));
        }
        for (ResourceEnvReferenceDescriptor next : env.getMessageDestinationReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            jndiBindings.add(this.getCompEnvBinding((MessageDestinationReferenceDescriptor)next));
        }
        this.addResourceReferences(scope, env.getResourceReferenceDescriptors().iterator(), jndiBindings);
        for (ResourceEnvReferenceDescriptor next : env.getEntityManagerFactoryReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new FactoryForEntityManagerFactoryWrapper(next.getUnitName(), this.invMgr, this);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (ResourceEnvReferenceDescriptor next : env.getServiceReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            if (next.getMappedName() != null) {
                next.setName(next.getMappedName());
            }
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new WebServiceRefProxy((ServiceReferenceDescriptor)next);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
        for (ResourceEnvReferenceDescriptor next : env.getEntityManagerReferenceDescriptors()) {
            if (!this.dependencyAppliesToScope((Descriptor)next, scope)) continue;
            name = this.descriptorToLogicalJndiName((Descriptor)next);
            value = new FactoryForEntityManagerWrapper((EntityManagerReferenceDescriptor)next, this);
            jndiBindings.add(new CompEnvBinding(name, value));
        }
    }

    private CompEnvBinding getCompEnvBinding(final ResourceEnvReferenceDescriptor next) {
        final String name = this.descriptorToLogicalJndiName((Descriptor)next);
        Object value = null;
        if (next.isEJBContext()) {
            value = new EjbContextProxy(next.getRefType());
        } else if (next.isValidator()) {
            value = new ValidatorProxy(this._logger);
        } else if (next.isValidatorFactory()) {
            value = new ValidatorFactoryProxy(this._logger);
        } else if (next.isCDIBeanManager()) {
            value = this.namingUtils.createLazyNamingObjectFactory(name, "java:comp/BeanManager", false);
        } else if (next.isManagedBean()) {
            ManagedBeanDescriptor managedBeanDesc = next.getManagedBeanDescriptor();
            value = this.processEnv.getProcessType().isServer() ? this.namingUtils.createLazyNamingObjectFactory(name, next.getJndiName(), false) : this.namingUtils.createLazyNamingObjectFactory(name, managedBeanDesc.getAppJndiName(), false);
        } else {
            value = new NamingObjectFactory(){
                NamingObjectFactory delegate;
                {
                    this.delegate = ComponentEnvManagerImpl.this.namingUtils.createLazyNamingObjectFactory(name, next.getJndiName(), false);
                }

                public boolean isCreateResultCacheable() {
                    return false;
                }

                public Object create(Context ic) throws NamingException {
                    return this.delegate.create(ic);
                }
            };
        }
        return new CompEnvBinding(name, value);
    }

    private CompEnvBinding getCompEnvBinding(MessageDestinationReferenceDescriptor next) {
        String name = this.descriptorToLogicalJndiName((Descriptor)next);
        String physicalJndiName = null;
        physicalJndiName = next.isLinkedToMessageDestination() ? next.getMessageDestination().getJndiName() : next.getJndiName();
        NamingObjectFactory value = this.namingUtils.createLazyNamingObjectFactory(name, physicalJndiName, true);
        return new CompEnvBinding(name, value);
    }

    private boolean dependencyAppliesToScope(Descriptor descriptor, ScopeType scope) {
        String name = descriptor.getName();
        return this.dependencyAppliesToScope(name, scope);
    }

    private boolean dependencyAppliesToScope(String name, ScopeType scope) {
        boolean appliesToScope = false;
        switch (scope) {
            case COMPONENT: {
                appliesToScope = name.startsWith(JAVA_COMP_PREFIX) || !name.startsWith(JAVA_COLON);
                break;
            }
            case MODULE: {
                appliesToScope = name.startsWith(JAVA_MODULE_PREFIX);
                break;
            }
            case APP: {
                appliesToScope = name.startsWith(JAVA_APP_PREFIX);
                break;
            }
            case GLOBAL: {
                appliesToScope = name.startsWith(JAVA_GLOBAL_PREFIX);
                break;
            }
        }
        return appliesToScope;
    }

    private String descriptorToLogicalJndiName(Descriptor descriptor) {
        String rawName = descriptor.getName();
        return rawName.startsWith(JAVA_COLON) ? rawName : JAVA_COMP_ENV_STRING + rawName;
    }

    @Override
    public String getComponentEnvId(JndiNameEnvironment env) {
        String id = DOLUtils.getComponentEnvId((JndiNameEnvironment)env);
        if (this._logger.isLoggable(Level.FINE)) {
            this._logger.log(Level.FINE, DOLUtils.getApplicationName((JndiNameEnvironment)env) + "Component Id: " + id);
        }
        return id;
    }

    @Override
    public ApplicationEnvironment getCurrentApplicationEnvironment() {
        return this.invMgr.peekAppEnvironment();
    }

    private static enum ScopeType {
        COMPONENT,
        MODULE,
        APP,
        GLOBAL;

    }

    private static class CompEnvBinding
    implements JNDIBinding {
        private String name;
        private Object value;

        CompEnvBinding(String name, Object value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue() {
            return this.value;
        }
    }

    private class EjbReferenceProxy
    implements NamingObjectProxy {
        private EjbReferenceDescriptor ejbRef;
        private volatile EjbNamingReferenceManager ejbRefMgr;
        private volatile Object cachedResult = null;
        private Boolean cacheable;

        EjbReferenceProxy(EjbReferenceDescriptor ejbRef) {
            this.ejbRef = ejbRef;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbRefMgr == null) {
                EjbReferenceProxy ejbReferenceProxy = this;
                synchronized (ejbReferenceProxy) {
                    if (this.ejbRefMgr == null) {
                        this.ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.locator.getService(EjbNamingReferenceManager.class, new Annotation[0]);
                        this.cacheable = this.ejbRefMgr.isEjbReferenceCacheable(this.ejbRef);
                    }
                }
            }
            if (this.ejbRefMgr != null) {
                result = this.cacheable != null && this.cacheable.booleanValue() ? (this.cachedResult != null ? this.cachedResult : (this.cachedResult = this.ejbRefMgr.resolveEjbReference(this.ejbRef, ctx))) : this.ejbRefMgr.resolveEjbReference(this.ejbRef, ctx);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve ejb reference " + this.ejbRef.getName() + " : " + this.ejbRef);
            }
            return result;
        }
    }

    private class WebServiceRefProxy
    implements NamingObjectProxy {
        private WebServiceReferenceManager wsRefMgr;
        private ServiceReferenceDescriptor serviceRef;

        WebServiceRefProxy(ServiceReferenceDescriptor servRef) {
            this.serviceRef = servRef;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            this.wsRefMgr = (WebServiceReferenceManager)ComponentEnvManagerImpl.this.locator.getService(WebServiceReferenceManager.class, new Annotation[0]);
            if (this.wsRefMgr != null) {
                result = this.wsRefMgr.resolveWSReference(this.serviceRef, ctx);
            } else {
                ComponentEnvManagerImpl.this._logger.log(Level.SEVERE, "Cannot find the following class to proceed with @WebServiceRef" + this.wsRefMgr + "Please confirm if webservices module is installed ");
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve webservice context of type " + this.serviceRef.getName());
            }
            return result;
        }
    }

    private static class ValidatorFactoryProxy
    implements NamingObjectProxy {
        private static final String nameForValidatorFactory = "java:comp/ValidatorFactory";
        private volatile ValidatorFactory validatorFactory;
        private final Logger _logger;

        private ValidatorFactoryProxy(Logger logger) {
            this._logger = logger;
        }

        public Object create(Context ctx) throws NamingException {
            if (null == this.validatorFactory) {
                try {
                    this.validatorFactory = Validation.buildDefaultValidatorFactory();
                }
                catch (ValidationException e) {
                    this._logger.log(Level.WARNING, "Unable to lookup {0}, or build a default Bean Validator Factory: {1}", new Object[]{nameForValidatorFactory, e});
                    NameNotFoundException ne = new NameNotFoundException();
                    ne.initCause(e);
                    throw ne;
                }
            }
            return this.validatorFactory;
        }
    }

    private static class ValidatorProxy
    implements NamingObjectProxy {
        private static final String nameForValidator = "java:comp/Validator";
        private volatile ValidatorFactory validatorFactory;
        private volatile Validator validator;
        private final Logger _logger;

        private ValidatorProxy(Logger logger) {
            this._logger = logger;
        }

        public Object create(Context ctx) throws NamingException {
            String exceptionMessage = "Can not obtain reference to Validator instance ";
            if (null == this.validator) {
                if (null == this.validatorFactory) {
                    ValidatorFactoryProxy factoryProxy = new ValidatorFactoryProxy(this._logger);
                    this.validatorFactory = (ValidatorFactory)factoryProxy.create(ctx);
                }
                if (null != this.validatorFactory) {
                    ValidatorContext validatorContext = this.validatorFactory.usingContext();
                    this.validator = validatorContext.getValidator();
                }
            }
            if (this.validator == null) {
                throw new NameNotFoundException(exceptionMessage);
            }
            return this.validator;
        }
    }

    private class EjbContextProxy
    implements NamingObjectProxy {
        private volatile EjbNamingReferenceManager ejbRefMgr;
        private String contextType;

        EjbContextProxy(String contextType) {
            this.contextType = contextType;
        }

        public Object create(Context ctx) throws NamingException {
            Object result = null;
            if (this.ejbRefMgr == null) {
                this.ejbRefMgr = (EjbNamingReferenceManager)ComponentEnvManagerImpl.this.locator.getService(EjbNamingReferenceManager.class, new Annotation[0]);
            }
            if (this.ejbRefMgr != null) {
                result = this.ejbRefMgr.getEJBContextObject(this.contextType);
            }
            if (result == null) {
                throw new NameNotFoundException("Can not resolve EJB context of type " + this.contextType);
            }
            return result;
        }
    }

    private class FactoryForEntityManagerWrapper
    implements NamingObjectProxy {
        private final EntityManagerReferenceDescriptor refDesc;
        private final ComponentEnvManager compEnvMgr;

        FactoryForEntityManagerWrapper(EntityManagerReferenceDescriptor refDesc, ComponentEnvManager compEnvMgr) {
            this.refDesc = refDesc;
            this.compEnvMgr = compEnvMgr;
        }

        public Object create(Context ctx) {
            EntityManagerWrapper emWrapper = new EntityManagerWrapper(ComponentEnvManagerImpl.this.txManager, ComponentEnvManagerImpl.this.invMgr, this.compEnvMgr, ComponentEnvManagerImpl.this.callFlowAgent);
            emWrapper.initializeEMWrapper(this.refDesc.getUnitName(), this.refDesc.getPersistenceContextType(), this.refDesc.getSynchronizationType(), this.refDesc.getProperties());
            return emWrapper;
        }
    }

    private static class RefCountJndiNameEnvironment {
        public JndiNameEnvironment env;
        public AtomicInteger refcnt;

        public RefCountJndiNameEnvironment(JndiNameEnvironment env) {
            this.env = env;
            this.refcnt = new AtomicInteger(1);
        }
    }
}

