/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.impl.EntityManagerFactoryWrapper;
import com.sun.enterprise.container.common.impl.PhysicalEntityManagerWrapper;
import com.sun.enterprise.container.common.impl.QueryWrapper;
import com.sun.enterprise.container.common.impl.StoreProcedureQueryWrapper;
import com.sun.enterprise.container.common.impl.TypedQueryWrapper;
import com.sun.enterprise.container.common.spi.JavaEEContainer;
import com.sun.enterprise.container.common.spi.util.CallFlowAgent;
import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.container.common.spi.util.EntityManagerMethod;
import com.sun.enterprise.transaction.api.JavaEETransaction;
import com.sun.enterprise.transaction.api.SimpleResource;
import com.sun.logging.LogDomains;
import jakarta.persistence.CacheRetrieveMode;
import jakarta.persistence.CacheStoreMode;
import jakarta.persistence.ConnectionConsumer;
import jakarta.persistence.ConnectionFunction;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.FindOption;
import jakarta.persistence.FlushModeType;
import jakarta.persistence.LockModeType;
import jakarta.persistence.LockOption;
import jakarta.persistence.PersistenceContextType;
import jakarta.persistence.Query;
import jakarta.persistence.RefreshOption;
import jakarta.persistence.StoredProcedureQuery;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TransactionRequiredException;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaDelete;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.CriteriaSelect;
import jakarta.persistence.criteria.CriteriaUpdate;
import jakarta.persistence.metamodel.Metamodel;
import jakarta.transaction.TransactionManager;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.ComponentInvocationHandler;
import org.glassfish.api.invocation.InvocationException;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;
import org.jvnet.hk2.annotations.Service;

public class EntityManagerWrapper
implements EntityManager,
Serializable {
    private static final Logger LOG = LogDomains.getLogger(EntityManagerWrapper.class, (String)"jakarta.enterprise.system.util", (boolean)false);
    private String unitName;
    private PersistenceContextType contextType;
    private Map emProperties;
    private SynchronizationType synchronizationType;
    private transient EntityManagerFactory entityManagerFactory;
    private transient TransactionManager txManager;
    private transient InvocationManager invMgr;
    private transient EntityManager extendedEntityManager;
    private transient ComponentEnvManager compEnvMgr;
    private transient CallFlowAgent callFlowAgent;
    private static final Class INVOCATION_PAYLOAD_KEY = EntityManagerWrapper.class;

    public EntityManagerWrapper(TransactionManager txManager, InvocationManager invMgr, ComponentEnvManager compEnvMgr, CallFlowAgent callFlowAgent) {
        this.txManager = txManager;
        this.invMgr = invMgr;
        this.compEnvMgr = compEnvMgr;
        this.callFlowAgent = callFlowAgent;
    }

    public void initializeEMWrapper(String unitName, PersistenceContextType contextType, SynchronizationType synchronizationType, Map emProperties) {
        this.unitName = unitName;
        this.contextType = contextType;
        this.synchronizationType = synchronizationType;
        this.emProperties = emProperties;
        if (contextType == PersistenceContextType.EXTENDED) {
            this._getDelegate();
        }
    }

    private void init() {
        this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.invMgr, this.compEnvMgr, this.unitName);
        if (this.entityManagerFactory == null) {
            throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
        }
    }

    private void doTransactionScopedTxCheck() {
        if (this.contextType != PersistenceContextType.TRANSACTION) {
            return;
        }
        this.doTxRequiredCheck();
    }

    private void doTxRequiredCheck() {
        if (this.entityManagerFactory == null) {
            this.init();
        }
        if (this.getCurrentTransaction() == null) {
            throw new TransactionRequiredException();
        }
    }

    private EntityManager _getDelegate() {
        EntityManager delegate;
        if (this.entityManagerFactory == null) {
            this.init();
        }
        if (this.contextType == PersistenceContextType.TRANSACTION) {
            JavaEETransaction tx = this.getCurrentTransaction();
            if (tx != null) {
                PhysicalEntityManagerWrapper propagatedPersistenceContext = EntityManagerWrapper.getExtendedEntityManager(tx, this.entityManagerFactory);
                if (propagatedPersistenceContext == null) {
                    propagatedPersistenceContext = EntityManagerWrapper.getTxEntityManager(tx, this.entityManagerFactory);
                    if (propagatedPersistenceContext == null) {
                        EntityManager em = this.entityManagerFactory.createEntityManager(this.synchronizationType, this.emProperties);
                        propagatedPersistenceContext = new PhysicalEntityManagerWrapper(em, this.synchronizationType);
                        tx.addTxEntityManagerMapping(this.entityManagerFactory, (SimpleResource)propagatedPersistenceContext);
                    } else if (this.synchronizationType == SynchronizationType.SYNCHRONIZED && propagatedPersistenceContext.getSynchronizationType() == SynchronizationType.UNSYNCHRONIZED) {
                        throw new IllegalStateException("Detected an UNSYNCHRONIZED  persistence context being propagated to SYNCHRONIZED persistence context.");
                    }
                }
                delegate = propagatedPersistenceContext.getEM();
            } else {
                delegate = this.getNonTxEMFromCurrentInvocation();
            }
        } else {
            Object cc;
            ComponentInvocation ci;
            if (this.extendedEntityManager == null && (ci = this.invMgr.getCurrentInvocation()) != null && (cc = ci.getContainer()) instanceof JavaEEContainer) {
                this.extendedEntityManager = ((JavaEEContainer)cc).lookupExtendedEntityManager(this.entityManagerFactory);
            }
            delegate = this.extendedEntityManager;
        }
        LOG.log(Level.FINE, "In EntityManagerWrapper::_getDelegate(). Logical entity manager={0}. Physical entity manager={1}", new Object[]{this, delegate});
        return delegate;
    }

    private JavaEETransaction getCurrentTransaction() {
        try {
            return (JavaEETransaction)this.txManager.getTransaction();
        }
        catch (Exception e) {
            throw new IllegalStateException("exception retrieving tx", e);
        }
    }

    private EntityManager getNonTxEMFromCurrentInvocation() {
        EntityManager nonTxEM;
        ComponentInvocation currentInvocation = this.invMgr.getCurrentInvocation();
        Map<EntityManagerFactory, EntityManager> nonTxEMs = EntityManagerWrapper.getNonTxEMsFromCurrentInvocation(currentInvocation);
        if (nonTxEMs == null) {
            nonTxEMs = new HashMap<EntityManagerFactory, EntityManager>();
            currentInvocation.setRegistryFor(INVOCATION_PAYLOAD_KEY, nonTxEMs);
        }
        if ((nonTxEM = nonTxEMs.get(this.entityManagerFactory)) == null) {
            nonTxEM = this.entityManagerFactory.createEntityManager(this.synchronizationType, this.emProperties);
            nonTxEMs.put(this.entityManagerFactory, nonTxEM);
        }
        return nonTxEM;
    }

    private static Map<EntityManagerFactory, EntityManager> getNonTxEMsFromCurrentInvocation(ComponentInvocation currentInvocation) {
        return (Map)currentInvocation.getRegistryFor(INVOCATION_PAYLOAD_KEY);
    }

    public void persist(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.PERSIST);
            }
            this._getDelegate().persist(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public <T> T merge(T entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.MERGE);
            }
            Object object = this._getDelegate().merge(entity);
            return (T)object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void remove(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REMOVE);
            }
            this._getDelegate().remove(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey);
            this.clearDetachedPersistenceContext(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, Map<String, Object> properties) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey, properties);
            this.clearDetachedPersistenceContext(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND_CLASS_OBJECT_LOCKMODETYPE);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey, lockMode);
            this.clearDetachedPersistenceContext(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T find(Class<T> entityClass, Object primaryKey, LockModeType lockMode, Map<String, Object> properties) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FIND_CLASS_OBJECT_LOCKMODETYPE_PROPERTIES);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.find(entityClass, primaryKey, lockMode, properties);
            this.clearDetachedPersistenceContext(delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T getReference(Class<T> entityClass, Object primaryKey) {
        Object returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_REFERENCE);
            }
            returnValue = this._getDelegate().getReference(entityClass, primaryKey);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return (T)returnValue;
    }

    public void flush() {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.FLUSH);
            }
            this._getDelegate().flush();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createQuery(String ejbqlString) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(String ejbqlString, Class<T> resultClass) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(ejbqlString, resultClass);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createQuery(CriteriaQuery<T> criteriaQuery) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createQuery(criteriaQuery);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNamedQuery(String name) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> TypedQuery<T> createNamedQuery(String name, Class<T> resultClass) {
        TypedQuery<T> returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedQuery(name, resultClass);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, Class resultClass) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultClass);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Query createNativeQuery(String sqlString, String resultSetMapping) {
        Query returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NATIVE_QUERY_STRING_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNativeQuery(sqlString, resultSetMapping);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public void refresh(Object entity) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH);
            }
            this._getDelegate().refresh(entity);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void refresh(Object entity, Map<String, Object> properties) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_PROPERTIES);
            }
            this._getDelegate().refresh(entity, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void refresh(Object entity, LockModeType lockMode) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_LOCKMODETYPE);
            }
            this._getDelegate().refresh(entity, lockMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.REFRESH_OBJECT_LOCKMODETYPE_MAP);
            }
            this._getDelegate().refresh(entity, lockMode, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object entity) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CONTAINS);
            }
            EntityManager delegate = this._getDelegate();
            boolean bl = delegate.contains(entity);
            return bl;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public LockModeType getLockMode(Object o) {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_LOCK_MODE);
            }
            LockModeType lockModeType = this._getDelegate().getLockMode(o);
            return lockModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void setProperty(String propertyName, Object value) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_PROPERTY);
            }
            this._getDelegate().setProperty(propertyName, value);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public Map<String, Object> getProperties() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_PROPERTIES);
            }
            Map map = this._getDelegate().getProperties();
            return map;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void close() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLOSE);
            this.callFlowAgent.entityManagerMethodEnd();
        }
        throw new IllegalStateException();
    }

    public boolean isOpen() {
        if (this.callFlowAgent.isEnabled()) {
            this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.IS_OPEN);
            this.callFlowAgent.entityManagerMethodEnd();
        }
        return true;
    }

    public EntityTransaction getTransaction() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_TRANSACTION);
            }
            EntityTransaction entityTransaction = this._getDelegate().getTransaction();
            return entityTransaction;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public EntityManagerFactory getEntityManagerFactory() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_MANAGER_FACTORY);
            }
            if (this.entityManagerFactory == null) {
                this.init();
            }
            EntityManagerFactory entityManagerFactory = this.entityManagerFactory;
            return entityManagerFactory;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public CriteriaBuilder getCriteriaBuilder() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_CRITERIA_BUILDER);
            }
            CriteriaBuilder criteriaBuilder = this._getDelegate().getCriteriaBuilder();
            return criteriaBuilder;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public Metamodel getMetamodel() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_METAMODEL);
            }
            Metamodel metamodel = this._getDelegate().getMetamodel();
            return metamodel;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void lock(Object entity, LockModeType lockMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK);
            }
            this._getDelegate().lock(entity, lockMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock(Object entity, LockModeType lockMode, Map<String, Object> properties) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.LOCK_LOCKMODETYPE_MAP);
            }
            this._getDelegate().lock(entity, lockMode, properties);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void clear() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CLEAR);
            }
            this._getDelegate().clear();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void detach(Object o) {
        this.doTransactionScopedTxCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.DETATCH);
            }
            this._getDelegate().detach(o);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public Object getDelegate() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_DELEGATE);
            }
            EntityManager entityManager = this._getDelegate();
            return entityManager;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public FlushModeType getFlushMode() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_FLUSH_MODE);
            }
            FlushModeType flushModeType = this._getDelegate().getFlushMode();
            return flushModeType;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void setFlushMode(FlushModeType flushMode) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.SET_FLUSH_MODE);
            }
            this._getDelegate().setFlushMode(flushMode);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public void joinTransaction() {
        this.doTxRequiredCheck();
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.JOIN_TRANSACTION);
            }
            this._getDelegate().joinTransaction();
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public <T> T unwrap(Class<T> tClass) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.UNWRAP);
            }
            Object object = this._getDelegate().unwrap(tClass);
            return (T)object;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createNamedStoredProcedureQuery(String name) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_NAMED_STORED_PROCEDURE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createNamedStoredProcedureQuery(name);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, Class ... resultClasses) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY_STRING_CLASS);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName, resultClasses);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StoredProcedureQuery createStoredProcedureQuery(String procedureName, String ... resultSetMappings) {
        StoredProcedureQuery returnValue = null;
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_STORED_PROCEDURE_QUERY_STRING_STRING);
            }
            EntityManager delegate = this._getDelegate();
            returnValue = delegate.createStoredProcedureQuery(procedureName, resultSetMappings);
            returnValue = this.wrapQueryIfDetached(returnValue, delegate);
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
        return returnValue;
    }

    public Query createQuery(CriteriaUpdate updateQuery) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_UPDATE);
            }
            Query query = this._getDelegate().createQuery(updateQuery);
            return query;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public Query createQuery(CriteriaDelete deleteQuery) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_QUERY_CRITERIA_DELETE);
            }
            Query query = this._getDelegate().createQuery(deleteQuery);
            return query;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public boolean isJoinedToTransaction() {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.IS_JOINED_TO_TRANSACTION);
            }
            boolean bl = this._getDelegate().isJoinedToTransaction();
            return bl;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public <T> EntityGraph<T> createEntityGraph(Class<T> rootType) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_ENTITY_GRAPH_CLASS);
            }
            EntityGraph entityGraph = this._getDelegate().createEntityGraph(rootType);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public EntityGraph<?> createEntityGraph(String graphName) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.CREATE_ENTITY_GRAPH_STRING);
            }
            EntityGraph entityGraph = this._getDelegate().createEntityGraph(graphName);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public EntityGraph<?> getEntityGraph(String graphName) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_GRAPH);
            }
            EntityGraph entityGraph = this._getDelegate().getEntityGraph(graphName);
            return entityGraph;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    public <T> List<EntityGraph<? super T>> getEntityGraphs(Class<T> entityClass) {
        try {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodStart(EntityManagerMethod.GET_ENTITY_GRAPHS);
            }
            List list = this._getDelegate().getEntityGraphs(entityClass);
            return list;
        }
        finally {
            if (this.callFlowAgent.isEnabled()) {
                this.callFlowAgent.entityManagerMethodEnd();
            }
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ServiceLocator defaultServiceLocator = Globals.getDefaultHabitat();
        this.txManager = (TransactionManager)defaultServiceLocator.getService(TransactionManager.class, new Annotation[0]);
        this.invMgr = (InvocationManager)defaultServiceLocator.getService(InvocationManager.class, new Annotation[0]);
        this.compEnvMgr = (ComponentEnvManager)defaultServiceLocator.getService(ComponentEnvManager.class, new Annotation[0]);
        this.callFlowAgent = (CallFlowAgent)defaultServiceLocator.getService(CallFlowAgent.class, new Annotation[0]);
    }

    private boolean isDetached() {
        return this.getCurrentTransaction() == null && this.contextType != PersistenceContextType.EXTENDED;
    }

    private StoredProcedureQuery wrapQueryIfDetached(StoredProcedureQuery query, EntityManager delegate) {
        return this.isDetached() ? StoreProcedureQueryWrapper.createQueryWrapper(query, delegate) : query;
    }

    private <T> TypedQuery<T> wrapQueryIfDetached(TypedQuery<T> query, EntityManager delegate) {
        return this.isDetached() ? TypedQueryWrapper.createQueryWrapper(query, delegate) : query;
    }

    private Query wrapQueryIfDetached(Query query, EntityManager delegate) {
        return this.isDetached() ? QueryWrapper.createQueryWrapper(query, delegate) : query;
    }

    private void clearDetachedPersistenceContext(EntityManager em) {
        if (this.isDetached()) {
            em.clear();
        }
    }

    public static PhysicalEntityManagerWrapper getExtendedEntityManager(JavaEETransaction transaction, EntityManagerFactory factory) {
        return (PhysicalEntityManagerWrapper)transaction.getExtendedEntityManagerResource(factory);
    }

    public static PhysicalEntityManagerWrapper getTxEntityManager(JavaEETransaction transaction, EntityManagerFactory factory) {
        return (PhysicalEntityManagerWrapper)transaction.getTxEntityManagerResource(factory);
    }

    public <T> T find(Class<T> entityClass, Object primaryKey, FindOption ... options) {
        return (T)this._getDelegate().find(entityClass, primaryKey, options);
    }

    public <T> T find(EntityGraph<T> entityGraph, Object primaryKey, FindOption ... options) {
        return (T)this._getDelegate().find(entityGraph, primaryKey, options);
    }

    public <T> T getReference(T entity) {
        return (T)this._getDelegate().getReference(entity);
    }

    public void lock(Object entity, LockModeType lockMode, LockOption ... options) {
        this._getDelegate().lock(entity, lockMode, options);
    }

    public void refresh(Object entity, RefreshOption ... options) {
        this._getDelegate().refresh(entity, options);
    }

    public void setCacheRetrieveMode(CacheRetrieveMode cacheRetrieveMode) {
        this._getDelegate().setCacheRetrieveMode(cacheRetrieveMode);
    }

    public void setCacheStoreMode(CacheStoreMode cacheStoreMode) {
        this._getDelegate().setCacheStoreMode(cacheStoreMode);
    }

    public CacheRetrieveMode getCacheRetrieveMode() {
        return this._getDelegate().getCacheRetrieveMode();
    }

    public CacheStoreMode getCacheStoreMode() {
        return this._getDelegate().getCacheStoreMode();
    }

    public <T> TypedQuery<T> createQuery(CriteriaSelect<T> selectQuery) {
        return this._getDelegate().createQuery(selectQuery);
    }

    public <T> TypedQuery<T> createQuery(TypedQueryReference<T> reference) {
        return this._getDelegate().createQuery(reference);
    }

    public <C> void runWithConnection(ConnectionConsumer<C> action) {
        this._getDelegate().runWithConnection(action);
    }

    public <C, T> T callWithConnection(ConnectionFunction<C, T> function) {
        return (T)this._getDelegate().callWithConnection(function);
    }

    @Service
    public static class NonTxEMCleaner
    implements ComponentInvocationHandler {
        public void beforePreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation newInv) throws InvocationException {
        }

        public void afterPreInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }

        public void beforePostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
            Map<EntityManagerFactory, EntityManager> nonTxEMs = EntityManagerWrapper.getNonTxEMsFromCurrentInvocation(curInv);
            if (nonTxEMs != null) {
                for (EntityManager nonTxEM : nonTxEMs.values()) {
                    nonTxEM.close();
                }
            }
        }

        public void afterPostInvoke(ComponentInvocation.ComponentInvocationType invType, ComponentInvocation prevInv, ComponentInvocation curInv) throws InvocationException {
        }
    }
}

