/*
 * Copyright (c) 2022 Contributors to the Eclipse Foundation
 * Copyright (c) 2008, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package com.sun.enterprise.container.common.impl.util;

import org.glassfish.api.naming.ComponentNamingUtil;
import org.glassfish.api.naming.SimpleJndiName;
import org.jvnet.hk2.annotations.Service;

@Service
public class ComponentNamingUtilImpl implements ComponentNamingUtil {

    private static final String INTERNAL_CLIENT_PREFIX = "__internal_java_app_for_app_client__";

    @Override
    public SimpleJndiName composeInternalGlobalJavaAppName(String appName, SimpleJndiName jndiName) {
        // FIXME dmatej added and commented out
//        if (jndiName.hasJavaPrefix()) {
//            return new SimpleJndiName(INTERNAL_CLIENT_PREFIX + appName + "__" + jndiName.removePrefix());
//        }
        return new SimpleJndiName(INTERNAL_CLIENT_PREFIX + appName + "__" + jndiName);
    }
}
