/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.container.common.impl;

import com.sun.enterprise.container.common.spi.util.ComponentEnvManager;
import com.sun.enterprise.deployment.Application;
import com.sun.enterprise.deployment.ApplicationClientDescriptor;
import com.sun.enterprise.deployment.BundleDescriptor;
import com.sun.enterprise.deployment.EjbDescriptor;
import com.sun.enterprise.deployment.JndiNameEnvironment;
import com.sun.enterprise.deployment.WebBundleDescriptor;
import com.sun.logging.LogDomains;
import jakarta.persistence.Cache;
import jakarta.persistence.EntityGraph;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityManagerFactory;
import jakarta.persistence.PersistenceUnitTransactionType;
import jakarta.persistence.PersistenceUnitUtil;
import jakarta.persistence.Query;
import jakarta.persistence.SchemaManager;
import jakarta.persistence.SynchronizationType;
import jakarta.persistence.TypedQueryReference;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.metamodel.Metamodel;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.logging.Logger;
import org.glassfish.api.invocation.ComponentInvocation;
import org.glassfish.api.invocation.InvocationManager;
import org.glassfish.hk2.api.ServiceLocator;
import org.glassfish.internal.api.Globals;

public class EntityManagerFactoryWrapper
implements EntityManagerFactory,
Serializable {
    static Logger _logger = LogDomains.getLogger(EntityManagerFactoryWrapper.class, (String)"jakarta.enterprise.system.util");
    private final String unitName;
    private transient InvocationManager invMgr;
    private transient EntityManagerFactory entityManagerFactory;
    private transient ComponentEnvManager compEnvMgr;

    public EntityManagerFactoryWrapper(String unitName, InvocationManager invMgr, ComponentEnvManager compEnvMgr) {
        this.unitName = unitName;
        this.invMgr = invMgr;
        this.compEnvMgr = compEnvMgr;
    }

    private EntityManagerFactory getDelegate() {
        if (this.entityManagerFactory == null) {
            this.entityManagerFactory = EntityManagerFactoryWrapper.lookupEntityManagerFactory(this.invMgr, this.compEnvMgr, this.unitName);
            if (this.entityManagerFactory == null) {
                throw new IllegalStateException("Unable to retrieve EntityManagerFactory for unitName " + this.unitName);
            }
        }
        return this.entityManagerFactory;
    }

    public EntityManager createEntityManager() {
        return this.getDelegate().createEntityManager();
    }

    public EntityManager createEntityManager(Map map) {
        return this.getDelegate().createEntityManager(map);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType) {
        return this.getDelegate().createEntityManager(synchronizationType);
    }

    public EntityManager createEntityManager(SynchronizationType synchronizationType, Map map) {
        return this.getDelegate().createEntityManager(synchronizationType, map);
    }

    public void addNamedQuery(String name, Query query) {
        this.getDelegate().addNamedQuery(name, query);
    }

    public <T> T unwrap(Class<T> cls) {
        return (T)this.getDelegate().unwrap(cls);
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.getDelegate().getCriteriaBuilder();
    }

    public Metamodel getMetamodel() {
        return this.getDelegate().getMetamodel();
    }

    public Map<String, Object> getProperties() {
        return this.getDelegate().getProperties();
    }

    public void close() {
        this.getDelegate().close();
    }

    public boolean isOpen() {
        return this.getDelegate().isOpen();
    }

    public Cache getCache() {
        return this.getDelegate().getCache();
    }

    public PersistenceUnitUtil getPersistenceUnitUtil() {
        return this.getDelegate().getPersistenceUnitUtil();
    }

    public <T> void addNamedEntityGraph(String graphName, EntityGraph<T> entityGraph) {
        this.getDelegate().addNamedEntityGraph(graphName, entityGraph);
    }

    public <R> R callInTransaction(Function<EntityManager, R> work) {
        return (R)this.getDelegate().callInTransaction(work);
    }

    public String getName() {
        return this.getDelegate().getName();
    }

    public <E> Map<String, EntityGraph<? extends E>> getNamedEntityGraphs(Class<E> entityType) {
        return this.getDelegate().getNamedEntityGraphs(entityType);
    }

    public <R> Map<String, TypedQueryReference<R>> getNamedQueries(Class<R> resultType) {
        return this.getDelegate().getNamedQueries(resultType);
    }

    public SchemaManager getSchemaManager() {
        return this.getDelegate().getSchemaManager();
    }

    public PersistenceUnitTransactionType getTransactionType() {
        return this.getDelegate().getTransactionType();
    }

    public void runInTransaction(Consumer<EntityManager> work) {
        this.getDelegate().runInTransaction(work);
    }

    static EntityManagerFactory lookupEntityManagerFactory(InvocationManager invMgr, ComponentEnvManager compEnvMgr, String emfUnitName) {
        JndiNameEnvironment desc;
        ComponentInvocation inv = invMgr.getCurrentInvocation();
        EntityManagerFactory emf = null;
        if (inv != null && (desc = compEnvMgr.getCurrentJndiNameEnvironment()) != null) {
            emf = EntityManagerFactoryWrapper.lookupEntityManagerFactory(inv.getInvocationType(), emfUnitName, desc);
        }
        return emf;
    }

    public static EntityManagerFactory lookupEntityManagerFactory(ComponentInvocation.ComponentInvocationType invType, String emfUnitName, Object descriptor) {
        Set emFactories;
        Application app = null;
        WebBundleDescriptor module = null;
        EntityManagerFactory emf = null;
        switch (invType) {
            case EJB_INVOCATION: {
                if (descriptor instanceof EjbDescriptor) {
                    EjbDescriptor ejbDesc = (EjbDescriptor)descriptor;
                    module = (BundleDescriptor)ejbDesc.getEjbBundleDescriptor().getModuleDescriptor().getDescriptor();
                    app = module.getApplication();
                    break;
                }
            }
            case SERVLET_INVOCATION: {
                module = (WebBundleDescriptor)descriptor;
                app = module.getApplication();
                break;
            }
            case APP_CLIENT_INVOCATION: {
                module = (ApplicationClientDescriptor)descriptor;
                app = module.getApplication();
                break;
            }
        }
        if (module != null) {
            if (emfUnitName != null) {
                emf = module.getEntityManagerFactory(emfUnitName);
            } else {
                emFactories = module.getEntityManagerFactories();
                if (emFactories.size() == 1) {
                    emf = (EntityManagerFactory)emFactories.iterator().next();
                }
            }
        }
        if (app != null && emf == null) {
            if (emfUnitName != null) {
                emf = app.getEntityManagerFactory(emfUnitName, (BundleDescriptor)module);
            } else {
                emFactories = app.getEntityManagerFactories();
                if (emFactories.size() == 1) {
                    emf = (EntityManagerFactory)emFactories.iterator().next();
                }
            }
        }
        return emf;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        ServiceLocator defaultServiceLocator = Globals.getDefaultHabitat();
        this.invMgr = (InvocationManager)defaultServiceLocator.getService(InvocationManager.class, new Annotation[0]);
        this.compEnvMgr = (ComponentEnvManager)defaultServiceLocator.getService(ComponentEnvManager.class, new Annotation[0]);
    }
}

