/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin.progress;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.progress.ProgressStatusEvent;

public abstract class ProgressStatusBase
implements ProgressStatus {
    protected String name;
    protected String id;
    protected int totalStepCount = -1;
    protected int currentStepCount = 0;
    protected ProgressStatusBase parent;
    protected boolean completed = false;
    protected Set<ChildProgressStatus> children = new HashSet<ChildProgressStatus>();

    protected ProgressStatusBase(ProgressStatusBase parent, String id) {
        this(null, -1, parent, id);
    }

    protected ProgressStatusBase(String name, ProgressStatusBase parent, String id) {
        this(name, -1, parent, id);
    }

    protected ProgressStatusBase(String name, int totalStepCount, ProgressStatusBase parent, String id) {
        this.name = name;
        this.totalStepCount = totalStepCount;
        this.parent = parent;
        if (id == null || id.isEmpty()) {
            id = UUID.randomUUID().toString();
        }
        this.id = id;
    }

    protected void fireEvent(ProgressStatusEvent event) {
        if (this.parent != null) {
            this.parent.fireEvent(event);
        }
    }

    protected final void fireEvent(String message, boolean spinner, ProgressStatusEvent.Changed ... changed) {
        this.fireEvent(new ProgressStatusEvent(this, message, spinner, changed));
    }

    @Override
    public synchronized void setTotalStepCount(int totalStepCount) {
        if (this.completed || this.totalStepCount == totalStepCount) {
            return;
        }
        this.totalStepCount = totalStepCount;
        if (totalStepCount >= 0 && this.currentStepCount > totalStepCount) {
            this.currentStepCount = totalStepCount;
        }
        this.fireEvent(null, false, ProgressStatusEvent.Changed.TOTAL_STEPS);
    }

    @Override
    public synchronized int getTotalStepCount() {
        return this.totalStepCount;
    }

    @Override
    public int getRemainingStepCount() {
        int childAlocSteps = 0;
        for (ChildProgressStatus childProgressStatus : this.children) {
            childAlocSteps += childProgressStatus.getAllocatedSteps();
        }
        return this.totalStepCount - this.currentStepCount - childAlocSteps;
    }

    @Override
    public synchronized void progress(int steps, String message, boolean spinner) {
        if (this.completed) {
            return;
        }
        boolean stepsChanged = false;
        if (steps > 0) {
            if (this.totalStepCount < 0) {
                this.currentStepCount += steps;
                stepsChanged = true;
            } else if (this.currentStepCount < this.totalStepCount) {
                this.currentStepCount += steps;
                if (this.currentStepCount > this.totalStepCount) {
                    this.currentStepCount = this.totalStepCount;
                }
                stepsChanged = true;
            }
        }
        if (stepsChanged) {
            this.fireEvent(message, spinner, ProgressStatusEvent.Changed.SPINNER, ProgressStatusEvent.Changed.STEPS);
        } else if (message != null && !message.isEmpty()) {
            this.fireEvent(message, spinner, ProgressStatusEvent.Changed.SPINNER);
        }
    }

    @Override
    public synchronized void progress(int steps, String message) {
        this.progress(steps, message, false);
    }

    @Override
    public void progress(int steps) {
        this.progress(steps, null, false);
    }

    @Override
    public void progress(String message) {
        this.progress(0, message, false);
    }

    @Override
    public synchronized void setCurrentStepCount(int stepCount) {
        if (this.completed) {
            return;
        }
        boolean stepsChanged = false;
        if (stepCount >= 0 && stepCount != this.currentStepCount) {
            if (this.totalStepCount < 0 || stepCount < this.totalStepCount) {
                this.currentStepCount = stepCount;
                stepsChanged = true;
            } else if (this.currentStepCount != this.totalStepCount) {
                this.currentStepCount = this.totalStepCount;
                stepsChanged = true;
            }
        }
        if (stepsChanged) {
            this.fireEvent(null, false, ProgressStatusEvent.Changed.STEPS);
        }
    }

    @Override
    public void complete(String message) {
        if (this.completeSilently()) {
            this.fireEvent(message, false, ProgressStatusEvent.Changed.COMPLETED);
        }
    }

    protected synchronized boolean completeSilently() {
        if (this.completed) {
            return false;
        }
        if (this.totalStepCount >= 0) {
            this.currentStepCount = this.totalStepCount;
        }
        this.completed = true;
        for (ChildProgressStatus child : this.children) {
            child.getProgressStatus().completeSilently();
        }
        return true;
    }

    @Override
    public void complete() {
        this.complete(null);
    }

    @Override
    public boolean isComplete() {
        return this.completed;
    }

    protected abstract ProgressStatusBase doCreateChild(String var1, int var2);

    protected void allocateStapsForChildProcess(int allocatedSteps) {
        if (allocatedSteps < 0) {
            allocatedSteps = 0;
        }
        if (this.totalStepCount >= 0) {
            for (ChildProgressStatus child : this.children) {
                allocatedSteps += child.getAllocatedSteps();
            }
            if (allocatedSteps + this.currentStepCount > this.totalStepCount) {
                this.currentStepCount = this.totalStepCount - allocatedSteps;
                if (this.currentStepCount < 0) {
                    this.currentStepCount = 0;
                    this.totalStepCount = allocatedSteps;
                    this.fireEvent(null, false, ProgressStatusEvent.Changed.STEPS, ProgressStatusEvent.Changed.TOTAL_STEPS);
                } else {
                    this.fireEvent(null, false, ProgressStatusEvent.Changed.STEPS);
                }
            }
        }
    }

    public synchronized ProgressStatus createChild(String name, int allocatedSteps, int totalStepCount) {
        if (allocatedSteps < 0) {
            allocatedSteps = 0;
        }
        this.allocateStapsForChildProcess(allocatedSteps);
        ProgressStatusBase result = this.doCreateChild(name, totalStepCount);
        this.children.add(new ChildProgressStatus(allocatedSteps, result));
        this.fireEvent(new ProgressStatusEvent(result, allocatedSteps));
        return result;
    }

    @Override
    public ProgressStatus createChild(String name, int allocatedSteps) {
        return this.createChild(name, allocatedSteps, -1);
    }

    @Override
    public ProgressStatus createChild(int allocatedSteps) {
        return this.createChild(null, allocatedSteps);
    }

    public synchronized int getCurrentStepCount() {
        return this.currentStepCount;
    }

    protected synchronized float computeCompleteSteps() {
        if (this.isComplete()) {
            return this.totalStepCount;
        }
        float realStepCount = this.currentStepCount;
        for (ChildProgressStatus child : this.children) {
            float childPortion = child.progressStatus.computeCompletePortion();
            if (childPortion < 0.0f) {
                return -1.0f;
            }
            realStepCount += (float)child.getAllocatedSteps() * childPortion;
        }
        return realStepCount;
    }

    public synchronized float computeCompletePortion() {
        if (this.isComplete()) {
            return 1.0f;
        }
        float realSteps = this.computeCompleteSteps();
        if (realSteps < 0.0f) {
            return -1.0f;
        }
        if (realSteps == 0.0f) {
            return 0.0f;
        }
        if (this.totalStepCount < 0) {
            return -1.0f;
        }
        if (this.totalStepCount > 0) {
            return realSteps / (float)this.totalStepCount;
        }
        return 1.0f;
    }

    public synchronized int computeSumSteps() {
        int result = 0;
        for (ChildProgressStatus child : this.children) {
            if (child.allocatedSteps <= 0) continue;
            result += child.progressStatus.computeSumSteps();
        }
        return this.getCurrentStepCount() + result;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        if (this.name == null) {
            result.append("NoName ");
        } else {
            result.append(this.name).append(' ');
        }
        float realSteps = this.computeCompleteSteps();
        if (realSteps < 0.0f) {
            result.append(this.currentStepCount).append(" / ").append('?');
        } else {
            result.append(Math.round(realSteps)).append(" / ");
            result.append(this.totalStepCount < 0 ? "?" : String.valueOf(this.totalStepCount));
        }
        return result.toString();
    }

    public synchronized Collection<ProgressStatusBase> getChildren() {
        ArrayList<ProgressStatusBase> result = new ArrayList<ProgressStatusBase>(this.children.size());
        for (ChildProgressStatus chld : this.children) {
            result.add(chld.getProgressStatus());
        }
        return result;
    }

    public Set<ChildProgressStatus> getChildProgressStatuses() {
        return this.children;
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public ProgressStatusBase getParrent() {
        return this.parent;
    }

    protected ProgressStatusBase findById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        if (id.equals(this.getId())) {
            return this;
        }
        for (ChildProgressStatus child : this.getChildProgressStatuses()) {
            ProgressStatusBase result = child.getProgressStatus().findById(id);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static class ChildProgressStatus {
        private final int allocatedSteps;
        private final ProgressStatusBase progressStatus;

        public ChildProgressStatus(int allocatedSteps, ProgressStatusBase progressStatus) {
            this.allocatedSteps = allocatedSteps > 0 ? allocatedSteps : 0;
            this.progressStatus = progressStatus;
        }

        public int getAllocatedSteps() {
            return this.allocatedSteps;
        }

        public ProgressStatusBase getProgressStatus() {
            return this.progressStatus;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ChildProgressStatus other = (ChildProgressStatus)obj;
            if (this.allocatedSteps != other.allocatedSteps) {
                return false;
            }
            return this.progressStatus == other.progressStatus || this.progressStatus != null && this.progressStatus.equals(other.progressStatus);
        }

        public int hashCode() {
            return this.progressStatus != null ? this.progressStatus.hashCode() : 0;
        }

        public String toString() {
            return "ChildProgressStatus{allocatedSteps=" + this.allocatedSteps + ", progressStatus=" + this.progressStatus + '}';
        }
    }
}

