/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin.progress;

import java.util.ArrayList;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.progress.ProgressStatusBase;
import org.glassfish.api.admin.progress.ProgressStatusEvent;
import org.glassfish.api.admin.progress.ProgressStatusImpl;

public class ProgressStatusMirroringImpl
extends ProgressStatusBase {
    public ProgressStatusMirroringImpl(String name, ProgressStatusBase parent, String id) {
        super(name, -1, parent, id);
    }

    @Override
    protected ProgressStatusBase doCreateChild(String name, int totalStepCount) {
        String childId = (this.id == null ? "" : this.id) + "." + (this.children.size() + 1);
        return new ProgressStatusImpl(name, totalStepCount, this, childId);
    }

    @Override
    public void setTotalStepCount(int totalStepCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void progress(int steps, String message) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setCurrentStepCount(int stepCount) {
        throw new UnsupportedOperationException();
    }

    @Override
    public synchronized ProgressStatus createChild(String name, int allocatedSteps, int totalStepCount) {
        ProgressStatusBase result = this.doCreateChild(name, totalStepCount);
        this.children.add(new ProgressStatusBase.ChildProgressStatus(allocatedSteps, result));
        this.fireEvent(new ProgressStatusEvent(result, 0));
        return result;
    }

    @Override
    protected synchronized void fireEvent(ProgressStatusEvent event) {
        this.recount();
        super.fireEvent(event);
    }

    private void recount() {
        int newTotalStepCount = 0;
        boolean unknown = false;
        int newCurrentStepCount = 0;
        for (ProgressStatusBase.ChildProgressStatus child : this.children) {
            ProgressStatusBase mirr = child.getProgressStatus();
            if (!unknown) {
                int tsc = mirr.getTotalStepCount();
                if (tsc < 0) {
                    unknown = true;
                    newTotalStepCount = -1;
                } else {
                    newTotalStepCount += tsc;
                }
            }
            newCurrentStepCount += mirr.getCurrentStepCount();
        }
        ArrayList<ProgressStatusEvent.Changed> changed = new ArrayList<ProgressStatusEvent.Changed>(2);
        if (newCurrentStepCount != this.currentStepCount) {
            this.currentStepCount = newCurrentStepCount;
            changed.add(ProgressStatusEvent.Changed.STEPS);
        }
        if (newTotalStepCount != this.totalStepCount) {
            this.totalStepCount = newTotalStepCount;
            changed.add(ProgressStatusEvent.Changed.TOTAL_STEPS);
        }
        if (!changed.isEmpty()) {
            super.fireEvent(null, false, changed.toArray(new ProgressStatusEvent.Changed[changed.size()]));
        }
    }

    @Override
    protected synchronized float computeCompleteSteps() {
        return this.currentStepCount;
    }

    @Override
    public synchronized float computeCompletePortion() {
        if (this.isComplete()) {
            return 1.0f;
        }
        if (this.totalStepCount == 0) {
            if (this.currentStepCount == 0) {
                return 0.0f;
            }
            return 1.0f;
        }
        return (float)this.currentStepCount / (float)this.totalStepCount;
    }
}

