/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.io.Serializable;
import java.util.UUID;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import org.glassfish.api.ActionReport;
import org.glassfish.api.admin.AdminCommandContext;
import org.glassfish.api.admin.AdminCommandEventBroker;
import org.glassfish.api.admin.Payload;
import org.glassfish.api.admin.ProgressStatus;
import org.glassfish.api.admin.progress.ProgressStatusImpl;

public class AdminCommandContextImpl
implements AdminCommandContext,
Serializable {
    private ActionReport report;
    private final transient Logger logger;
    private transient Payload.Inbound inboundPayload;
    private transient Payload.Outbound outboundPayload;
    private transient Subject subject;
    private ProgressStatus progressStatus;
    private final transient AdminCommandEventBroker eventBroker;
    private final String jobId;

    public AdminCommandContextImpl(Logger logger, ActionReport report) {
        this(logger, report, null, null, null, null);
    }

    public AdminCommandContextImpl(Logger logger, ActionReport report, Payload.Inbound inboundPayload, Payload.Outbound outboundPayload, AdminCommandEventBroker eventBroker, String jobId) {
        this.logger = logger;
        this.report = report;
        this.inboundPayload = inboundPayload;
        this.outboundPayload = outboundPayload;
        this.eventBroker = eventBroker;
        this.jobId = jobId;
    }

    @Override
    public ActionReport getActionReport() {
        return this.report;
    }

    @Override
    public void setActionReport(ActionReport newReport) {
        this.report = newReport;
    }

    @Override
    public Logger getLogger() {
        return this.logger;
    }

    @Override
    public Payload.Inbound getInboundPayload() {
        return this.inboundPayload;
    }

    @Override
    public void setInboundPayload(Payload.Inbound newInboundPayload) {
        this.inboundPayload = newInboundPayload;
    }

    @Override
    public Payload.Outbound getOutboundPayload() {
        return this.outboundPayload;
    }

    @Override
    public void setOutboundPayload(Payload.Outbound newOutboundPayload) {
        this.outboundPayload = newOutboundPayload;
    }

    @Override
    public Subject getSubject() {
        return this.subject;
    }

    @Override
    public void setSubject(Subject subject) {
        this.subject = subject;
    }

    @Override
    public ProgressStatus getProgressStatus() {
        if (this.progressStatus == null) {
            this.progressStatus = new ProgressStatusImpl();
        }
        return this.progressStatus;
    }

    @Override
    public AdminCommandEventBroker getEventBroker() {
        return this.eventBroker;
    }

    @Override
    public String getJobId() {
        return this.jobId;
    }

    static class ErrorProgressStatus
    implements ProgressStatus,
    Serializable {
        private static final String EXC_MESSAGE = "@Progress annotation is not present.";
        private String id = null;

        ErrorProgressStatus() {
        }

        @Override
        public void setTotalStepCount(int totalStepCount) {
            throw new IllegalStateException(EXC_MESSAGE);
        }

        @Override
        public int getTotalStepCount() {
            return 0;
        }

        @Override
        public int getRemainingStepCount() {
            return 0;
        }

        @Override
        public void progress(int steps, String message) {
            throw new IllegalStateException(EXC_MESSAGE);
        }

        @Override
        public void progress(int steps) {
            throw new IllegalStateException(EXC_MESSAGE);
        }

        @Override
        public void progress(String message) {
            throw new IllegalStateException(EXC_MESSAGE);
        }

        @Override
        public void progress(int steps, String message, boolean spinner) {
            throw new IllegalStateException(EXC_MESSAGE);
        }

        @Override
        public void setCurrentStepCount(int stepCount) {
            throw new IllegalStateException(EXC_MESSAGE);
        }

        @Override
        public void complete(String message) {
        }

        @Override
        public void complete() {
        }

        @Override
        public boolean isComplete() {
            return true;
        }

        @Override
        public ProgressStatus createChild(String name, int allocatedSteps) {
            throw new IllegalStateException(EXC_MESSAGE);
        }

        @Override
        public ProgressStatus createChild(int allocatedSteps) {
            throw new IllegalStateException(EXC_MESSAGE);
        }

        @Override
        public synchronized String getId() {
            if (this.id == null) {
                this.id = UUID.randomUUID().toString();
            }
            return this.id;
        }
    }
}

