/*
 * Copyright (c) 2006, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.api.content;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.annotation.ElementType;

/**
 * Annotation that denote a class capable of handling
 * particular URL patterns. The definition of handling
 * is loose in this particular context as it can be
 * file servicing, or any other type of behaviour. The
 * type of handling the annotated class will usually be
 * defined by an interface the class implements
 *
 * @see {link:FileServer} 
 *
 * @author Jerome Dochez
 */
@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.TYPE)
public @interface WebRequestHandler {
    /**
     * Returns the URL pattern for URL request this class
     * is capable of handling.
     * @return URL pattern
     */
    public String urlPattern() default "";
}
