/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.api.admin;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.jvnet.hk2.config.ConfigBeanProxy;
import org.jvnet.hk2.config.ConfigModel;
import org.jvnet.hk2.config.Dom;

@Target(value={ElementType.TYPE})
@Retention(value=RetentionPolicy.RUNTIME)
public @interface AccessRequired {
    public String[] resource();

    public String[] action();

    public static class Util {
        public static String resourceNameFromDom(Dom d) {
            Dom lastDom = null;
            StringBuilder path = new StringBuilder();
            while (d != null) {
                if (path.length() > 0) {
                    path.insert(0, '/');
                }
                ConfigModel m = d.model;
                lastDom = d;
                String key = d.getKey();
                String pathSegment = m.getTagName() + (key == null ? "" : "/" + key);
                path.insert(0, pathSegment);
                d = d.parent();
            }
            if (lastDom != null && lastDom.getKey() != null) {
                path.insert(0, Util.pluralize(lastDom.model.getTagName()) + '/');
            }
            return path.toString();
        }

        public static String resourceNameFromConfigBeanProxy(ConfigBeanProxy b) {
            return b == null ? null : Util.resourceNameFromDom(Dom.unwrap((ConfigBeanProxy)b));
        }

        public static String resourceNameFromConfigBeanType(ConfigBeanProxy parent, String collectionName, Class<? extends ConfigBeanProxy> childType) {
            return parent == null ? null : Util.resourceNameFromConfigBeanType(Dom.unwrap((ConfigBeanProxy)parent), collectionName, childType);
        }

        public static String resourceNameFromConfigBeanType(Dom parent, String collectionName, Class<? extends ConfigBeanProxy> childType) {
            StringBuilder sb = new StringBuilder(Util.resourceNameFromDom(parent)).append('/');
            String tagName = parent.document.buildModel(childType).getTagName();
            if (collectionName != null) {
                if (collectionName.isEmpty()) {
                    collectionName = Util.pluralize(tagName);
                }
                sb.append(collectionName).append('/');
            }
            sb.append(tagName);
            return sb.toString();
        }

        static String resourceNameFromConfigBeanTypeAndName(ConfigBeanProxy parent, Class<? extends ConfigBeanProxy> childType, String childName) {
            return Util.resourceNameFromConfigBeanType(parent, null, childType) + (childName != null && !childName.isEmpty() ? "/" + childName : "");
        }

        private static String pluralize(String s) {
            char lastChar = s.charAt(s.length() - 1);
            if (lastChar == 's' || lastChar == 'S' || lastChar == 'x' || lastChar == 'X') {
                return s + "es";
            }
            return s + "s";
        }
    }

    public static class AccessCheck<T> {
        private final String resourceName;
        private final String action;
        private final String note;
        private final Class<? extends ConfigBeanProxy> childType;
        private final ConfigBeanProxy parent;
        private final String childName;
        private final ConfigBeanProxy resource;
        private final boolean isFailureFatal;
        private boolean isSuccessful = false;
        private final T relatedObject;

        public static <U> Collection<U> relatedObjects(Collection<AccessCheck<U>> accessChecks) {
            return AccessCheck.relatedObjects(accessChecks, true);
        }

        public static <U> Collection<U> relatedObjects(Collection<AccessCheck<U>> accessChecks, boolean successfulOnly) {
            return new RelatedObjectCollection(accessChecks, successfulOnly);
        }

        public AccessCheck(T relatedObject, String resourceName, String action, String note, boolean isFailureFinal) {
            this.relatedObject = relatedObject;
            this.resourceName = resourceName;
            this.action = action;
            this.note = note;
            this.childType = null;
            this.parent = null;
            this.isFailureFatal = isFailureFinal;
            this.resource = null;
            this.childName = null;
        }

        public AccessCheck(String resourceName, String action, String note, boolean isFailureFinal) {
            this(null, resourceName, action, note, isFailureFinal);
        }

        public AccessCheck(String resourceName, String action, String note) {
            this(resourceName, action, note, true);
        }

        public AccessCheck(String resourceName, String action, boolean isFailureFinal) {
            this(resourceName, action, "", isFailureFinal);
        }

        public AccessCheck(T relatedObject, String resourceName, String action, boolean isFailureFinal) {
            this(relatedObject, resourceName, action, "", isFailureFinal);
        }

        public AccessCheck(ConfigBeanProxy resource, String action, boolean isFailureFatal) {
            this.resourceName = null;
            this.resource = resource;
            this.action = action;
            this.note = null;
            this.childType = null;
            this.parent = resource.getParent();
            this.isFailureFatal = isFailureFatal;
            this.childName = null;
            this.relatedObject = null;
        }

        public AccessCheck(String resourceName, String action) {
            this(resourceName, action, "", true);
        }

        public AccessCheck(ConfigBeanProxy parent, Class<? extends ConfigBeanProxy> childType, String action, String note, boolean isFailureFinal) {
            this(parent, childType, null, action, note, isFailureFinal);
        }

        public AccessCheck(ConfigBeanProxy parent, Class<? extends ConfigBeanProxy> childType, String childName, String action, String note, boolean isFailureFinal) {
            this.parent = parent;
            this.childType = childType;
            this.action = action;
            this.note = note;
            this.resourceName = null;
            this.isFailureFatal = isFailureFinal;
            this.resource = null;
            this.childName = childName;
            this.relatedObject = null;
        }

        public AccessCheck(ConfigBeanProxy parent, Class<? extends ConfigBeanProxy> childType, String action, boolean isFailureFinal) {
            this(parent, childType, action, "", isFailureFinal);
        }

        public AccessCheck(ConfigBeanProxy parent, Class<? extends ConfigBeanProxy> childType, String action) {
            this(parent, childType, action, true);
        }

        public AccessCheck(ConfigBeanProxy parent, Class<? extends ConfigBeanProxy> childType, String childName, String action) {
            this(Util.resourceNameFromConfigBeanTypeAndName(parent, childType, childName), action);
        }

        public T relatedObject() {
            return this.relatedObject;
        }

        public String resourceName() {
            if (this.resource != null) {
                return Util.resourceNameFromConfigBeanProxy(this.resource);
            }
            if (this.parent != null) {
                if (this.childName == null) {
                    return Util.resourceNameFromConfigBeanType(this.parent, null, this.childType);
                }
                return Util.resourceNameFromConfigBeanTypeAndName(this.parent, this.childType, this.childName);
            }
            return this.resourceName;
        }

        public String action() {
            return this.action;
        }

        public Class<? extends ConfigBeanProxy> childType() {
            return this.childType;
        }

        public ConfigBeanProxy parent() {
            return this.parent;
        }

        public String note() {
            return this.note;
        }

        public ConfigBeanProxy resource() {
            return this.resource;
        }

        public boolean isFailureFinal() {
            return this.isFailureFatal;
        }

        public void setSuccessful(boolean passed) {
            this.isSuccessful = passed;
        }

        public boolean isSuccessful() {
            return this.isSuccessful;
        }

        public String toString() {
            return "AccessCheck " + this.resourceName() + "=" + this.action + ", isSuccessful=" + this.isSuccessful + ", isFailureFatal=" + this.isFailureFatal + "//" + this.note;
        }

        private static class RelatedObjectCollection<U>
        extends AbstractCollection<U> {
            private final Collection<AccessCheck<U>> accessChecks;
            private final boolean accessibleOnly;

            private RelatedObjectCollection(Collection<AccessCheck<U>> accessChecks, boolean accessibleOnly) {
                this.accessChecks = accessChecks;
                this.accessibleOnly = accessibleOnly;
            }

            @Override
            public Iterator<U> iterator() {
                return new Iterator<U>(){
                    private final Iterator<AccessCheck<U>> baseIt;
                    private AccessCheck<U> nextAccessCheck;
                    {
                        this.baseIt = accessChecks.iterator();
                        this.nextAccessCheck = this.chooseNext();
                    }

                    private AccessCheck<U> chooseNext() {
                        while (this.baseIt.hasNext()) {
                            AccessCheck next = this.baseIt.next();
                            if (accessibleOnly && !next.isSuccessful) continue;
                            return next;
                        }
                        return null;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.nextAccessCheck != null;
                    }

                    @Override
                    public U next() {
                        if (this.nextAccessCheck == null) {
                            throw new NoSuchElementException();
                        }
                        Object result = this.nextAccessCheck.relatedObject;
                        this.nextAccessCheck = this.chooseNext();
                        return result;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                int count = 0;
                for (AccessCheck<U> accessCheck : this.accessChecks) {
                    if (this.accessibleOnly && !accessCheck.isSuccessful()) continue;
                    ++count;
                }
                return count;
            }
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface NewChild {
        public String collection() default "";

        public Class type();

        public String[] action() default {"create"};

        @Target(value={ElementType.FIELD})
        @Retention(value=RetentionPolicy.RUNTIME)
        public static @interface List {
            public NewChild[] value();
        }
    }

    @Target(value={ElementType.FIELD})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface To {
        public String[] value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface Delegate {
        public Class value();
    }

    @Target(value={ElementType.TYPE})
    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface List {
        public AccessRequired[] value();
    }
}

