/*
 * Copyright (c) 1997, 2018 Oracle and/or its affiliates. All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v. 2.0, which is available at
 * http://www.eclipse.org/legal/epl-2.0.
 *
 * This Source Code may also be made available under the following Secondary
 * Licenses when the conditions for such availability set forth in the
 * Eclipse Public License v. 2.0 are satisfied: GNU General Public License,
 * version 2 with the GNU Classpath Exception, which is available at
 * https://www.gnu.org/software/classpath/license.html.
 *
 * SPDX-License-Identifier: EPL-2.0 OR GPL-2.0 WITH Classpath-exception-2.0
 */

package org.glassfish.api.admin.config;

import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.Target;

import static java.lang.annotation.ElementType.METHOD;
import static java.lang.annotation.RetentionPolicy.RUNTIME;

/**
 * Annotation that holds an array of {@link PropertyDesc} for properties eg {@link org.jvnet.hk2.config.types.Property}.
 * Needed because it's not otherwise possible to have more than one annotation of the same type.
 */
@Retention(RUNTIME)
@Target({ METHOD })
@Documented
public @interface PropertiesDesc {
    /** name of the property */
    PropertyDesc[] props();

    /** returns true if these describe &lt;system-property> */
    boolean systemProperties() default false;
}
