/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.remote.JMXConnectionNotification;
import javax.management.remote.JMXConnectorServer;
import org.glassfish.admin.mbeanserver.JMXStartupService;
import org.glassfish.external.amx.BootAMXMBean;

class BootAMXListener
implements NotificationListener {
    private JMXConnectorServer mServer = null;
    private final BootAMXMBean mBooter;
    private static final Logger LOGGER = JMXStartupService.JMX_LOGGER;
    private static final String JMX_BOOTING_AMX_LISTENER = "NCLS-JMX-00008";

    public BootAMXListener(BootAMXMBean booter) {
        this.mBooter = booter;
    }

    void setServer(JMXConnectorServer server) {
        this.mServer = server;
    }

    @Override
    public void handleNotification(Notification notif, Object handback) {
        JMXConnectionNotification n;
        if (notif instanceof JMXConnectionNotification && (n = (JMXConnectionNotification)notif).getType().equals("jmx.remote.connection.opened")) {
            LOGGER.log(Level.INFO, JMX_BOOTING_AMX_LISTENER, handback);
            this.mBooter.bootAMX();
            if (this.mServer != null) {
                try {
                    this.mServer.removeNotificationListener(this);
                    LOGGER.fine("ConnectorStartupService.BootAMXListener: AMX is booted, stopped listening");
                }
                catch (ListenerNotFoundException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

