/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver.ssl;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import org.glassfish.admin.mbeanserver.ssl.SSLClientConfigurator;
import org.glassfish.admin.mbeanserver.ssl.SSLParams;

public final class SecureRMIClientSocketFactory
extends SslRMIClientSocketFactory {
    private InetAddress mAddress;
    private transient SSLParams sslParams;
    private transient Map socketMap = new HashMap();
    private static final Logger _logger = Logger.getLogger(SecureRMIClientSocketFactory.class.getName());

    public SecureRMIClientSocketFactory(SSLParams sslParams, InetAddress addr) {
        this.mAddress = addr;
        this.sslParams = sslParams;
        if (sslParams != null) {
            _logger.log(Level.INFO, "Creating a SecureRMIClientSocketFactory @ {0}with ssl config = {1}", new Object[]{addr.getHostAddress(), sslParams.toString()});
        }
    }

    public SecureRMIClientSocketFactory() {
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof SecureRMIClientSocketFactory) {
            return this.hashCode() == obj.hashCode();
        }
        return false;
    }

    @Override
    public int hashCode() {
        return this.mAddress.hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        throw new IOException("Serialization not supported");
    }

    @Override
    public Socket createSocket(String host, int port) throws IOException {
        if (this.socketMap.containsKey(port)) {
            return (Socket)this.socketMap.get(port);
        }
        int backlog = 5;
        SSLClientConfigurator sslCC = SSLClientConfigurator.getInstance();
        _logger.log(Level.INFO, "Setting SSLParams @ {0}", this.sslParams);
        sslCC.setSSLParams(this.sslParams);
        SSLContext sslContext = sslCC.configure(this.sslParams);
        SSLSocket sslSocket = (SSLSocket)sslContext.getSocketFactory().createSocket(this.mAddress, port);
        this.configureSSLSocket(sslSocket, sslCC);
        this.socketMap.put(8686, sslSocket);
        return sslSocket;
    }

    private void configureSSLSocket(SSLSocket sslSocket, SSLClientConfigurator sslCC) {
        String[] ep;
        String[] ecs = sslCC.getEnabledCipherSuites();
        if (ecs != null) {
            sslSocket.setEnabledCipherSuites(SecureRMIClientSocketFactory.configureEnabledCiphers(sslSocket, ecs));
        }
        if ((ep = sslCC.getEnabledProtocols()) != null) {
            sslSocket.setEnabledProtocols(SecureRMIClientSocketFactory.configureEnabledProtocols(sslSocket, ep));
        }
        sslSocket.setUseClientMode(true);
    }

    private static String[] configureEnabledProtocols(SSLSocket socket, String[] requestedProtocols) {
        String[] supportedProtocols = socket.getSupportedProtocols();
        String[] protocols = null;
        ArrayList<String> list = null;
        block0: for (String supportedProtocol : supportedProtocols) {
            for (String protocol : requestedProtocols) {
                if (!supportedProtocol.equals(protocol = protocol.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(protocol);
                continue block0;
            }
        }
        if (list != null) {
            protocols = list.toArray(new String[list.size()]);
        }
        return protocols;
    }

    private static String[] configureEnabledCiphers(SSLSocket socket, String[] requestedCiphers) {
        String[] supportedCiphers = socket.getSupportedCipherSuites();
        String[] ciphers = null;
        ArrayList<String> list = null;
        block0: for (String supportedCipher : supportedCiphers) {
            for (String cipher : requestedCiphers) {
                if (!supportedCipher.equals(cipher = cipher.trim())) continue;
                if (list == null) {
                    list = new ArrayList<String>();
                }
                list.add(cipher);
                continue block0;
            }
        }
        if (list != null) {
            ciphers = list.toArray(new String[list.size()]);
        }
        return ciphers;
    }
}

