/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mbeanserver;

import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.UnicastRemoteObject;
import java.security.Security;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import javax.management.MBeanServer;
import javax.management.remote.JMXAuthenticator;
import javax.management.remote.JMXConnectorServer;
import javax.management.remote.JMXConnectorServerFactory;
import javax.management.remote.JMXServiceURL;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectorServer;
import javax.management.remote.rmi.RMIJRMPServerImpl;
import javax.net.ssl.SSLContext;
import javax.rmi.ssl.SslRMIClientSocketFactory;
import javax.security.auth.Subject;
import org.glassfish.admin.mbeanserver.BootAMXListener;
import org.glassfish.admin.mbeanserver.ConnectorStarter;
import org.glassfish.admin.mbeanserver.Util;
import org.glassfish.admin.mbeanserver.ssl.JMXMasterPasswordImpl;
import org.glassfish.admin.mbeanserver.ssl.SSLClientConfigurator;
import org.glassfish.admin.mbeanserver.ssl.SSLParams;
import org.glassfish.admin.mbeanserver.ssl.SecureRMIServerSocketFactory;
import org.glassfish.grizzly.config.dom.Ssl;
import org.glassfish.hk2.api.ServiceLocator;

final class RMIConnectorStarter
extends ConnectorStarter {
    public static final String RMI_HOSTNAME_PROP = "java.rmi.server.hostname";
    private final Registry mRegistry;
    private final boolean mBindToSingleIP;
    private volatile MyRMIJRMPServerImpl mMyServer;
    private final MyRMIServerSocketFactory mServerSocketFactory;
    private final SecureRMIServerSocketFactory sslServerSocketFactory;
    private final SslRMIClientSocketFactory sslCsf;
    private String masterPassword = null;

    public RMIConnectorStarter(MBeanServer mbeanServer, String address, int port, String protocol, boolean securityEnabled, ServiceLocator habitat, BootAMXListener bootListener, Ssl sslConfig) throws UnknownHostException {
        super(mbeanServer, address, port, securityEnabled, habitat, bootListener);
        this.masterPassword = new String(((JMXMasterPasswordImpl)habitat.getService(JMXMasterPasswordImpl.class, new Annotation[0])).getMasterPassword());
        if (!"rmi_jrmp".equals(protocol)) {
            throw new IllegalArgumentException("JMXConnectorServer not yet supporting protocol: " + protocol);
        }
        boolean ENABLED = true;
        this.mBindToSingleIP = !address.equals("0.0.0.0") && !address.equals("");
        InetAddress inetAddr = RMIConnectorStarter.getAddress(address);
        if (this.mBindToSingleIP) {
            if (this.isSecurityEnabled()) {
                Util.getLogger().info("Security enabled");
                this.sslServerSocketFactory = new SecureRMIServerSocketFactory(habitat, sslConfig, inetAddr);
                this.sslCsf = this.getClientSocketFactory(sslConfig);
                this.mServerSocketFactory = null;
            } else {
                this.mServerSocketFactory = new MyRMIServerSocketFactory(inetAddr);
                this.sslServerSocketFactory = null;
                this.sslCsf = null;
            }
        } else {
            this.mServerSocketFactory = null;
            if (this.isSecurityEnabled()) {
                this.sslServerSocketFactory = new SecureRMIServerSocketFactory(habitat, sslConfig, RMIConnectorStarter.getAddress(address));
                this.sslCsf = this.getClientSocketFactory(sslConfig);
            } else {
                this.sslServerSocketFactory = null;
                this.sslCsf = null;
            }
        }
        this.mRegistry = this.startRegistry(address, this.mPort);
    }

    private static InetAddress getAddress(String addrSpec) throws UnknownHostException {
        String actual = addrSpec;
        if (addrSpec.equals("localhost")) {
            actual = "127.0.0.1";
        }
        InetAddress addr = InetAddress.getByName(actual);
        return addr;
    }

    static String setupRMIHostname(String host) {
        return System.setProperty(RMI_HOSTNAME_PROP, host);
    }

    private static void restoreRMIHostname(String saved, String expectedValue) {
        if (saved == null) {
            System.clearProperty(RMI_HOSTNAME_PROP);
        } else {
            String temp = System.setProperty(RMI_HOSTNAME_PROP, saved);
            if (!temp.equals(expectedValue)) {
                throw new IllegalStateException("Something changed java.rmi.server.hostname to " + temp);
            }
        }
    }

    private static void debug(Object o) {
        System.out.println("" + o);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Registry startRegistry(String addr, int port) {
        Registry registry = null;
        if (this.mBindToSingleIP) {
            String saved = RMIConnectorStarter.setupRMIHostname(addr);
            try {
                Util.getLogger().log(Level.INFO, "Binding RMI port to single IP address = {0}, port {1}", new Object[]{System.getProperty(RMI_HOSTNAME_PROP), port});
                registry = this._startRegistry(port);
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, addr);
            }
        } else {
            Util.getLogger().log(Level.FINE, "Binding RMI port to *:{0}", port);
            registry = this._startRegistry(port);
        }
        return registry;
    }

    private Registry _startRegistry(int port) {
        System.setProperty("java.rmi.server.randomIDs", "true");
        try {
            if (this.isSecurityEnabled()) {
                return LocateRegistry.createRegistry(port, this.sslCsf, this.sslServerSocketFactory);
            }
            return LocateRegistry.createRegistry(port, null, this.mServerSocketFactory);
        }
        catch (Exception e) {
            throw new RuntimeException("Port " + port + " is not available for the internal rmi registry. " + "This means that a call was made with the same port, without closing earlier " + "registry instance. This has to do with the system jmx connector configuration " + "in admin-service element of the configuration associated with this instance");
        }
    }

    @Override
    public JMXConnectorServer start() throws MalformedURLException, IOException, UnknownHostException {
        String name = "jmxrmi";
        String hostname = this.hostname();
        HashMap<String, Object> env = new HashMap<String, Object>();
        env.put("jmx.remote.jndi.rebind", "true");
        env.put("jmx.remote.rmi.client.socket.factory", this.sslCsf);
        env.put("jmx.remote.rmi.server.socket.factory", this.sslServerSocketFactory);
        env.put("com.sun.jndi.rmi.factory.socket", this.sslCsf);
        JMXAuthenticator authenticator = this.getAccessController();
        if (authenticator != null) {
            env.put("jmx.remote.authenticator", authenticator);
        }
        String jmxHostPort = hostname + ":" + this.mPort;
        String registryHostPort = hostname + ":" + this.mPort;
        String urlStr = "service:jmx:rmi://" + jmxHostPort + "/jndi/rmi://" + registryHostPort + "/" + "jmxrmi";
        this.mJMXServiceURL = new JMXServiceURL(urlStr);
        if (this.mBindToSingleIP) {
            RMIServerSocketFactory rmiSSF = this.isSecurityEnabled() ? this.sslServerSocketFactory : this.mServerSocketFactory;
            this.mMyServer = new MyRMIJRMPServerImpl(this.mPort, env, rmiSSF, hostname);
            this.mConnectorServer = new RMIConnectorServer(this.mJMXServiceURL, env, this.mMyServer, this.mMBeanServer);
        } else {
            this.mConnectorServer = JMXConnectorServerFactory.newJMXConnectorServer(this.mJMXServiceURL, env, this.mMBeanServer);
        }
        if (this.mBootListener != null) {
            this.mConnectorServer.addNotificationListener(this.mBootListener, null, this.mJMXServiceURL.toString());
        }
        this.mConnectorServer.start();
        return this.mConnectorServer;
    }

    public void stopAndUnexport() {
        super.stop();
        try {
            if (this.mBindToSingleIP) {
                this.mRegistry.unbind(this.mHostName);
            }
            UnicastRemoteObject.unexportObject(this.mRegistry, true);
        }
        catch (RemoteException ex) {
            Util.getLogger().log(Level.SEVERE, null, ex);
        }
        catch (NotBoundException ex) {
            Util.getLogger().log(Level.SEVERE, null, ex);
        }
    }

    private SslRMIClientSocketFactory getClientSocketFactory(Ssl sslConfig) {
        String enabledCipherSuites;
        SSLParams sslParams = this.convertToSSLParams(sslConfig);
        SSLClientConfigurator sslCC = SSLClientConfigurator.getInstance();
        sslCC.setSSLParams(sslParams);
        SSLContext sslContext = sslCC.configure(sslParams);
        Security.setProperty("ssl.SocketFactory.provider", sslContext.getClass().getName());
        String enabledProtocols = sslCC.getEnabledProtocolsAsString();
        if (enabledProtocols != null) {
            System.setProperty("javax.rmi.ssl.client.enabledProtocols", enabledProtocols);
        }
        if ((enabledCipherSuites = sslCC.getEnabledCipherSuitesAsString()) != null) {
            System.setProperty("javax.rmi.ssl.client.enabledCipherSuites", enabledCipherSuites);
        }
        System.setProperty("javax.net.ssl.keyStorePassword", sslParams.getKeyStorePassword() == null ? "changeit" : sslParams.getKeyStorePassword());
        System.setProperty("javax.net.ssl.trustStorePassword", sslParams.getTrustStorePassword() == null ? "changeit" : sslParams.getTrustStorePassword());
        SslRMIClientSocketFactory sslRMICsf = new SslRMIClientSocketFactory();
        return sslRMICsf;
    }

    private SSLParams convertToSSLParams(Ssl sslConfig) {
        String trustStoreType = sslConfig.getTrustStoreType() == null ? System.getProperty("javax.net.ssl.trustStoreType", "JKS") : sslConfig.getTrustStoreType();
        String trustStorePwd = sslConfig.getTrustStorePassword() == null ? this.masterPassword : sslConfig.getTrustStorePassword();
        File trustStore = sslConfig.getTrustStore() == null ? new File(System.getProperty("javax.net.ssl.trustStore")) : new File(sslConfig.getTrustStore());
        String keyStoreType = sslConfig.getTrustStoreType() == null ? System.getProperty("javax.net.ssl.keyStoreType", "JKS") : sslConfig.getKeyStoreType();
        String keyStorePwd = sslConfig.getTrustStorePassword() == null ? this.masterPassword : sslConfig.getKeyStorePassword();
        File keyStore = sslConfig.getTrustStore() == null ? new File(System.getProperty("javax.net.ssl.keyStore")) : new File(sslConfig.getKeyStore());
        SSLParams sslParams = new SSLParams(trustStore, trustStorePwd, trustStoreType);
        sslParams.setTrustAlgorithm(sslConfig.getTrustAlgorithm());
        sslParams.setCertNickname(sslConfig.getCertNickname());
        sslParams.setCrlFile(sslConfig.getCrlFile());
        sslParams.setClientAuthEnabled(sslConfig.getClientAuthEnabled());
        sslParams.setClientAuth(sslConfig.getClientAuth());
        sslParams.setKeyAlgorithm(sslConfig.getKeyAlgorithm());
        sslParams.setKeyStore(keyStore.getAbsolutePath());
        sslParams.setKeyStorePassword(keyStorePwd);
        sslParams.setKeyStoreType(keyStoreType);
        sslParams.setSsl2Ciphers(sslConfig.getSsl2Ciphers());
        sslParams.setSsl2Enabled(sslConfig.getSsl2Enabled());
        sslParams.setSsl3Enabled(sslConfig.getSsl3Enabled());
        sslParams.setSsl3TlsCiphers(sslConfig.getSsl3TlsCiphers());
        sslParams.setTlsEnabled(sslConfig.getTlsEnabled());
        sslParams.setTlsRollbackEnabled(sslConfig.getTlsRollbackEnabled());
        return sslParams;
    }

    private static final class MyRMIJRMPServerImpl
    extends RMIJRMPServerImpl {
        private final String mBindToAddr;

        public MyRMIJRMPServerImpl(int port, Map<String, ?> env, RMIServerSocketFactory serverSocketFactory, String bindToAddr) throws IOException {
            super(port, (RMIClientSocketFactory)env.get("jmx.remote.rmi.client.socket.factory"), serverSocketFactory, env);
            this.mBindToAddr = bindToAddr;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected synchronized void export(String host) throws IOException {
            String saved = RMIConnectorStarter.setupRMIHostname(this.mBindToAddr);
            try {
                super.export();
                Util.getLogger().log(Level.INFO, "MyRMIJRMPServerImpl: exported on address {0}", this.mBindToAddr);
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, this.mBindToAddr);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected synchronized RMIConnection makeClient(String connectionId, Subject subject) throws IOException {
            String saved = RMIConnectorStarter.setupRMIHostname(this.mBindToAddr);
            try {
                Util.getLogger().log(Level.INFO, "MyRMIJRMPServerImpl: makeClient on address = {0}", System.getProperty(RMIConnectorStarter.RMI_HOSTNAME_PROP));
                RMIConnection rMIConnection = super.makeClient(connectionId, subject);
                return rMIConnection;
            }
            finally {
                RMIConnectorStarter.restoreRMIHostname(saved, this.mBindToAddr);
            }
        }
    }

    public static final class MyRMIServerSocketFactory
    extends RMISocketFactory {
        private final InetAddress mAddress;

        public MyRMIServerSocketFactory(InetAddress addr) {
            this.mAddress = addr;
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            int backlog = 5;
            ServerSocket s = new ServerSocket(port, 5, this.mAddress);
            return s;
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            Socket s = new Socket(host, port);
            return s;
        }
    }
}

